<?php $__env->startSection('content-header'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Users</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('AdminDash')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active">Users</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>


            <div class="row">
                <div class="col-12">
                    <div class="card">

                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="callRecordsTable" class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th data-sortable="true">ID</th>
                                    <th data-sortable="false">Name</th>
                                    <th data-sortable="false">Number</th>
                                    <th data-sortable="false">Email</th>
                                    <th data-sortable="true">Balance</th>
                                    <th data-sortable="true">Status</th>
                                    <th data-sortable="true">Deactive</th>
                                    <th data-sortable="true">Join</th>
                                    <th data-sortable="false">Action</th>
                                </tr>
                                </thead>
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($item->id); ?></td>
                                            <td><?php echo e($item->fname); ?> <?php echo e($item->lname); ?></td>
                                            <td><?php echo e($item->phone); ?></td>
                                            <td><?php echo e($item->email); ?></td>
                                            <td><?php echo e($item->balance); ?> BDT</td>
                                            <td>
                                                <?php if($item->user_active == 0): ?>
                                                    <span style="color: red;">In-Active</span>
                                                <?php else: ?>
                                                    <span style="color: green;">Active</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($item->deactive); ?></td>
                                            <td><?php echo e($item->created_at->format('M D Y')); ?></td>
                                            <td><a href="<?php echo e(route('ActiveUser', $item->id)); ?>">ACTIVE</a> / <a href="<?php echo e(route('DectiveUser', $item->id)); ?>">DEACTIVE</a></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cashproc/insafnm.0-13.xyz/resources/views/dashboard/usersdata.blade.php ENDPATH**/ ?>