<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
.deposit-container {
    max-width: 600px;
    margin: 0 auto;
    padding: 20px;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: #333;
}
.deposit-header {
    text-align: center;
    margin-bottom: 40px;
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    padding: 40px 20px;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0, 136, 204, 0.3);
    animation: fadeInUp 0.8s ease-out;
    position: relative;
    overflow: hidden;
}
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}
.deposit-header h1 {
    font-size: 2.2rem;
    margin-bottom: 10px;
    font-weight: 700;
    text-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 12px;
    opacity: 0.95;
}
.deposit-header p {
    font-size: 1.1rem;
    opacity: 0.9;
    margin: 0;
    font-weight: 500;
}
.deposit-card {
    background: white;
    padding: 40px;
    border-radius: 20px;
    box-shadow: 0 15px 40px rgba(0, 0, 0, 0.1);
    margin-bottom: 30px;
    border: 1px solid rgba(0, 136, 204, 0.1);
    backdrop-filter: blur(10px);
    animation: slideInUp 0.6s ease-out;
    position: relative;
    overflow: hidden;
}
@keyframes slideInUp {
    from { opacity: 0; transform: translateY(30px); }
    to { opacity: 1; transform: translateY(0); }
}
.deposit-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    border-radius: 20px 20px 0 0;
}
.deposit-card h3 {
    text-align: center;
    color: #0088cc;
    margin-bottom: 30px;
    font-size: 1.5rem;
    font-weight: 700;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
}
.deposit-card h3 i {
    font-size: 1.8rem;
    animation: pulse 2s infinite;
}
@keyframes pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.1); }
    100% { transform: scale(1); }
}
.form-group {
    margin-bottom: 25px;
    position: relative;
    animation: fadeInUp 0.6s ease-out 0.2s both;
}
.form-group label {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-bottom: 8px;
    font-weight: 600;
    color: #0088cc;
    font-size: 1rem;
}
.form-group i {
    color: #0088cc;
    font-size: 1.1rem;
}
.form-control {
    width: 100%;
    padding: 15px 18px 15px 50px;
    border: 2px solid #e0e0e0;
    border-radius: 12px;
    font-size: 1.1rem;
    transition: all 0.3s ease;
    background: #f8f9fa;
    position: relative;
    font-weight: 500;
}
.form-control:focus {
    border-color: #0088cc;
    outline: none;
    box-shadow: 0 0 0 0.2rem rgba(0, 136, 204, 0.15);
    background: white;
    transform: translateY(-1px);
}
.input-icon {
    position: absolute;
    left: 16px;
    top: 50%;
    transform: translateY(-50%);
    color: #0088cc;
    font-size: 1.1rem;
    z-index: 1;
}
.input-group-text {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    border: none;
    border-radius: 12px 0 0 12px;
    font-weight: 600;
    padding: 15px 18px;
    font-size: 1.1rem;
}
.invalid-feedback {
    color: #dc3545;
    font-size: 0.9rem;
    margin-top: 5px;
    display: block;
}
.btn-deposit {
    background: linear-gradient(135deg, #27ae60 0%, #2ecc71 100%);
    color: white;
    border: none;
    padding: 15px 40px;
    border-radius: 12px;
    font-size: 1.1rem;
    font-weight: bold;
    cursor: pointer;
    width: 100%;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    box-shadow: 0 4px 15px rgba(39, 174, 96, 0.3);
    animation: fadeInUp 0.6s ease-out 0.4s both;
}
.btn-deposit:hover:not(:disabled) {
    background: linear-gradient(135deg, #219a52 0%, #27ae60 100%);
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(39, 174, 96, 0.4);
    color: white;
}
.btn-deposit:disabled {
    background: #bdc3c7;
    cursor: not-allowed;
    transform: none;
    box-shadow: none;
}
.footer-credit {
    text-align: center;
    margin-top: 30px;
    padding: 15px;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border-radius: 12px;
    font-size: 0.9rem;
    color: #666;
    animation: fadeInUp 0.6s ease-out 0.5s both;
}
.footer-credit a {
    color: #0088cc;
    font-weight: bold;
    text-decoration: none;
    transition: color 0.3s ease;
}
.footer-credit a:hover {
    color: #006ba6;
    text-decoration: underline;
}
/* Responsive */
@media (max-width: 768px) {
    .deposit-container { padding: 15px; }
    .deposit-header { padding: 30px 15px; border-radius: 15px; }
    .deposit-header h1 { font-size: 1.8rem; }
    .deposit-card { padding: 30px 20px; border-radius: 15px; }
    .form-control { padding: 13px 16px 13px 45px; font-size: 0.95rem; }
    .input-group-text { padding: 13px 16px; font-size: 1rem; }
    .btn-deposit { padding: 13px 30px; font-size: 1rem; }
    .footer-credit { padding: 12px; font-size: 0.85rem; }
}
@media (max-width: 480px) {
    .deposit-header h1 { font-size: 1.6rem; }
    .deposit-card { padding: 25px 15px; }
    .form-control { padding: 12px 14px 12px 40px; }
}
</style>
<br><br><br><br>

    <div class="deposit-card">
        <h3><i class="fas fa-money-check-alt"></i> Deposit Amount</h3>
        <form action="<?php echo e(route('deposit')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label for="amount">
                    <i class="fas fa-coins"></i> Enter Amount (৳)
                </label>
                <div class="input-group">
                    <input type="number" name="amount" id="amount" class="form-control <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                           placeholder="Minimum ৳10" min="10" step="1" required value="<?php echo e(old('amount')); ?>">
                </div>
                <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <small class="text-muted">Minimum deposit: ৳10.00 – Funds reflect instantly for seamless transactions</small>
            </div>
            <div class="d-grid">
                <button type="submit" class="btn-deposit">
                    <i class="fas fa-arrow-right"></i> Proceed to Secure Payment
                </button>
            </div>
        </form>
        <div class="footer-credit">
            Powered by <a href="https://t.me/sb_lab"><strong>SB LAB</strong></a> | 100% Secure & Lightning Fast
        </div>
    </div>
</div>
<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/zonexpro/hgzy.zone-x.pro/resources/views/user/deposit.blade.php ENDPATH**/ ?>