<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<br><br><br>
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-10 col-lg-8">
            <div class="card history-card">
                <div class="card-header history-header">
                    <div class="header-content">
                        <i class="fas fa-history header-icon"></i>
                        <h4 class="mb-0 header-title">Gift Code Redemption History</h4>
                    </div>
                </div>
                <div class="card-body history-body">
                    <?php if($redemptions->count() > 0): ?>
                        <div class="table-responsive history-table-wrapper">
                            <table class="table history-table">
                                <thead class="table-header">
                                    <tr>
                                        <th><i class="fas fa-key me-1"></i>Code</th>
                                        <th><i class="fas fa-coins me-1"></i>Amount</th>
                                        <th><i class="fas fa-clock me-1"></i>Redeemed At</th>
                                        <th><i class="fas fa-check-circle me-1"></i>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $redemptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $redemption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="table-row" style="animation-delay: <?php echo e($index * 0.1); ?>s;">
                                            <td class="code-cell"><code class="code-badge"><?php echo e($redemption->giftCode->code); ?></code></td>
                                            <td class="amount-cell text-success">
                                                <i class="fas fa-plus-circle me-1"></i>
                                                +৳<?php echo e(number_format($redemption->redeemed_amount, 2)); ?>

                                            </td>
                                            <td class="date-cell"><?php echo e($redemption->redeemed_at->format('M d, Y h:i A')); ?></td>
                                            <td class="status-cell">
                                                <span class="status-badge success-badge">Redeemed</span>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="text-center mt-4 total-rewards">
                            <p class="total-text">
                                <i class="fas fa-trophy me-1"></i>
                                Total Rewarded: ৳<?php echo e(number_format($redemptions->sum('redeemed_amount'), 2)); ?>

                            </p>
                        </div>
                    <?php else: ?>
                        <div class="empty-state">
                            <div class="empty-icon-wrapper">
                                <i class="fas fa-gift empty-icon"></i>
                            </div>
                            <h5 class="empty-title">No Redemptions Yet</h5>
                            <p class="empty-text">Your gift code history is empty. Start redeeming to see your rewards here!</p>
                            <a href="<?php echo e(route('gift.code')); ?>" class="redeem-btn-empty">
                                <i class="fas fa-magic me-1"></i> Redeem a Gift Code
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<style>
/* Telegram Blue Theme Integration */
body {
    background: linear-gradient(135deg, #f0f2f5 0%, #e8f0fe 100%);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: #000;
    overflow-x: hidden;
}
.container-fluid {
    padding: 20px 15px;
    min-height: 100vh;
}
.history-card {
    border: none;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0, 136, 204, 0.2);
    overflow: hidden;
    background: #ffffff;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    animation: fadeInUp 0.8s ease-out;
}
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}
.history-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 15px 50px rgba(0, 136, 204, 0.3);
}
.history-header {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    border: none;
    border-radius: 20px 20px 0 0;
    padding: 20px;
    color: white;
    text-align: center;
}
.header-content {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 12px;
}
.header-icon {
    font-size: 1.8rem;
    animation: rotate 3s linear infinite;
}
@keyframes rotate {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}
.header-title {
    margin: 0;
    font-weight: 700;
    font-size: 1.5rem;
    opacity: 0.95;
}
.history-body {
    padding: 30px;
}
.history-table-wrapper {
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    animation: fadeInUp 0.8s ease-out 0.2s both;
}
.history-table {
    margin: 0;
    font-size: 0.95rem;
}
.table-header {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
}
.table-header th {
    font-weight: 600;
    padding: 15px 12px;
    text-align: center;
    border: none;
}
.table-row {
    animation: slideInRight 0.6s ease-out;
    transition: background 0.3s ease;
}
@keyframes slideInRight {
    from { opacity: 0; transform: translateX(-20px); }
    to { opacity: 1; transform: translateX(0); }
}
.table-row:hover {
    background: rgba(0, 136, 204, 0.05);
    transform: scale(1.01);
}
.table-row td {
    padding: 15px 12px;
    vertical-align: middle;
    text-align: center;
    border-color: #e0e0e0;
}
.code-cell code.code-badge {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    padding: 6px 12px;
    border-radius: 20px;
    font-weight: 500;
    font-size: 0.9rem;
    display: inline-block;
}
.amount-cell {
    font-weight: 600;
    font-size: 1.1rem;
}
.date-cell {
    color: #666;
    font-size: 0.9rem;
}
.status-cell .status-badge {
    padding: 6px 12px;
    border-radius: 20px;
    font-weight: 500;
    font-size: 0.85rem;
}
.success-badge {
    background: linear-gradient(135deg, #00ff88 0%, #10b981 100%);
    color: white;
}
.total-rewards {
    animation: fadeInUp 0.8s ease-out 0.4s both;
}
.total-text {
    font-size: 1.2rem;
    color: #0088cc;
    font-weight: 600;
    margin: 0;
}
.empty-state {
    text-align: center;
    padding: 40px 20px;
    animation: fadeInUp 0.8s ease-out;
}
.empty-icon-wrapper {
    margin-bottom: 20px;
}
.empty-icon {
    font-size: 5rem;
    color: #0088cc;
    opacity: 0.5;
    animation: bounce 2s infinite;
}
@keyframes bounce {
    0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
    40% { transform: translateY(-20px); }
    60% { transform: translateY(-10px); }
}
.empty-title {
    color: #333;
    margin-bottom: 10px;
    font-weight: 600;
    font-size: 1.5rem;
}
.empty-text {
    color: #666;
    margin-bottom: 25px;
    font-size: 1.1rem;
}
.redeem-btn-empty {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    border: none;
    padding: 12px 30px;
    border-radius: 25px;
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(0, 136, 204, 0.3);
}
.redeem-btn-empty:hover {
    background: linear-gradient(135deg, #006ba6 0%, #0088cc 100%);
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(0, 136, 204, 0.4);
    color: white;
    text-decoration: none;
}
/* Responsive */
@media (max-width: 768px) {
    .container-fluid { padding: 15px 10px; }
    .history-body { padding: 20px; }
    .table-header th, .table-row td { padding: 10px 8px; font-size: 0.9rem; }
    .empty-state { padding: 30px 15px; }
    .empty-icon { font-size: 4rem; }
    .header-content { gap: 8px; }
    .header-icon { font-size: 1.5rem; }
    .header-title { font-size: 1.3rem; }
}
</style>
<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/zonexpro/hgzy.zone-x.pro/resources/views/user/gift_code_history.blade.php ENDPATH**/ ?>