<?php if(auth()->guard()->check()): ?>
<?php
    header("Location: /dashboard");
    exit();
?>
<?php endif; ?>
<?php echo $__env->make('user.layout.header1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
    /* Same styles as forgot-password.blade.php */
    :root {
        --primary-color: #0088cc;
        --primary-hover: #006ba6;
        --accent-color: #00ff88;
        --bg-color: linear-gradient(135deg, #f0f2f5 0%, #e8f0fe 100%);
        --card-bg: #ffffff;
        --text-color: #333;
        --muted-color: #666;
        --border-color: #e0e0e0;
        --shadow-light: rgba(0, 136, 204, 0.1);
        --shadow-medium: rgba(0, 136, 204, 0.2);
    }
    body {
        background: var(--bg-color);
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        margin: 0;
        color: var(--text-color);
        overflow-x: hidden;
    }
    .header-gradient {
        background: linear-gradient(135deg, var(--primary-color) 0%, #00a0e9 100%);
        padding: 60px 20px 50px;
        text-align: center;
        color: #fff;
        box-shadow: 0 8px 30px rgba(0, 136, 204, 0.3);
        position: relative;
        overflow: hidden;
    }
    .header-gradient::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
        opacity: 0.1;
    }
    .header-gradient h1 {
        font-size: 2.5rem;
        margin-bottom: 10px;
        color: white;
        font-weight: 700;
        text-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
        animation: fadeInDown 1s ease-out;
    }
    .header-gradient p {
        font-size: 1.1rem;
        color: rgba(255, 255, 255, 0.9);
        margin: 0;
        animation: fadeInUp 1s ease-out 0.3s both;
    }
    .login-container {
        display: flex;
        justify-content: center;
        align-items: center;
        padding: 40px 20px;
        min-height: calc(100vh - 200px);
    }
    .login-box {
        background: var(--card-bg);
        padding: 40px;
        max-width: 420px;
        width: 100%;
        border-radius: 20px;
        box-shadow: 0 15px 40px var(--shadow-medium);
        position: relative;
        animation: slideInUp 0.6s ease-out;
        border: 1px solid rgba(0, 136, 204, 0.1);
        backdrop-filter: blur(10px);
    }
    .login-box::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(135deg, var(--primary-color) 0%, #00a0e9 100%);
        border-radius: 20px 20px 0 0;
    }
    .login-box h2 {
        text-align: center;
        margin-bottom: 30px;
        color: var(--primary-color);
        font-size: 1.8rem;
        font-weight: 700;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
    }
    .form-item {
        margin-bottom: 20px;
        position: relative;
        animation: fadeInUp 0.6s ease-out 0.2s both;
    }
    .input-field {
        width: 100%;
        padding: 15px 20px 15px 50px;
        border: 2px solid var(--border-color);
        border-radius: 12px;
        background-color: #f8f9fa;
        font-size: 1rem;
        transition: all 0.3s ease;
    }
    .input-field:focus {
        outline: none;
        border-color: var(--primary-color);
        background-color: #fff;
        box-shadow: 0 0 0 0.2rem rgba(0, 136, 204, 0.15);
        transform: translateY(-2px);
    }
    .input-icon {
        position: absolute;
        left: 18px;
        top: 50%;
        transform: translateY(-50%);
        color: var(--primary-color);
        font-size: 1.2rem;
        z-index: 1;
    }
    .btn-submit {
        width: 100%;
        padding: 15px;
        background: linear-gradient(135deg, var(--primary-color) 0%, #00a0e9 100%);
        color: white;
        border: none;
        border-radius: 12px;
        font-weight: 600;
        font-size: 1rem;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px var(--shadow-light);
    }
    .btn-submit:hover {
        background: linear-gradient(135deg, var(--primary-hover) 0%, var(--primary-color) 100%);
        transform: translateY(-2px);
        box-shadow: 0 6px 20px var(--shadow-medium);
        color: white;
    }
    .footer-text {
        text-align: center;
        font-size: 0.9rem;
        color: var(--muted-color);
        margin-top: 20px;
    }
    .footer-text a {
        color: var(--primary-color);
        text-decoration: none;
        font-weight: 600;
        transition: color 0.3s ease;
    }
    .footer-text a:hover {
        color: var(--primary-hover);
        text-decoration: underline;
    }
    .error-message {
        background: rgba(220, 53, 69, 0.1);
        border: 1px solid #dc3545;
        color: #dc3545;
        padding: 12px;
        border-radius: 8px;
        margin-bottom: 20px;
        font-size: 0.9rem;
        text-align: center;
    }
    .success-message {
        background: rgba(40, 167, 69, 0.1);
        border: 1px solid #28a745;
        color: #28a745;
        padding: 12px;
        border-radius: 8px;
        margin-bottom: 20px;
        font-size: 0.9rem;
        text-align: center;
    }
    .validation-error {
        color: #dc3545;
        font-size: 0.85rem;
        margin-top: 5px;
        display: block;
    }
    .toggle-password {
        position: absolute;
        right: 15px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        font-size: 1.1rem;
        color: var(--muted-color);
        transition: color 0.3s ease;
        z-index: 1;
    }
</style>

<div class="header-gradient">
    <h1>Set New Password</h1>
    <p>Enter verification code and new password</p>
</div>

<div class="login-container">
    <div class="login-box">
        <h2><i class="fas fa-lock"></i> Reset Password</h2>
        
        <?php if(session('error')): ?>
            <div class="error-message">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>
        
        <?php if(session('success')): ?>
            <div class="success-message">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="error-message">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($error); ?><br>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>

        <form method="post" action="<?php echo e(route('reset.password.submit')); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="token" value="<?php echo e($token); ?>">

            <div class="form-item">
                <i class="fas fa-shield-alt input-icon"></i>
                <input type="text" name="code" class="input-field <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                       placeholder="Enter 6-digit code" maxlength="6" required>
                <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="validation-error"><?php echo e($message); ?></span>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-item">
                <i class="fas fa-lock input-icon"></i>
                <input type="password" name="password" class="input-field <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                       placeholder="New password" id="passwordField" required>
                <span class="toggle-password" onclick="togglePassword('passwordField')">👁</span>
                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="validation-error"><?php echo e($message); ?></span>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-item">
                <i class="fas fa-lock input-icon"></i>
                <input type="password" name="password_confirmation" class="input-field" 
                       placeholder="Confirm new password" id="confirmPasswordField" required>
                <span class="toggle-password" onclick="togglePassword('confirmPasswordField')">👁</span>
            </div>

            <div class="form-item">
                <button type="submit" class="btn-submit">
                    <i class="fas fa-sync-alt"></i> Reset Password
                </button>
            </div>

            <div class="footer-text">
                <a href="<?php echo e(route('forgot.password')); ?>">Resend code</a> | 
                <a href="<?php echo e(route('login')); ?>">Back to login</a>
            </div>
        </form>
    </div>
</div>

<script>
    function togglePassword(fieldId) {
        const passwordField = document.getElementById(fieldId);
        const icon = passwordField.nextElementSibling;
        
        if (passwordField.type === "password") {
            passwordField.type = "text";
            icon.textContent = "🙈";
        } else {
            passwordField.type = "password";
            icon.textContent = "👁";
        }
    }
</script>

<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/teleearn/checkk.tele-earn.com/resources/views/user/reset-password.blade.php ENDPATH**/ ?>