<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<br><br>
<div class="col-12 pb-3">
    <div class="hidden-lg-up"></div>
    <div class="row">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-12 col-lg-10">
                    <div class="leaders-header">
                        <div class="header-wrapper">
                            <i class="fas fa-crown header-icon"></i>
                            <h4 class="leaders-title">Referral Leaders</h4>
                        </div>
                    </div>
                    <div class="leaders-list-container">
                        <?php $counter = 0; ?>
                        <?php $__currentLoopData = $topUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($counter < 300000000): ?>
                        <div class="leaders-list-item" style="animation-delay: <?php echo e($counter * 0.05); ?>s;">
                            <div class="item-avatar-wrapper">
                                <img src="<?php echo e($user->profile_image ? asset('uploads/profile_images/' . $user->profile_image) : asset('https://www.pngall.com/wp-content/uploads/5/Profile-PNG-File.png')); ?>" alt="Profile Image" class="item-avatar">
                                <div class="avatar-status"></div>
                            </div>
                            <div class="item-info">
                                <div class="item-name"><?php echo e($user->fname); ?> <?php echo e($user->lname); ?></div>
                                <div class="item-details">
                                    <i class="fas fa-envelope me-1"></i>
                                    <span class="detail-text"><?php echo e($user->email); ?></span>
                                </div>
                            </div>
                            <div class="item-referral">
                                <i class="fas fa-users item-icon"></i>
                                <span class="referral-count"><?php echo e($user->total_referral_count); ?></span>
                                <span class="referral-label">Refs</span>
                            </div>
                        </div>
                        <?php $counter++; ?>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<style>
/* Telegram Blue Theme Integration */
body {
    background: linear-gradient(135deg, #f0f2f5 0%, #e8f0fe 100%);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: #000;
    overflow-x: hidden;
}
.container-fluid {
    padding: 15px;
}
.leaders-header {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    border-radius: 15px;
    padding: 20px;
    margin-bottom: 20px;
    text-align: center;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
    animation: fadeInUp 0.8s ease-out;
}
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}
.header-wrapper {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 12px;
}
.header-icon {
    font-size: 2rem;
    color: #ffd700;
    animation: pulse 2s infinite;
}
@keyframes pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.1); }
    100% { transform: scale(1); }
}
.leaders-title {
    margin: 0;
    color: white;
    font-weight: 700;
    font-size: 1.5rem;
    letter-spacing: 0.5px;
    text-transform: uppercase;
    opacity: 0.95;
}
.leaders-list-container {
    background: white;
    border-radius: 15px;
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
    padding: 0;
    overflow: hidden;
    animation: fadeInUp 0.8s ease-out 0.2s both;
}
.leaders-list-item {
    display: flex;
    align-items: center;
    padding: 15px 20px;
    border-bottom: 1px solid #f0f2f5;
    transition: all 0.3s ease;
    animation: slideInUp 0.6s ease-out;
}
@keyframes slideInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}
.leaders-list-item:hover {
    background: linear-gradient(90deg, #f0f2f5 0%, #e3f2fd 100%);
    transform: translateX(5px);
    box-shadow: inset 0 2px 8px rgba(0, 136, 204, 0.1);
}
.leaders-list-item:last-child {
    border-bottom: none;
}
.item-avatar-wrapper {
    position: relative;
    width: 50px;
    height: 50px;
    border-radius: 50%;
    overflow: hidden;
    margin-right: 15px;
    flex-shrink: 0;
    box-shadow: 0 4px 12px rgba(0, 136, 204, 0.2);
}
.item-avatar {
    width: 100%;
    height: 100%;
    object-fit: cover;
    display: block;
}
.avatar-status {
    position: absolute;
    bottom: 0;
    right: 0;
    width: 15px;
    height: 15px;
    background: #00ff88;
    border: 2px solid white;
    border-radius: 50%;
    animation: pulse-small 2s infinite;
}
@keyframes pulse-small {
    0% { box-shadow: 0 0 0 0 rgba(0, 255, 136, 0.7); }
    70% { box-shadow: 0 0 0 5px rgba(0, 255, 136, 0); }
    100% { box-shadow: 0 0 0 0 rgba(0, 255, 136, 0); }
}
.item-info {
    flex-grow: 1;
    min-width: 0;
}
.item-name {
    font-weight: 600;
    color: #333;
    font-size: 1.1rem;
    margin-bottom: 2px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}
.item-details {
    display: flex;
    align-items: center;
    font-size: 0.85rem;
    color: #666;
    gap: 5px;
}
.detail-text {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    max-width: 200px;
}
.item-referral {
    display: flex;
    align-items: center;
    gap: 6px;
    font-weight: 700;
    color: #0088cc;
    font-size: 1rem;
    background: linear-gradient(135deg, #e3f2fd 0%, #f0f8ff 100%);
    padding: 8px 12px;
    border-radius: 20px;
    box-shadow: 0 2px 8px rgba(0, 136, 204, 0.2);
    transition: all 0.3s ease;
    flex-shrink: 0;
}
.item-referral:hover {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    transform: scale(1.05);
    box-shadow: 0 4px 12px rgba(0, 136, 204, 0.3);
}
.item-icon {
    color: #ffd700;
    font-size: 1.1rem;
    animation: bounce 2s infinite;
}
.referral-count {
    font-size: 1.1rem;
}
.referral-label {
    font-size: 0.8rem;
    opacity: 0.8;
}
/* Responsive */
@media (max-width: 768px) {
    .leaders-header { padding: 15px; margin-bottom: 15px; }
    .header-icon { font-size: 1.5rem; }
    .leaders-title { font-size: 1.3rem; }
    .leaders-list-item { padding: 12px 15px; }
    .item-avatar-wrapper { width: 45px; height: 45px; margin-right: 12px; }
    .item-name { font-size: 1rem; }
    .item-details { font-size: 0.8rem; }
    .item-referral { font-size: 0.9rem; padding: 6px 10px; }
    .detail-text { max-width: 150px; }
}
@media (max-width: 480px) {
    .leaders-list-item { padding: 10px 12px; }
    .item-avatar-wrapper { width: 40px; height: 40px; margin-right: 10px; }
    .item-name { font-size: 0.95rem; }
    .item-details { font-size: 0.75rem; }
    .item-referral { font-size: 0.85rem; padding: 5px 8px; }
}
</style>
<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/zonexpro/hgzy.zone-x.pro/resources/views/user/leaders.blade.php ENDPATH**/ ?>