<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
.create-order-container {
    max-width: 800px;
    margin: 0 auto;
    padding: 20px;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: #333;
}
.order-header {
    text-align: center;
    margin-bottom: 40px;
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    padding: 40px 20px;
    border-radius: 15px;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
    animation: fadeInUp 0.8s ease-out;
}
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}
.order-header h1 {
    font-size: 2.2rem;
    margin-bottom: 10px;
    font-weight: 700;
    text-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
}
.order-header p {
    font-size: 1.1rem;
    opacity: 0.9;
    margin: 0;
}
.order-form {
    background: white;
    padding: 40px;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
    margin-bottom: 30px;
    border: 1px solid rgba(0, 136, 204, 0.1);
    backdrop-filter: blur(10px);
    animation: fadeInUp 0.8s ease-out 0.2s both;
}
.form-group {
    margin-bottom: 25px;
    position: relative;
    animation: fadeInUp 0.6s ease-out 0.3s both;
}
.form-group label {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-bottom: 8px;
    font-weight: 600;
    color: #0088cc;
    font-size: 1rem;
}
.form-group i {
    color: #0088cc;
    font-size: 1.1rem;
}
.form-control {
    width: 100%;
    padding: 15px 18px 15px 45px;
    border: 2px solid #e0e0e0;
    border-radius: 12px;
    font-size: 1rem;
    transition: all 0.3s ease;
    background: #f8f9fa;
    position: relative;
    box-sizing: border-box;
}
.form-control:focus {
    border-color: #0088cc;
    outline: none;
    box-shadow: 0 0 0 0.2rem rgba(0, 136, 204, 0.15);
    background: white;
    transform: translateY(-1px);
}
.input-icon {
    position: absolute;
    left: 16px;
    top: 50%;
    transform: translateY(-50%);
    color: #0088cc;
    font-size: 1.1rem;
    z-index: 1;
}
.verify-section {
    background: linear-gradient(135deg, #e3f2fd 0%, #f0f8ff 100%);
    padding: 25px;
    border-radius: 12px;
    margin-bottom: 25px;
    border-left: 4px solid #0088cc;
    box-shadow: 0 4px 15px rgba(0, 136, 204, 0.1);
    animation: fadeInUp 0.6s ease-out 0.4s both;
}
.verify-section h4 {
    color: #0088cc;
    margin-bottom: 10px;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 8px;
}
.verify-section p {
    color: #666;
    margin-bottom: 15px;
    font-size: 0.95rem;
}
.btn-verify {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    border: none;
    padding: 12px 25px;
    border-radius: 25px;
    cursor: pointer;
    transition: all 0.3s ease;
    font-weight: 600;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    box-shadow: 0 4px 15px rgba(0, 136, 204, 0.3);
}
.btn-verify:hover:not(:disabled) {
    background: linear-gradient(135deg, #006ba6 0%, #0088cc 100%);
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(0, 136, 204, 0.4);
    color: white;
}
.btn-verify:disabled {
    background: #bdc3c7;
    cursor: not-allowed;
    transform: none;
    box-shadow: none;
}
.calculation-card {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    padding: 25px;
    border-radius: 15px;
    margin-bottom: 25px;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
    animation: fadeInUp 0.6s ease-out 0.5s both;
}
.calculation-card h4 {
    text-align: center;
    margin-bottom: 20px;
    font-weight: 700;
    font-size: 1.3rem;
}
.calc-row {
    display: flex;
    justify-content: space-between;
    margin-bottom: 10px;
    padding: 8px 0;
    border-bottom: 1px solid rgba(255,255,255,0.2);
    font-size: 1rem;
}
.calc-row.total {
    font-size: 1.3rem;
    font-weight: bold;
    border-bottom: none;
    margin-top: 15px;
    padding-top: 15px;
    border-top: 2px solid rgba(255,255,255,0.3);
    color: #00ff88;
}
.balance-check {
    padding: 15px;
    border-radius: 12px;
    margin-bottom: 20px;
    text-align: center;
    font-weight: 600;
    transition: all 0.3s ease;
    animation: fadeInUp 0.6s ease-out 0.6s both;
}
.balance-check.success {
    background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
    border: 1px solid #c3e6cb;
    color: #155724;
    box-shadow: 0 4px 15px rgba(76, 175, 80, 0.2);
}
.balance-check.insufficient {
    background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%);
    border: 1px solid #f5c6cb;
    color: #721c24;
    box-shadow: 0 4px 15px rgba(220, 53, 69, 0.2);
}
.balance-check.default {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border: 1px solid #dee2e6;
    color: #495057;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
}
.btn-submit {
    background: linear-gradient(135deg, #27ae60 0%, #2ecc71 100%);
    color: white;
    border: none;
    padding: 15px 40px;
    border-radius: 12px;
    font-size: 1.1rem;
    font-weight: bold;
    cursor: pointer;
    width: 100%;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    box-shadow: 0 4px 15px rgba(39, 174, 96, 0.3);
    animation: fadeInUp 0.6s ease-out 0.7s both;
}
.btn-submit:hover:not(:disabled) {
    background: linear-gradient(135deg, #219a52 0%, #27ae60 100%);
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(39, 174, 96, 0.4);
    color: white;
}
.btn-submit:disabled {
    background: #bdc3c7;
    cursor: not-allowed;
    transform: none;
    box-shadow: none;
}
.loading-spinner {
    display: none;
    width: 20px;
    height: 20px;
    border: 2px solid #ffffff;
    border-top: 2px solid transparent;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}
@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}
.verification-result {
    margin-top: 15px;
    padding: 12px;
    border-radius: 8px;
    display: none;
    font-weight: 600;
    transition: all 0.3s ease;
}
.verification-success {
    background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
    border: 1px solid #c3e6cb;
    color: #155724;
    box-shadow: 0 2px 8px rgba(76, 175, 80, 0.2);
}
.verification-error {
    background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%);
    border: 1px solid #f5c6cb;
    color: #721c24;
    box-shadow: 0 2px 8px rgba(220, 53, 69, 0.2);
}
.admin-bot-info {
    background: linear-gradient(135deg, #e3f2fd 0%, #f0f8ff 100%);
    border: 1px solid #bbdefb;
    padding: 20px;
    border-radius: 12px;
    margin-bottom: 20px;
    text-align: center;
    font-size: 0.95rem;
    box-shadow: 0 4px 15px rgba(0, 136, 204, 0.1);
    animation: fadeInUp 0.6s ease-out 0.8s both;
}
.admin-bot-info strong {
    color: #0088cc;
}
.admin-bot-info a {
    color: #0088cc;
    font-weight: bold;
    text-decoration: none;
    padding: 8px 16px;
    background: white;
    border-radius: 20px;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(0, 136, 204, 0.2);
}
.admin-bot-info a:hover {
    background: #f0f8ff;
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(0, 136, 204, 0.3);
    text-decoration: none;
    color: #0088cc;
}
.deposit-balance-info {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    padding: 20px;
    border-radius: 15px;
    margin-bottom: 20px;
    text-align: center;
    font-weight: 600;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
    animation: fadeInUp 0.6s ease-out 0.1s both;
}
.deposit-balance-info strong {
    font-size: 1.3rem;
}
.deposit-balance-info small {
    opacity: 0.9;
    display: block;
    margin-top: 5px;
}
.back-link {
    text-align: center;
    margin-top: 20px;
    animation: fadeInUp 0.6s ease-out 0.9s both;
}
.back-link a {
    background: linear-gradient(135deg, #95a5a6 0%, #7f8c8d 100%);
    color: white;
    padding: 12px 30px;
    border-radius: 25px;
    text-decoration: none;
    font-weight: bold;
    font-size: 1rem;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(149, 165, 166, 0.3);
}
.back-link a:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(149, 165, 166, 0.4);
    text-decoration: none;
    color: white;
}
/* Responsive */
@media (max-width: 768px) {
    .create-order-container { padding: 15px; }
    .order-header { padding: 30px 15px; }
    .order-header h1 { font-size: 1.8rem; }
    .order-form { padding: 30px 20px; }
    .form-group { margin-bottom: 20px; }
    .verify-section, .calculation-card { padding: 20px; }
    .btn-submit { padding: 13px 30px; font-size: 1rem; }
    .admin-bot-info, .deposit-balance-info { padding: 15px; }
}
</style>
<!-- Success Sound Audio (with fallback handling) -->
<audio id="successSound" preload="auto">
    <source src="https://hgzy.zone-x.pro/public/sounds/1.mp3" type="audio/mpeg">
    <!-- Fallback to a silent or local sound if external fails -->
</audio>
<br><br><br>
<div class="create-order-container">
    <div class="order-header">
        <h1><i class="fas fa-plus-circle"></i> Create Channel Order</h1>
        <p>Order premium members using your <strong>Deposit Balance</strong> – Watch your channel thrive!</p>
    </div>
    <?php if(!Auth::check() || !Auth::user()->telegram_user_id || Auth::user()->tg_id_status != 1): ?>
        <div class="alert alert-warning text-center" style="background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%); border: 1px solid #ffeaa7; color: #856404; padding: 20px; border-radius: 12px; margin-bottom: 20px; box-shadow: 0 4px 15px rgba(255, 193, 7, 0.2);">
            <h4><i class="fas fa-exclamation-triangle"></i> Telegram Verification Required</h4>
            <p>Please <a href="<?php echo e(route('telegram.connect')); ?>" style="color: #856404; font-weight: bold; text-decoration: underline;">verify your Telegram ID</a> to unlock channel ordering features.</p>
        </div>
    <?php else: ?>
        <!-- Deposit Balance Display -->
        <div class="deposit-balance-info">
            <strong>Available Deposit Balance: ৳<?php echo e(number_format(Auth::user()->deposit_balance ?? 0, 2)); ?></strong>
            <small>This secure balance will power your channel growth – Add funds anytime!</small>
        </div>
        <div class="admin-bot-info">
            <strong><i class="fas fa-robot"></i> Pro Tip:</strong> For flawless delivery, add
            <a href="https://t.me/ChatID_SB_Robot" target="_blank">@ChatID_SB_Robot</a>
            as admin to your channel now.
        </div>
        <form id="orderForm" method="POST" action="<?php echo e(route('channel.order.store')); ?>">
            <?php echo csrf_field(); ?>
            <div class="order-form">
                <!-- Channel Username -->
                <div class="form-group">
                    <label for="channel_username">
                        <i class="fas fa-at"></i> Channel Username *
                    </label>
                    <i class="fas fa-at input-icon"></i>
                    <input type="text" id="channel_username" name="channel_username" class="form-control"
                           placeholder="e.g., mychannel (without @)" required value="<?php echo e(old('channel_username')); ?>">
                    <small class="text-muted">Enter username without @ symbol – We'll verify instantly!</small>
                    <?php $__errorArgs = ['channel_username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger mt-1"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <!-- Admin Verification -->
                <div class="verify-section">
                    <h4><i class="fas fa-user-shield"></i> Verify Admin Status</h4>
                    <p>Confirm you're an admin for secure, targeted delivery</p>
                    <input type="hidden" id="user_telegram_id" value="<?php echo e(Auth::user()->telegram_user_id ?? ''); ?>">
                    <button type="button" onclick="verifyChannelAdmin()" class="btn-verify" id="verify-btn">
                        <i class="fas fa-check-circle"></i> Verify Admin Status
                        <div class="loading-spinner" id="verify-spinner"></div>
                    </button>
                    <div class="verification-result" id="verification-result"></div>
                </div>
                <!-- Member Count -->
                <div class="form-group">
                    <label for="member_count">
                        <i class="fas fa-users"></i> Number of Members *
                    </label>
                    <i class="fas fa-users input-icon"></i>
                    <input type="number" id="member_count" name="member_count" class="form-control"
                           min="<?php echo e($minMembers ?? 50); ?>" max="<?php echo e($maxMembers ?? 50000); ?>"
                           value="<?php echo e(old('member_count', $minMembers ?? 50)); ?>" required>
                    <small class="text-muted">Min: <?php echo e($minMembers ?? 50); ?> | Max: <?php echo e($maxMembers ?? 50000); ?> – Choose wisely for optimal growth!</small>
                    <?php $__errorArgs = ['member_count'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger mt-1"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <!-- Calculation Card -->
                <div class="calculation-card">
                    <h4><i class="fas fa-calculator"></i> Smart Order Summary</h4>
                    <div class="calc-row">
                        <span><i class="fas fa-user-plus me-2"></i>Members:</span>
                        <span id="calc-members">0</span>
                    </div>
                    <div class="calc-row">
                        <span><i class="fas fa-coins me-2"></i>Cost per Member:</span>
                        <span>৳<?php echo e(number_format($costPerMember ?? 1, 2)); ?></span>
                    </div>
                    <div class="calc-row total">
                        <span><i class="fas fa-wallet me-2"></i>Total Investment:</span>
                        <span>৳<span id="calc-total">0.00</span></span>
                    </div>
                </div>
                <!-- Balance Check -->
                <div class="balance-check default" id="balance-check">
                    <div id="balance-message">Enter member count to preview your Deposit Balance</div>
                </div>
                <!-- Submit Button -->
                <button type="submit" class="btn-submit" id="submit-btn" disabled>
                    <i class="fas fa-paper-plane"></i> Launch Growth - ৳<span id="submit-amount">0.00</span>
                    <div class="loading-spinner" id="submit-spinner"></div>
                </button>
            </div>
        </form>
    <?php endif; ?>
    <div class="back-link">
        <a href="<?php echo e(route('channel.orders')); ?>">
            <i class="fas fa-arrow-left"></i> Back to Orders Dashboard
        </a>
    </div>
</div>
<script>
let isVerified = false;
const successSound = document.getElementById('successSound');
function playSuccessSound() {
    if (successSound) {
        successSound.currentTime = 0;
        successSound.volume = 0.5; // Reduced volume to avoid annoyance
        successSound.play().catch(e => console.log('Audio play failed:', e));
    }
}
// Update calculation + balance check
function updateCalculation() {
    const memberCountInput = document.getElementById('member_count');
    const memberCount = parseInt(memberCountInput ? memberCountInput.value : 0) || 0;
    const costPerMember = parseFloat('<?php echo e($costPerMember ?? 1); ?>') || 1;
    const totalCost = memberCount * costPerMember;
    const depositBalance = parseFloat('<?php echo e(Auth::user()->deposit_balance ?? 0); ?>') || 0;
    // Update UI safely
    const calcMembersEl = document.getElementById('calc-members');
    const calcTotalEl = document.getElementById('calc-total');
    const submitAmountEl = document.getElementById('submit-amount');
    if (calcMembersEl) calcMembersEl.textContent = memberCount.toLocaleString();
    if (calcTotalEl) calcTotalEl.textContent = totalCost.toFixed(2);
    if (submitAmountEl) submitAmountEl.textContent = totalCost.toFixed(2);
    const balanceCheck = document.getElementById('balance-check');
    const message = document.getElementById('balance-message');
    const submitBtn = document.getElementById('submit-btn');
    if (!balanceCheck || !message || !submitBtn) return; // Safety check
    if (memberCount > 0) {
        if (depositBalance >= totalCost && isVerified) {
            balanceCheck.className = 'balance-check success';
            message.innerHTML = `<i class="fas fa-check-circle me-2"></i>Sufficient Deposit Balance: ৳${depositBalance.toFixed(2)} – Ready to launch!`;
            submitBtn.disabled = false;
        } else if (depositBalance < totalCost) {
            balanceCheck.className = 'balance-check insufficient';
            message.innerHTML = `<i class="fas fa-exclamation-triangle me-2"></i>Insufficient Deposit Balance<br>
                <strong>Need:</strong> ৳${totalCost.toFixed(2)} | <strong>Available:</strong> ৳${depositBalance.toFixed(2)}<br>
                <small><a href="<?php echo e(route('deposit')); ?>">Add Funds Now</a></small>`;
            submitBtn.disabled = true;
        } else {
            balanceCheck.className = 'balance-check default';
            message.innerHTML = `<i class="fas fa-shield-alt me-2"></i>Verify admin status to proceed – Your security first!`;
            submitBtn.disabled = true;
        }
    } else {
        balanceCheck.className = 'balance-check default';
        message.innerHTML = `<i class="fas fa-info-circle me-2"></i>Enter member count to preview your investment and balance`;
        submitBtn.disabled = true;
    }
}
// Verify Channel Admin
function verifyChannelAdmin() {
    const channelInput = document.getElementById('channel_username');
    const userIdInput = document.getElementById('user_telegram_id');
    const channel = channelInput ? channelInput.value.trim() : '';
    const userId = userIdInput ? userIdInput.value : '';
    const btn = document.getElementById('verify-btn');
    const spinner = document.getElementById('verify-spinner');
    const result = document.getElementById('verification-result');
    if (!btn || !result) return;
    if (!channel) {
        result.className = 'verification-result verification-error';
        result.innerHTML = '<i class="fas fa-exclamation-triangle me-2"></i>Please enter channel username first.';
        result.style.display = 'block';
        return;
    }
    if (!userId) {
        result.className = 'verification-result verification-error';
        result.innerHTML = '<i class="fas fa-exclamation-triangle me-2"></i>Telegram ID not found. Please reconnect.';
        result.style.display = 'block';
        return;
    }
    btn.disabled = true;
    if (spinner) spinner.style.display = 'inline-block';
    result.style.display = 'none';
    fetch('<?php echo e(route("channel.order.verify")); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '<?php echo e(csrf_token()); ?>',
            'Accept': 'application/json'
        },
        body: JSON.stringify({
            channel_username: channel,
            user_telegram_id: userId
        })
    })
    .then(response => {
        if (!response.ok) {
            throw new Error(`HTTP ${response.status}: ${response.statusText}`);
        }
        return response.json();
    })
    .then(data => {
        if (data.success && data.is_admin) {
            result.className = 'verification-result verification-success';
            result.innerHTML = `<i class="fas fa-check-circle me-2"></i>${data.message || 'Admin verified successfully!'} – Channel secured!`;
            isVerified = true;
            updateCalculation();
        } else {
            result.className = 'verification-result verification-error';
            result.innerHTML = `<i class="fas fa-times-circle me-2"></i>${data.message || 'Admin verification failed – Double-check your channel settings.'}`;
            isVerified = false;
            const submitBtn = document.getElementById('submit-btn');
            if (submitBtn) submitBtn.disabled = true;
        }
        result.style.display = 'block';
    })
    .catch(error => {
        console.error('Verification error:', error);
        result.className = 'verification-result verification-error';
        result.innerHTML = '<i class="fas fa-exclamation-triangle me-2"></i>Verification failed. Please try again or contact support.';
        result.style.display = 'block';
        isVerified = false;
        const submitBtn = document.getElementById('submit-btn');
        if (submitBtn) submitBtn.disabled = true;
    })
    .finally(() => {
        btn.disabled = false;
        if (spinner) spinner.style.display = 'none';
    });
}
// Event Listeners
document.addEventListener('DOMContentLoaded', function() {
    const memberCountEl = document.getElementById('member_count');
    const channelUsernameEl = document.getElementById('channel_username');
    if (memberCountEl) {
        memberCountEl.addEventListener('input', updateCalculation);
    }
    if (channelUsernameEl) {
        channelUsernameEl.addEventListener('input', () => {
            isVerified = false;
            const resultEl = document.getElementById('verification-result');
            const submitBtn = document.getElementById('submit-btn');
            if (resultEl) resultEl.style.display = 'none';
            if (submitBtn) submitBtn.disabled = true;
        });
    }
    // Initial load
    updateCalculation();
});
// Form submit with AJAX for success sound
document.addEventListener('DOMContentLoaded', function() {
    const orderForm = document.getElementById('orderForm');
    if (!orderForm) return;
    orderForm.addEventListener('submit', function(e) {
        e.preventDefault();
        if (!isVerified) {
            const resultEl = document.getElementById('verification-result');
            if (resultEl) {
                resultEl.scrollIntoView({ behavior: 'smooth' });
            }
            alert('Please verify admin status first to ensure secure delivery.');
            return;
        }
        const formData = new FormData(orderForm);
        const btn = document.getElementById('submit-btn');
        const spinner = document.getElementById('submit-spinner');
        if (!btn) return;
        if (spinner) spinner.style.display = 'inline-block';
        btn.disabled = true;
        const originalHTML = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i> Launching Growth...';
        fetch('<?php echo e(route('channel.order.store')); ?>', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(response => {
            if (!response.ok) {
                throw new Error(`HTTP ${response.status}: ${response.statusText}`);
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                playSuccessSound();
                alert(data.message || 'Order placed successfully! Redirecting...');
                window.location.href = "<?php echo e(route('channel.orders')); ?>";
            } else {
                alert(data.message || 'Order failed. Please try again.');
            }
        })
        .catch(error => {
            console.error('Submit error:', error);
            alert('Something went wrong! Please try again.');
        })
        .finally(() => {
            btn.disabled = false;
            if (spinner) spinner.style.display = 'none';
            btn.innerHTML = originalHTML;
        });
    });
});
</script>
<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/teleearn/public_html/resources/views/user/create_channel_order.blade.php ENDPATH**/ ?>