<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<br><br><br>
<div class="user-profile-wrapper">
    <div class="profile-section">
        <div class="profile-header">
            <h2 class="profile-title">Edit Your Profile</h2>
            <p class="profile-subtitle">Keep your account information up to date</p>
        </div>

        <form action="<?php echo e(route('profile_update')); ?>" method="POST" enctype="multipart/form-data" class="profile-form">
            <?php echo csrf_field(); ?>
            <div class="form-grid">
                <div class="form-block">
                    <label class="form-label-custom" for="profile_image">Profile Image</label>
                    <input type="file" name="profile_image" id="profile_image" class="form-input-custom">
                </div>

                <div class="form-block">
                    <label class="form-label-custom" for="first_name">First Name</label>
                    <input type="text" name="first_name" id="first_name" value="<?php echo e($data->fname); ?>" class="form-input-custom" required>
                </div>

                <div class="form-block">
                    <label class="form-label-custom" for="email">Email Address</label>
                    <input type="email" name="email" id="email" value="<?php echo e($data->email); ?>" class="form-input-custom" required>
                </div>

                <div class="form-block">
                    <label class="form-label-custom" for="phone">Phone Number</label>
                    <input type="text" name="phone" id="phone" value="<?php echo e($data->phone); ?>" class="form-input-custom" readonly>
                </div>

                <div class="form-block">
                    <label class="form-label-custom" for="password">New Password</label>
                    <input type="text" name="password" id="password" class="form-input-custom" placeholder="Enter new password">
                </div>
            </div>

            <div class="form-footer">
                <button type="submit" class="btn-update-profile">Process</button>
            </div>
        </form>
    </div>
</div>

<style>
    body {
        font-family: 'Segoe UI', sans-serif;
        background-color: #e0f7fa; /* Lighter sky blue */
        color: #263238; /* Darker text for contrast */
        margin: 0;
        padding: 0;
    }

    .user-profile-wrapper {
        width: 90%; /* Slightly smaller overall */
        max-width: 400px; /* Reduced max-width */
        margin: 20px auto; /* Adjusted margin */
        background: #ffffff;
        border-radius: 10px; /* Slightly smaller border-radius */
        box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1); /* Softer shadow */
        overflow: hidden;
    }

    .profile-section {
        padding: 20px; /* Reduced padding */
    }

    .profile-header {
        text-align: center;
        margin-bottom: 25px; /* Reduced margin */
    }

    .profile-title {
        font-size: 22px; /* Smaller font size */
        font-weight: 700; /* Bolder */
        color: #0288d1; /* Sky blue */
        margin-bottom: 5px;
    }

    .profile-subtitle {
        font-size: 13px; /* Smaller font size */
        color: #78909c; /* Muted sky blue text */
    }

    .profile-form {
        display: flex;
        flex-direction: column;
        gap: 15px; /* Reduced gap */
    }

    .form-grid {
        display: grid;
        grid-template-columns: 1fr; /* Always single column for smaller design */
        gap: 15px; /* Reduced gap */
    }

    .form-block {
        display: flex;
        flex-direction: column;
    }

    .form-label-custom {
        font-size: 13px; /* Smaller font size */
        font-weight: 600; /* Slightly bolder */
        margin-bottom: 5px; /* Reduced margin */
        color: #455a64; /* Darker grey-blue */
    }

    .form-input-custom {
        padding: 9px 12px; /* Reduced padding */
        border-radius: 6px; /* Smaller border-radius */
        border: 1px solid #b0bec5; /* Muted border color */
        font-size: 13px; /* Smaller font size */
        transition: 0.3s ease;
        background-color: #f5f5f5; /* Light grey background */
    }

    .form-input-custom:focus {
        outline: none;
        border-color: #03a9f4; /* Brighter sky blue on focus */
        box-shadow: 0 0 0 3px rgba(3, 169, 244, 0.2); /* Softer shadow on focus */
        background-color: #ffffff;
    }

    .form-footer {
        text-align: center;
        margin-top: 20px; /* Adjusted margin */
    }

    .btn-update-profile {
        padding: 10px 25px; /* Reduced padding */
        background-color: #03a9f4; /* Sky blue button */
        color: white;
        font-size: 14px; /* Smaller font size */
        font-weight: 600;
        border: none;
        border-radius: 20px; /* More rounded */
        cursor: pointer;
        transition: background-color 0.3s ease, box-shadow 0.3s ease;
        box-shadow: 0 4px 10px rgba(3, 169, 244, 0.3); /* Sky blue shadow */
    }

    .btn-update-profile:hover {
        background-color: #0288d1; /* Darker sky blue on hover */
        box-shadow: 0 6px 15px rgba(2, 136, 209, 0.4);
    }

    /* No specific media query needed as form-grid is already single column */
</style>

<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/botpaysh/aruu.bot-pay.shop/resources/views/user/profile.blade.php ENDPATH**/ ?>