

<?php $__env->startSection('body'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Ads Management</h3>
                </div>
                <div class="card-body">
                    
                    <!-- Pending Ads -->
                    <h4>Pending Ads (<?php echo e($pendingAds->count()); ?>)</h4>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>User</th>
                                    <th>Image</th>
                                    <th>Link</th>
                                    <th>Duration</th>
                                    <th>Amount</th>
                                    <th>Created At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $pendingAds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($ad->user->name); ?> (<?php echo e($ad->user->email); ?>)</td>
                                    <td>
                                        <img src="<?php echo e(asset('ads_images/' . $ad->image)); ?>" alt="Ad Image" style="width: 100px; height: auto;">
                                    </td>
                                    <td><a href="<?php echo e($ad->link); ?>" target="_blank"><?php echo e(Str::limit($ad->link, 30)); ?></a></td>
                                    <td><?php echo e($ad->duration_hours); ?> hours</td>
                                    <td>৳<?php echo e($ad->amount); ?></td>
                                    <td><?php echo e($ad->created_at->format('d M Y h:i A')); ?></td>
                                    <td>
                                        <form action="<?php echo e(route('admin.ads.approve', $ad->id)); ?>" method="POST" style="display: inline;">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-success btn-sm">Approve</button>
                                        </form>
                                        <form action="<?php echo e(route('admin.ads.reject', $ad->id)); ?>" method="POST" style="display: inline;">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-danger btn-sm">Reject</button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Active Ads -->
                    <h4 class="mt-5">Active Ads (<?php echo e($activeAds->count()); ?>)</h4>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>User</th>
                                    <th>Image</th>
                                    <th>Link</th>
                                    <th>Duration</th>
                                    <th>Start Time</th>
                                    <th>End Time</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $activeAds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($ad->user->name); ?></td>
                                    <td>
                                        <img src="<?php echo e(asset('ads_images/' . $ad->image)); ?>" alt="Ad Image" style="width: 100px; height: auto;">
                                    </td>
                                    <td><a href="<?php echo e($ad->link); ?>" target="_blank"><?php echo e(Str::limit($ad->link, 30)); ?></a></td>
                                    <td><?php echo e($ad->duration_hours); ?> hours</td>
                                    <td><?php echo e($ad->start_time->format('d M Y h:i A')); ?></td>
                                    <td><?php echo e($ad->end_time->format('d M Y h:i A')); ?></td>
                                    <td>
                                        <form action="<?php echo e(route('admin.ads.delete', $ad->id)); ?>" method="POST" style="display: inline;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/teleearn/checkk.tele-earn.com/resources/views/admin/ads/index.blade.php ENDPATH**/ ?>