<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
.loader-spinner {
  width: 16px;
  height: 16px;
  border: 2px solid white;
  border-top: 2px solid transparent;
  border-radius: 50%;
  animation: spin 0.8s linear infinite;
  display: inline-block;
}
@keyframes spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}
/* Deposit Balance Styles - Telegram Blue Theme */
.deposit-balance-section {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    border-radius: 15px;
    padding: 20px;
    margin: 20px 0;
    color: white;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
}
.balance-container {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 20px;
}
.balance-card {
    background: rgba(255, 255, 255, 0.2);
    padding: 20px;
    border-radius: 12px;
    text-align: center;
    flex: 1;
    min-width: 200px;
    backdrop-filter: blur(10px);
}
.balance-card h3 {
    margin: 0 0 10px 0;
    font-size: 1rem;
    opacity: 0.9;
}
.balance-card .amount {
    font-size: 2rem;
    font-weight: bold;
    margin: 0;
}
.balance-card.main-balance .amount {
    color: #fff;
}
.balance-card.deposit-balance .amount {
    color: #00ff88;
}
.balance-stats {
    display: flex;
    gap: 15px;
    margin-top: 15px;
    justify-content: center;
}
.stat-item {
    background: rgba(255, 255, 255, 0.2);
    padding: 10px 15px;
    border-radius: 8px;
    text-align: center;
}
.stat-item .label {
    font-size: 0.8rem;
    opacity: 0.8;
}
.stat-item .value {
    font-size: 1.1rem;
    font-weight: bold;
}
.deposit-actions {
    display: flex;
    gap: 10px;
    margin-top: 15px;
    justify-content: center;
}
.btn-deposit {
    background: white;
    color: #0088cc;
    border: none;
    padding: 10px 20px;
    border-radius: 25px;
    font-weight: bold;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 5px;
}
.btn-deposit:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(255, 255, 255, 0.3);
    color: #0088cc;
    text-decoration: none;
}
.btn-transfer {
    background: transparent;
    color: white;
    border: 2px solid white;
    padding: 10px 20px;
    border-radius: 25px;
    font-weight: bold;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 5px;
}
.btn-transfer:hover {
    background: white;
    color: #0088cc;
    text-decoration: none;
}
/* Existing Styles Adapted to Blue Theme */
.mining-box {
    max-width: 360px;
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    margin: 25px auto;
    padding: 25px 28px;
    border-radius: 15px;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: white;
    text-align: center;
    user-select: none;
}
.mining-box strong {
    color: #fff;
    font-weight: 700;
}
.progress-bar-container {
    width: 100%;
    height: 14px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 12px;
    margin: 20px 0 0 0;
    overflow: hidden;
    box-shadow: inset 0 1px 3px rgba(0,0,0,0.1);
}
.progress-bar-fill {
    height: 100%;
    width: 0;
    background: linear-gradient(90deg, #00ff88, #10b981);
    border-radius: 12px;
    transition: width 1s linear;
    box-shadow: 0 0 8px rgba(0, 255, 136, 0.6);
}
.modal-overlay {
    position: fixed;
    inset: 0;
    background: rgba(0, 136, 204, 0.7);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 9999;
    opacity: 0;
    pointer-events: none;
    transition: opacity 0.3s ease;
}
.modal-overlay.active {
    opacity: 1;
    pointer-events: all;
}
.modal-content {
    background: white;
    border-radius: 20px;
    padding: 30px 35px 40px 35px;
    width: 380px;
    max-width: 95vw;
    box-shadow: 0 15px 40px rgba(0, 136, 204, 0.25);
    text-align: center;
    position: relative;
}
.modal-content h2 {
    color: #0088cc;
    font-weight: 700;
    font-size: 26px;
    margin-bottom: 15px;
    user-select: text;
}
.collected-amount {
    font-size: 28px;
    font-weight: 700;
    color: #00ff88;
    margin-bottom: 25px;
    opacity: 0;
    transform: translateY(15px);
    transition: opacity 0.5s ease, transform 0.5s ease;
    user-select: text;
}
.collected-amount.visible {
    opacity: 1;
    transform: translateY(0);
}
.gift-box {
    width: 140px;
    height: 140px;
    margin: 0 auto 30px auto;
    background: url('https://pngimg.com/d/gift_PNG100280.png') no-repeat center/contain;
    cursor: pointer;
    position: relative;
    transition: transform 0.35s ease;
    user-select: none;
    perspective: 600px;
}
.gift-box::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 140px;
    height: 140px;
    background: url('https://pngimg.com/d/gift_PNG5946.png') no-repeat center/contain;
    background-position: top center;
    transform-origin: bottom center;
    transition: transform 1s ease;
    z-index: 10;
    backface-visibility: hidden;
}
.gift-box.open::before {
    transform: rotateX(-100deg);
}
.gift-box.open {
    animation: bounceOpen 0.6s ease forwards;
}
@keyframes bounceOpen {
    0% { transform: scale(1); }
    50% { transform: scale(1.1) translateY(-8px); }
    100% { transform: scale(1); }
}
.modal-collect-btn {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    border: none;
    padding: 14px 32px;
    border-radius: 35px;
    font-weight: 700;
    font-size: 18px;
    color: white;
    box-shadow: 0 6px 15px rgba(0, 136, 204, 0.5);
    cursor: pointer;
    transition: background 0.3s ease, box-shadow 0.3s ease;
    user-select: none;
    width: 100%;
    max-width: 320px;
    margin: 0 auto;
}
.modal-collect-btn:hover:not(:disabled) {
    background: linear-gradient(135deg, #006ba6 0%, #0088cc 100%);
    box-shadow: 0 8px 25px rgba(0, 107, 166, 0.6);
}
.modal-collect-btn:disabled {
    background: #94a3b8;
    cursor: not-allowed;
    box-shadow: none;
}
.modal-close-btn {
    position: absolute;
    top: 10px;
    right: 15px;
    font-size: 24px;
    background: none;
    border: none;
    color: #aaa;
    cursor: pointer;
}
.modal-close-btn:hover {
    color: #000;
}
.wallet-blue {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    border-radius: 15px;
    padding: 25px;
    color: white;
    margin: 20px 0;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
}
.wallet-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}
.wallet-header h2 {
    margin: 0;
    font-size: 1.5rem;
}
.wallet-btn {
    background: rgba(255, 255, 255, 0.2);
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 25px;
    cursor: pointer;
    font-weight: bold;
    display: flex;
    align-items: center;
    gap: 8px;
    transition: all 0.3s ease;
    text-decoration: none;
}
.wallet-btn:hover {
    background: rgba(255, 255, 255, 0.3);
    transform: translateY(-2px);
}
.wallet-balance {
    text-align: center;
    margin-bottom: 25px;
}
.wallet-balance p {
    margin: 0 0 10px 0;
    opacity: 0.9;
    font-size: 1rem;
}
.wallet-balance h1 {
    margin: 0;
    font-size: 3rem;
    font-weight: bold;
}
.wallet-stats {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
    gap: 15px;
    margin-bottom: 25px;
}
.stat-box {
    background: rgba(255, 255, 255, 0.2);
    padding: 15px;
    border-radius: 10px;
    text-align: center;
    backdrop-filter: blur(10px);
}
.stat-box p {
    margin: 0 0 5px 0;
    font-size: 0.9rem;
    opacity: 0.8;
}
.stat-box h3 {
    margin: 0;
    font-size: 1.3rem;
    font-weight: bold;
}
.wallet-activity {
    background: rgba(255, 255, 255, 0.1);
    padding: 20px;
    border-radius: 10px;
}
.wallet-activity h4 {
    margin: 0 0 15px 0;
    font-size: 1.1rem;
}
.wallet-activity ul {
    list-style: none;
    padding: 0;
    margin: 0;
}
.wallet-activity li {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}
.wallet-activity li:last-child {
    border-bottom: none;
}
.referral-section {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    border-radius: 15px;
    padding: 25px;
    color: white;
    margin: 20px 0;
    text-align: center;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
}
.referral-section h3 {
    margin: 0 0 10px 0;
    font-size: 1.4rem;
}
.referral-section p {
    margin: 0 0 20px 0;
    opacity: 0.9;
}
.referral-box {
    display: flex;
    gap: 10px;
    margin-bottom: 15px;
    max-width: 400px;
    margin-left: auto;
    margin-right: auto;
}
.referral-box input {
    flex: 1;
    padding: 12px 15px;
    border: none;
    border-radius: 25px;
    background: rgba(255, 255, 255, 0.9);
    font-size: 0.9rem;
}
.referral-box button {
    background: white;
    color: #0088cc;
    border: none;
    padding: 12px 20px;
    border-radius: 25px;
    font-weight: bold;
    cursor: pointer;
    transition: all 0.3s ease;
}
.referral-box button:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(255, 255, 255, 0.3);
}
.referral-note {
    font-size: 0.9rem;
    opacity: 0.8;
    margin: 0;
}
.social-box-section {
    margin: 20px 0;
}
.social-box-section h3 {
    text-align: center;
    margin-bottom: 20px;
    color: #2c3e50;
}
.social-box {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 20px;
}
.telegram-card, .youtube-card {
    background: white;
    border-radius: 15px;
    padding: 25px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}
.telegram-card {
    border-left: 4px solid #0088cc;
}
.youtube-card {
    border-left: 4px solid #ff0000;
}
.social-title {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-bottom: 15px;
}
.social-title h4 {
    margin: 0;
    color: #2c3e50;
}
.social-title i {
    font-size: 1.5rem;
}
.telegram-card .social-title i {
    color: #0088cc;
}
.youtube-card .social-title i {
    color: #ff0000;
}
.social-btn {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    padding: 12px 25px;
    border-radius: 25px;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    font-weight: bold;
    transition: all 0.3s ease;
}
.social-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0, 136, 204, 0.4);
    color: white;
    text-decoration: none;
}
.youtube-embed {
    margin-top: 15px;
    border-radius: 10px;
    overflow: hidden;
}
.youtube-embed iframe {
    width: 100%;
    height: 200px;
    border: none;
    border-radius: 10px;
}
.investment-plans-section {
    margin: 20px 0;
    text-align: center;
}
.investment-plans-section h2 {
    color: #2c3e50;
    margin-bottom: 25px;
}
.plans-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
}
.plan-card {
    background: white;
    padding: 25px;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    text-align: center;
    transition: transform 0.3s ease;
    border-top: 4px solid #0088cc;
}
.plan-card:hover {
    transform: translateY(-5px);
}
.plan-card h3 {
    color: #2c3e50;
    margin-bottom: 10px;
}
.plan-card p {
    color: #7f8c8d;
    margin-bottom: 15px;
}
.plan-tag {
    background: #0088cc;
    color: white;
    padding: 5px 15px;
    border-radius: 15px;
    font-size: 0.8rem;
    font-weight: bold;
}
.plan-tag.high {
    background: #00a0e9;
}
.telegram-connect-section {
    margin: 25px 0;
}
.telegram-connect-card {
    background: linear-gradient(135deg, #0088cc, #00a0e9);
    border-radius: 15px;
    padding: 25px;
    color: white;
    display: flex;
    align-items: center;
    box-shadow: 0 10px 25px rgba(0, 136, 204, 0.3);
}
.telegram-connect-card .telegram-icon {
    font-size: 50px;
    margin-right: 20px;
    opacity: 0.9;
}
.telegram-content {
    flex: 1;
}
.telegram-content h3 {
    margin: 0 0 10px 0;
    font-size: 22px;
    font-weight: 700;
}
.telegram-content p {
    margin: 0 0 15px 0;
    opacity: 0.9;
    font-size: 14px;
}
.telegram-status {
    display: inline-flex;
    align-items: center;
    padding: 8px 15px;
    border-radius: 20px;
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 15px;
}
.telegram-status.verified {
    background: rgba(0, 255, 136, 0.2);
    border: 1px solid #00ff88;
}
.telegram-status.not-verified {
    background: rgba(255, 193, 7, 0.2);
    border: 1px solid #ffc107;
}
.telegram-status i {
    margin-right: 5px;
}
.btn-telegram-connect {
    background: white;
    color: #0088cc;
    padding: 12px 25px;
    border-radius: 25px;
    text-decoration: none;
    font-weight: 700;
    display: inline-flex;
    align-items: center;
    transition: all 0.3s ease;
}
.btn-telegram-connect:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(255, 255, 255, 0.3);
    color: #0088cc;
    text-decoration: none;
}
.btn-telegram-connect i {
    margin-right: 8px;
}
</style>
<div class="col-lg-8">
    <div class="padding-top-2x mt-2 hidden-lg-up"></div>
    <br>
  
    <div class="notice-headline">
        ⚠️ <span id="notice-text">Welcome To Tele Earn</span>
    </div>
  
    <?php if(auth()->user()->user_active == 0): ?>
    <div class="account-activate-box">
        <div class="activate-content">
            <div class="activate-icon">
                <img src="https://cdn-icons-png.flaticon.com/512/1828/1828843.png" alt="Lock Icon" />
            </div>
            <div class="activate-text">
                <h4>Software Inactive in this account</h4>
                <p>Please activate the software in your account</p>
                <a href="<?php echo e(route('account_payment')); ?>" class="activate-btn">Run the Software</a>
            </div>
        </div>
    </div>
    <?php endif; ?>
  
    <br>
    <!-- Deposit Balance Section -->
    <div class="deposit-balance-section">
        <div class="balance-container">
            <div class="balance-card main-balance">
                <h3>💰 Main Balance</h3>
                <p class="amount">৳<?php echo e(number_format(Auth::user()->balance, 2)); ?></p>
                <div class="balance-stats">
                    <div class="stat-item">
                        <div class="label">Today</div>
                        <div class="value">+৳0.00</div>
                    </div>
                    <div class="stat-item">
                        <div class="label">Total</div>
                        <div class="value">৳<?php echo e(number_format($totalEarned, 2)); ?></div>
                    </div>
                </div>
            </div>
          
            <div class="balance-card deposit-balance">
                <h3>🏦 Deposit Balance</h3>
                <p class="amount">৳<?php echo e(number_format(Auth::user()->deposit_balance, 2)); ?></p>
                <div class="balance-stats">
                    <div class="stat-item">
                        <div class="label">Locked</div>
                        <div class="value">৳0.00</div>
                    </div>
                    <div class="stat-item">
                        <div class="label">Available</div>
                        <div class="value">৳<?php echo e(number_format(Auth::user()->deposit_balance, 2)); ?></div>
                    </div>
                </div>
            </div>
        </div>
      
        <div class="deposit-actions">
            <a href="/deposit" class="btn-deposit">
                <i class="fas fa-plus"></i> Add Deposit
            </a>
            <button class="btn-transfer" onclick="showTransferModal()">
                <i class="fas fa-exchange-alt"></i> Transfer
            </button>
        </div>
    </div>
    <?php
        use Carbon\Carbon;
        $user = Auth::user();
        $pendingAmount = $user->pending_earning;
        $lastTime = $user->last_earning_time ? Carbon::parse($user->last_earning_time) : now();
        $nextEarningTime = $lastTime->copy()->addMinute();
    ?>
    <div class="mining-box" style="display: none">
        <p><strong>Pending Balance:</strong> ৳<?php echo e(number_format($pendingAmount, 2)); ?></p>
        <p><strong>Next Earning In:</strong></p>
        <div class="progress-bar-container">
            <div class="progress-bar-fill" id="progress-bar"></div>
        </div>
    </div>
    <?php if($pendingAmount > 0): ?>
    <div class="modal-overlay active" id="gift-modal" role="dialog" aria-modal="true" aria-labelledby="modal-title" tabindex="-1">
        <div class="modal-content">
            <h2 id="modal-title">You have a gift!</h2>
            <button class="modal-close-btn" id="modal-close-btn" aria-label="Close modal">&times;</button>
            <div class="collected-amount" id="collected-amount">৳<?php echo e(number_format($pendingAmount, 2)); ?></div>
            <div class="gift-box" id="gift-box" tabindex="0" aria-label="Gift box, click to open"></div>
            <form method="POST" action="<?php echo e(route('mining.collect')); ?>">
                <?php echo csrf_field(); ?>
                <button type="submit" class="modal-collect-btn" id="collect-btn" <?php if($pendingAmount <= 0): ?> disabled <?php endif; ?> disabled>
                    Collect
                </button>
            </form>
        </div>
    </div>
    <?php endif; ?>
    <div class="wallet-blue">
        <div class="wallet-header">
            <h2>My Wallet 💳</h2>
            <a href="" class="wallet-btn">
                Earnig
                <?php if(auth()->user()->user_active == 1): ?>
                    <span class="loader-spinner"></span>
                <?php else: ?>
                    <span>❌</span>
                <?php endif; ?>
            </a>
        </div>
        <div class="wallet-balance">
            <p>Total Available Balance</p>
            <h1>৳<?php echo e(number_format(Auth::user()->balance + Auth::user()->deposit_balance, 2)); ?></h1>
        </div>
        <div class="wallet-stats">
            <div class="stat-box">
                <p>Total Earned</p>
                <h3>৳<?php echo e(number_format($totalEarned, 2)); ?></h3>
            </div>
            <div class="stat-box">
                <p>Total Spent</p>
                <h3>৳<?php echo e(number_format($totalPayments, 2)); ?></h3>
            </div>
            <div class="stat-box">
                <p>Total Withdraw</p>
                <h3>৳<?php echo e(number_format($totalWithdrawalAmount, 2)); ?></h3>
            </div>
        </div>
        </div>
    <div class="referral-section">
        <h3>Refer & Earn 🎉</h3>
        <p>Share your referral code and earn rewards!</p>
        <div class="referral-box">
            <input type="text" id="referralCode" value="<?php echo e(route('register')); ?>?by=<?php echo e(auth()->user()->ref_code); ?>" readonly>
            <button onclick="copyReferralCode()">Copy</button>
        </div>
        <p class="referral-note">You'll earn money for every friend who signs up using your link!</p>
    </div>
    <div class="social-box-section">
        <h3>Connected With Us</h3>
        <div class="social-box">
            <div class="telegram-card">
                <div class="social-title">
                    <i class="fab fa-telegram-plane"></i>
                    <h4>Join Our Telegram</h4>
                </div>
                <p>Get updates, tips & community support.</p>
                <a href="<?php echo e(app('telegram_url')); ?>" target="_blank" class="social-btn">
                    <i class="fab fa-telegram-plane"></i> Join Now
                </a>
            </div>
            <div class="youtube-card">
                <div class="social-title">
                    <i class="fab fa-youtube"></i>
                    <h4>Watch on YouTube</h4>
                </div>
                <p>Learn how to use the app and earn more.</p>
                <div class="youtube-embed">
                    <iframe src="<?php echo e(app('youtube_link_embed')); ?>" title="YouTube video" allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </div>
    <div class="telegram-connect-section">
        <div class="telegram-connect-card">
            <div class="telegram-icon">
                <i class="fab fa-telegram-plane"></i>
            </div>
            <div class="telegram-content">
                <h3>Connect Telegram</h3>
                <p>Connect your Telegram account to unlock exclusive features and notifications</p>
              
                <?php if(Auth::user()->tg_id_status == 1): ?>
                    <div class="telegram-status verified">
                        <i class="fas fa-check-circle"></i>
                        <span>Telegram Connected ✅</span>
                    </div>
                <?php else: ?>
                    <div class="telegram-status not-verified">
                        <i class="fas fa-exclamation-circle"></i>
                        <span>Telegram Not Connected</span>
                    </div>
                <?php endif; ?>
              
                <a href="<?php echo e(route('telegram.connect')); ?>" class="btn-telegram-connect">
                    <i class="fab fa-telegram-plane"></i>
                    <?php echo e(Auth::user()->tg_id_status == 1 ? 'Manage Connection' : 'Connect Now'); ?>

                </a>
            </div>
        </div>
    </div>
    <div class="investment-plans-section">
        <h2>Popular Investment Plans</h2>
        <div class="plans-grid">
            <div class="plan-card">
                <h3>Auto Mining</h3>
                <p>Get return per hour</p>
                <span class="plan-tag">No Risk</span>
            </div>
            <div class="plan-card">
                <h3>AutoType Earning</h3>
                <p>Use software and earn auto</p>
                <span class="plan-tag">Secure</span>
            </div>
            <div class="plan-card">
                <h3>Refer extra earning</h3>
                <p>🚀 Refer and Get Commissions | No Risk</p>
                <span class="plan-tag high">No Risk</span>
            </div>
        </div>
    </div>
    <?php if(session('register_success')): ?>
    <div class="alert alert-success text-center" style="font-size: 20px; margin-top: 20px;">
        <?php echo e(session('register_success')); ?>

    </div>
    <script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.6.0/dist/confetti.browser.min.js"></script>
    <script>
        const audio = new Audio("<?php echo e(asset('sounds/register_success.mp3')); ?>");
        audio.play();
        function launchConfetti() {
            const duration = 3 * 1000;
            const animationEnd = Date.now() + duration;
            const defaults = { startVelocity: 30, spread: 360, ticks: 60, zIndex: 9999 };
            function randomInRange(min, max) {
                return Math.random() * (max - min) + min;
            }
            const interval = setInterval(function() {
                const timeLeft = animationEnd - Date.now();
                if (timeLeft <= 0) {
                    clearInterval(interval);
                    return;
                }
                confetti({
                    particleCount: 50,
                    origin: { x: randomInRange(0.1, 0.9), y: Math.random() - 0.2 },
                    ...defaults
                });
            }, 200);
        }
        launchConfetti();
    </script>
    <?php endif; ?>
</div>
<script>
    // Deposit and Transfer Modal Functions
    function showDepositModal() {
        alert('Deposit feature coming soon!');
    }
  
    function showTransferModal() {
        alert('Transfer between balances feature coming soon!');
    }
  
    function copyReferralCode() {
        const input = document.getElementById("referralCode");
        input.select();
        input.setSelectionRange(0, 99999);
        try {
            navigator.clipboard.writeText(input.value).then(() => {
                alert("Referral link copied to clipboard!");
            }).catch(() => {
                document.execCommand("copy");
                alert("Referral link copied to clipboard!");
            });
        } catch (err) {
            document.execCommand("copy");
            alert("Referral link copied to clipboard!");
        }
    }
    // Existing mining functionality
    const nextEarningTime = new Date("<?php echo e($nextEarningTime->format('Y-m-d H:i:s')); ?>").getTime();
    const progressBar = document.getElementById('progress-bar');
    const totalDuration = 60;
    let interval;
    function updateProgress() {
        const now = new Date().getTime();
        let distance = (nextEarningTime - now) / 1000;
        if (distance <= 0) {
            progressBar.style.width = '100%';
            clearInterval(interval);
            return;
        }
        let progressPercent = ((totalDuration - distance) / totalDuration) * 100;
        progressBar.style.width = progressPercent + '%';
    }
    updateProgress();
    interval = setInterval(updateProgress, 1000);
    <?php if($pendingAmount > 0): ?>
    const giftBox = document.getElementById('gift-box');
    const collectBtn = document.getElementById('collect-btn');
    const collectedAmountEl = document.getElementById('collected-amount');
    collectedAmountEl.classList.remove('visible');
    collectBtn.disabled = true;
    function openGiftBox() {
        giftBox.classList.add('open');
        setTimeout(() => {
            collectedAmountEl.classList.add('visible');
            collectBtn.disabled = false;
        }, 1000);
    }
    giftBox.addEventListener('click', () => {
        if (collectBtn.disabled) openGiftBox();
    });
    giftBox.addEventListener('keydown', (e) => {
        if ((e.key === "Enter" || e.key === " ") && collectBtn.disabled) {
            e.preventDefault();
            openGiftBox();
        }
    });
    <?php endif; ?>
    document.addEventListener('DOMContentLoaded', () => {
        const modal = document.getElementById('gift-modal');
        const closeBtn = document.getElementById('modal-close-btn');
        const closedAt = localStorage.getItem('giftModalClosedAt');
        if (closedAt) {
            const diff = (Date.now() - parseInt(closedAt, 10)) / (1000 * 60 * 60);
            if (diff < 1 && modal) {
                modal.style.display = 'none';
            }
        }
        if (closeBtn) {
            closeBtn.addEventListener('click', () => {
                if (modal) {
                    modal.style.display = 'none';
                    localStorage.setItem('giftModalClosedAt', Date.now().toString());
                }
            });
        }
    });
</script>
<script>
document.addEventListener("DOMContentLoaded", () => {
    // শুধুমাত্র একবার বাজানোর জন্য sessionStorage ব্যবহার
    if (!sessionStorage.getItem('soundPlayed')) {
        const audio = new Audio("<?php echo e(asset('sounds/1.mp3')); ?>"); // আপনার public/sounds/1.mp3 ফাইলের পাথ
        audio.preload = 'auto'; // Preload করে ভালো পারফর্মেন্সের জন্য
        audio.volume = 1.0;
        audio.load(); // লোড নিশ্চিত করুন
        // Autoplay চেষ্টা করুন
        audio.play()
            .then(() => {
                console.log('Sound played successfully!');
                sessionStorage.setItem('soundPlayed', 'true');
            })
            .catch((error) => {
                console.log('Autoplay prevented:', error);
                // যদি autoplay block হয়, প্রথম ক্লিকে বাজান
                const playOnce = () => {
                    audio.play().then(() => {
                        console.log('Sound played on click!');
                        sessionStorage.setItem('soundPlayed', 'true');
                        document.body.removeEventListener('click', playOnce);
                    }).catch((err) => {
                        console.log('Play on click failed:', err);
                    });
                };
                document.body.addEventListener('click', playOnce, { once: true });
            });
    }
});
</script>
<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/zonexpro/hgzy.zone-x.pro/resources/views/user/dashboard.blade.php ENDPATH**/ ?>