<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;700&family=Plus+Jakarta+Sans:wght@400;500;600;700&display=swap" rel="stylesheet">

<div class="page-wrapper">
    <div class="leaderboard-wrapper">
        
        <div class="leaderboard-hero">
            <div class="hero-content">
                <div class="hero-badge">
                    <i class="fas fa-crown"></i> Elite Club
                </div>
                <h1 class="hero-title">Referral Champions</h1>
                <p class="hero-subtitle">Top influencers shaping the future of our community</p>
            </div>
            <div class="hero-glow-effect"></div>
        </div>
        
        <div class="leaderboard-container">
            <div class="podium-section">
                <?php $rank = 1; ?>
                <?php $__currentLoopData = $topUsers->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topUser): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($rank <= 3): ?>
                        <div class="podium-item rank-<?php echo e($rank); ?>">
                            <div class="crown-icon">
                                <?php echo $rank === 1 ? '<i class="fas fa-crown"></i>' : ''; ?>

                            </div>
                            
                            <div class="podium-avatar-wrapper">
                                <img src="<?php echo e($topUser->profile_image ? asset('uploads/profile_images/' . $topUser->profile_image) : 'https://www.pngall.com/wp-content/uploads/5/Profile-PNG-File.png'); ?>" alt="Profile" class="avatar-img" onerror="this.src='https://www.pngall.com/wp-content/uploads/5/Profile-PNG-File.png'; this.onerror=null;">
                                <div class="rank-badge"><?php echo e($rank); ?></div>
                            </div>

                            <div class="podium-details">
                                <h3 class="podium-name"><?php echo e($topUser->fname); ?> <?php echo e($topUser->lname); ?></h3>
                                <div class="podium-stats">
                                    <span class="stat-value"><?php echo e($topUser->ura); ?></span>
                                    <span class="stat-label">Referrals</span>
                                </div>
                            </div>
                            
                            <div class="podium-base">
                                <div class="podium-number"><?php echo e($rank === 1 ? '1st' : ($rank === 2 ? '2nd' : '3rd')); ?></div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php $rank++; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            
            <div class="leaders-grid">
                <?php $counter = 3; ?>
                <?php $__currentLoopData = $topUsers->skip(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($counter < 300000000): ?>
                        <div class="leader-card" style="--delay: <?php echo e(($counter - 3) * 0.05); ?>s;">
                            <div class="card-left">
                                <div class="card-rank">#<?php echo e($counter + 1); ?></div>
                                <div class="card-avatar">
                                    <img src="<?php echo e($user->profile_image ? asset('uploads/profile_images/' . $user->profile_image) : 'https://www.pngall.com/wp-content/uploads/5/Profile-PNG-File.png'); ?>" alt="Profile" onerror="this.src='https://www.pngall.com/wp-content/uploads/5/Profile-PNG-File.png'; this.onerror=null;">
                                </div>
                                <div class="card-info">
                                    <h4 class="card-name"><?php echo e($user->fname); ?> <?php echo e($user->lname); ?></h4>
                                    <p class="card-email"><?php echo e($user->email); ?></p>
                                </div>
                            </div>
                            <div class="card-stats">
                                <div class="stat-pill">
                                    <i class="fas fa-users"></i>
                                    <span><?php echo e($user->ura); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php $counter++; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>

<style>
/* PREMIUM DARK GLASS THEME 
    Font: Outfit & Plus Jakarta Sans
*/
:root {
    --bg-dark: #0f172a;
    --card-bg: rgba(30, 41, 59, 0.7);
    --glass-border: rgba(255, 255, 255, 0.08);
    --text-primary: #f8fafc;
    --text-secondary: #94a3b8;
    
    /* Rank Colors */
    --gold: #fbbf24;
    --gold-glow: rgba(251, 191, 36, 0.5);
    --silver: #e2e8f0;
    --silver-glow: rgba(226, 232, 240, 0.4);
    --bronze: #f59e0b;
    --bronze-glow: rgba(245, 158, 11, 0.4);
    
    --accent: #6366f1; /* Indigo */
    --accent-glow: rgba(99, 102, 241, 0.4);
}

body {
    background-color: var(--bg-dark);
    background-image: 
        radial-gradient(at 0% 0%, rgba(99, 102, 241, 0.15) 0px, transparent 50%),
        radial-gradient(at 100% 0%, rgba(236, 72, 153, 0.15) 0px, transparent 50%);
    font-family: 'Plus Jakarta Sans', sans-serif;
    color: var(--text-primary);
    margin: 0;
    overflow-x: hidden;
}

.page-wrapper {
    padding-top: 60px; /* Replaces br tags */
    padding-bottom: 60px;
    min-height: 100vh;
}

.leaderboard-wrapper {
    max-width: 1100px;
    margin: 0 auto;
    padding: 0 20px;
}

/* --- Hero Section --- */
.leaderboard-hero {
    text-align: center;
    padding: 60px 20px;
    margin-bottom: 60px;
    position: relative;
    border-radius: 24px;
    background: linear-gradient(180deg, rgba(255,255,255,0.05) 0%, rgba(255,255,255,0) 100%);
    border: 1px solid var(--glass-border);
    backdrop-filter: blur(10px);
    overflow: hidden;
}

.hero-badge {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    background: rgba(99, 102, 241, 0.2);
    color: #a5b4fc;
    padding: 8px 16px;
    border-radius: 100px;
    font-size: 0.9rem;
    font-weight: 600;
    margin-bottom: 20px;
    border: 1px solid rgba(99, 102, 241, 0.3);
}

.hero-title {
    font-family: 'Outfit', sans-serif;
    font-size: 3.5rem;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, #fff 0%, #cbd5e1 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    letter-spacing: -1px;
    text-shadow: 0 10px 30px rgba(0,0,0,0.2);
}

.hero-subtitle {
    font-size: 1.1rem;
    color: var(--text-secondary);
    margin-top: 15px;
    max-width: 600px;
    margin-left: auto;
    margin-right: auto;
}

/* --- Podium Section --- */
.podium-section {
    display: flex;
    justify-content: center;
    align-items: flex-end;
    gap: 20px;
    margin-bottom: 80px;
    min-height: 380px;
}

.podium-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-align: center;
    position: relative;
    transition: transform 0.4s cubic-bezier(0.34, 1.56, 0.64, 1);
    z-index: 1;
}

.podium-item:hover {
    transform: translateY(-10px);
}

/* Reordering for visual hierarchy: 2-1-3 */
.rank-1 { order: 2; z-index: 10; margin-bottom: 20px; }
.rank-2 { order: 1; }
.rank-3 { order: 3; }

.podium-avatar-wrapper {
    position: relative;
    margin-bottom: 20px;
    border-radius: 50%;
    padding: 4px;
    background: linear-gradient(180deg, rgba(255,255,255,0.2), transparent);
}

.avatar-img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    border-radius: 50%;
    border: 3px solid #1e293b;
}

.rank-1 .avatar-img { width: 120px; height: 120px; border-color: var(--gold); box-shadow: 0 0 30px var(--gold-glow); }
.rank-2 .avatar-img { width: 90px; height: 90px; border-color: var(--silver); box-shadow: 0 0 20px var(--silver-glow); }
.rank-3 .avatar-img { width: 90px; height: 90px; border-color: var(--bronze); box-shadow: 0 0 20px var(--bronze-glow); }

.rank-badge {
    position: absolute;
    bottom: -5px;
    left: 50%;
    transform: translateX(-50%);
    width: 30px;
    height: 30px;
    background: #1e293b;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 800;
    font-size: 0.9rem;
    border: 2px solid;
}
.rank-1 .rank-badge { border-color: var(--gold); color: var(--gold); }
.rank-2 .rank-badge { border-color: var(--silver); color: var(--silver); }
.rank-3 .rank-badge { border-color: var(--bronze); color: var(--bronze); }

.crown-icon {
    font-size: 2.5rem;
    color: var(--gold);
    margin-bottom: 10px;
    filter: drop-shadow(0 0 10px var(--gold-glow));
    animation: float 3s ease-in-out infinite;
}

.podium-details {
    margin-bottom: 15px;
}

.podium-name {
    font-family: 'Outfit', sans-serif;
    font-size: 1.2rem;
    font-weight: 700;
    color: #fff;
    margin: 0 0 5px 0;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    max-width: 180px;
}

.podium-stats {
    display: flex;
    flex-direction: column;
    gap: 2px;
}
.stat-value {
    font-weight: 800;
    font-size: 1.4rem;
    color: var(--text-primary);
}
.rank-1 .stat-value { color: var(--gold); }
.stat-label {
    font-size: 0.75rem;
    text-transform: uppercase;
    letter-spacing: 1px;
    color: var(--text-secondary);
}

/* The glowing boxes under the avatars */
.podium-base {
    width: 100%;
    border-radius: 16px 16px 0 0;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(180deg, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0.02) 100%);
    backdrop-filter: blur(20px);
    border-top: 1px solid rgba(255,255,255,0.2);
    box-shadow: 0 10px 30px rgba(0,0,0,0.3);
}

.rank-1 .podium-base { height: 160px; width: 200px; background: linear-gradient(180deg, rgba(251, 191, 36, 0.15) 0%, rgba(30, 41, 59, 0.4) 100%); border-top: 1px solid var(--gold); }
.rank-2 .podium-base { height: 110px; width: 160px; background: linear-gradient(180deg, rgba(226, 232, 240, 0.1) 0%, rgba(30, 41, 59, 0.4) 100%); border-top: 1px solid var(--silver); }
.rank-3 .podium-base { height: 80px; width: 160px; background: linear-gradient(180deg, rgba(245, 158, 11, 0.1) 0%, rgba(30, 41, 59, 0.4) 100%); border-top: 1px solid var(--bronze); }

.podium-number {
    font-family: 'Outfit', sans-serif;
    font-size: 3rem;
    font-weight: 800;
    opacity: 0.3;
}
.rank-1 .podium-number { color: var(--gold); font-size: 4rem; opacity: 0.5; }

/* --- Leaders List Grid --- */
.leaders-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
    gap: 20px;
}

.leader-card {
    display: flex;
    align-items: center;
    justify-content: space-between;
    background: var(--card-bg);
    border: 1px solid var(--glass-border);
    padding: 16px 20px;
    border-radius: 16px;
    transition: all 0.3s ease;
    animation: slideUp 0.6s cubic-bezier(0.2, 0.8, 0.2, 1) forwards;
    opacity: 0;
    transform: translateY(20px);
    animation-delay: var(--delay);
}

.leader-card:hover {
    transform: translateY(-5px) scale(1.02);
    background: rgba(45, 55, 72, 0.8);
    border-color: rgba(99, 102, 241, 0.4);
    box-shadow: 0 10px 25px rgba(0,0,0,0.2);
}

.card-left {
    display: flex;
    align-items: center;
    gap: 15px;
    flex: 1;
    min-width: 0;
}

.card-rank {
    font-family: 'Outfit', sans-serif;
    font-size: 1.1rem;
    font-weight: 700;
    color: var(--text-secondary);
    min-width: 35px;
}

.card-avatar {
    width: 45px;
    height: 45px;
    border-radius: 50%;
    overflow: hidden;
    flex-shrink: 0;
    border: 2px solid rgba(255,255,255,0.1);
}
.card-avatar img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.card-info {
    flex: 1;
    min-width: 0;
}

.card-name {
    margin: 0;
    font-size: 1rem;
    font-weight: 600;
    color: #fff;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.card-email {
    margin: 2px 0 0 0;
    font-size: 0.8rem;
    color: var(--text-secondary);
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.card-stats .stat-pill {
    background: rgba(99, 102, 241, 0.1);
    color: #818cf8;
    padding: 6px 12px;
    border-radius: 100px;
    font-size: 0.9rem;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 6px;
    border: 1px solid rgba(99, 102, 241, 0.2);
}
.leader-card:hover .stat-pill {
    background: #6366f1;
    color: #fff;
}

/* Animations */
@keyframes float {
    0%, 100% { transform: translateY(0); }
    50% { transform: translateY(-8px); }
}
@keyframes slideUp {
    to { opacity: 1; transform: translateY(0); }
}

/* Responsive */
@media (max-width: 768px) {
    .podium-section {
        flex-direction: column;
        align-items: center;
        gap: 30px;
        min-height: auto;
    }
    
    .rank-1, .rank-2, .rank-3 { order: unset; width: 100%; margin: 0; }
    
    .podium-base {
        width: 100% !important;
        height: 60px !important;
        border-radius: 12px;
    }
    .podium-number { font-size: 1.5rem !important; }
    
    .hero-title { font-size: 2.5rem; }
    .leaders-grid { grid-template-columns: 1fr; }
}
</style>
<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/teleearn/public_html/resources/views/user/leaders.blade.php ENDPATH**/ ?>