<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<style>

.loader-spinner {
  width: 16px;
  height: 16px;
  border: 2px solid white;
  border-top: 2px solid transparent;
  border-radius: 50%;
  animation: spin 0.8s linear infinite;
  display: inline-block;
}

@keyframes spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}
</style>




<div class="col-lg-8">
    <div class="padding-top-2x mt-2 hidden-lg-up"></div>
    <br>
<div class="notice-headline">
  ⚠️ <span id="notice-text">Important: Your notice hare.</span>
</div>
        <?php if(auth()->user()->user_active == 0): ?>
        <div class="account-activate-box">
            <div class="activate-content">
                <div class="activate-icon">
                    <img src="https://cdn-icons-png.flaticon.com/512/1828/1828843.png" alt="Lock Icon" />
                </div>
                <div class="activate-text">
                    <h4>Software Inactive in this account</h4>
                    <p>Please activate the software in your account</p>
                    <a href="<?php echo e(route('account_payment')); ?>" class="activate-btn">Run the Software</a>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
<br>
<?php
    use Carbon\Carbon;

    $user = Auth::user();

    $pendingAmount = $user->pending_earning;
    $lastTime = $user->last_earning_time ? Carbon::parse($user->last_earning_time) : now();
    $nextEarningTime = $lastTime->copy()->addMinute();
?>

<style>
    .mining-box {
        max-width: 360px;
        background: #f3f4f6; /* light gray background */
        margin: 25px auto;
        padding: 25px 28px;
        border-radius: 15px;
        box-shadow: 0 8px 25px rgba(100, 116, 139, 0.15);
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        color: #1e293b;
        text-align: center;
        user-select: none;
    }

    .mining-box strong {
        color: #2563eb; /* bright blue */
        font-weight: 700;
    }

    .progress-bar-container {
        width: 100%;
        height: 14px;
        background: #d1d5db;
        border-radius: 12px;
        margin: 20px 0 0 0;
        overflow: hidden;
        box-shadow: inset 0 1px 3px rgba(0,0,0,0.1);
    }

    .progress-bar-fill {
        height: 100%;
        width: 0;
        background: linear-gradient(90deg, #10b981, #3b82f6);
        border-radius: 12px;
        transition: width 1s linear;
        box-shadow: 0 0 8px rgba(16, 185, 129, 0.6);
    }

    /* Modal overlay */
    .modal-overlay {
        position: fixed;
        inset: 0;
        background: rgba(31, 41, 55, 0.7);
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9999;
        opacity: 0;
        pointer-events: none;
        transition: opacity 0.3s ease;
    }
    .modal-overlay.active {
        opacity: 1;
        pointer-events: all;
    }

    /* Modal content */
    .modal-content {
        background: white;
        border-radius: 20px;
        padding: 30px 35px 40px 35px;
        width: 380px;
        max-width: 95vw;
        box-shadow: 0 15px 40px rgba(0,0,0,0.25);
        text-align: center;
        position: relative;
    }

    .modal-content h2 {
        color: #2563eb;
        font-weight: 700;
        font-size: 26px;
        margin-bottom: 15px;
        user-select: text;
    }

    /* Collected amount text above gift box */
    .collected-amount {
        font-size: 28px;
        font-weight: 700;
        color: #10b981;
        margin-bottom: 25px;
        opacity: 0;
        transform: translateY(15px);
        transition: opacity 0.5s ease, transform 0.5s ease;
        user-select: text;
    }
    .collected-amount.visible {
        opacity: 1;
        transform: translateY(0);
    }

    /* Gift box container */
    .gift-box {
        width: 140px;
        height: 140px;
        margin: 0 auto 30px auto;
        background: url('https://pngimg.com/d/gift_PNG100280.png') no-repeat center/contain;
        cursor: pointer;
        position: relative;
        transition: transform 0.35s ease;
        user-select: none;
        perspective: 600px;
    }

    /* Lid is a pseudo element */
    .gift-box::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 140px;
        height: 140px;
        background: url('https://pngimg.com/d/gift_PNG5946.png') no-repeat center/contain;
        background-position: top center;
        transform-origin: bottom center;
        transition: transform 1s ease;
        z-index: 10;
        backface-visibility: hidden;
    }

    /* Lid open */
    .gift-box.open::before {
        transform: rotateX(-100deg);
    }

    /* Slight bounce on open */
    .gift-box.open {
        animation: bounceOpen 0.6s ease forwards;
    }
    @keyframes bounceOpen {
        0% { transform: scale(1); }
        50% { transform: scale(1.1) translateY(-8px); }
        100% { transform: scale(1); }
    }

    /* Collect button */
    .modal-collect-btn {
        background-color: #10b981;
        border: none;
        padding: 14px 32px;
        border-radius: 35px;
        font-weight: 700;
        font-size: 18px;
        color: white;
        box-shadow: 0 6px 15px rgba(16, 185, 129, 0.5);
        cursor: pointer;
        transition: background-color 0.3s ease, box-shadow 0.3s ease;
        user-select: none;
        width: 100%;
        max-width: 320px;
        margin: 0 auto;
    }
    .modal-collect-btn:hover:not(:disabled) {
        background-color: #059669;
        box-shadow: 0 8px 25px rgba(5, 150, 105, 0.6);
    }
    .modal-collect-btn:disabled {
        background-color: #94a3b8;
        cursor: not-allowed;
        box-shadow: none;
    }
</style>

<div class="mining-box " style="display: none">
    <p><strong>Pending Balance:</strong> ৳<?php echo e(number_format($pendingAmount, 2)); ?></p>

    <p><strong>Next Earning In:</strong></p>
    <div class="progress-bar-container">
        <div class="progress-bar-fill" id="progress-bar"></div>
    </div>
</div>


<?php if($pendingAmount > 0): ?>
<div class="modal-overlay active" id="gift-modal" role="dialog" aria-modal="true" aria-labelledby="modal-title" tabindex="-1">
    <div class="modal-content">
        <h2 id="modal-title">You have a gift!</h2>

        <div class="collected-amount" id="collected-amount">৳<?php echo e(number_format($pendingAmount, 2)); ?></div>

        <div class="gift-box" id="gift-box" tabindex="0" aria-label="Gift box, click to open"></div>

        <form method="POST" action="<?php echo e(route('mining.collect')); ?>">
            <?php echo csrf_field(); ?>
            <button
                type="submit"
                class="modal-collect-btn"
                id="collect-btn"
                <?php if($pendingAmount <= 0): ?> disabled <?php endif; ?>
                disabled
            >
                Collect
            </button>
        </form>
    </div>
</div>
<?php endif; ?>

<script>
    // Progress bar
    const nextEarningTime = new Date("<?php echo e($nextEarningTime->format('Y-m-d H:i:s')); ?>").getTime();
    const progressBar = document.getElementById('progress-bar');
    const totalDuration = 60; // seconds
    let interval;

    function updateProgress() {
        const now = new Date().getTime();
        let distance = (nextEarningTime - now) / 1000;

        if (distance <= 0) {
            progressBar.style.width = '100%';
            clearInterval(interval);
            return;
        }

        let progressPercent = ((totalDuration - distance) / totalDuration) * 100;
        progressBar.style.width = progressPercent + '%';
    }

    updateProgress();
    interval = setInterval(updateProgress, 1000);

    // Gift modal logic
    <?php if($pendingAmount > 0): ?>
    const giftBox = document.getElementById('gift-box');
    const collectBtn = document.getElementById('collect-btn');
    const collectedAmountEl = document.getElementById('collected-amount');

    // Initially hide the collected amount and disable collect button
    collectedAmountEl.classList.remove('visible');
    collectBtn.disabled = true;

    function openGiftBox() {
        giftBox.classList.add('open');

        // Animate bounce is handled by CSS keyframes on open class

        // After animation ends (1s), reveal amount & enable collect button
        setTimeout(() => {
            collectedAmountEl.classList.add('visible');
            collectBtn.disabled = false;
        }, 1000);
    }

    giftBox.addEventListener('click', () => {
        if (collectBtn.disabled) openGiftBox();
    });

    giftBox.addEventListener('keydown', (e) => {
        if ((e.key === "Enter" || e.key === " ") && collectBtn.disabled) {
            e.preventDefault();
            openGiftBox();
        }
    });
    <?php endif; ?>
</script>




<div class="wallet-green">
  <div class="wallet-header">
    <h2>My Wallet 💳</h2>
    <a href="/mining">
   <button class="wallet-btn">
  Mining 
 <?php if(auth()->user()->user_active == 1): ?> <span class="loader-spinner"></span> <?php else: ?>
 <span>❌</span> <?php endif; ?>
</button> </a>

  </div>

  <div class="wallet-balance"> 
    <p>Available Balance</p>
    <h1>৳<?php echo e(Auth::user()->balance); ?></h1>
  </div>

  <div class="wallet-stats">
    <div class="stat-box">
      <p>Earned</p>
      <h3>৳0.0</h3>
    </div>
    <div class="stat-box">
      <p>Spent</p>
      <h3>৳0.0</h3>
    </div>
    <div class="stat-box">
      <p>Pending</p>
      <h3>৳<?php echo e(number_format($totalPendingAmount, 2)); ?></h3>
    </div>
  </div>

  <div class="wallet-activity">
    <h4>Total History</h4>
    <ul>
      <li><span>+৳<?php echo e(number_format($totalCollectedAmount, 2)); ?></span><span>Mining Income </span></li>
      <li><span>+৳300</span><span>Typing Income </span></li>
      <li><span>+৳500</span><span>Refer Income </span></li>
    </ul>
  </div>
</div>
<div class="referral-section">
  <h3>Refer & Earn 🎉</h3>
  <p>Share your referral code and earn rewards!</p>

  <div class="referral-box">
    <input type="text" id="referralCode" value="<?php echo e(route('register')); ?>?by=<?php echo e(auth()->user()->ref_code); ?>" readonly>
    <button onclick="copyReferralCode()">Copy</button>
  </div>

  <p class="referral-note">You’ll earn money for every friend who signs up using your link!</p>
</div>


<div class="social-box-section">
  <h3>Connected With Us🌐</h3>

  <div class="social-box">
    <div class="telegram-card">
      <div class="social-title">
        <h4>Join Our Telegram</h4>
      </div>
      <p>Get updates, tips & community support.</p>
      <a href="<?php echo e(app('telegram_url')); ?>" target="_blank" class="social-btn">
        <i class="fab fa-telegram-plane"></i> Join Now
      </a>
    </div>

    <div class="youtube-card">
      <div class="social-title">
        <i class="fab fa-youtube"></i>
        <h4>Watch on YouTube</h4>
      </div>
      <p>Learn how to use the app and earn more.</p>
      <div class="youtube-embed">
        <iframe src="<?php echo e(app('youtube_link_embed')); ?>"
                title="YouTube video"
                allowfullscreen></iframe>
      </div>
    </div>
  </div>
</div>


<div class="investment-plans-section">
  <h2>Popular Investment Plans</h2>

  <div class="plans-grid">
    <div class="plan-card">
      <h3>Smart Growth Fund</h3>
      <p>💹 Up to 14% Annual Return</p>
      <span class="plan-tag">Low Risk</span>
    </div>

    <div class="plan-card">
      <h3>Green Savings Bond</h3>
      <p>🌱 Government-backed | 8.5% Return</p>
      <span class="plan-tag">Secure</span>
    </div>

    <div class="plan-card">
      <h3>Crypto Flex Plan</h3>
      <p>🚀 Variable Returns | High Risk</p>
      <span class="plan-tag high">High Risk</span>
    </div>
  </div>
</div>

<script>
  function copyReferralCode() {
    const input = document.getElementById("referralCode");
    input.select();
    input.setSelectionRange(0, 99999); // Mobile support
    document.execCommand("copy");
    alert("Referral link copied to clipboard!");
  }
</script>
<?php if(session('register_success')): ?>
    <div class="alert alert-success text-center" style="font-size: 20px; margin-top: 20px;">
        <?php echo e(session('register_success')); ?>

    </div>

    <!-- Confetti + Sound -->
    <script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.6.0/dist/confetti.browser.min.js"></script>
    <script>
        const audio = new Audio("/public/1750675489186991179sblrujhyi-voicemaker.in-speech.mp3");
        audio.play();

        function launchConfetti() {
            const duration = 3 * 1000;
            const animationEnd = Date.now() + duration;
            const defaults = { startVelocity: 30, spread: 360, ticks: 60, zIndex: 9999 };

            function randomInRange(min, max) {
                return Math.random() * (max - min) + min;
            }

            const interval = setInterval(function() {
                const timeLeft = animationEnd - Date.now();

                if (timeLeft <= 0) {
                    clearInterval(interval);
                    return;
                }

                confetti({
                    particleCount: 50,
                    origin: {
                        x: randomInRange(0.1, 0.9),
                        y: Math.random() - 0.2
                    },
                    ...defaults
                });
            }, 200);
        }

        launchConfetti();
    </script>
<?php endif; ?>





<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/studentjobbd/kkkkkk.hatiya-panel.site/resources/views/user/dashboard.blade.php ENDPATH**/ ?>