<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
/* Global Page Alignment - Shift to Right */
body {
    margin-left: 0px;
    margin-right: 0;
}

.container {
    margin-left: 20px;
    margin-right: auto;
}

.loader-spinner {
  width: 16px;
  height: 16px;
  border: 2px solid white;
  border-top: 2px solid transparent;
  border-radius: 50%;
  animation: spin 0.8s linear infinite;
  display: inline-block;
}
@keyframes spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}
/* Deposit Balance Styles - Telegram Blue Theme */
.deposit-balance-section {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    border-radius: 15px;
    padding: 20px;
    margin: 20px 0;
    color: white;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
}
.balance-container {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 20px;
}
.balance-card {
    background: rgba(255, 255, 255, 0.2);
    padding: 20px;
    border-radius: 12px;
    text-align: center;
    flex: 1;
    min-width: 200px;
    backdrop-filter: blur(10px);
}
.balance-card h3 {
    margin: 0 0 10px 0;
    font-size: 1rem;
    opacity: 0.9;
}
.balance-card .amount {
    font-size: 2rem;
    font-weight: bold;
    margin: 0;
}
.balance-card.main-balance .amount {
    color: #fff;
}
.balance-card.deposit-balance .amount {
    color: #00ff88;
}
.balance-stats {
    display: flex;
    gap: 15px;
    margin-top: 15px;
    justify-content: center;
}
.stat-item {
    background: rgba(255, 255, 255, 0.2);
    padding: 10px 15px;
    border-radius: 8px;
    text-align: center;
}
.stat-item .label {
    font-size: 0.8rem;
    opacity: 0.8;
}
.stat-item .value {
    font-size: 1.1rem;
    font-weight: bold;
}
.deposit-actions {
    display: flex;
    gap: 10px;
    margin-top: 15px;
    justify-content: center;
}
.btn-deposit {
    background: white;
    color: #0088cc;
    border: none;
    padding: 10px 20px;
    border-radius: 25px;
    font-weight: bold;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 5px;
}
.btn-deposit:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(255, 255, 255, 0.3);
    color: #0088cc;
    text-decoration: none;
}
.btn-transfer {
    background: transparent;
    color: white;
    border: 2px solid white;
    padding: 10px 20px;
    border-radius: 25px;
    font-weight: bold;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 5px;
}
.btn-transfer:hover {
    background: white;
    color: #0088cc;
    text-decoration: none;
}
/* Existing Styles Adapted to Blue Theme */
.mining-box {
    max-width: 360px;
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    margin: 25px auto;
    padding: 25px 28px;
    border-radius: 15px;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: white;
    text-align: center;
    user-select: none;
}
.mining-box strong {
    color: #fff;
    font-weight: 700;
}
.progress-bar-container {
    width: 100%;
    height: 14px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 12px;
    margin: 20px 0 0 0;
    overflow: hidden;
    box-shadow: inset 0 1px 3px rgba(0,0,0,0.1);
}
.progress-bar-fill {
    height: 100%;
    width: 0;
    background: linear-gradient(90deg, #00ff88, #10b981);
    border-radius: 12px;
    transition: width 1s linear;
    box-shadow: 0 0 8px rgba(0, 255, 136, 0.6);
}
.modal-overlay {
    position: fixed;
    inset: 0;
    background: rgba(0, 136, 204, 0.7);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 9999;
    opacity: 0;
    pointer-events: none;
    transition: opacity 0.3s ease;
}
.modal-overlay.active {
    opacity: 1;
    pointer-events: all;
}
.modal-content {
    background: white;
    border-radius: 20px;
    padding: 30px 35px 40px 35px;
    width: 380px;
    max-width: 95vw;
    box-shadow: 0 15px 40px rgba(0, 136, 204, 0.25);
    text-align: center;
    position: relative;
}
.modal-content h2 {
    color: #0088cc;
    font-weight: 700;
    font-size: 26px;
    margin-bottom: 15px;
    user-select: text;
}
.collected-amount {
    font-size: 28px;
    font-weight: 700;
    color: #00ff88;
    margin-bottom: 25px;
    opacity: 0;
    transform: translateY(15px);
    transition: opacity 0.5s ease, transform 0.5s ease;
    user-select: text;
}
.collected-amount.visible {
    opacity: 1;
    transform: translateY(0);
}
.gift-box {
    width: 140px;
    height: 140px;
    margin: 0 auto 30px auto;
    background: url('https://pngimg.com/d/gift_PNG100280.png') no-repeat center/contain;
    cursor: pointer;
    position: relative;
    transition: transform 0.35s ease;
    user-select: none;
    perspective: 600px;
}
.gift-box::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 140px;
    height: 140px;
    background: url('https://pngimg.com/d/gift_PNG5946.png') no-repeat center/contain;
    background-position: top center;
    transform-origin: bottom center;
    transition: transform 1s ease;
    z-index: 10;
    backface-visibility: hidden;
}
.gift-box.open::before {
    transform: rotateX(-100deg);
}
.gift-box.open {
    animation: bounceOpen 0.6s ease forwards;
}
@keyframes bounceOpen {
    0% { transform: scale(1); }
    50% { transform: scale(1.1) translateY(-8px); }
    100% { transform: scale(1); }
}
.modal-collect-btn {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    border: none;
    padding: 14px 32px;
    border-radius: 35px;
    font-weight: 700;
    font-size: 18px;
    color: white;
    box-shadow: 0 6px 15px rgba(0, 136, 204, 0.5);
    cursor: pointer;
    transition: background 0.3s ease, box-shadow 0.3s ease;
    user-select: none;
    width: 100%;
    max-width: 320px;
    margin: 0 auto;
}
.modal-collect-btn:hover:not(:disabled) {
    background: linear-gradient(135deg, #006ba6 0%, #0088cc 100%);
    box-shadow: 0 8px 25px rgba(0, 107, 166, 0.6);
}
.modal-collect-btn:disabled {
    background: #94a3b8;
    cursor: not-allowed;
    box-shadow: none;
}
.modal-close-btn {
    position: absolute;
    top: 10px;
    right: 15px;
    font-size: 24px;
    background: none;
    border: none;
    color: #aaa;
    cursor: pointer;
}
.modal-close-btn:hover {
    color: #000;
}
.wallet-blue {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    border-radius: 15px;
    padding: 25px;
    color: white;
    margin: 20px 0;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
}
.wallet-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}
.wallet-header h2 {
    margin: 0;
    font-size: 1.5rem;
}
.wallet-btn {
    background: rgba(255, 255, 255, 0.2);
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 25px;
    cursor: pointer;
    font-weight: bold;
    display: flex;
    align-items: center;
    gap: 8px;
    transition: all 0.3s ease;
    text-decoration: none;
}
.wallet-btn:hover {
    background: rgba(255, 255, 255, 0.3);
    transform: translateY(-2px);
}
.wallet-balance {
    text-align: center;
    margin-bottom: 25px;
}
.wallet-balance p {
    margin: 0 0 10px 0;
    opacity: 0.9;
    font-size: 1rem;
}
.wallet-balance h1 {
    margin: 0;
    font-size: 3rem;
    font-weight: bold;
}
.wallet-stats {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
    gap: 15px;
    margin-bottom: 25px;
}
.stat-box {
    background: rgba(255, 255, 255, 0.2);
    padding: 15px;
    border-radius: 10px;
    text-align: center;
    backdrop-filter: blur(10px);
}
.stat-box p {
    margin: 0 0 5px 0;
    font-size: 0.9rem;
    opacity: 0.8;
}
.stat-box h3 {
    margin: 0;
    font-size: 1.3rem;
    font-weight: bold;
}
.wallet-activity {
    background: rgba(255, 255, 255, 0.1);
    padding: 20px;
    border-radius: 10px;
}
.wallet-activity h4 {
    margin: 0 0 15px 0;
    font-size: 1.1rem;
}
.wallet-activity ul {
    list-style: none;
    padding: 0;
    margin: 0;
}
.wallet-activity li {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}
.wallet-activity li:last-child {
    border-bottom: none;
}
.referral-section {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    border-radius: 15px;
    padding: 25px;
    color: white;
    margin: 20px 0;
    text-align: center;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
}
.referral-section h3 {
    margin: 0 0 10px 0;
    font-size: 1.4rem;
}
.referral-section p {
    margin: 0 0 20px 0;
    opacity: 0.9;
}
.referral-box {
    display: flex;
    gap: 10px;
    margin-bottom: 15px;
    max-width: 400px;
    margin-left: auto;
    margin-right: auto;
}
.referral-box input {
    flex: 1;
    padding: 12px 15px;
    border: none;
    border-radius: 25px;
    background: rgba(255, 255, 255, 0.9);
    font-size: 0.9rem;
}
.referral-box button {
    background: white;
    color: #0088cc;
    border: none;
    padding: 12px 20px;
    border-radius: 25px;
    font-weight: bold;
    cursor: pointer;
    transition: all 0.3s ease;
}
.referral-box button:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(255, 255, 255, 0.3);
}
.referral-note {
    font-size: 0.9rem;
    opacity: 0.8;
    margin: 0;
}
.social-box-section {
    margin: 20px 0;
}
.social-box-section h3 {
    text-align: center;
    margin-bottom: 20px;
    color: #2c3e50;
}
.social-box {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 20px;
}
.telegram-card, .youtube-card {
    background: white;
    border-radius: 15px;
    padding: 25px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}
.telegram-card {
    border-left: 4px solid #0088cc;
}
.youtube-card {
    border-left: 4px solid #ff0000;
}
.social-title {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-bottom: 15px;
}
.social-title h4 {
    margin: 0;
    color: #2c3e50;
}
.social-title i {
    font-size: 1.5rem;
}
.telegram-card .social-title i {
    color: #0088cc;
}
.youtube-card .social-title i {
    color: #ff0000;
}
.social-btn {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    padding: 12px 25px;
    border-radius: 25px;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    font-weight: bold;
    transition: all 0.3s ease;
}
.social-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0, 136, 204, 0.4);
    color: white;
    text-decoration: none;
}
.youtube-embed {
    margin-top: 15px;
    border-radius: 10px;
    overflow: hidden;
}
.youtube-embed iframe {
    width: 100%;
    height: 200px;
    border: none;
    border-radius: 10px;
}
.investment-plans-section {
    margin: 20px 0;
    text-align: center;
}
.investment-plans-section h2 {
    color: #2c3e50;
    margin-bottom: 25px;
}
.plans-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
}
.plan-card {
    background: white;
    padding: 25px;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    text-align: center;
    transition: transform 0.3s ease;
    border-top: 4px solid #0088cc;
}
.plan-card:hover {
    transform: translateY(-5px);
}
.plan-card h3 {
    color: #2c3e50;
    margin-bottom: 10px;
}
.plan-card p {
    color: #7f8c8d;
    margin-bottom: 15px;
}
.plan-tag {
    background: #0088cc;
    color: white;
    padding: 5px 15px;
    border-radius: 15px;
    font-size: 0.8rem;
    font-weight: bold;
}
.plan-tag.high {
    background: #00a0e9;
}
.telegram-connect-section {
    margin: 25px 0;
}
.telegram-connect-card {
    background: linear-gradient(135deg, #0088cc, #00a0e9);
    border-radius: 15px;
    padding: 25px;
    color: white;
    display: flex;
    align-items: center;
    box-shadow: 0 10px 25px rgba(0, 136, 204, 0.3);
}
.telegram-connect-card .telegram-icon {
    font-size: 50px;
    margin-right: 20px;
    opacity: 0.9;
}
.telegram-content {
    flex: 1;
}
.telegram-content h3 {
    margin: 0 0 10px 0;
    font-size: 22px;
    font-weight: 700;
}
.telegram-content p {
    margin: 0 0 15px 0;
    opacity: 0.9;
    font-size: 14px;
}
.telegram-status {
    display: inline-flex;
    align-items: center;
    padding: 8px 15px;
    border-radius: 20px;
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 15px;
}
.telegram-status.verified {
    background: rgba(0, 255, 136, 0.2);
    border: 1px solid #00ff88;
}
.telegram-status.not-verified {
    background: rgba(255, 193, 7, 0.2);
    border: 1px solid #ffc107;
}
.telegram-status i {
    margin-right: 5px;
}
.btn-telegram-connect {
    background: white;
    color: #0088cc;
    padding: 12px 25px;
    border-radius: 25px;
    text-decoration: none;
    font-weight: 700;
    display: inline-flex;
    align-items: center;
    transition: all 0.3s ease;
}
.btn-telegram-connect:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(255, 255, 255, 0.3);
    color: #0088cc;
    text-decoration: none;
}
.btn-telegram-connect i {
    margin-right: 8px;
}
/* Completely Redesigned Account Activate Box - Fresh Green Eco Theme */
.account-activate-box {
    background: linear-gradient(135deg, #27ae60 0%, #2ecc71 50%, #58d68d 100%);
    border-radius: 25px;
    padding: 35px;
    margin: 20px 0;
    color: #ffffff;
    box-shadow: 0 10px 30px rgba(39, 174, 96, 0.4), inset 0 1px 0 rgba(255, 255, 255, 0.2);
    display: grid;
    grid-template-columns: 1fr auto 1fr;
    align-items: center;
    gap: 30px;
    text-align: center;
    position: relative;
    overflow: hidden;
    border: 2px solid rgba(255, 255, 255, 0.2);
    transition: all 0.5s ease-in-out;
    max-width: 800px;
    margin-left: auto;
    margin-right: auto;
}
.account-activate-box::after {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
    opacity: 0;
    transition: opacity 0.5s ease;
    animation: float 6s ease-in-out infinite;
}
@keyframes float {
    0%, 100% { transform: translateY(0px) rotate(0deg); }
    50% { transform: translateY(-10px) rotate(180deg); }
}
.account-activate-box:hover {
    transform: scale(1.02);
    box-shadow: 0 15px 40px rgba(39, 174, 96, 0.5);
}
.account-activate-box .activate-content {
    grid-column: 2;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 20px;
    position: relative;
    z-index: 1;
}
.activate-icon {
    position: relative;
    width: 80px;
    height: 80px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    backdrop-filter: blur(15px);
    border: 2px solid rgba(255, 255, 255, 0.3);
    transition: all 0.4s ease;
    animation: pulse 2s infinite;
}
@keyframes pulse {
    0% { box-shadow: 0 0 0 0 rgba(255, 255, 255, 0.7); }
    70% { box-shadow: 0 0 0 20px rgba(255, 255, 255, 0); }
    100% { box-shadow: 0 0 0 0 rgba(255, 255, 255, 0); }
}
.activate-icon i {
    font-size: 40px;
    color: #ffffff;
    text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
}
.account-activate-box:hover .activate-icon {
    background: rgba(255, 255, 255, 0.3);
    transform: rotate(360deg);
}
.activate-text {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 10px;
}
.activate-text h4 {
    margin: 0;
    font-size: 1.8rem;
    font-weight: 700;
    color: #ffffff;
    text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    letter-spacing: 1px;
}
.activate-text p {
    margin: 0;
    font-size: 1.05rem;
    color: rgba(255, 255, 255, 0.95);
    line-height: 1.6;
    font-weight: 400;
}
.activate-btn {
    background: rgba(255, 255, 255, 0.2);
    color: #ffffff;
    border: 2px solid #ffffff;
    padding: 15px 35px;
    border-radius: 50px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.4s ease;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 12px;
    font-size: 1.1rem;
    backdrop-filter: blur(10px);
    position: relative;
    overflow: hidden;
}
.activate-btn::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
    transition: left 0.6s ease;
}
.activate-btn:hover::before {
    left: 100%;
}
.activate-btn:hover {
    background: #ffffff;
    color: #27ae60;
    transform: translateY(-4px);
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
}
.activate-btn i {
    font-size: 1.3rem;
    transition: transform 0.3s ease;
}
.activate-btn:hover i {
    transform: scale(1.2) rotate(90deg);
}
@media (max-width: 768px) {
    .account-activate-box {
        grid-template-columns: 1fr;
        gap: 25px;
        padding: 25px;
        text-align: center;
    }
    .activate-icon {
        width: 70px;
        height: 70px;
    }
    .activate-icon i {
        font-size: 35px;
    }
    .activate-text h4 {
        font-size: 1.5rem;
    }
}

/* Image Display Section */
.image-display-section {
    margin: 20px 0;
    text-align: center;
}
.image-container {
    max-width: 100%;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
    margin: 0 auto;
}
.displayed-image {
    width: 100%;
    height: auto;
    display: block;
    transition: transform 0.3s ease;
}
.displayed-image:hover {
    transform: scale(1.02);
}
</style>


<style>
/* YouTube Thumbnail Style Image Display */
.image-display-section {
    margin: 30px 0;
    text-align: center;
    padding: 0 15px;
    position: relative;
}

/* YouTube thumbnail standard size: 1280x720 (16:9 ratio) */
.thumbnail-container {
    width: 100%;
    max-width: 640px; /* Half of 1280 for better fit */
    height: 360px; /* Half of 720 for better fit */
    margin: 0 auto;
    position: relative;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 
        0 25px 50px rgba(0, 0, 0, 0.25),
        0 15px 30px rgba(0, 0, 0, 0.2),
        0 5px 15px rgba(0, 0, 0, 0.15);
    border: 3px solid #ffffff;
    background: #000;
    animation: floatThumbnail 4s ease-in-out infinite;
}

@keyframes floatThumbnail {
    0%, 100% {
        transform: translateY(0px) scale(1);
        box-shadow: 
            0 25px 50px rgba(0, 0, 0, 0.25),
            0 15px 30px rgba(0, 0, 0, 0.2);
    }
    50% {
        transform: translateY(-10px) scale(1.02);
        box-shadow: 
            0 35px 60px rgba(0, 0, 0, 0.35),
            0 20px 40px rgba(0, 0, 0, 0.25);
    }
}

.thumbnail-image {
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: center;
    display: block;
    transition: all 0.5s ease;
    animation: imageGlow 3s ease-in-out infinite;
}

@keyframes imageGlow {
    0%, 100% {
        filter: brightness(1) contrast(1.05);
    }
    50% {
        filter: brightness(1.05) contrast(1.1);
    }
}

.thumbnail-container:hover .thumbnail-image {
    transform: scale(1.03);
    filter: brightness(1.1) contrast(1.15);
    animation: none;
}

/* Professional frame effect */
.thumbnail-frame {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    border: 2px solid rgba(255, 255, 255, 0.1);
    border-radius: 10px;
    pointer-events: none;
    z-index: 2;
}

.thumbnail-frame::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    border: 1px solid rgba(0, 0, 0, 0.3);
    border-radius: 10px;
    pointer-events: none;
}

/* Play button overlay (optional YouTube style) */
.play-button-overlay {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 80px;
    height: 80px;
    background: rgba(255, 0, 0, 0.9);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0;
    transition: all 0.3s ease;
    cursor: pointer;
    z-index: 3;
}

.play-button-overlay::before {
    content: '';
    width: 0;
    height: 0;
    border-left: 20px solid white;
    border-top: 12px solid transparent;
    border-bottom: 12px solid transparent;
    margin-left: 5px;
}

.thumbnail-container:hover .play-button-overlay {
    opacity: 1;
    transform: translate(-50%, -50%) scale(1.1);
}

/* Corner accents */
.corner-accent {
    position: absolute;
    width: 30px;
    height: 30px;
    z-index: 2;
}

.corner-accent.tl {
    top: 10px;
    left: 10px;
    border-top: 2px solid rgba(255, 255, 255, 0.5);
    border-left: 2px solid rgba(255, 255, 255, 0.5);
}

.corner-accent.tr {
    top: 10px;
    right: 10px;
    border-top: 2px solid rgba(255, 255, 255, 0.5);
    border-right: 2px solid rgba(255, 255, 255, 0.5);
}

.corner-accent.bl {
    bottom: 10px;
    left: 10px;
    border-bottom: 2px solid rgba(255, 255, 255, 0.5);
    border-left: 2px solid rgba(255, 255, 255, 0.5);
}

.corner-accent.br {
    bottom: 10px;
    right: 10px;
    border-bottom: 2px solid rgba(255, 255, 255, 0.5);
    border-right: 2px solid rgba(255, 255, 255, 0.5);
}

/* Responsive design for YouTube thumbnail */
@media (max-width: 768px) {
    .thumbnail-container {
        max-width: 100%;
        height: 300px;
    }
}

@media (max-width: 480px) {
    .thumbnail-container {
        height: 250px;
        border-radius: 8px;
    }
    
    .play-button-overlay {
        width: 60px;
        height: 60px;
    }
    
    .play-button-overlay::before {
        border-left: 15px solid white;
        border-top: 9px solid transparent;
        border-bottom: 9px solid transparent;
        margin-left: 4px;
    }
}

/* For very small screens */
@media (max-width: 360px) {
    .thumbnail-container {
        height: 200px;
    }
}
</style>


<style>
    /* Discount Tag Styles */
.discount-tag {
    position: absolute;
    top: -10px;
    right: 30px;
    z-index: 10;
    animation: bounce 2s ease-in-out infinite;
}

.discount-text {
    background: linear-gradient(135deg, #ff6b6b, #ff8e8e);
    color: white;
    padding: 8px 16px;
    border-radius: 25px;
    font-weight: bold;
    font-size: 14px;
    text-shadow: 0 1px 2px rgba(0,0,0,0.3);
    box-shadow: 0 4px 15px rgba(255, 107, 107, 0.4);
    position: relative;
    z-index: 2;
    display: block;
}

.discount-ribbon {
    position: absolute;
    top: 100%;
    left: 50%;
    transform: translateX(-50%);
    width: 0;
    height: 0;
    border-left: 8px solid transparent;
    border-right: 8px solid transparent;
    border-top: 10px solid #ff6b6b;
    filter: drop-shadow(0 2px 4px rgba(0,0,0,0.2));
}

@keyframes bounce {
    0%, 100% {
        transform: translateY(0);
    }
    50% {
        transform: translateY(-5px);
    }
}

/* Account Activate Box position relative for absolute positioning */
.account-activate-box {
    position: relative;
}

/* Optional: Add some sparkle effects */
.discount-tag::before {
    content: 'тЬи';
    position: absolute;
    top: -5px;
    left: -5px;
    font-size: 12px;
    animation: sparkle 1.5s ease-in-out infinite;
}

.discount-tag::after {
    content: 'тЬи';
    position: absolute;
    bottom: -5px;
    right: -5px;
    font-size: 10px;
    animation: sparkle 1.5s ease-in-out infinite 0.5s;
}

@keyframes sparkle {
    0%, 100% {
        opacity: 0;
        transform: scale(0.5);
    }
    50% {
        opacity: 1;
        transform: scale(1);
    }
}
    
</style>

<br><br><br>
<style>
    /* Premium Ad Card Styles */
    .premium-ad-card {
        background: white;
        border-radius: 16px;
        padding: 10px;
        margin: 15px auto;
        position: relative;
        overflow: hidden;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        border: 1px solid rgba(0, 0, 0, 0.04);
        display: flex;
        align-items: center;
        gap: 12px;
        max-width: 100%;
        transition: transform 0.2s ease, box-shadow 0.2s ease;
        text-decoration: none; /* Remove underline from link */
    }

    /* Hover Effect */
    .premium-ad-card:active {
        transform: scale(0.98);
    }

    /* Shining Animation Effect (Eye Catcher) */
    .premium-ad-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 50%;
        height: 100%;
        background: linear-gradient(to right, transparent, rgba(255, 255, 255, 0.8), transparent);
        transform: skewX(-25deg);
        animation: shine 3s infinite;
        pointer-events: none;
    }

    @keyframes shine {
        100% { left: 200%; }
    }

    /* Label Badge */
    .ad-badge {
        position: absolute;
        top: 0;
        left: 0;
        background: linear-gradient(135deg, #FF9800 0%, #F57C00 100%);
        color: white;
        font-size: 9px;
        font-weight: 700;
        padding: 2px 8px;
        border-bottom-right-radius: 8px;
        border-top-left-radius: 16px; /* Matches card corner */
        z-index: 2;
        letter-spacing: 0.5px;
    }

    /* Image Styling */
    .ad-image-wrapper {
        width: 80px; /* Fixed width for consistency */
        height: 60px; /* Compact height */
        border-radius: 10px;
        overflow: hidden;
        flex-shrink: 0;
        background: #f0f0f0;
    }

    .ad-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    /* Content Styling */
    .ad-content {
        flex: 1;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .ad-title {
        font-size: 14px;
        font-weight: 600;
        color: #1f2937;
        margin-bottom: 2px;
        line-height: 1.2;
    }

    .ad-cta {
        font-size: 11px;
        color: #229ED9; /* Telegram Blue */
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 4px;
    }
    
    .ad-arrow-icon {
        width: 18px;
        height: 18px;
        background: #e0f2fe;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 10px;
    }
</style>

<?php
    $activeAd = \App\Models\Ad::active()->first();
    
    // যখনি অ্যাডটি লোড হবে, ভিউ বা ইম্প্রেশন ১ বাড়বে
    if($activeAd){
        $activeAd->increment('views');
    }
?>

<?php if($activeAd): ?>
    
    <a href="<?php echo e(route('ad.track.click', $activeAd->id)); ?>" target="_blank" class="premium-ad-card">
        <span class="ad-badge">SPONSORED</span>
        
        <div class="ad-image-wrapper">
            <img src="<?php echo e(asset('ads_images/' . $activeAd->image)); ?>" alt="Offer" class="ad-image">
        </div>
        
        <div class="ad-content">
            <div class="ad-title">Exclusive Offer For You</div>
            <div class="ad-cta">
                Click to View 
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
<?php else: ?>
    <a href="/ads/create" target="_blank" class="premium-ad-card">
        <span class="ad-badge">Ads Offer</span>
        
        <div class="ad-image-wrapper">
            <img src="<?php echo e(asset('ads_images/ads.jpg')); ?>" alt="Offer" class="ad-image">
        </div>
        
        <div class="ad-content">
            <div class="ad-title">Run Your Ads And Grow Your Team</div>
            <div class="ad-cta">
                Click to Run
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
<?php endif; ?>
    
    <!-- Software Activation Box (if needed) -->
<?php if(auth()->user()->user_active == 0): ?>
<div class="account-activate-box">
    <!-- 50% Discount Tag -->
    <div class="discount-tag">
        <span class="discount-text">50% OFF</span>
        <div class="discount-ribbon"></div>
    </div>
    
    <div class="activate-content">
        <div class="activate-icon">
            <i class="fas fa-power-off"></i>
        </div>
        <div class="activate-text">
            <h4>Software Inactive in this account</h4>
            <p>Please activate the software in your account</p>
            <a href="<?php echo e(route('account_payment')); ?>" class="activate-btn">
                <i class="fas fa-play-circle"></i> Run the Software
            </a>
        </div>
    </div>
</div>
<?php endif; ?>
    <br>
    <!-- Deposit Balance Section -->
    <div class="deposit-balance-section">
        <div class="balance-container">
            <div class="balance-card main-balance">
                <h3>Main Balance</h3>
                <p class="amount"><?php echo e(number_format(Auth::user()->balance, 2)); ?></p>
                <div class="balance-stats">

                </div>
            </div>
      

        </div>
  

    </div>
    <?php
        use Carbon\Carbon;
        $user = Auth::user();
        $pendingAmount = $user->pending_earning;
        $lastTime = $user->last_earning_time ? Carbon::parse($user->last_earning_time) : now();
        $nextEarningTime = $lastTime->copy()->addMinute();
    ?>
    <div class="mining-box" style="display: none">
        <p><strong>Pending Balance:</strong> <?php echo e(number_format($pendingAmount, 2)); ?></p>
        <p><strong>Next Earning In:</strong></p>
        <div class="progress-bar-container">
            <div class="progress-bar-fill" id="progress-bar"></div>
        </div>
    </div>
    <div class="wallet-blue">
        <div class="wallet-header">
            <h2>My Wallet </h2>
            <a href="" class="wallet-btn">
                Earnig
                <?php if(auth()->user()->user_active == 1): ?>
                    <span class="loader-spinner"></span>
                <?php else: ?>
                    <span>тЭМ</span>
                <?php endif; ?>
            </a>
        </div>
        <div class="wallet-balance">
            <p>Total Available Balance</p>
            <h1><?php echo e(number_format(Auth::user()->balance + Auth::user()->deposit_balance, 2)); ?></h1>
        </div>
        <div class="wallet-stats">
            <div class="stat-box">
                <p>Total Earned</p>
                <h3><?php echo e(number_format($totalEarned, 2)); ?></h3>
            </div>
            <div class="stat-box">
                <p>Total Spent</p>
                <h3><?php echo e(number_format($totalPayments, 2)); ?></h3>
            </div>
            <div class="stat-box">
                <p>Total Withdraw</p>
                <h3><?php echo e(number_format($totalWithdrawalAmount, 2)); ?></h3>
            </div>
        </div>
        </div>
    <div class="referral-section" style="margin: 30px 0; position: relative; overflow: hidden; border-radius: 20px;">
    
    <div style="position: absolute; top: -50%; left: -50%; width: 200%; height: 200%; background: radial-gradient(circle, rgba(255,255,255,0.08) 0%, transparent 70%); animation: float 20s ease-in-out infinite;"></div>
    
    <div style="text-align: center; padding: 40px 20px; border-radius: 20px; background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%); color: white; box-shadow: 0 15px 40px rgba(0, 136, 204, 0.5); position: relative; z-index: 1;">
        
        <h2 style="font-size: 2.2rem; font-weight: 800; color: #fff; margin: 0 0 12px 0; text-shadow: 0 4px 10px rgba(0,0,0,0.3);">
            Invite Friends & Earn <span style="color: #ffd700;">৳40</span> Per Referral! 🚀
        </h2>
        
        <p style="font-size: 1.1rem; color: rgba(255,255,255,0.9); margin-bottom: 25px;">
            বন্ধুদের ইনভাইট করুন এবং প্রতিটি অ্যাক্টিভ রেফারেলের জন্য ৳40 ইনস্ট্যান্ট আর্ন করুন!
        </p>
        
        <div style="max-width: 600px; margin: 0 auto 30px auto; display: flex; gap: 12px; flex-wrap: wrap; justify-content: center;">
            <input type="text" id="referralCode" value="<?php echo e(route('register')); ?>?by=<?php echo e(auth()->user()->ref_code); ?>" readonly
                   style="flex: 1; min-width: 280px; padding: 16px 20px; border: none; border-radius: 50px; background: rgba(255,255,255,0.95); font-size: 1rem; color: #333; box-shadow: 0 8px 20px rgba(0,0,0,0.15);">
            <button onclick="copyReferralCode()" style="padding: 16px 32px; background: #ffd700; color: #0088cc; border: none; border-radius: 50px; font-weight: bold; cursor: pointer; box-shadow: 0 8px 20px rgba(255,215,0,0.4); transition: all 0.3s; font-size: 1rem;">
                🔗 Copy Link
            </button>
        </div>
        
        <div style="margin-top: 35px;">
            <p style="color: rgba(255,255,255,0.8); margin-bottom: 18px; font-size: 1.1rem; font-weight: 600;">এক ক্লিকে আপনার বন্ধুকে শেয়ার করুন 👇</p>
            <div style="display: flex; flex-wrap: wrap; gap: 15px; justify-content: center;">
                
                <a href="https://wa.me/?text=🚀 অসাধারণ এই আর্নিং অ্যাপে জয়েন করে আপনিও ৳40 বোনাস পেতে পারেন! দেরি না করে এখনই সাইন আপ করুন: <?php echo e(route('register')); ?>?by=<?php echo e(auth()->user()->ref_code); ?>" target="_blank" style="padding: 14px 20px; background: #25D366; color: white; border-radius: 50px; text-decoration: none; font-weight: bold; display: flex; align-items: center; gap: 10px; box-shadow: 0 8px 20px rgba(37,211,102,0.4); transition: all 0.3s;">
                    <i class="fab fa-whatsapp" style="font-size: 1.4rem;"></i> WhatsApp
                </a>
                
                <a href="https://t.me/share/url?url=<?php echo e(route('register')); ?>?by=<?php echo e(auth()->user()->ref_code); ?>&text=🚀 অসাধারণ এই আর্নিং অ্যাপে জয়েন করে আপনিও ৳40 বোনাস পেতে পারেন! এখনই সাইন আপ করুন:" target="_blank" style="padding: 14px 20px; background: #0088cc; color: white; border-radius: 50px; text-decoration: none; font-weight: bold; display: flex; align-items: center; gap: 10px; box-shadow: 0 8px 20px rgba(0,136,204,0.4); transition: all 0.3s;">
                    <i class="fab fa-telegram-plane" style="font-size: 1.4rem;"></i> Telegram
                </a>

                <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('register')); ?>?by=<?php echo e(auth()->user()->ref_code); ?>" target="_blank" style="padding: 14px 20px; background: #1877F2; color: white; border-radius: 50px; text-decoration: none; font-weight: bold; display: flex; align-items: center; gap: 10px; box-shadow: 0 8px 20px rgba(24,119,242,0.4); transition: all 0.3s;">
                    <i class="fab fa-facebook-f" style="font-size: 1.4rem;"></i> Facebook
                </a>
                
                <a href="fb-messenger://share?link=<?php echo e(route('register')); ?>?by=<?php echo e(auth()->user()->ref_code); ?>" style="padding: 14px 20px; background: #0084FF; color: white; border-radius: 50px; text-decoration: none; font-weight: bold; display: flex; align-items: center; gap: 10px; box-shadow: 0 8px 20px rgba(0,132,255,0.4); transition: all 0.3s;">
                    <i class="fab fa-facebook-messenger" style="font-size: 1.4rem;"></i> Messenger
                </a>
                
                <a href="https://twitter.com/intent/tweet?text=🚀 অসাধারণ এই আর্নিং অ্যাপে জয়েন করে আপনিও ৳40 বোনাস পেতে পারেন! এখনই সাইন আপ করুন:%20<?php echo e(route('register')); ?>?by=<?php echo e(auth()->user()->ref_code); ?>" target="_blank" style="padding: 14px 20px; background: #000; color: white; border-radius: 50px; text-decoration: none; font-weight: bold; display: flex; align-items: center; gap: 10px; box-shadow: 0 8px 20px rgba(0,0,0,0.4); transition: all 0.3s;">
                    <i class="fab fa-x-twitter" style="font-size: 1.4rem;"></i> X (Twitter)
                </a>
            </div>
        </div>
    </div>
</div>

<style>
/* Animation for background float */
@keyframes float {
    0%, 100% { transform: translateY(0) rotate(0deg); }
    50% { transform: translateY(-20px) rotate(180deg); }
}

/* Hover effect for buttons */
.referral-section a:hover, .referral-section button:hover {
    transform: translateY(-5px) scale(1.03) !important;
    box-shadow: 0 15px 30px rgba(0,0,0,0.3) !important;
}

/* General styling for the new referral link box */
.referral-section input {
    /* Ensure input is fully visible */
    border: none !important;
    outline: none !important;
}

</style>

<script>
// JavaScript function to copy the referral link and show a toast message
function copyReferralCode() {
    const link = document.getElementById('referralLink');
    
    // Use modern Clipboard API
    if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText(link.value).then(() => {
            showToast('✅ রেফারেল লিঙ্ক কপি করা হয়েছে!');
        }).catch(() => {
            fallbackCopy(link);
        });
    } else {
        // Fallback for older browsers
        fallbackCopy(link);
    }
}

function fallbackCopy(element) {
    element.select();
    element.setSelectionRange(0, 99999);
    try {
        document.execCommand('copy');
        showToast('✅ রেফারেল লিঙ্ক কপি করা হয়েছে!');
    } catch (err) {
        showToast('❌ কপি করা যায়নি! লিঙ্কটি ম্যানুয়ালি কপি করুন।');
    }
}

function showToast(message) {
    // Remove previous toast if exists
    const oldToast = document.getElementById('copyToast');
    if (oldToast) oldToast.remove();
    
    const toast = document.createElement('div');
    toast.id = 'copyToast';
    toast.textContent = message;
    toast.style.cssText = `
        position: fixed; top: 20px; left: 50%; transform: translateX(-50%);
        background: #333; color: white; padding: 14px 32px; border-radius: 50px;
        font-weight: bold; font-size: 16px; z-index: 99999;
        box-shadow: 0 10px 30px rgba(0,0,0,0.3);
        animation: toastAnim 3s forwards;
    `;
    document.body.appendChild(toast);
    setTimeout(() => toast.remove(), 3000);
}

// CSS Keyframes for the toast animation (if not already defined)
if (!document.querySelector('style').textContent.includes('@keyframes toastAnim')) {
    const style = document.createElement('style');
    style.innerHTML = `
        @keyframes toastAnim {
            0% { opacity: 0; transform: translateX(-50%) translateY(-30px); }
            15% { opacity: 1; transform: translateX(-50%) translateY(0); }
            85% { opacity: 1; transform: translateX(-50%) translateY(0); }
            100% { opacity: 0; transform: translateX(-50%) translateY(-30px); }
        }
    `;
    document.head.appendChild(style);
}
</script>
    <div class="social-box-section">
        <h3>Connected With Us</h3>
        <div class="social-box">
            <div class="telegram-card">
                <div class="social-title">
                    <i class="fab fa-telegram-plane"></i>
                    <h4>Join Our Telegram</h4>
                </div>
                <p>Get updates, tips & community support.</p>
                <a href="<?php echo e(app('telegram_url')); ?>" target="_blank" class="social-btn">
                    <i class="fab fa-telegram-plane"></i> Join Now
                </a>
            </div>
            <div class="youtube-card">
                <div class="social-title">
                    <i class="fab fa-youtube"></i>
                    <h4>Watch on YouTube</h4>
                </div>
                <p>Learn how to use the app and earn more.</p>
                <div class="youtube-embed">
                    <iframe src="<?php echo e(app('youtube_link_embed')); ?>" title="YouTube video" allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </div>
    <div class="telegram-connect-section">
        <div class="telegram-connect-card">
            <div class="telegram-icon">
                <i class="fab fa-telegram-plane"></i>
            </div>
            <div class="telegram-content">
                <h3>Connect Telegram</h3>
                <p>Connect your Telegram account to unlock exclusive features and notifications</p>
          
                <?php if(Auth::user()->tg_id_status == 1): ?>
                    <div class="telegram-status verified">
                        <i class="fas fa-check-circle"></i>
                        <span>Telegram Connected тЬЕ</span>
                    </div>
                <?php else: ?>
                    <div class="telegram-status not-verified">
                        <i class="fas fa-exclamation-circle"></i>
                        <span>Telegram Not Connected</span>
                    </div>
                <?php endif; ?>
          
                <a href="<?php echo e(route('telegram.connect')); ?>" class="btn-telegram-connect">
                    <i class="fab fa-telegram-plane"></i>
                    <?php echo e(Auth::user()->tg_id_status == 1 ? 'Manage Connection' : 'Connect Now'); ?>

                </a>
            </div>
        </div>
    </div>
    <div class="investment-plans-section">
        <h2>Popular Investment Plans</h2>
        <div class="plans-grid">
            <div class="plan-card">
                <h3>Auto Mining</h3>
                <p>Get return per hour</p>
                <span class="plan-tag">No Risk</span>
            </div>
            <div class="plan-card">
                <h3>AutoType Earning</h3>
                <p>Use software and earn auto</p>
                <span class="plan-tag">Secure</span>
            </div>
            <div class="plan-card">
                <h3>Refer extra earning</h3>
                <p>ЁЯдС Refer and Get Commissions | No Risk</p>
                <span class="plan-tag high">No Risk</span>
            </div>
        </div>
    </div>
    <?php if(session('register_success')): ?>
    <div class="alert alert-success text-center" style="font-size: 20px; margin-top: 20px;">
        <?php echo e(session('register_success')); ?>

    </div>
    <script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.6.0/dist/confetti.browser.min.js"></script>
    <script>
        const audio = new Audio("<?php echo e(asset('sounds/register_success.mp3')); ?>");
        audio.play();
        function launchConfetti() {
            const duration = 3 * 1000;
            const animationEnd = Date.now() + duration;
            const defaults = { startVelocity: 30, spread: 360, ticks: 60, zIndex: 9999 };
            function randomInRange(min, max) {
                return Math.random() * (max - min) + min;
            }
            const interval = setInterval(function() {
                const timeLeft = animationEnd - Date.now();
                if (timeLeft <= 0) {
                    clearInterval(interval);
                    return;
                }
                confetti({
                    particleCount: 50,
                    origin: { x: randomInRange(0.1, 0.9), y: Math.random() - 0.2 },
                    ...defaults
                });
            }, 200);
        }
        launchConfetti();
    </script>
    <?php endif; ?>
</div>
<script>
    // Deposit and Transfer Modal Functions
    function showDepositModal() {
        alert('Deposit feature coming soon!');
    }
    function showTransferModal() {
        alert('Transfer between balances feature coming soon!');
    }
    function copyReferralCode() {
        const input = document.getElementById("referralCode");
        input.select();
        input.setSelectionRange(0, 99999);
        try {
            navigator.clipboard.writeText(input.value).then(() => {
                alert("Referral link copied to clipboard!");
            }).catch(() => {
                document.execCommand("copy");
                alert("Referral link copied to clipboard!");
            });
        } catch (err) {
            document.execCommand("copy");
            alert("Referral link copied to clipboard!");
        }
    }
    // Existing mining functionality
    const nextEarningTime = new Date("<?php echo e($nextEarningTime->format('Y-m-d H:i:s')); ?>").getTime();
    const progressBar = document.getElementById('progress-bar');
    const totalDuration = 60;
    let interval;
    function updateProgress() {
        const now = new Date().getTime();
        let distance = (nextEarningTime - now) / 1000;
        if (distance <= 0) {
            progressBar.style.width = '100%';
            clearInterval(interval);
            return;
        }
        let progressPercent = ((totalDuration - distance) / totalDuration) * 100;
        progressBar.style.width = progressPercent + '%';
    }
    updateProgress();
    interval = setInterval(updateProgress, 1000);
    <?php if($pendingAmount > 0): ?>
    const giftBox = document.getElementById('gift-box');
    const collectBtn = document.getElementById('collect-btn');
    const collectedAmountEl = document.getElementById('collected-amount');
    collectedAmountEl.classList.remove('visible');
    collectBtn.disabled = true;
    function openGiftBox() {
        giftBox.classList.add('open');
        setTimeout(() => {
            collectedAmountEl.classList.add('visible');
            collectBtn.disabled = false;
        }, 1000);
    }
    giftBox.addEventListener('click', () => {
        if (collectBtn.disabled) openGiftBox();
    });
    giftBox.addEventListener('keydown', (e) => {
        if ((e.key === "Enter" || e.key === " ") && collectBtn.disabled) {
            e.preventDefault();
            openGiftBox();
        }
    });
    <?php endif; ?>
    document.addEventListener('DOMContentLoaded', () => {
        const modal = document.getElementById('gift-modal');
        const closeBtn = document.getElementById('modal-close-btn');
        const closedAt = localStorage.getItem('giftModalClosedAt');
        if (closedAt) {
            const diff = (Date.now() - parseInt(closedAt, 10)) / (1000 * 60 * 60);
            if (diff < 1 && modal) {
                modal.style.display = 'none';
            }
        }
        if (closeBtn) {
            closeBtn.addEventListener('click', () => {
                if (modal) {
                    modal.style.display = 'none';
                    localStorage.setItem('giftModalClosedAt', Date.now().toString());
                }
            });
        }
    });
</script>
<script>
document.addEventListener("DOMContentLoaded", () => {
    // рж╢рзБржзрзБржорж╛рждрзНрж░ ржкрзНрж░ржержоржмрж╛рж░рзЗрж░ ржЬржирзНржп рж╕рж╛ржЙржирзНржб ржкрзНрж▓рзЗ рж╣ржмрзЗ
    if (!sessionStorage.getItem('soundPlayed')) {
        const audio = new Audio("<?php echo e(asset('sounds/1.mp3')); ?>"); // ржЖржкржирж╛рж░ public/sounds/1.mp3 ржлрж╛ржЗрж▓ржЯрж┐ ржмрзНржпржмрж╣рж╛рж░ ржХрж░рзБржи
        audio.preload = 'auto'; // Preload рж╕рзЗржЯ ржХрж░рзЗ ржжрж┐рж▓рж╛ржо ржпрж╛рждрзЗ рж╕ржорж╕рзНржпрж╛ ржирж╛ рж╣рзЯ
        audio.volume = 1.0;
        audio.load(); // ржлрж╛ржЗрж▓ржЯрж┐ рж▓рзЛржб ржХрж░рждрзЗ ржмрж▓рж▓рж╛ржо
        // Autoplay ржмрзНрж▓ржХ рж╣рж▓рзЗ, ржХрзНрж▓рж┐ржХ ржЗржнрзЗржирзНржЯрзЗ ржкрзНрж▓рзЗ рж╣ржмрзЗ
        audio.play()
            .then(() => {
                console.log('Sound played successfully!');
                sessionStorage.setItem('soundPlayed', 'true');
            })
            .catch((error) => {
                console.log('Autoplay prevented:', error);
                // ржпржжрж┐ autoplay block рж╣рзЯ, ржХрзНрж▓рж┐ржХ ржЗржнрзЗржирзНржЯрзЗ ржкрзНрж▓рзЗ рж╣ржмрзЗ
                const playOnce = () => {
                    audio.play().then(() => {
                        console.log('Sound played on click!');
                        sessionStorage.setItem('soundPlayed', 'true');
                        document.body.removeEventListener('click', playOnce);
                    }).catch((err) => {
                        console.log('Play on click failed:', err);
                    });
                };
                document.body.addEventListener('click', playOnce, { once: true });
            });
    }
});
</script>



<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/teleearn/checkk.tele-earn.com/resources/views/user/dashboard.blade.php ENDPATH**/ ?>