<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
.order-history-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 20px;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: #333;
}
.history-header {
    text-align: center;
    margin-bottom: 40px;
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    padding: 40px 20px;
    border-radius: 15px;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
    animation: fadeInUp 0.8s ease-out;
    position: relative;
    overflow: hidden;
}
.history-header::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
    opacity: 0.05;
}
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}
.history-header h1 {
    font-size: 2.2rem;
    margin-bottom: 10px;
    font-weight: 700;
    text-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
    opacity: 0.95;
}
.history-header p {
    font-size: 1.1rem;
    opacity: 0.9;
    margin: 0;
    font-weight: 500;
}
.stats-cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-bottom: 40px;
}
.stat-card {
    background: white;
    padding: 25px;
    border-radius: 12px;
    text-align: center;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
    border-top: 4px solid #0088cc;
    transition: all 0.3s ease;
    animation: fadeInUp 0.8s ease-out 0.2s both;
    position: relative;
    overflow: hidden;
}
.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: linear-gradient(90deg, #0088cc, #00a0e9);
}
.stat-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.15);
}
.stat-card h3 {
    color: #0088cc;
    font-size: 2rem;
    margin-bottom: 5px;
    font-weight: 700;
}
.stat-card p {
    color: #666;
    margin: 0;
    font-weight: 500;
}
.orders-table {
    background: white;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
    margin-bottom: 30px;
    animation: fadeInUp 0.8s ease-out 0.3s both;
}
.table-header {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    padding: 20px;
    display: grid;
    grid-template-columns: 1fr 1fr 1fr 1fr 1fr 1fr;
    font-weight: bold;
    font-size: 0.95rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    box-shadow: 0 2px 10px rgba(0, 136, 204, 0.2);
}
.table-row {
    display: grid;
    grid-template-columns: 1fr 1fr 1fr 1fr 1fr 1fr;
    padding: 20px;
    border-bottom: 1px solid #f0f2f5;
    align-items: center;
    transition: all 0.3s ease;
    position: relative;
}
.table-row::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    bottom: 0;
    width: 4px;
    background: linear-gradient(135deg, #0088cc, #00a0e9);
    opacity: 0;
    transition: opacity 0.3s ease;
}
.table-row:hover {
    background: linear-gradient(90deg, #f8f9fa 0%, #e3f2fd 100%);
    transform: translateX(5px);
}
.table-row:hover::before {
    opacity: 1;
}
.table-row:last-child {
    border-bottom: none;
}
.channel-username {
    font-weight: bold;
    color: #0088cc;
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 1rem;
}
.admin-status {
    font-size: 0.85rem;
    margin-top: 5px;
    padding: 4px 8px;
    border-radius: 12px;
    display: inline-block;
    font-weight: 500;
}
.admin-approved {
    background: rgba(40, 167, 69, 0.1);
    color: #28a745;
}
.admin-pending {
    background: rgba(255, 193, 7, 0.1);
    color: #ffc107;
}
.bot-admin {
    background: rgba(23, 162, 184, 0.1);
    color: #17a2b8;
    font-size: 0.8rem;
}
.progress-info {
    font-size: 0.9rem;
    color: #666;
    display: flex;
    flex-direction: column;
    gap: 4px;
    line-height: 1.4;
}
.progress-info span {
    font-weight: bold;
    color: #0088cc;
}
.status-badge {
    padding: 8px 16px;
    border-radius: 25px;
    font-size: 0.85rem;
    font-weight: bold;
    text-align: center;
    transition: all 0.3s ease;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
}
.status-pending {
    background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);
    color: #856404;
    box-shadow: 0 2px 8px rgba(255, 193, 7, 0.2);
}
.status-approved {
    background: linear-gradient(135deg, #d1edff 0%, #b3d9ff 100%);
    color: #004085;
    box-shadow: 0 2px 8px rgba(33, 150, 243, 0.2);
}
.status-completed {
    background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
    color: #155724;
    box-shadow: 0 2px 8px rgba(40, 167, 69, 0.2);
}
.status-rejected {
    background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%);
    color: #721c24;
    box-shadow: 0 2px 8px rgba(220, 53, 69, 0.2);
}
.no-orders {
    text-align: center;
    padding: 60px 20px;
    color: #666;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border-radius: 15px;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
    animation: fadeInUp 0.8s ease-out 0.4s both;
    position: relative;
    overflow: hidden;
}
.no-orders::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(0, 136, 204, 0.05) 0%, transparent 70%);
    animation: rotate 20s linear infinite;
}
@keyframes rotate {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}
.no-orders i {
    font-size: 5rem;
    margin-bottom: 20px;
    opacity: 0.5;
    color: #0088cc;
    animation: bounce 2s infinite;
}
@keyframes bounce {
    0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
    40% { transform: translateY(-10px); }
    60% { transform: translateY(-5px); }
}
.no-orders h3 {
    color: #0088cc;
    margin-bottom: 10px;
    font-weight: 600;
    font-size: 1.5rem;
}
.no-orders p {
    font-size: 1.1rem;
    margin-bottom: 25px;
    opacity: 0.8;
}
.action-buttons {
    text-align: center;
    margin-top: 30px;
    display: flex;
    gap: 15px;
    justify-content: center;
    flex-wrap: wrap;
    animation: fadeInUp 0.8s ease-out 0.5s both;
}
.btn-primary {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    padding: 15px 35px;
    border-radius: 25px;
    text-decoration: none;
    font-weight: bold;
    font-size: 1rem;
    display: inline-flex;
    align-items: center;
    gap: 10px;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(0, 136, 204, 0.3);
}
.btn-primary:hover {
    background: linear-gradient(135deg, #006ba6 0%, #0088cc 100%);
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(0, 136, 204, 0.4);
    text-decoration: none;
    color: white;
}
.btn-secondary {
    background: linear-gradient(135deg, #95a5a6 0%, #7f8c8d 100%);
    color: white;
    padding: 15px 35px;
    border-radius: 25px;
    text-decoration: none;
    font-weight: bold;
    font-size: 1rem;
    display: inline-flex;
    align-items: center;
    gap: 10px;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(149, 165, 166, 0.3);
}
.btn-secondary:hover {
    background: linear-gradient(135deg, #7f8c8d 0%, #95a5a6 100%);
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(149, 165, 166, 0.4);
    text-decoration: none;
    color: white;
}
@media (max-width: 768px) {
    .table-header, .table-row {
        grid-template-columns: 1fr 1fr;
        gap: 10px;
    }
    .table-header div:nth-child(n+3),
    .table-row div:nth-child(n+3) {
        display: none;
    }
    .action-buttons { flex-direction: column; align-items: center; }
    .btn-primary, .btn-secondary { width: 100%; max-width: 250px; }
}
</style>
<br><br><br>
<div class="order-history-container">
    <div class="history-header">
        <h1><i class="fas fa-history"></i> Order History</h1>
        <p>Track your channel orders and their status</p>
    </div>
    <div class="stats-cards">
        <div class="stat-card">
            <h3><?php echo e($orders->count()); ?></h3>
            <p>Total Orders</p>
        </div>
        <div class="stat-card">
            <h3><?php echo e($orders->where('status', 'completed')->count()); ?></h3>
            <p>Completed</p>
        </div>
        <div class="stat-card">
            <h3>৳<?php echo e(number_format($orders->sum('total_cost'), 2)); ?></h3>
            <p>Total Spent</p>
        </div>
        <div class="stat-card">
            <h3><?php echo e(Auth::user()->today_orders); ?>/<?php echo e(DB::table('settings')->where('key', 'max_orders_per_day')->value('value')); ?></h3>
            <p>Today's Orders</p>
        </div>
    </div>
    <?php if($orders->count() > 0): ?>
    <div class="orders-table">
        <div class="table-header">
            <div>Channel</div>
            <div>Target Members</div>
            <div>Progress</div>
            <div>Amount</div>
            <div>Status</div>
            <div>Date</div>
        </div>
        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="table-row">
            <div>
                <div class="channel-username"><?php echo e($order->channel_username); ?></div>
                <div class="admin-status <?php echo e($order->admin_approved ? 'admin-approved' : 'admin-pending'); ?>">
                    <?php echo e($order->admin_approved ? '✅ Admin Approved' : '⏳ Pending Approval'); ?>

                </div>
                <?php if($order->bot_admin): ?>
                <div class="admin-status bot-admin">🤖 Bot Added</div>
                <?php endif; ?>
            </div>
            <div><?php echo e(number_format($order->member_count)); ?></div>
            <div class="progress-info">
                Joined: <span><?php echo e(number_format($order->joined_count)); ?></span><br>
                Remaining: <span><?php echo e(number_format($order->remaining)); ?></span>
            </div>
            <div>৳<?php echo e(number_format($order->total_cost, 2)); ?></div>
            <div>
                <span class="status-badge status-<?php echo e($order->status); ?>">
                    <?php echo e(ucfirst($order->status)); ?>

                </span>
            </div>
            <div><?php echo e($order->created_at->format('M d, Y')); ?></div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <?php else: ?>
    <div class="no-orders">
        <div>📭</div>
        <h3>No Orders Yet</h3>
        <p>You haven't placed any channel orders yet.</p>
        <a href="<?php echo e(route('channel.order.create')); ?>" class="btn-primary">
            Create Your First Order
        </a>
    </div>
    <?php endif; ?>
    <div class="action-buttons">
        <a href="<?php echo e(route('channel.order.create')); ?>" class="btn-primary">
            + Create New Order
        </a>
        <a href="<?php echo e(route('channel.orders')); ?>" class="btn btn-secondary" style="margin-left: 10px;">
            Back to Orders
        </a>
    </div>
</div>
<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/zonexpro/hgzy.zone-x.pro/resources/views/user/channel_order_history.blade.php ENDPATH**/ ?>