<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<br><br><br>
<div class="user-profile-wrapper">
    <div class="profile-section">
        <div class="profile-header">
            <h2 class="profile-title">Edit Your Profile</h2>
            <p class="profile-subtitle">Keep your account information up to date</p>
        </div>

        <form action="<?php echo e(route('profile_update')); ?>" method="POST" enctype="multipart/form-data" class="profile-form">
            <?php echo csrf_field(); ?>
            <div class="form-grid">
                <div class="form-block">
                    <label class="form-label-custom" for="profile_image">Profile Image</label>
                    <input type="file" name="profile_image" id="profile_image" class="form-input-custom">
                </div>

                <div class="form-block">
                    <label class="form-label-custom" for="first_name">First Name</label>
                    <input type="text" name="first_name" id="first_name" value="<?php echo e($data->fname); ?>" class="form-input-custom" required>
                </div>

                <div class="form-block">
                    <label class="form-label-custom" for="email">Email Address</label>
                    <input type="email" name="email" id="email" value="<?php echo e($data->email); ?>" class="form-input-custom" required>
                </div>

                <div class="form-block">
                    <label class="form-label-custom" for="phone">Phone Number</label>
                    <input type="text" name="phone" id="phone" value="<?php echo e($data->phone); ?>" class="form-input-custom" readonly>
                </div>

                <div class="form-block">
                    <label class="form-label-custom" for="password">New Password</label>
                    <input type="text" name="password" id="password" class="form-input-custom" placeholder="Enter new password">
                </div>
            </div>

            <div class="form-footer">
                <button type="submit" class="btn-update-profile">Proccess</button>
            </div>
        </form>
    </div>
</div>

<style>
.user-profile-wrapper {
    margin: 0 auto;
    padding: 30px;
    background: #fff8e1;
    border-radius: 12px;
    box-shadow: 0 8px 24px rgba(0,0,0,0.1);
    font-family: 'Segoe UI', sans-serif;
}

.profile-section {
    padding: 20px;
}

.profile-header {
    text-align: center;
    margin-bottom: 30px;
}

.profile-title {
    font-size: 26px;
    font-weight: bold;
    color: #ff6f00;
}

.profile-subtitle {
    font-size: 14px;
    color: #757575;
}

.profile-form {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.form-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px;
}

.form-block {
    display: flex;
    flex-direction: column;
}

.form-label-custom {
    font-size: 14px;
    font-weight: 500;
    margin-bottom: 6px;
    color: #333;
}

.form-input-custom {
    padding: 10px 15px;
    border-radius: 8px;
    border: 1px solid #ccc;
    font-size: 14px;
    transition: 0.3s;
}

.form-input-custom:focus {
    outline: none;
    border-color: #ffa000;
    box-shadow: 0 0 0 3px rgba(255, 160, 0, 0.2);
}

.form-footer {
    text-align: center;
    margin-top: 20px;
}

.btn-update-profile {
    padding: 12px 30px;
    background-color: #ffa000;
    color: white;
    font-size: 16px;
    border: none;
    border-radius: 25px;
    cursor: pointer;
    transition: background-color 0.3s ease;
}

.btn-update-profile:hover {
    background-color: #ff8f00;
}

@media(max-width: 768px) {
    .form-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/studentjobbd/kkkkkk.hatiya-panel.site/resources/views/user/profile.blade.php ENDPATH**/ ?>