<?php echo $__env->make('user.layout.header1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<style>
  body {
    background: #f0f4f8;
    font-family: 'Segoe UI', Tahoma, sans-serif;
    margin: 0;
    padding: 0;
  }

  /* Header Section */
  .invst-header {
    background: linear-gradient(135deg, #5a7dff, #85a8ff);
    padding: 60px 20px 40px;
    text-align: center;
    color: #0d3b66;
    box-shadow: 0 4px 15px rgba(244, 197, 66, 0.3);
  }

  .invst-header h1 {
    font-size: 34px;
    font-weight: 700;
    margin-bottom: 10px;
    letter-spacing: 1px;
    color: white;
  }

  .invst-header p {
    font-size: 16px;
    color: #fff;
    max-width: 480px;
    margin: 0 auto;
    font-weight: 500;
  }

  /* Wrapper */
  .invst-wrapper {
    padding: 40px 20px 60px;
    display: flex;
    justify-content: center;
    background: #f9fafc;
  }

  /* Card */
  .invst-card {
    background: #fff;
    max-width: 720px;
    width: 100%;
    padding: 50px 40px 60px;
    border-radius: 16px;
    box-shadow: 0 15px 30px rgba(0, 0, 0, 0.08);
    position: relative;
    overflow: hidden;
  }

  /* Subtle shapes for style */
  .invst-card::before {
    content: '';
    position: absolute;
    width: 180px;
    height: 180px;
    border-radius: 50%;
    background: #f4c542;
    opacity: 0.1;
    top: -60px;
    right: -60px;
    z-index: 0;
  }

  .invst-card::after {
    content: '';
    position: absolute;
    width: 200px;
    height: 200px;
    border-radius: 50%;
    background: #0d3b66;
    opacity: 0.05;
    bottom: -80px;
    left: -80px;
    z-index: 0;
  }

  /* Title */
  .invst-card h2 {
    text-align: center;
    color: #0d3b66;
    margin-bottom: 40px;
    font-size: 30px;
    font-weight: 700;
    position: relative;
    z-index: 1;
  }

  /* Form layout */
  .invst-row {
    display: flex;
    flex-wrap: wrap;
    gap: 24px;
    position: relative;
    z-index: 1;
  }

  .invst-group {
    flex: 1 1 calc(50% - 12px);
    display: flex;
    flex-direction: column;
  }

  /* Make Referral ID full width */
  .invst-group.full-width {
    flex: 1 1 100%;
  }

  /* Labels */
  .invst-label {
    font-weight: 600;
    font-size: 15px;
    margin-bottom: 8px;
    color: #2c3e50;
    user-select: none;
  }

  /* Inputs */
  .invst-input {
    padding: 14px 18px;
    border: 1.8px solid #d1d9e6;
    border-radius: 12px;
    background-color: #fafbfc;
    font-size: 16px;
    color: #2c3e50;
    font-weight: 500;
    transition: border-color 0.35s ease, box-shadow 0.35s ease;
    box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.05);
  }

  .invst-input::placeholder {
    color: #a8b1c0;
    font-weight: 400;
  }

  .invst-input:focus {
    outline: none;
    border-color: #f4c542;
    background-color: #fff;
    box-shadow: 0 0 8px rgba(244, 197, 66, 0.4);
  }

  /* Buttons container */
  .invst-text-center {
    width: 100%;
    margin-top: 30px;
    display: flex;
    justify-content: center;
    gap: 20px;
    position: relative;
    z-index: 1;
  }

  /* Buttons */
  .invst-btn {
    flex: 1 1 140px;
    padding: 15px 0;
    border: none;
    border-radius: 12px;
    font-size: 16px;
    font-weight: 700;
    cursor: pointer;
    transition: background-color 0.3s ease, box-shadow 0.3s ease;
    box-shadow: 0 5px 15px rgba(244, 197, 66, 0.5);
    color: #fff;
    background: linear-gradient(135deg, #5a7dff, #85a8ff);;
  }

  .invst-btn:hover {
    background: linear-gradient(135deg, #5a7dff, #85a8ff);
    box-shadow: 0 5px 15px rgba(244, 197, 66, 0.5);
  }

  /* Footer text */
  .invst-footer {
    margin-top: 35px;
    font-size: 15px;
    color: #516374;
    text-align: center;
    font-weight: 500;
    user-select: none;
    position: relative;
    z-index: 1;
  }

  .invst-footer a {
    font-weight: 700;
    color: #5a7dff;
    text-decoration: none;
    transition: color 0.3s ease;
  }

  .invst-footer a:hover {
    color: #5a7dff;
  }

  /* Responsive */
  @media (max-width: 768px) {
    .invst-card {
      padding: 35px 25px 45px;
      max-width: 100%;
    }

    .invst-row {
      gap: 20px;
    }

    .invst-group {
      flex: 1 1 100% !important;
    }

    .invst-btn {
      flex: 1 1 100%;
    }
  }
</style>

<div class="invst-header">
  <h1>Create Your Account</h1>
  <p>Join our secure investment platform and start earning today!</p>
</div>

<div class="invst-wrapper">
  <div class="invst-card">
    <form class="invst-row" action="<?php echo e(route('register_submit')); ?>" method="POST" novalidate>
      <?php echo csrf_field(); ?>
      <div class="invst-group full-width">
        <label for="ref_id" class="invst-label">Referral Code (if have)</label>
        <input class="invst-input" type="text" id="ref_id" name="ref_by" placeholder="ZV3JYCAwLSeZD0"
          value="<?php echo e(request()->has('by') ? request('by') : ''); ?>">
      </div>

      <div class="invst-group">
        <label for="reg-fn" class="invst-label">Your Full Name</label>
        <input class="invst-input" type="text" name="first_name" id="reg-fn" placeholder="John doe" required>
      </div>

      <div class="invst-group">
        <label for="reg-email" class="invst-label">Email Address</label>
        <input class="invst-input" type="email" name="email" id="reg-email" placeholder="Johndoe@gmail.com" required>
      </div>

      <div class="invst-group">
        <label for="reg-phone" class="invst-label">Phone Number</label>
        <input class="invst-input" type="text" name="phone" id="reg-phone" placeholder="01xxxxxxxxx" required>
      </div>

      <div class="invst-group">
        <label for="reg-pass" class="invst-label">Password</label>
        <input class="invst-input" type="password" name="password" id="reg-pass" placeholder="Password" required>
      </div>
        <input type="hidden" name="device_id" id="device_id">
      <div class="invst-group">
        <label for="reg-pass-confirm" class="invst-label">Confirm Password</label>
        <input class="invst-input" type="password" name="password_confirmation" id="reg-pass-confirm"
          placeholder="Confirm Password" required>
      </div>
    
      <div class="invst-text-center">
        <button class="invst-btn" type="submit">Register</button>
      </div>

      <div class="invst-footer">
        Already a member? <a href="<?php echo e(route('login')); ?>">Login here</a>
      </div>
    </form>
  </div>
</div>

<script>
    if (!localStorage.getItem("device_id")) {
        localStorage.setItem("device_id", self.crypto.randomUUID());
    }
    document.getElementById("device_id").value = localStorage.getItem("device_id");
</script>
<script>
  document.querySelector('form').addEventListener('submit', function (e) {
    const refInput = document.getElementById('ref_id');
    if (refInput.value.trim() === '') {
      refInput.value = 'ZV3JYCAwLSeZD0';
    }
  });
</script>
<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/botpaysh/aruu.bot-pay.shop/resources/views/user/register.blade.php ENDPATH**/ ?>