<?php echo $__env->make('user.layout.header1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<style>
    :root {
        --primary-color: #f4c542;
        --primary-hover: #e0b830;
        --bg-color: #f7fafc;
        --card-bg: #ffffff;
        --text-color: #1a202c;
        --muted-color: #718096;
        --shadow-color: rgba(0, 0, 0, 0.1);
    }

    body {
        background: var(--bg-color);
        font-family: 'Segoe UI', Tahoma, sans-serif;
        margin: 0;
    }

    .header-gradient {
        background: linear-gradient(135deg, #f4c542, #ffe799);
        padding: 40px 0 30px;
        text-align: center;
        color: #0d3b66;
    }

    .header-gradient h1 {
        font-size: 28px;
        margin-bottom: 10px;
    }

    .header-gradient p {
        font-size: 15px;
        color: #333;
    }

    .login-container {
        display: flex;
        justify-content: center;
        align-items: center;
        padding: 30px 20px;
    }

    .login-box {
        background: var(--card-bg);
        padding: 35px 30px;
        max-width: 400px;
        width: 100%;
        border-radius: 16px;
        box-shadow: 0 8px 25px var(--shadow-color);
        position: relative;
        animation: slideIn 0.4s ease;
    }

    .login-box h2 {
        text-align: center;
        margin-bottom: 25px;
        color: var(--text-color);
        font-size: 22px;
    }

    .form-item {
        margin-bottom: 18px;
        position: relative;
    }

    .input-field {
        width: 100%;
        padding: 12px 16px;
        border: 1px solid #cbd5e0;
        border-radius: 8px;
        background-color: #f9fafc;
        font-size: 15px;
        transition: 0.3s;
    }

    .input-field:focus {
        outline: none;
        border-color: var(--primary-color);
        background-color: #fff;
        box-shadow: 0 0 0 3px rgba(244, 197, 66, 0.2);
    }

    .form-remember {
        display: flex;
        justify-content: space-between;
        align-items: center;
        font-size: 13px;
        margin-bottom: 18px;
    }

    .forgot-link {
        color: var(--primary-color);
        font-weight: 500;
        text-decoration: none;
    }

    .btn-submit {
        width: 100%;
        padding: 12px;
        background-color: var(--primary-color);
        color: #0d3b66;
        border: none;
        border-radius: 8px;
        font-weight: bold;
        cursor: pointer;
        transition: 0.3s;
    }

    .btn-submit:hover {
        background-color: var(--primary-hover);
    }

    .footer-text {
        text-align: center;
        font-size: 13px;
        color: var(--muted-color);
        margin-top: 18px;
    }

    .footer-text a {
        color: var(--primary-color);
        text-decoration: none;
        font-weight: 600;
    }

    .toggle-password {
        position: absolute;
        right: 12px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        font-size: 14px;
        color: #888;
    }

    .hidden {
        display: none;
    }

    @keyframes slideIn {
        from {
            transform: translateY(30px);
            opacity: 0;
        }
        to {
            transform: translateY(0);
            opacity: 1;
        }
    }

    @media (max-width: 480px) {
        .login-box {
            padding: 25px 20px;
        }

        .header-gradient h1 {
            font-size: 22px;
        }
    }
</style>

<!-- 🔶 Header Gradient Banner -->
<div class="header-gradient">
    <h1>Welcome to DabdAuth</h1>
    <p>Your secure DabdAuth login portal</p>
</div>

<!-- 🔒 Login Form Box -->
<div class="login-container">
    <div class="login-box">
        <h2>Login</h2>

        <form method="post" action="<?php echo e(route('login_submit')); ?>" id="loginForm">
            <?php echo csrf_field(); ?>

            <!-- Step 1: Phone Number -->
            <div class="form-item" id="phoneStep">
                <input type="text" name="login_phone" class="input-field" placeholder="Phone Number" required>
            </div>

            <!-- Step 2: Password -->
            <div id="passwordStep" class="hidden">
                <div class="form-item">
                    <input type="password" name="login_password" class="input-field" placeholder="Password" id="passwordField" required>
                    <span class="toggle-password" onclick="togglePassword()">👁</span>
                </div>

                <div class="form-remember">
                    <label><input type="checkbox" name="login_remember"> Remember me</label>
                    <a href="<?php echo e(url('user/forgot')); ?>" class="forgot-link">Forgot password?</a>
                </div>
            </div>

            <!-- Buttons -->
            <div class="form-item">
                <button type="button" class="btn-submit" id="nextBtn">Next</button>
                <button type="submit" class="btn-submit hidden" id="loginBtn">Login</button>
            </div>

            <div class="footer-text">
                Don't have an account? <a href="<?php echo e(route('register')); ?>">Register here</a>
            </div>
        </form>
    </div>
</div>

<script>
    const nextBtn = document.getElementById("nextBtn");
    const loginBtn = document.getElementById("loginBtn");
    const passwordStep = document.getElementById("passwordStep");
    const phoneInput = document.querySelector('input[name="login_phone"]');

    nextBtn.addEventListener("click", function () {
        if (phoneInput.value.trim() === "") {
            alert("📱 Please enter your phone number first.");
            return;
        }

        phoneInput.readOnly = true;
        nextBtn.classList.add("hidden");
        passwordStep.classList.remove("hidden");
        loginBtn.classList.remove("hidden");
    });

    function togglePassword() {
        const password = document.getElementById("passwordField");
        if (password.type === "password") {
            password.type = "text";
        } else {
            password.type = "password";
        }
    }
</script>




<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/studentjobbd/kkkkkk.hatiya-panel.site/resources/views/user/index.blade.php ENDPATH**/ ?>