<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reward System | Luxury Dashboard</title>
    <meta name="theme-color" content="#5B2CFB">
    
    <!-- Fonts & Icons -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Confetti & Particles -->
    <script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.9.3/dist/confetti.browser.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/tsparticles@2.12.0/tsparticles.bundle.min.js"></script>

    <style>
        :root {
            --primary: #5B2CFB;
            --secondary: #8A2BE2;
            --accent: #00F5FF;
            --glass: rgba(255, 255, 255, 0.1);
            --glass-border: rgba(255, 255, 255, 0.2);
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #0f0f1e 0%, #1a0b2e 100%);
            color: #fff;
            min-height: 100vh;
            overflow-x: hidden;
            background-attachment: fixed;
        }

        .floating-particles {
            position: fixed;
            top: 0; left: 0; width: 100%; height: 100%;
            pointer-events: none;
            z-index: 1;
        }

        .container { position: relative; z-index: 2; }

        .glass-card {
            background: var(--glass);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border-radius: 24px;
            border: 1px solid var(--glass-border);
            box-shadow: 0 20px 40px rgba(0,0,0,0.4);
            overflow: hidden;
            transition: all 0.5s ease;
        }

        .glass-card:hover {
            transform: translateY(-15px) scale(1.02);
            box-shadow: 0 30px 60px rgba(91, 44, 251, 0.4);
        }

        .premium-title {
            font-weight: 800;
            font-size: 3.5rem;
            background: linear-gradient(90deg, #5B2CFB, #00F5FF, #FF00E5);
            );
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            text-align: center;
            margin-bottom: 10px;
            animation: glow 2s ease-in-out infinite alternate;
        }

        @keyframes glow {
            from { filter: drop-shadow(0 0 20px #5B2CFB); }
            to { filter: drop-shadow(0 0 40px #00F5FF); }
        }

        .giftcode-box {
            background: linear-gradient(135deg, rgba(91,44,251,0.4), rgba(138,43,226,0.8));
            backdrop-filter: blur(20px);
            border: 2px solid rgba(255,255,255,0.2);
            border-radius: 30px;
            padding: 3rem;
            text-align: center;
            box-shadow: 0 30px 80px rgba(91, 44, 251, 0.6);
            animation: float 6s ease-in-out infinite;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-20px); }
        }

        .giftcode {
            font-size: 3rem;
            font-weight: 900;
            letter-spacing: 12px;
            background: rgba(255,255,255,0.25);
            padding: 20px 40px;
            border-radius: 20px;
            display: inline-block;
            margin: 25px 0;
            backdrop-filter: blur(10px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.5);
        }

        .copy-btn {
            background: linear-gradient(45deg, #00F5FF, #FF00E5);
            border: none;
            color: white;
            padding: 16px 40px;
            border-radius: 50px;
            font-weight: 700;
            font-size: 1.1rem;
            box-shadow: 0 10px 30px rgba(0,245,255,0.4);
            transition: all 0.3s;
        }

        .copy-btn:hover {
            transform: scale(1.1);
            box-shadow: 0 20px 40px rgba(255,0,229,0.6);
        }

        .reward-card {
            background: var(--glass);
            backdrop-filter: blur(16px);
            border-radius: 24px;
            border: 1px solid var(--glass-border);
            height: 100%;
            transition: all 0.6s ease;
            opacity: 0;
            transform: translateY(60px);
        }

        .reward-card.animate {
            opacity: 1;
            transform: translateY(0);
        }

        .eligible {
            border: 3px solid #00ff88;
            box-shadow: 0 0 40px rgba(0, 255, 136, 0.5);
        }

        .progress {
            height: 40px;
            border-radius: 20px;
            background: rgba(255,255,255,0.1);
            overflow: hidden;
            border: 1px solid rgba(255,255,255,0.2);
        }

        .progress-bar {
            background: linear-gradient(90deg, #5B2CFB, #00F5FF);
            font-size: 1.2rem;
            font-weight: 700;
            display: flex;
            align-items: center;
            justify-content: center;
            text-shadow: 0 0 10px black;
        }
    </style>
</head>
<body>

<div id="particles-js" class="floating-particles"></div>

<div class="container py-5">

    <!-- Premium Gift Code Reveal -->
    <?php if(session('giftcode_success')): ?>
        <div class="row mb-5">
            <div class="col-lg-8 mx-auto">
                <div class="giftcode-box text-white">
                    <i class="fas fa-gift fa-3x mb-4" style="background: linear-gradient(45deg, #FFD700, #FFA500); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"></i>
                    <h2 class="fw-bold display-5 mb-3">✨ JACKPOT UNLOCKED ✨</h2>
                    <p class="lead opacity-90">Tumi successfully claim kore nilen exclusive gift code!</p>
                    <div class="giftcode" id="giftCode">
                        <?php echo e(session('giftcode_success.code')); ?>

                    </div>
                    <button class="btn copy-btn btn-lg mt-3" onclick="copyAndCelebrate()">
                        <i class="fas fa-copy me-3"></i> COPY & CELEBRATE
                    </button>
                    <p class="mt-4 fs-5">
                        <strong>Ki korben?</strong> Gift Code section-e giye paste korun → Balance instantly add hobe!
                    </p>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Normal Messages -->
    <?php if(session('success')): ?>
        <div class="alert alert-success glass-card text-white border-0 shadow-lg">
            <i class="fas fa-check-circle me-2"></i> <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="text-center mb-6">
        <h1 class="premium-title">Referral Rewards</h1>
        <p class="lead text-white opacity-80">Invite korun, luxury gift code unlock korun!</p>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-5 g-4">
        <div class="col-md-6">
            <div class="glass-card text-white text-center p-5">
                <i class="fas fa-users fa-4x mb-4" style="background: linear-gradient(45deg, #5B2CFB, #8A2BE2); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"></i>
                <h2 class="display-4 fw-bold"><?php echo e($userActiveReferrals); ?></h2>
                <p class="fs-4 opacity-80">Active Referrals</p>
            </div>
        </div>
        <div class="col-md-6">
            <div class="glass-card text-white text-center p-5">
                <i class="fas fa-gift fa-4x mb-4" style="background: linear-gradient(45deg, #00F5FF, #FF00E5); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"></i>
                <h2 class="display-4 fw-bold"><?php echo e(count($eligibleRewards) - count($claimedRewards)); ?></h2>
                <p class="fs-4 opacity-80">Unclaimed Rewards</p>
            </div>
        </div>
    </div>

    <!-- Reward Tiers -->
    <div class="row g-4" id="rewardContainer">
        <?php $__currentLoopData = $rewardOffers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $threshold => $amount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $isEligible = $userActiveReferrals >= $threshold;
                $isClaimed = in_array($threshold, $claimedRewards);
                $delay = $loop->index * 0.2;
            ?>
            <div class="col-lg-4 col-md-6">
                <div class="glass-card reward-card text-white text-center p-4" style="animation-delay: <?php echo e($delay); ?>s">
                    <div class="my-4">
                        <i class="fas fa-crown fa-5x" style="color: #FFD700; filter: drop-shadow(0 0 20px #FFD700);"></i>
                    </div>
                    <h3 class="fw-bold fs-2"><?php echo e($threshold); ?> Referrals</h3>
                    <h2 class="mt-3 mb-4 text-accent fw-bold"><?php echo e($amount); ?> ৳</h2>

                    <?php if($isClaimed): ?>
                        <button class="btn btn-secondary btn-lg w-100" disabled>
                            <i class="fas fa-check-double me-2"></i> Claimed
                        </button>
                    <?php elseif($isEligible): ?>
                        <form action="<?php echo e(route('claim.reward')); ?>" method="POST" onsubmit="playClaimSound(); triggerConfetti();">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="threshold" value="<?php echo e($threshold); ?>">
                            <button type="submit" class="btn btn-success btn-lg w-100 glowing-btn">
                                <i class="fas fa-gift me-2"></i> CLAIM NOW
                            </button>
                        </form>
                    <?php else: ?>
                        <div class="text-muted opacity-75">
                            <small>আর <?php echo e($threshold - $userActiveReferrals); ?> জন লাগবে</small>
                            <button class="btn btn-outline-light w-100 mt-3" disabled>Locked</button>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Progress Bar -->
    <?php
        $max = max(array_keys($rewardOffers));
        $progress = ($userActiveReferrals / $max) * 100;
    ?>
    <div class="glass-card mt-5 p-5">
        <h4 class="text-white mb-4">Top Tier Unlock Progress (<?php echo e($max); ?> Referrals)</h4>
        <div class="progress">
            <div class="progress-bar" style="width: <?php echo e($progress); ?>%">
                <?php echo e($userActiveReferrals); ?> / <?php echo e($max); ?> • <?php echo e(number_format($progress, 1)); ?>%
            </div>
        </div>
    </div>
</div>

<!-- Premium Sounds (hosted on your server) -->
<audio id="pageLoadSound" preload="auto">
    <source src="/sounds/page-load.mp3" type="audio/mpeg">
</audio>
<audio id="claimSound" preload="auto">
    <source src="/sounds/7.mp3" type="audio/mpeg"> <!-- তোর ফাইলটা এখানে রাখিস -->
</audio>
<audio id="copySound" preload="auto">
    <source src="/sounds/copy.mp3" type="audio/mpeg">
</audio>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Premium Page Load Sound + Particles + Animation
window.onload = function() {
    // Play cinematic intro sound
    document.getElementById('pageLoadSound').play().catch(e => console.log("Sound blocked"));

    // Particles Background
    tsParticles.load("particles-js", {
        particles: {
            number: { value: 80 },
            color: { value: ["#5B2CFB", "#00F5FF", "#FF00E5"] },
            shape: { type: "circle" },
            opacity: { value: 0.5, random: true },
            size: { value: 3, random: true },
            move: { enable: true, speed: 1, direction: "none", outModes: "bounce" },
            links: { enable: true, distance: 150, color: "#ffffff", opacity: 0.2 }
        },
        interactivity: {
            events: { onHover: { enable: true, mode: "repulse" } },
        },
        background: { color: "transparent" }
    });

    // Animate cards one by one
    setTimeout(() => {
        document.querySelectorAll('.reward-card').forEach((card, i) => {
            setTimeout(() => card.classList.add('animate'), i * 300);
        });
    }, 600);

    // If just claimed → auto play claim sound & confetti
    <?php if(session('giftcode_success')): ?>
        playClaimSound();
        triggerConfetti();
    <?php endif; ?>
};

// Claim button sound + confetti
function playClaimSound() {
    document.getElementById('claimSound').play();
}

function triggerConfetti() {
    confetti({
        particleCount: 300,
        spread: 100,
        origin: { y: 0.6 },
        colors: ['#5B2CFB', '#00F5FF', '#FF00E5', '#FFD700'],
        scalar: 1.2,
        ticks: 300
    });
}

function copyAndCelebrate() {
    const code = document.getElementById('giftCode').innerText;
    navigator.clipboard.writeText(code);
    
    document.getElementById('copySound').play();
    
    confetti({
        particleCount: 150,
        angle: 90,
        spread: 45,
        origin: { x: 0.5, y: 0.8 }
    });

    alert('Gift Code Copied! Enjoy your reward! ');
}
</script>

<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/teleearn/checkk.tele-earn.com/resources/views/user/reward-system.blade.php ENDPATH**/ ?>