<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<div class="glass-background">
    <div class="shape shape-1"></div>
    <div class="shape shape-2"></div>
    <div class="shape shape-3"></div>
</div>

<br><br><br>

<div class="container-fluid py-4 lottery-page-wrapper">
    
    
    <div class="row justify-content-center mb-4">
        <div class="col-md-8">
            <?php
    $activeAd = \App\Models\Ad::active()->first();
    
    // যখনই অ্যাডটি লোড হবে, ভিউ বা ইম্প্রেশন ১ বাড়বে
    if($activeAd){
        $activeAd->increment('views');
    }
?>

<?php if($activeAd): ?>
    
    <a href="<?php echo e(route('ad.track.click', $activeAd->id)); ?>" target="_blank" class="premium-ad-card">
        <span class="ad-badge">SPONSORED</span>
        
        <div class="ad-image-wrapper">
            <img src="<?php echo e(asset('ads_images/' . $activeAd->image)); ?>" alt="<?php echo e($activeAd->ad_name ?: 'Exclusive Offer For You'); ?>" class="ad-image">
        </div>
        
        <div class="ad-content">
            <div class="ad-title"><?php echo e($activeAd->ad_name ?: 'Exclusive Offer For You'); ?></div>
            
            <div class="ad-cta">
                Click to View 
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
<?php else: ?>
    
    <a href="/ads/create" target="_blank" class="premium-ad-card">
        <span class="ad-badge">Ads Offer</span>
        
        <div class="ad-image-wrapper">
            <img src="<?php echo e(asset('ads_images/ads.jpg')); ?>" alt="Offer" class="ad-image">
        </div>
        
        <div class="ad-content">
            <div class="ad-title">Run Your Ads And Grow Your Team</div>
            <div class="ad-cta">
                Click to Run
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
<?php endif; ?>
        </div>
    </div>

    
    <div class="row justify-content-center">
        <div class="col-12 col-lg-10">
            
            
            <div class="glass-panel hero-panel text-center mb-5">
                <div class="lottery-badge-pill">DAILY JACKPOT</div>
                <h1 class="lottery-title">Try Your Luck & Win Big!</h1>
                <p class="lottery-subtitle">Join today's draw and change your fortune instantly.</p>

                <?php if($todayLottery->is_completed): ?>
                    
                    <div class="completed-glass-banner">
                        <div class="fireworks" aria-hidden="true">
                            <div class="firework"></div><div class="firework"></div>
                            <div class="firework"></div><div class="firework"></div>
                        </div>
                        <h3>🎉 Draw Completed! 🎉</h3>
                        <p>Winners are announced below. Come back tomorrow!</p>
                    </div>
                <?php else: ?>
                    
                    <div class="countdown-container">
                        <p class="text-uppercase text-muted fw-bold mb-3 small" style="letter-spacing: 2px;">Next Draw In</p>
                        <div class="glass-countdown-grid">
                            <div class="glass-time-box">
                                <span id="countdown-hours">00</span>
                                <label>HOURS</label>
                            </div>
                            <div class="glass-separator">:</div>
                            <div class="glass-time-box">
                                <span id="countdown-minutes">00</span>
                                <label>MINS</label>
                            </div>
                            <div class="glass-separator">:</div>
                            <div class="glass-time-box">
                                <span id="countdown-seconds">00</span>
                                <label>SECS</label>
                            </div>
                        </div>
                        <div class="next-draw-tag mt-3">
                            <i class="fas fa-clock me-2"></i> Draw: 11:50 AM (BD Time)
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            
            <div class="row mb-5">
                <div class="col-6 col-md-3 mb-4">
                    <div class="glass-stat-card">
                        <div class="icon-bubble blue"><i class="fas fa-users"></i></div>
                        <div class="stat-value"><?php echo e($todayLottery->total_participants); ?></div>
                        <div class="stat-label">Participants</div>
                    </div>
                </div>
                <div class="col-6 col-md-3 mb-4">
                    <div class="glass-stat-card">
                        <div class="icon-bubble green"><i class="fas fa-ticket-alt"></i></div>
                        <div class="stat-value"><?php echo e($todayLottery->join_amount); ?>৳</div>
                        <div class="stat-label">Entry Fee</div>
                    </div>
                </div>
                <div class="col-6 col-md-3 mb-4">
                    <div class="glass-stat-card">
                        <div class="icon-bubble purple"><i class="fas fa-trophy"></i></div>
                        <div class="stat-value"><?php echo e($todayLottery->first_prize); ?>৳</div>
                        <div class="stat-label">1st Prize</div>
                    </div>
                </div>
                <div class="col-6 col-md-3 mb-4">
                    <div class="glass-stat-card">
                        <div class="icon-bubble pink"><i class="fas fa-medal"></i></div>
                        <div class="stat-value">3</div>
                        <div class="stat-label">Winners</div>
                    </div>
                </div>
            </div>

            <?php if(!$todayLottery->is_completed): ?>
            
            <div class="glass-panel mb-5">
                <div class="text-center mb-4">
                    <h3 class="fw-bold section-title">🎟️ Get Your Ticket</h3>
                    <p class="text-muted">Simple process, instant entry.</p>
                </div>

                <?php
                    $userEntry = (isset($userParticipation) && $userParticipation) ? $userParticipation : null;
                ?>

                <?php if($userEntry): ?>
                    
                    <div class="glass-success-msg">
                        <div class="success-icon"><i class="fas fa-check"></i></div>
                        <h4>Participation Confirmed!</h4>
                        <div class="ticket-display">
                            <div class="ticket-row">
                                <span>Ticket Number:</span>
                                <strong><?php echo e($userEntry->ticket_number); ?></strong>
                            </div>
                            <div class="ticket-row">
                                <span>Time:</span>
                                <strong><?php echo e($userEntry->created_at->format('h:i A')); ?></strong>
                            </div>
                        </div>
                        <p class="mb-0 mt-3 text-sm">Best of luck! Winners announced at 11:50 PM.</p>
                    </div>
                <?php else: ?>
                    
                    <div class="row align-items-center">
                        <div class="col-md-6 mb-4 mb-md-0 text-center text-md-start ps-md-5">
                            <div class="price-display">
                                <span class="currency">৳</span><?php echo e($todayLottery->join_amount); ?>

                            </div>
                            <span class="price-label">Entry Fee Only</span>
                            <ul class="glass-list mt-3">
                                <li><i class="fas fa-check-circle text-success me-2"></i> Win up to <?php echo e($todayLottery->first_prize); ?>৳</li>
                                <li><i class="fas fa-check-circle text-success me-2"></i> Automatic Payout</li>
                                <li><i class="fas fa-check-circle text-success me-2"></i> 100% Fair Draw</li>
                            </ul>
                        </div>
                        <div class="col-md-6 text-center">
                            <form action="<?php echo e(route('join.lottery')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="glass-btn-primary pulse-animation">
                                    Join Lottery Now <i class="fas fa-arrow-right ms-2"></i>
                                </button>
                            </form>
                            <p class="small text-muted mt-2">Balance will be deducted automatically.</p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <?php if($todayLottery->is_completed && $todayLottery->winners && count($todayLottery->winners) > 0): ?>
            
            <div class="glass-panel mb-5">
                <div class="text-center mb-4">
                    <h3 class="fw-bold section-title">🏆 Lucky Winners</h3>
                    <p class="text-muted">Congratulations to today's champions!</p>
                </div>

                <div class="winners-grid">
                    <?php $__currentLoopData = $todayLottery->winners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $winner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $prizeClass = $winner['prize_type'] ?? 'third';
                    ?>
                    <div class="winner-glass-card <?php echo e($prizeClass); ?>">
                        <div class="winner-rank-badge">
                            <?php if(($winner['prize_type'] ?? '') == 'first'): ?> 🥇 1st
                            <?php elseif(($winner['prize_type'] ?? '') == 'second'): ?> 🥈 2nd
                            <?php else: ?> 🥉 3rd <?php endif; ?>
                        </div>
                        <div class="winner-avatar">
                            <?php echo e(substr($winner['user_name'] ?? 'U', 0, 1)); ?>

                        </div>
                        <div class="winner-details">
                            <h5><?php echo e($winner['user_name'] ?? 'User'); ?></h5>
                            <span class="ticket-pill">Ticket: <?php echo e($winner['ticket_number'] ?? '-'); ?></span>
                        </div>
                        <div class="winner-prize">
                            +<?php echo e($winner['prize_amount'] ?? 0); ?>৳
                        </div>

                        
                        <?php if(auth()->check() && auth()->id() == ($winner['user_id'] ?? null)): ?>
                            <div class="mt-3 w-100">
                                <?php if(empty($winner['is_claimed'])): ?>
                                    <form action="<?php echo e(route('claim.lottery.prize')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="ticket_number" value="<?php echo e($winner['ticket_number'] ?? ''); ?>">
                                        <input type="hidden" name="lottery_date" value="<?php echo e($todayLottery->lottery_date ?? ''); ?>">
                                        <button type="submit" class="btn-claim-glass">Claim Prize</button>
                                    </form>
                                <?php else: ?>
                                    <button class="btn-claim-glass claimed" disabled>Claimed ✓</button>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endif; ?>

            
            <div class="row">
                <div class="col-12 text-center mb-4">
                    <h3 class="fw-bold section-title">💰 Prize Pool</h3>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="prize-glass-box first">
                        <div class="prize-icon">👑</div>
                        <h4>1st Prize</h4>
                        <div class="amount"><?php echo e($todayLottery->first_prize); ?>৳</div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="prize-glass-box second">
                        <div class="prize-icon">🥈</div>
                        <h4>2nd Prize</h4>
                        <div class="amount"><?php echo e($todayLottery->second_prize); ?>৳</div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="prize-glass-box third">
                        <div class="prize-icon">🥉</div>
                        <h4>3rd Prize</h4>
                        <div class="amount"><?php echo e($todayLottery->third_prize); ?>৳</div>
                    </div>
                </div>
            </div>
            
            
            <div class="glass-panel mt-4 p-4">
                <h5 class="fw-bold mb-3"><i class="fas fa-info-circle me-2"></i>How It Works</h5>
                <div class="steps-row">
                    <div class="step-item">
                        <div class="step-num">1</div>
                        <p>Pay <strong><?php echo e($todayLottery->join_amount); ?>৳</strong> entry fee</p>
                    </div>
                    <div class="step-arrow"><i class="fas fa-chevron-right"></i></div>
                    <div class="step-item">
                        <div class="step-num">2</div>
                        <p>Wait for <strong>11:50 PM</strong> Draw</p>
                    </div>
                    <div class="step-arrow"><i class="fas fa-chevron-right"></i></div>
                    <div class="step-item">
                        <div class="step-num">3</div>
                        <p>Win & Get <strong>Cash</strong></p>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<style>
    /* -------------------------------- 
       GLASSMORPHISM BASE SETUP 
    -------------------------------- */
    :root {
        --glass-bg: rgba(255, 255, 255, 0.65); /* হালকা স্বচ্ছ ব্যাকগ্রাউন্ড */
        --glass-border: 1px solid rgba(255, 255, 255, 0.5); /* সাদা স্বচ্ছ বর্ডার */
        --glass-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.1); /* হালকা শ্যাডো */
        --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%); /* মূল রঙের গ্রেডিয়েন্ট */
        --accent-color: #764ba2; /* অ্যাকসেন্ট রঙ */
    }

    body {
        font-family: 'Poppins', sans-serif;
        background: #f0f2f5;
        overflow-x: hidden;
    }

    /* Floating Shapes Background */
    .glass-background {
        position: fixed;
        top: 0;
        left: 0;
        width: 100vw;
        height: 100vh;
        z-index: -1;
        /* ব্যাকগ্রাউন্ড কালার চেঞ্জ: আরও প্রাণবন্ত শেড ব্যবহার করা হয়েছে */
        background: linear-gradient(to bottom right, #eaf4ff, #ffeaf4); 
        overflow: hidden;
    }

    /* Shape Animation remains the same for the smooth floating effect */
    .shape {
        position: absolute;
        filter: blur(80px); /* ব্লার এর মাত্রা বাড়ানো হলো */
        opacity: 0.6; /* অস্বচ্ছতা কমানো হলো */
        animation: floatShape 20s infinite alternate;
    }

    .shape-1 {
        top: -10%; left: -10%;
        width: 50vw; height: 50vw;
        background: #a18cd1; /* বেগুনি শেড */
        border-radius: 50%;
    }

    .shape-2 {
        bottom: -10%; right: -10%;
        width: 60vw; height: 60vw;
        background: #fbc2eb; /* গোলাপী শেড */
        border-radius: 50%;
        animation-delay: -5s;
    }

    .shape-3 {
        top: 30%; left: 40%;
        width: 30vw; height: 30vw;
        background: #8ec5fc; /* নীল শেড */
        border-radius: 50%;
        animation-delay: -10s;
    }

    @keyframes floatShape {
        0% { transform: translate(0, 0) rotate(0deg); }
        100% { transform: translate(20px, 40px) rotate(10deg); }
    }

    .lottery-page-wrapper {
        position: relative;
        z-index: 1;
    }

    /* -------------------------------- 
       PREMIUM AD GLASS CARD (নতুন)
    -------------------------------- */
    .premium-ad-card {
        display: flex;
        align-items: center;
        background: rgba(255, 255, 255, 0.85); /* আরও স্বচ্ছ */
        backdrop-filter: blur(14px); /* ব্লার এর মাত্রা সামান্য বাড়লো */
        -webkit-backdrop-filter: blur(14px);
        border: 1px solid rgba(255, 255, 255, 0.7); /* আরো স্পষ্ট বর্ডার */
        border-radius: 20px;
        padding: 15px;
        text-decoration: none;
        box-shadow: 0 10px 20px rgba(0,0,0,0.08); /* শ্যাডো সামান্য গাঢ় হলো */
        position: relative;
        overflow: hidden;
        transition: transform 0.3s;
    }

    .premium-ad-card:hover {
        transform: translateY(-5px); /* হোভার প্রভাব সামান্য বাড়লো */
        box-shadow: 0 15px 30px rgba(0,0,0,0.1);
    }

    .ad-badge {
        position: absolute;
        top: 0; left: 0;
        background: linear-gradient(45deg, #FF9800, #F57C00);
        color: white;
        font-size: 10px;
        font-weight: bold;
        padding: 4px 10px;
        border-bottom-right-radius: 12px;
        z-index: 10;
    }

    .ad-image-wrapper {
        width: 80px; /* সাইজ সামান্য বাড়লো */
        height: 60px;
        border-radius: 12px;
        overflow: hidden;
        margin-right: 15px;
        flex-shrink: 0;
        border: 1px solid rgba(255, 255, 255, 0.5); /* ইমেজ বর্ডার যোগ করা হলো */
    }
    .ad-image-wrapper img { width: 100%; height: 100%; object-fit: cover; }

    .ad-content { flex: 1; }
    .ad-title { color: #333; font-weight: 700; font-size: 16px; margin-bottom: 3px; }
    .ad-cta { 
        color: var(--accent-color); 
        font-size: 13px; 
        font-weight: 600;
        display: flex;
        align-items: center;
    }
    .ad-arrow-icon { margin-left: 5px; font-size: 10px; }


    /* -------------------------------- 
       GLASS PANELS & CARDS 
    -------------------------------- */
    .glass-panel {
        background: var(--glass-bg);
        backdrop-filter: blur(18px); /* ব্লার এর মাত্রা সামান্য বাড়লো */
        -webkit-backdrop-filter: blur(18px);
        border-radius: 28px; /* বর্ডার রেডিয়াস সামান্য বাড়লো */
        border: var(--glass-border);
        box-shadow: 0 10px 40px 0 rgba(31, 38, 135, 0.15); /* শ্যাডো সামান্য গাঢ় হলো */
        padding: 2.5rem;
        position: relative;
    }

    /* Hero Typography */
    .lottery-badge-pill {
        /* স্টাইল অপরিবর্তিত */
        display: inline-block;
        background: rgba(118, 75, 162, 0.1);
        color: #764ba2;
        padding: 6px 16px;
        border-radius: 30px;
        font-weight: 700;
        font-size: 0.8rem;
        letter-spacing: 1px;
        margin-bottom: 1rem;
        border: 1px solid rgba(118, 75, 162, 0.2);
    }

    .lottery-title {
        font-size: 3rem; /* ফন্ট সাইজ সামান্য বাড়লো */
        font-weight: 800;
        background: var(--primary-gradient);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        margin-bottom: 0.5rem;
    }

    /* Completed Banner */
    .completed-glass-banner {
        background: rgba(255, 215, 0, 0.1);
        border: 1px solid rgba(255, 215, 0, 0.3);
        border-radius: 18px;
        padding: 20px;
        margin-top: 2rem;
        position: relative;
        overflow: hidden;
    }

    /* Glass Countdown */
    .glass-time-box {
        background: rgba(255, 255, 255, 0.8); /* আরও স্পষ্ট ব্যাকগ্রাউন্ড */
        border: 1px solid rgba(255, 255, 255, 0.9); /* আরও স্পষ্ট বর্ডার */
        padding: 15px 25px;
        border-radius: 18px;
        box-shadow: 0 4px 10px rgba(0,0,0,0.05); /* শ্যাডো বাড়লো */
    }
    
    .glass-time-box span {
        font-size: 2.8rem; /* ফন্ট সাইজ সামান্য বাড়লো */
    }

    /* Stats Cards */
    .glass-stat-card {
        background: rgba(255, 255, 255, 0.5);
        border: 1px solid rgba(255, 255, 255, 0.6); /* বর্ডার স্পষ্ট হলো */
        border-radius: 20px;
        padding: 20px;
        transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
        height: 100%;
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    }
    .glass-stat-card:hover {
        background: rgba(255, 255, 255, 0.9);
        transform: translateY(-8px); /* হোভার প্রভাব বাড়লো */
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
    }

    /* Join Section */
    .price-display {
        font-size: 4rem; /* ফন্ট সাইজ বাড়লো */
    }
    .glass-btn-primary {
        /* বাটন স্টাইল অপরিবর্তিত - এটি গ্লাসমরফিজমের সাথে মানানসই */
        background: var(--primary-gradient);
        color: white;
        border: none;
        padding: 16px 45px;
        font-size: 1.2rem;
        border-radius: 50px;
        font-weight: 600;
        box-shadow: 0 10px 20px rgba(118, 75, 162, 0.3);
        transition: 0.3s;
        width: 100%;
        max-width: 320px;
    }

    /* Prize Box */
    .prize-glass-box {
        background: rgba(255, 255, 255, 0.7); /* আরো স্বচ্ছ */
        border: 1px solid rgba(255, 255, 255, 0.7);
        padding: 2.5rem; /* প্যাডিং সামান্য বাড়লো */
        border-radius: 24px; /* বর্ডার রেডিয়াস বাড়লো */
        box-shadow: 0 6px 20px rgba(0,0,0,0.05);
    }
    .prize-glass-box:hover { transform: translateY(-8px); background: rgba(255,255,255,1); }

    .prize-glass-box.first { 
        border: 3px solid #FFD700; /* বর্ডার মোটা হলো */
        box-shadow: 0 0 20px rgba(255, 215, 0, 0.5); /* সোনালী গ্লো */
    }
    .prize-glass-box.second { border: 3px solid #C0C0C0; }
    .prize-glass-box.third { border: 3px solid #CD7F32; }

    /* Winners Grid */
    .winner-glass-card {
        background: rgba(255, 255, 255, 0.6); /* আরো স্বচ্ছ */
        border: 1px solid rgba(255, 255, 255, 0.8);
        border-radius: 18px;
        box-shadow: 0 4px 10px rgba(0,0,0,0.05);
    }
    .winner-glass-card.first { border-left: 5px solid #FFD700; }
    .winner-glass-card.second { border-left: 5px solid #C0C0C0; }
    .winner-glass-card.third { border-left: 5px solid #CD7F32; }
    
    .winner-prize {
        color: #008000; /* সবুজ রঙ ব্যবহার করা হলো */
        font-size: 1.3rem; /* ফন্ট সাইজ বাড়লো */
    }

    /* Instructions Row */
    .steps-row {
        display: flex; align-items: center; justify-content: space-around; /* স্পেস বাড়ানো হলো */
        text-align: center; margin-top: 1.5rem;
    }
    .step-item { flex-basis: 30%; /* সমান জায়গা */ }
    .step-num {
        /* স্টাইল অপরিবর্তিত */
        background: linear-gradient(135deg, #667eea, #764ba2);
    }

    /* Mobile Responsive */
    @media (max-width: 768px) {
        .glass-panel { padding: 1.5rem; }
        .lottery-title { font-size: 2.5rem; }
        .glass-time-box { min-width: 60px; padding: 8px; }
        .glass-time-box span { font-size: 1.6rem; }
        .glass-separator { font-size: 1.5rem; margin-top: -10px; }
        .steps-row { flex-direction: column; gap: 20px; }
        .step-arrow { transform: rotate(90deg); }
        .price-display { font-size: 3rem; }
    }
</style>

<script>
// কাউন্টডাউন স্ক্রিপ্টটি অপরিবর্তিত রয়েছে কারণ এটি সঠিকভাবে কাজ করছে।
(function() {
    const nextDrawTs = <?php echo e($nextDrawTime->getTimestamp() * 1000); ?>;
    
    function updateCountdown() {
        const nextDraw = new Date(nextDrawTs);
        const now = new Date();
        const diff = nextDraw - now;

        if (diff <= 0) {
            const mega = document.querySelector('.glass-countdown-grid');
            if (mega) {
                // ড্রয়িং সম্পন্ন হলে মেসেজ দেখাবে 
                mega.innerHTML = '<div class="text-danger fw-bold fs-3">Drawing Now...</div>';
            }
            setTimeout(function() {
                window.location.reload();
            }, 2500);
            return;
        }

        const hours = Math.floor(diff / (1000 * 60 * 60));
        const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
        const seconds = Math.floor((diff % (1000 * 60)) / 1000);

        const elHours = document.getElementById('countdown-hours');
        const elMinutes = document.getElementById('countdown-minutes');
        const elSeconds = document.getElementById('countdown-seconds');

        if (elHours) elHours.textContent = String(hours).padStart(2, '0');
        if (elMinutes) elMinutes.textContent = String(minutes).padStart(2, '0');
        if (elSeconds) elSeconds.textContent = String(seconds).padStart(2, '0');
    }

    updateCountdown();
    setInterval(updateCountdown, 1000);
})();
</script>

<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/teleearn/public_html/resources/views/user/lottery.blade.php ENDPATH**/ ?>