<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<style>
    :root {
        --tg-blue: #229ED9;
        --tg-light-blue: #40c4ff;
        --tg-bg: #ffffff;
        --tg-gray: #f5f7fa;
        --tg-text: #1a1a1a;
        --tg-muted: #65676b;
        --tg-success: #00b488;
        --tg-border: rgba(34, 158, 217, 0.15);
    }

    body {
        background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        min-height: 100vh;
    }

    .create-wrapper {
        min-height: 100vh;
        display: flex;
        align-items: center;
        padding: 20px 0;
        position: relative;
    }

    .create-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        -webkit-backdrop-filter: blur(20px);
        border-radius: 28px;
        overflow: hidden;
        box-shadow: 
            0 20px 60px rgba(34, 158, 217, 0.2),
            0 8px 25px rgba(0,0,0,0.1);
        max-width: 500px;
        margin: 0 auto;
        width: 100%;
        border: 1px solid rgba(255,255,255,0.3);
        animation: floatIn 0.8s ease-out;
    }

    @keyframes floatIn {
        from { opacity: 0; transform: translateY(40px) scale(0.95); }
        to { opacity: 1; transform: translateY(0) scale(1); }
    }

    /* Premium Header with Shine */
    .create-header {
        background: linear-gradient(135deg, var(--tg-light-blue), var(--tg-blue));
        padding: 40px 24px 60px;
        text-align: center;
        position: relative;
        overflow: hidden;
        color: white;
    }

    .create-header::before {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: linear-gradient(45deg, transparent 30%, rgba(255,255,255,0.15) 50%, transparent 70%);
        transform: rotate(30deg);
        animation: shine 8s infinite;
    }

    @keyframes shine {
        0% { transform: translateX(-100%) translateY(-100%) rotate(30deg); }
        100% { transform: translateX(100%) translateY(100%) rotate(30deg); }
    }

    .create-header h3 {
        margin: 0;
        font-size: 28px;
        font-weight: 800;
        position: relative;
        z-index: 2;
        text-shadow: 0 2px 10px rgba(0,0,0,0.2);
    }

    .create-header p {
        margin: 12px 0 0;
        font-size: 16px;
        opacity: 0.95;
        position: relative;
        z-index: 2;
    }

    .create-body {
        margin-top: -40px;
        padding: 32px;
        padding-top: 40px;
        background: white;
        border-radius: 28px 28px 0 0;
    }

    .form-group {
        margin-bottom: 24px;
    }

    .form-label {
        font-weight: 600;
        color: var(--tg-text);
        margin-bottom: 10px;
        display: block;
        font-size: 15px;
    }

    .form-control {
        border: none;
        background: var(--tg-gray);
        border-radius: 18px;
        padding: 16px 18px;
        font-size: 17px;
        transition: all 0.3s;
        box-shadow: inset 0 2px 8px rgba(0,0,0,0.05);
    }

    .form-control:focus {
        background: white;
        box-shadow: 
            0 0 0 4px rgba(34, 158, 217, 0.2),
            0 8px 25px rgba(34, 158, 217, 0.15);
        transform: translateY(-2px);
    }

    .help-text {
        font-size: 13.5px;
        color: var(--tg-muted);
        margin-top: 8px;
    }

    /* Premium Total Amount */
    .total-box {
        background: linear-gradient(135deg, #e8f5e8, #c8e6c9);
        border: 2px solid #81c784;
        color: #2e7d32;
        padding: 20px;
        border-radius: 20px;
        text-align: center;
        font-size: 24px;
        font-weight: 800;
        margin: 28px 0;
        box-shadow: 0 8px 25px rgba(76, 175, 80, 0.15);
        animation: pulse 2s infinite;
    }

    @keyframes pulse {
        0%, 100% { transform: scale(1); }
        50% { transform: scale(1.02); }
    }

    .total-label { font-size: 14px; font-weight: 600; opacity: 0.8; margin-bottom: 4px; }

    /* Image Preview */
    .preview-wrapper {
        position: relative;
        display: inline-block;
        margin-top: 12px;
    }

    .preview-wrapper img {
        max-height: 220px;
        border-radius: 18px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.15);
    }

    .remove-image {
        position: absolute;
        top: 8px;
        right: 8px;
        background: rgba(244,67,54,0.9);
        color: white;
        border: none;
        width: 36px;
        height: 36px;
        border-radius: 50%;
        font-size: 18px;
        cursor: pointer;
    }

    /* Submit Button */
    .btn-create {
        width: 100%;
        background: linear-gradient(135deg, var(--tg-blue), #1e88e5);
        color: white;
        border: none;
        padding: 18px;
        border-radius: 18px;
        font-size: 18px;
        font-weight: 700;
        margin-top: 10px;
        box-shadow: 0 10px 30px rgba(34, 158, 217, 0.4);
        transition: all 0.4s;
        position: relative;
        overflow: hidden;
    }

    .btn-create:hover {
        transform: translateY(-4px);
        box-shadow: 0 20px 40px rgba(34, 158, 217, 0.5);
    }

    .btn-create:active {
        transform: translateY(-1px);
    }
</style>
<br><br>
<div class="create-wrapper">
    <div class="create-card">
        <div class="create-header">
            <h3>Create New Ad</h3>
            <p>Reach thousands instantly • Live in seconds</p>
        </div>

        <div class="create-body">
            <form action="<?php echo e(route('ads.store')); ?>" method="POST" enctype="multipart/form-data" id="adForm">
                <?php echo csrf_field(); ?>

                <!-- Image Upload -->
                <div class="form-group">
                    <label class="form-label">Ad Image <span style="color:#e53935">*</span></label>
                    <input type="file" class="form-control <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           id="image" name="image" accept="image/*" required>
                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="text-danger mt-2"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <small class="help-text">Supported: JPEG, PNG, GIF • Max 2MB</small>

                    <div class="preview-wrapper text-center" id="previewContainer" style="display:none; margin-top:16px;">
                        <img id="imagePreview" src="" alt="Preview">
                        <button type="button" class="remove-image" onclick="removeImage()">×</button>
                    </div>
                </div>

                <!-- Link -->
                <div class="form-group">
                    <label class="form-label">Destination Link <span style="color:#e53935">*</span></label>
                    <input type="url" class="form-control <?php $__errorArgs = ['link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           id="link" name="link" value="<?php echo e(old('link')); ?>" 
                           placeholder="https://yoursite.com" required>
                    <?php $__errorArgs = ['link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="text-danger mt-2"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Duration -->
                <div class="form-group">
                    <label class="form-label">Duration (Hours) <span style="color:#e53935">*</span></label>
                    <input type="number" class="form-control <?php $__errorArgs = ['duration_hours'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                           id="duration_hours" name="duration_hours" 
                           value="<?php echo e(old('duration_hours', 1)); ?>" min="1" required>
                    <?php $__errorArgs = ['duration_hours'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="text-danger mt-2"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <small class="help-text">Rate: ৳<?php echo e(number_format($ratePerHour)); ?> per hour</small>
                </div>

                <!-- Total Amount -->
                <div class="total-box">
                    <div class="total-label">Total Amount</div>
                    ৳<span id="totalAmount">0</span>
                </div>

                <button type="submit" class="btn-create">
                    Proceed to Payment
                </button>
            </form>
        </div>
    </div>
</div>

<script>
    const rate = <?php echo e($ratePerHour); ?>;
    const hoursInput = document.getElementById('duration_hours');
    const totalSpan = document.getElementById('totalAmount');

    function calculateTotal() {
        const hours = parseInt(hoursInput.value) || 0;
        const total = hours * rate;
        totalSpan.textContent = new Intl.NumberFormat('en-BD').format(total);
    }

    hoursInput.addEventListener('input', calculateTotal);
    calculateTotal();

    // Image Preview + Remove
    document.getElementById('image').addEventListener('change', function(e) {
        const file = e.target.files[0];
        const previewContainer = document.getElementById('previewContainer');
        const previewImg = document.getElementById('imagePreview');

        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                previewImg.src = e.target.result;
                previewContainer.style.display = 'block';
            }
            reader.readAsDataURL(file);
        }
    });

    function removeImage() {
        document.getElementById('image').value = '';
        document.getElementById('previewContainer').style.display = 'none';
    }
</script>

<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/teleearn/checkk.tele-earn.com/resources/views/user/create_ad.blade.php ENDPATH**/ ?>