<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reward System | Premium Dashboard</title>
    <meta name="description" content="Unlock exclusive gift codes by inviting friends!">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&family=Space+Grotesk:wght@500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>

    <!-- Confetti JS -->
    <script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.6.0/dist/confetti.browser.min.js"></script>

    <style>
        :root {
            --primary: #0088cc;
            --primary-dark: #006da3;
            --success: #00a884;
            --glass: rgba(255,255,255,0.95);
            --glass-border: rgba(0,136,204,0.15);
            --shadow: 0 4px 20px rgba(0,0,0,0.08);
            --sidebar-width: 260px;
            --header-height: 60px;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: #f5f7fa;
            color: #333;
            min-height: 100vh;
            overflow-x: hidden;
        }
        
        /* Telegram-inspired Header */
        .app-header {
            height: var(--header-height);
            background: #fff;
            box-shadow: 0 1px 3px rgba(0,0,0,0.08);
            position: sticky;
            top: 0;
            z-index: 1000;
        }
        
        .app-logo {
            font-family: 'Space Grotesk', sans-serif;
            font-weight: 700;
            font-size: 1.5rem;
            color: var(--primary);
            display: flex;
            align-items: center;
        }
        
        .app-logo i {
            margin-right: 8px;
            font-size: 1.3rem;
        }
        
        .user-avatar {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: var(--primary);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
        }
        
        /* Main Content Area */
        .main-content {
            margin-left: 0;
            padding: 2rem;
            min-height: calc(100vh - var(--header-height));
            transition: all 0.3s ease;
        }
        
        @media (min-width: 992px) {
            .main-content {
                margin-left: var(--sidebar-width);
            }
        }
        
        /* Cards */
        .telegram-card {
            background: var(--glass);
            border: 1px solid var(--glass-border);
            border-radius: 14px;
            box-shadow: var(--shadow);
            transition: all 0.3s ease;
            overflow: hidden;
        }
        
        .telegram-card:hover {
            box-shadow: 0 8px 25px rgba(0,0,0,0.12);
            transform: translateY(-5px);
        }
        
        .card-header {
            background: rgba(0,136,204,0.05);
            border-bottom: 1px solid rgba(0,136,204,0.1);
            padding: 1.25rem 1.5rem;
            font-weight: 600;
            color: var(--primary);
        }
        
        /* Stats Cards */
        .stat-card {
            padding: 1.5rem;
            text-align: center;
            border-radius: 14px;
            position: relative;
            overflow: hidden;
        }
        
        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: linear-gradient(90deg, var(--primary), var(--success));
        }
        
        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
            font-size: 1.5rem;
            background: rgba(0,136,204,0.1);
            color: var(--primary);
        }
        
        .stat-value {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            color: var(--primary);
        }
        
        .stat-label {
            color: #666;
            font-weight: 500;
        }
        
        /* Gift Code Box */
        .giftcode-box {
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            border-radius: 16px;
            padding: 2.5rem 2rem;
            text-align: center;
            position: relative;
            overflow: hidden;
            color: white;
            margin-bottom: 2rem;
        }
        
        .giftcode-box::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            animation: pulse 8s infinite;
        }
        
        @keyframes pulse {
            0%, 100% { opacity: 0.4; }
            50% { opacity: 0.8; }
        }
        
        .giftcode {
            font-size: 2.5rem;
            font-weight: 700;
            letter-spacing: 8px;
            background: rgba(255,255,255,0.15);
            backdrop-filter: blur(10px);
            padding: 1.5rem 2rem;
            border-radius: 12px;
            display: inline-block;
            margin: 1.5rem 0;
            border: 1px solid rgba(255,255,255,0.3);
            font-family: 'Space Grotesk', monospace;
        }
        
        /* Buttons */
        .tg-btn {
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }
        
        .tg-btn-primary {
            background: var(--primary);
        }
        
        .tg-btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,136,204,0.3);
        }
        
        .tg-btn-success {
            background: var(--success);
        }
        
        .tg-btn-success:hover {
            background: #008e6f;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,168,132,0.3);
        }
        
        .tg-btn-secondary {
            background: #6c757d;
        }
        
        .tg-btn-secondary:hover {
            background: #5a6268;
            transform: translateY(-2px);
        }
        
        /* Progress Bar */
        .progress {
            height: 16px;
            border-radius: 10px;
            background: rgba(0,0,0,0.05);
            overflow: hidden;
        }
        
        .progress-bar {
            background: linear-gradient(90deg, var(--primary), var(--success));
            font-size: 0.75rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden;
        }
        
        .progress-bar::after {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            animation: shine 3s infinite;
        }
        
        @keyframes shine {
            to { left: 100%; }
        }
        
        /* Reward Tiers */
        .reward-tier {
            padding: 1.5rem;
            text-align: center;
            position: relative;
            transition: all 0.3s ease;
        }
        
        .reward-tier.eligible {
            border: 2px solid var(--success);
        }
        
        .reward-tier.claimed {
            opacity: 0.8;
        }
        
        .tier-icon {
            font-size: 3rem;
            margin-bottom: 1rem;
            color: var(--primary);
        }
        
        .tier-amount {
            font-size: 2rem;
            font-weight: 700;
            color: var(--primary);
            margin: 0.5rem 0;
        }
        
        .locked-badge {
            position: absolute;
            top: 1rem;
            right: 1rem;
            background: rgba(108,117,125,0.1);
            color: #6c757d;
            padding: 0.25rem 0.75rem;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 500;
        }
        
        /* Alerts */
        .tg-alert {
            border-radius: 12px;
            border: none;
            padding: 1rem 1.5rem;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
        }
        
        .tg-alert-success {
            background: rgba(0,168,132,0.1);
            color: #006652;
            border-left: 4px solid var(--success);
        }
        
        .tg-alert-danger {
            background: rgba(220,53,69,0.1);
            color: #a71d2a;
            border-left: 4px solid #dc3545;
        }
        
        /* Animations */
        @keyframes float {
            0% { transform: translateY(100vh) scale(0); opacity: 0; }
            10% { opacity: 1; }
            90% { opacity: 1; }
            100% { transform: translateY(-100px) scale(1); opacity: 0; }
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .main-content {
                padding: 1rem;
            }
            
            .giftcode {
                font-size: 1.5rem;
                letter-spacing: 4px;
                padding: 1rem 1.5rem;
            }
            
            .stat-value {
                font-size: 2rem;
            }
        }
        
        /* Page Title */
        .page-title {
            font-family: 'Space Grotesk', sans-serif;
            font-weight: 700;
            font-size: 2.5rem;
            margin-bottom: 0.5rem;
            color: var(--primary);
        }
        
        .page-subtitle {
            color: #666;
            margin-bottom: 2rem;
        }
    </style>
</head>
<body>

<!-- Victory Sound (Hidden) -->
<audio id="rewardSound" preload="auto">
    <source src="<?php echo e(asset('sounds/6.mp3')); ?>" type="audio/mpeg">
</audio>

<!-- Header -->
<header class="app-header d-flex align-items-center justify-content-between px-3 px-lg-4">
    <div class="app-logo">
        <i class="fas fa-paper-plane"></i>
        <span>TeleRewards</span>
    </div>
    <div class="d-flex align-items-center">
        <div class="user-avatar me-3">
            <i class="fas fa-user"></i>
        </div>
        <span class="d-none d-md-inline">User Dashboard</span>
    </div>
</header>

<!-- Main Content -->
<main class="main-content">
    <div class="container-fluid">
        <!-- Gift Code Success Box + Auto Sound & Confetti -->
        <?php if(session('giftcode_success')): ?>
        <div class="row mb-4 animate__animated animate__fadeInDown">
            <div class="col-12">
                <div class="giftcode-box">
                    <i class="fas fa-gift fa-3x mb-3 animate__animated animate__tada animate__infinite"></i>
                    <h2 class="fw-bold mb-2">Congratulations! 🎉</h2>
                    <p class="mb-3 opacity-90">Your exclusive gift code is ready to use</p>

                    <div class="giftcode animate__animated animate__pulse" id="giftCode">
                        <?php echo e(session('giftcode_success.code')); ?>

                    </div>

                    <button class="btn tg-btn tg-btn-primary mt-3" onclick="copyCode()">
                        <i class="fas fa-copy me-2"></i> Copy Gift Code
                    </button>

                    <p class="mt-3 opacity-90">
                        <i class="fas fa-lightbulb me-2"></i>
                        <strong>Pro Tip:</strong> Use it instantly in the Gift Code section!
                    </p>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Success / Error Messages -->
        <?php if(session('success')): ?>
            <div class="tg-alert tg-alert-success animate__animated animate__fadeIn">
                <i class="fas fa-check-circle me-2"></i> <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
        <?php if(session('error')): ?>
            <div class="tg-alert tg-alert-danger animate__animated animate__fadeIn">
                <i class="fas fa-exclamation-triangle me-2"></i> <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <!-- Page Title -->
        <div class="mb-5">
            <h1 class="page-title">Referral Rewards</h1>
            <p class="page-subtitle">Invite friends • Unlock exclusive gift codes • Earn rewards</p>
        </div>
        
        <!-- নতুন: user_active == 1 হলে ৳3 স্পেশাল বোনাস -->
        <?php if($user->user_active == 1): ?>
            <?php
                $claimedRewards = $user->claimed_rewards ? json_decode($user->claimed_rewards, true) : [];
                $alreadyClaimedSpecial = is_array($claimedRewards) && in_array('user_active_bonus', $claimedRewards);
            ?>

            <div class="telegram-card special-bonus-card mb-4 animate__animated animate__bounceIn">
                <div class="card-body text-center p-4">
                    <i class="fas fa-star fa-3x text-success mb-3"></i>
                    <h3 class="fw-bold text-success">স্পেশাল ওয়েলকাম বোনাস!</h3>
                    <p class="mb-3">আপনার অ্যাকাউন্ট অ্যাকটিভ হয়েছে। একবারের জন্য <strong>৳3</strong> ফ্রি গিফট কোড নিন!</p>

                    <?php if(!$alreadyClaimedSpecial): ?>
                        <form action="<?php echo e(route('user.claim.useractive.bonus')); ?>" method="POST" onsubmit="celebrate()">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn tg-btn-success btn-lg">
                                <i class="fas fa-gift me-2"></i> ৳3 ক্লেইম করুন (একবার মাত্র)
                            </button>
                        </form>
                    <?php else: ?>
                        <button class="btn btn-secondary btn-lg" disabled>
                            <i class="fas fa-check me-2"></i> ইতিমধ্যে ক্লেইম করা হয়েছে
                        </button>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
        
        <!-- Stats Cards -->
        <div class="row g-4 mb-5">
            <div class="col-md-6">
                <div class="telegram-card stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="stat-value"><?php echo e($userActiveReferrals); ?></div>
                    <div class="stat-label">Active Referrals</div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="telegram-card stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-gift"></i>
                    </div>
                    <div class="stat-value"><?php echo e(count($eligibleRewards) - count($claimedRewards)); ?></div>
                    <div class="stat-label">Unclaimed Rewards</div>
                </div>
            </div>
        </div>

        <!-- Reward Tiers -->
        <div class="telegram-card mb-5">
            <div class="card-header">
                <i class="fas fa-trophy me-2"></i> Available Rewards
            </div>
            <div class="card-body p-4">
                <div class="row g-4">
                    <?php $__currentLoopData = $rewardOffers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $threshold => $amount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $isEligible = $userActiveReferrals >= $threshold;
                            $isClaimed = in_array($threshold, $claimedRewards);
                        ?>
                        <div class="col-lg-4 col-md-6">
                            <div class="telegram-card reward-tier h-100 <?php echo e($isEligible ? 'eligible' : ''); ?> <?php echo e($isClaimed ? 'claimed' : ''); ?>">
                                <?php if(!$isEligible): ?>
                                    <div class="locked-badge"><i class="fas fa-lock me-1"></i> Locked</div>
                                <?php endif; ?>

                                <div class="p-3">
                                    <div class="tier-icon">
                                        <i class="fas fa-trophy"></i>
                                    </div>
                                    <h4 class="fw-bold"><?php echo e($threshold); ?> Referrals</h4>
                                    <div class="tier-amount">৳<?php echo e($amount); ?></div>

                                    <?php if($isClaimed): ?>
                                        <button class="btn tg-btn tg-btn-secondary w-100 mt-3" disabled>
                                            <i class="fas fa-check me-2"></i> Claimed
                                        </button>
                                    <?php elseif($isEligible): ?>
                                        <form action="<?php echo e(route('claim.reward')); ?>" method="POST" class="mt-3" onsubmit="celebrate()">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="threshold" value="<?php echo e($threshold); ?>">
                                            <button type="submit" class="btn tg-btn tg-btn-success w-100">
                                                <i class="fas fa-gift me-2"></i> Claim Now
                                            </button>
                                        </form>
                                    <?php else: ?>
                                        <p class="text-muted mt-3">Need <?php echo e($threshold - $userActiveReferrals); ?> more referrals</p>
                                        <button class="btn tg-btn tg-btn-secondary w-100" disabled>Locked</button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        <!-- Progress Bar -->
        <?php
            $max = max(array_keys($rewardOffers));
            $progress = min(100, ($userActiveReferrals / $max) * 100);
        ?>
        <div class="telegram-card">
            <div class="card-header">
                <i class="fas fa-chart-line me-2"></i> Progress to Ultimate Reward (<?php echo e($max); ?> Referrals)
            </div>
            <div class="card-body p-4">
                <div class="progress mb-3">
                    <div class="progress-bar" style="width: <?php echo e($progress); ?>%">
                        <?php echo e($userActiveReferrals); ?> / <?php echo e($max); ?> • <?php echo e(number_format($progress,1)); ?>%
                    </div>
                </div>
                <p class="text-muted mb-0">Keep inviting friends to unlock more rewards!</p>
            </div>
        </div>
    </div>
</main>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
// Victory Sound + Confetti Function
function celebrate() {
    // Play sound
    const sound = document.getElementById('rewardSound');
    sound.currentTime = 0;
    sound.play();

    // Confetti explosion
    confetti({
        particleCount: 150,
        spread: 70,
        origin: { y: 0.6 },
        colors: ['#0088cc', '#00a884', '#fbbf24', '#8b5cf6', '#ec4899']
    });
}

// Copy Gift Code + Sound + Confetti
function copyCode() {
    const code = document.getElementById('giftCode')?.innerText || '';
    navigator.clipboard.writeText(code).then(() => {
        const btn = event.target.closest('button');
        const original = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-check me-2"></i> Copied!';
        btn.classList.remove('tg-btn-primary');
        btn.classList.add('tg-btn-success');

        celebrate(); // Sound + Confetti on copy

        setTimeout(() => {
            btn.innerHTML = original;
            btn.classList.remove('tg-btn-success');
            btn.classList.add('tg-btn-primary');
        }, 2000);
    });
}

// Auto play sound + confetti when page loads with giftcode_success or success message
document.addEventListener('DOMContentLoaded', function() {
    <?php if(session('giftcode_success') || session('success')): ?>
        setTimeout(celebrate, 700);
    <?php endif; ?>

    // Floating particles background
    for(let i = 0; i < 20; i++) {
        const p = document.createElement('div');
        p.style.cssText = `
            position:fixed; width:4px; height:4px; background:rgba(0,136,204,0.3);
            border-radius:50%; pointer-events:none; z-index:-1;
            left:${Math.random()*100}vw; animation:float ${8+Math.random()*8}s linear infinite;
            animation-delay:${Math.random()*8}s;
        `;
        document.body.appendChild(p);
    }
});
</script>

</body>
</html>

<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/teleearn/public_html/resources/views/user/reward-system.blade.php ENDPATH**/ ?>