<?php $__env->startSection('body'); ?>


            <div class="notice-wrapper">
    <div class="notice-panel">
        <div class="notice-panel-header">
            <button type="button" class="notice-btn-add" data-toggle="modal" data-target="#noticeModal">
                + Add New Notice
            </button>
        </div>

        <div class="notice-table-container">
            <table class="notice-table" id="noticesTable">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Date</th>
                        <th>Title</th>
                        <th>Content</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($item->id); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($item->created_at)->format('d.m.Y')); ?></td>
                            <td><?php echo e($item->notice_title); ?></td>
                            <td><?php echo e($item->notice_body); ?></td>
                            <td>
                                <a href="<?php echo e(route('NoticeAdminDelete', $item->id)); ?>" class="notice-btn-delete">
                                    Delete
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="noticeModal" tabindex="-1" role="dialog" aria-labelledby="noticeModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form action="<?php echo e(route('submitNotice')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="noticeModalLabel">Create New Notice</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-field">
                        <label class="form-label">Notice Title</label>
                        <input type="text" name="notice_title" class="form-input" placeholder="Enter title" required>
                    </div>
                    <div class="form-field">
                        <label class="form-label">Notice Content</label>
                        <textarea name="notice_content" class="form-input" rows="4" placeholder="Enter content" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="modal-close-btn" data-dismiss="modal">Close</button>
                    <button type="submit" class="modal-save-btn">Add Notice</button>
                </div>
            </form>
        </div>
    </div>
</div>
<style>
    .notice-wrapper {
    padding: 25px;
    background: #f4f7fc;
}

.notice-panel {
    background: #ffffff;
    border-radius: 10px;
    box-shadow: 0 3px 12px rgba(0, 0, 0, 0.06);
    padding: 20px;
}

.notice-panel-header {
    display: flex;
    justify-content: flex-end;
    margin-bottom: 15px;
}

.notice-btn-add {
    background: #007bff;
    color: #fff;
    border: none;
    padding: 8px 18px;
    border-radius: 6px;
    font-weight: bold;
    transition: 0.3s;
}

.notice-btn-add:hover {
    background: #0069d9;
}

.notice-table {
    width: 100%;
    border-collapse: collapse;
}

.notice-table th,
.notice-table td {
    padding: 12px 14px;
    border: 1px solid #dee2e6;
    text-align: center;
    vertical-align: middle;
}

.notice-btn-delete {
    color: #dc3545;
    font-weight: bold;
    text-decoration: none;
}

.notice-btn-delete:hover {
    text-decoration: underline;
}

.form-field {
    margin-bottom: 15px;
}

.form-label {
    display: block;
    font-weight: 600;
    margin-bottom: 6px;
    color: #333;
}

.form-input {
    width: 100%;
    padding: 10px 12px;
    border: 1px solid #ccc;
    border-radius: 6px;
    font-size: 15px;
}

.modal-close-btn,
.modal-save-btn {
    padding: 8px 16px;
    border-radius: 6px;
    border: none;
    font-weight: bold;
}

.modal-close-btn {
    background: #6c757d;
    color: #fff;
}

.modal-save-btn {
    background: #28a745;
    color: #fff;
}

</style>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/studentjobbd/kkkkkk.hatiya-panel.site/resources/views/dashboard/notice.blade.php ENDPATH**/ ?>