<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<style>
    :root {
        --primary: #229ED9;
        --primary-dark: #1c88bd;
        --secondary: #f0f2f5;
        --text-dark: #1f2937;
        --text-light: #6b7280;
        --white: #ffffff;
        --shadow-sm: 0 2px 4px rgba(0,0,0,0.02);
        --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
        --radius: 16px;
    }

    body {
        background: linear-gradient(135deg, #f0f7ff 0%, #e0f2fe 100%);
        font-family: 'Inter', sans-serif;
        color: var(--text-dark);
    }

    .create-wrapper {
        min-height: 100vh;
        display: flex;
        justify-content: center;
        padding: 40px 15px;
    }

    .main-card {
        background: var(--white);
        width: 100%;
        max-width: 600px;
        border-radius: 24px;
        box-shadow: 0 20px 40px rgba(34, 158, 217, 0.15);
        overflow: hidden;
        border: 1px solid rgba(255,255,255,0.6);
        animation: slideUp 0.6s cubic-bezier(0.16, 1, 0.3, 1);
    }

    @keyframes slideUp {
        from { transform: translateY(30px); opacity: 0; }
        to { transform: translateY(0); opacity: 1; }
    }

    /* --- Header Section --- */
    .card-header-custom {
        background: linear-gradient(135deg, #229ED9, #0088cc);
        padding: 40px 30px;
        text-align: center;
        color: white;
        position: relative;
        overflow: hidden;
    }

    .card-header-custom::after {
        content: ''; position: absolute; top: 0; left: 0; right: 0; bottom: 0;
        background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.1'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E");
    }

    .header-icon {
        width: 60px; height: 60px; background: rgba(255,255,255,0.2);
        border-radius: 50%; display: flex; align-items: center; justify-content: center;
        font-size: 24px; margin: 0 auto 15px; backdrop-filter: blur(5px);
    }

    .card-header-custom h2 { font-size: 24px; font-weight: 700; margin: 0; letter-spacing: -0.5px; }
    .card-header-custom p { margin: 8px 0 0; opacity: 0.9; font-size: 14px; }

    /* --- Body Section --- */
    .card-body-custom { padding: 30px; }

    .section-title {
        font-size: 13px; font-weight: 700; text-transform: uppercase;
        color: var(--text-light); letter-spacing: 1px; margin-bottom: 15px;
        display: block;
    }

    /* --- Selection Cards (Radio Replacement) --- */
    .selection-grid {
        display: grid; grid-template-columns: repeat(3, 1fr); gap: 10px; margin-bottom: 25px;
    }

    .selection-card {
        position: relative; cursor: pointer;
    }

    .selection-card input { position: absolute; opacity: 0; }

    .card-inner {
        border: 2px solid #e5e7eb; border-radius: 12px; padding: 15px 5px;
        text-align: center; transition: all 0.3s ease;
        background: #f9fafb; height: 100%; display: flex; flex-direction: column; align-items: center; justify-content: center;
    }

    .card-inner i { font-size: 24px; color: var(--text-light); margin-bottom: 8px; transition: 0.3s; }
    .card-inner span { font-size: 12px; font-weight: 600; color: var(--text-dark); line-height: 1.2; }

    /* Checked State */
    .selection-card input:checked + .card-inner {
        border-color: var(--primary); background: #f0f9ff;
        box-shadow: 0 4px 12px rgba(34, 158, 217, 0.15); transform: translateY(-2px);
    }
    .selection-card input:checked + .card-inner i { color: var(--primary); }
    .selection-card input:checked + .card-inner span { color: var(--primary); }

    /* --- Form Inputs --- */
    .input-group-custom { position: relative; margin-bottom: 20px; }
    
    .input-icon {
        position: absolute; left: 16px; top: 50%; transform: translateY(-50%);
        color: var(--text-light); font-size: 18px; z-index: 2;
    }

    .form-control-custom {
        width: 100%; padding: 16px 16px 16px 48px;
        border: 2px solid #e5e7eb; border-radius: 12px;
        font-size: 15px; font-weight: 500; color: var(--text-dark);
        transition: all 0.3s; background: #fff;
    }

    .form-control-custom:focus {
        border-color: var(--primary); outline: none;
        box-shadow: 0 0 0 4px rgba(34, 158, 217, 0.1);
    }

    /* --- Image Upload Area --- */
    #manualImageSection { display: none; margin-bottom: 25px; animation: fadeIn 0.4s; }
    @keyframes fadeIn { from { opacity: 0; transform: translateY(-10px); } to { opacity: 1; transform: translateY(0); } }

    .upload-box {
        border: 2px dashed #cbd5e1; border-radius: 16px; padding: 20px;
        text-align: center; background: #f8fafc; cursor: pointer; transition: 0.3s;
        position: relative;
    }
    .upload-box:hover { border-color: var(--primary); background: #f0f9ff; }
    .upload-icon { font-size: 32px; color: var(--primary); margin-bottom: 10px; }
    .upload-text { font-size: 14px; color: var(--text-light); }
    
    .file-input-hidden {
        position: absolute; top: 0; left: 0; width: 100%; height: 100%; opacity: 0; cursor: pointer;
    }

    /* Preview */
    .preview-area { position: relative; margin-top: 15px; display: none; }
    .preview-area img { width: 100%; height: 180px; object-fit: cover; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
    .remove-btn {
        position: absolute; top: -10px; right: -10px; background: #ef4444; color: white;
        border: none; width: 30px; height: 30px; border-radius: 50%; cursor: pointer;
        box-shadow: 0 2px 5px rgba(0,0,0,0.2); display: flex; align-items: center; justify-content: center;
    }

    /* --- Impression/Reach Box (NEW) --- */
    .reach-info {
        background: linear-gradient(135deg, #10b98115, #05966915);
        border: 1px solid #10b98140;
        border-radius: 16px;
        padding: 15px 20px;
        margin-bottom: 20px;
        display: flex;
        align-items: center;
        gap: 15px;
        animation: fadeIn 0.5s;
    }
    .reach-icon {
        width: 45px; height: 45px;
        background: #10b981;
        color: white;
        border-radius: 12px;
        display: flex; align-items: center; justify-content: center;
        font-size: 20px;
        box-shadow: 0 4px 10px rgba(16, 185, 129, 0.2);
    }
    .reach-text h5 { margin: 0; font-size: 13px; color: #059669; font-weight: 600; text-transform: uppercase; }
    .reach-text span { font-size: 18px; font-weight: 700; color: #047857; }


    /* --- Schedule Info Box --- */
    .schedule-info {
        background: linear-gradient(135deg, #f0f9ff, #e0f2fe);
        border: 2px solid #bae6fd;
        border-radius: 16px;
        padding: 20px;
        margin: 20px 0;
        text-align: center;
    }

    .schedule-icon {
        font-size: 24px;
        color: var(--primary);
        margin-bottom: 10px;
    }

    .schedule-title {
        font-size: 14px;
        font-weight: 600;
        color: var(--text-dark);
        margin-bottom: 5px;
    }

    .schedule-time {
        font-size: 16px;
        font-weight: 700;
        color: var(--primary);
    }

    .schedule-note {
        font-size: 12px;
        color: var(--text-light);
        margin-top: 8px;
    }

    /* --- Total Cost Box --- */
    .cost-display {
        background: #1f2937; color: white; border-radius: 16px; padding: 20px;
        display: flex; justify-content: space-between; align-items: center;
        margin-top: 30px; margin-bottom: 20px;
        box-shadow: 0 10px 25px rgba(31, 41, 55, 0.2);
    }
    .cost-left span { display: block; font-size: 12px; opacity: 0.7; text-transform: uppercase; }
    .cost-left h4 { margin: 0; font-size: 18px; font-weight: 500; }
    .cost-right { font-size: 28px; font-weight: 700; color: #4ade80; }

    /* --- Submit Button --- */
    .btn-submit {
        width: 100%; background: linear-gradient(135deg, var(--primary), #0088cc);
        color: white; border: none; padding: 18px; border-radius: 14px;
        font-size: 16px; font-weight: 700; letter-spacing: 0.5px;
        cursor: pointer; transition: 0.3s; box-shadow: 0 8px 20px rgba(34, 158, 217, 0.3);
        display: flex; align-items: center; justify-content: center; gap: 10px;
    }
    .btn-submit:hover { transform: translateY(-2px); box-shadow: 0 12px 25px rgba(34, 158, 217, 0.4); }

    /* Mobile Responsive */
    @media (max-width: 480px) {
        .selection-grid { gap: 8px; }
        .card-inner { padding: 10px 2px; }
        .card-inner span { font-size: 10px; }
    }
</style>

<br><br>
<div class="create-wrapper">
    <div class="main-card">
        <div class="card-header-custom">
            <div class="header-icon">
                <i class="fas fa-rocket"></i>
            </div>
            <h2>Create Campaign</h2>
            <p>Reach thousands of real users instantly</p>
        </div>

        <div class="card-body-custom">
            <form action="<?php echo e(route('ads.store')); ?>" method="POST" enctype="multipart/form-data" id="adForm">
                <?php echo csrf_field(); ?>
                
                <input type="hidden" name="default_image" id="defaultImage" value="join.jpg">

                <span class="section-title">1. Select Campaign Type</span>
                
                <div class="selection-grid">
                    <label class="selection-card">
                        <input type="radio" name="ad_type" value="telegram" checked onchange="handleTypeChange()">
                        <div class="card-inner">
                            <i class="fab fa-telegram-plane"></i>
                            <span>Telegram<br>Channel</span>
                        </div>
                    </label>

                    <label class="selection-card">
                        <input type="radio" name="ad_type" value="website" onchange="handleTypeChange()">
                        <div class="card-inner">
                            <i class="fas fa-globe"></i>
                            <span>Website<br>Link</span>
                        </div>
                    </label>

                    <label class="selection-card">
                        <input type="radio" name="ad_type" value="manual" onchange="handleTypeChange()">
                        <div class="card-inner">
                            <i class="fas fa-upload"></i>
                            <span>Custom<br>Banner</span>
                        </div>
                    </label>
                </div>

                <div id="manualImageSection">
                    <div class="upload-box">
                        <div class="upload-icon"><i class="fas fa-cloud-upload-alt"></i></div>
                        <div class="upload-text">Click to upload banner image</div>
                        <small style="color:#94a3b8; display:block; margin-top:5px;">Max 2MB (JPG, PNG)</small>
                        <input type="file" class="file-input-hidden <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="image" name="image" accept="image/*">
                    </div>
                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="text-danger mt-2" style="font-size:13px;"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    <div class="preview-area" id="previewContainer">
                        <img id="imagePreview" src="" alt="Preview">
                        <button type="button" class="remove-btn" onclick="removeImage()"><i class="fas fa-times"></i></button>
                    </div>
                </div>
                
                <span class="section-title" style="margin-top: 20px;">2. Ads Name</span>
<div class="input-group-custom">
    <i class="fas fa-tag input-icon"></i>
    <input type="text" class="form-control-custom <?php $__errorArgs = ['ad_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
           id="ad_name" name="ad_name" value="<?php echo e(old('ad_name')); ?>" 
           placeholder="Enter Ads Name (e.g. Banner Ad 1)" required>
    <?php $__errorArgs = ['ad_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="text-danger mt-2" style="font-size:13px;"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
</div>
                
                <span class="section-title" style="margin-top: 20px;">3. Destination Link</span>
                <div class="input-group-custom">
                    <i class="fas fa-link input-icon"></i>
                    <input type="url" class="form-control-custom <?php $__errorArgs = ['link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           id="link" name="link" value="<?php echo e(old('link')); ?>" 
                           placeholder="https://t.me/yourchannel" required>
                    <?php $__errorArgs = ['link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="text-danger mt-2" style="font-size:13px;"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <span class="section-title">3. Duration & Reach</span>
                <div class="input-group-custom">
                    <i class="fas fa-clock input-icon"></i>
                    <input type="number" class="form-control-custom <?php $__errorArgs = ['duration_hours'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                           id="duration_hours" name="duration_hours" 
                           value="<?php echo e(old('duration_hours', 1)); ?>" min="1" required oninput="updateCalculations()">
                    <div style="position: absolute; right: 16px; top: 50%; transform: translateY(-50%); color: var(--text-light); font-size: 13px;">
                        Hours
                    </div>
                </div>

                <div class="reach-info">
                    <div class="reach-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <div class="reach-text">
                        <h5>Expected Impressions</h5>
                        <span id="estimatedReach">0 - 0</span>
                    </div>
                </div>

                <div class="schedule-info" id="scheduleInfo">
                    <div class="schedule-icon">
                        <i class="fas fa-calendar-check"></i>
                    </div>
                    <div class="schedule-title">Ads Start Time</div>
                    <div class="schedule-time" id="estimatedStartTime">
                        <?php echo e($estimatedStartTime->format('M j, Y g:i A')); ?>

                    </div>
                    <div class="schedule-note">
                        * This is an estimate. Actual start time may vary based on approval queue.
                    </div>
                </div>

                <div class="cost-display">
                    <div class="cost-left">
                        <span>Rate: ৳<?php echo e(number_format($ratePerHour)); ?>/hr</span>
                        <p>Total Payable</p>
                    </div>
                    <div class="cost-right">
                        ৳<span id="totalAmount">0</span>
                    </div>
                </div>

                <button type="submit" class="btn-submit">
                    Continue to Payment <i class="fas fa-chevron-right"></i>
                </button>
            </form>
        </div>
    </div>
</div>

<script>
    // --- Javascript Logic for Dynamic Options ---
    const imageSection = document.getElementById('manualImageSection');
    const fileInput = document.getElementById('image');
    const defaultImageInput = document.getElementById('defaultImage');
    const estimatedStartTime = new Date('<?php echo e($estimatedStartTime); ?>');

    function handleTypeChange() {
        // Get the selected radio button value
        const type = document.querySelector('input[name="ad_type"]:checked').value;

        if (type === 'manual') {
            imageSection.style.display = 'block';
            fileInput.setAttribute('required', 'required');
            defaultImageInput.value = '';
        } else if (type === 'website') {
            imageSection.style.display = 'none';
            fileInput.removeAttribute('required');
            defaultImageInput.value = 'click.jpg';
        } else {
            // Telegram (Default)
            imageSection.style.display = 'none';
            fileInput.removeAttribute('required');
            defaultImageInput.value = 'join.jpg';
        }
    }

    // Run once on load
    handleTypeChange();

    // --- Calculation Logic (Cost & Impressions) ---
    const rate = <?php echo e($ratePerHour); ?>;
    // Env থেকে আসা ভ্যালুগুলো এখানে নেওয়া হচ্ছে (Default values fallback হিসেবে দেওয়া হলো)
    const baseMinViews = <?php echo e($minViews ?? 1100); ?>;
    const baseMaxViews = <?php echo e($maxViews ?? 2600); ?>;

    const hoursInput = document.getElementById('duration_hours');
    const totalSpan = document.getElementById('totalAmount');
    const reachSpan = document.getElementById('estimatedReach');

    // সংখ্যাকে "k" ফরমেটে নেওয়ার ফাংশন (যেমন: 4500 -> 4.5k)
    function formatK(num) {
        if (num >= 1000) {
            return (num / 1000).toFixed(1).replace('.0', '') + 'k';
        }
        return num;
    }

    function calculateTotal() {
        const hours = parseInt(hoursInput.value) || 0;
        
        // Cost Calculation
        const total = hours * rate;
        totalSpan.textContent = new Intl.NumberFormat('en-BD').format(total);

        // Reach (Impression) Calculation
        const minReach = hours * baseMinViews;
        const maxReach = hours * baseMaxViews;
        
        // Display Reach (e.g., 4.4k - 5k)
        reachSpan.textContent = `${formatK(minReach)} - ${formatK(maxReach)}`;
    }

    function updateCalculations() {
        const hours = parseInt(hoursInput.value) || 0;
        calculateTotal();
        
        // Update schedule info based on duration
        if (hours > 24) {
            document.querySelector('.schedule-note').textContent = 
                '* Long duration campaign. Your ad will run continuously for ' + hours + ' hours after approval.';
        } else {
            document.querySelector('.schedule-note').textContent = 
                '* This is an estimate. Actual start time may vary based on approval queue.';
        }
    }

    // Event Listeners
    hoursInput.addEventListener('input', updateCalculations);
    
    // Initial Run
    calculateTotal();
    updateCalculations();

    // --- Image Preview Logic ---
    fileInput.addEventListener('change', function(e) {
        const file = e.target.files[0];
        const previewContainer = document.getElementById('previewContainer');
        const previewImg = document.getElementById('imagePreview');
        const uploadBox = document.querySelector('.upload-box');

        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                previewImg.src = e.target.result;
                previewContainer.style.display = 'block';
                uploadBox.style.display = 'none'; // Hide upload box when preview shows
            }
            reader.readAsDataURL(file);
        }
    });

    function removeImage() {
        fileInput.value = '';
        document.getElementById('previewContainer').style.display = 'none';
        document.querySelector('.upload-box').style.display = 'block'; // Show upload box again
    }
</script>

<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/teleearn/public_html/resources/views/user/create_ad.blade.php ENDPATH**/ ?>