

<?php $__env->startSection('body'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0"><i class="fas fa-gift"></i> Manage Gift Codes</h4>
                </div>
                <div class="card-body">
                    <!-- Create Gift Code Form -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header bg-success text-white">
                                    <h5 class="mb-0">Create New Gift Code</h5>
                                </div>
                                <div class="card-body">
                                    <form method="POST" action="<?php echo e(route('admin.gift.codes.store')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label>Code *</label>
                                                    <input type="text" name="code" class="form-control" required 
                                                           placeholder="e.g., WELCOME100">
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label>Amount (৳) *</label>
                                                    <input type="number" name="amount" class="form-control" 
                                                           step="0.01" min="0.01" required>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label>Max Uses *</label>
                                                    <input type="number" name="max_uses" class="form-control" 
                                                           min="1" value="1" required>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label>Valid From *</label>
                                                    <input type="datetime-local" name="valid_from" class="form-control" required>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label>Valid Until *</label>
                                                    <input type="datetime-local" name="valid_until" class="form-control" required>
                                                </div>
                                            </div>
                                            <div class="col-md-1">
                                                <div class="form-group">
                                                    <label>&nbsp;</label>
                                                    <button type="submit" class="btn btn-success btn-block">
                                                        <i class="fas fa-plus"></i> Create
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Gift Codes List -->
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Code</th>
                                    <th>Amount</th>
                                    <th>Uses</th>
                                    <th>Valid From</th>
                                    <th>Valid Until</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $giftCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $giftCode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><code><?php echo e($giftCode->code); ?></code></td>
                                        <td class="text-success">৳<?php echo e(number_format($giftCode->amount, 2)); ?></td>
                                        <td><?php echo e($giftCode->used_count); ?> / <?php echo e($giftCode->max_uses); ?></td>
                                        <td><?php echo e($giftCode->valid_from->format('M d, Y h:i A')); ?></td>
                                        <td><?php echo e($giftCode->valid_until->format('M d, Y h:i A')); ?></td>
                                        <td>
                                            <?php if($giftCode->isValid()): ?>
                                                <span class="badge badge-success">Active</span>
                                            <?php else: ?>
                                                <span class="badge badge-danger">Inactive</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('admin.gift.codes.toggle', $giftCode->id)); ?>" 
                                               class="btn btn-sm btn-<?php echo e($giftCode->is_active ? 'warning' : 'success'); ?>">
                                                <?php echo e($giftCode->is_active ? 'Deactivate' : 'Activate'); ?>

                                            </a>
                                            <a href="<?php echo e(route('admin.gift.codes.delete', $giftCode->id)); ?>" 
                                               class="btn btn-sm btn-danger" 
                                               onclick="return confirm('Are you sure?')">
                                                Delete
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/teleearn/public_html/resources/views/admin/gift_codes.blade.php ENDPATH**/ ?>