<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8">

            <div class="card shadow-sm border-0 rounded-3 mb-4">
                <div class="card-body p-4 d-flex justify-content-between align-items-center">
                    <h4 class="text-primary mb-0 fw-bold">💰 All Withdrawals</h4>
                    </div>
            </div>

            <div class="card shadow-sm border-0 rounded-3">
                <div class="card-body p-0"> <div class="table-responsive rounded-3">
                        <table class="table table-hover text-center align-middle mb-0 withdraw-table">
                            
                            <thead class="table-light">
                                <tr>
                                    <th scope="col" class="py-3 px-2 text-uppercase fw-semibold text-muted">Date</th>
                                    <th scope="col" class="py-3 px-2 text-uppercase fw-semibold text-muted">Amount</th>
                                    <th scope="col" class="py-3 px-2 text-uppercase fw-semibold text-muted">Charge</th>
                                    <th scope="col" class="py-3 px-2 text-uppercase fw-semibold text-muted">Total</th>
                                    <th scope="col" class="py-3 px-2 text-uppercase fw-semibold text-muted">Operator</th>
                                    <th scope="col" class="py-3 px-2 text-uppercase fw-semibold text-muted">Status</th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td class="py-3"><?php echo e(\Carbon\Carbon::parse($item->created_at)->format('d M, Y')); ?></td>
                                        
                                        <td>৳<?php echo e(number_format($item->amount, 2)); ?></td>
                                        
                                        <td>৳<?php echo e(number_format($item->charges, 2)); ?></td>
                                        
                                        <td>৳<?php echo e(number_format($item->amount + $item->charges, 2)); ?></td>
                                        
                                        <td><?php echo e($item->method); ?></td>
                                        
                                        <td>
                                            <?php if($item->status == "Success"): ?>
                                                <span class="badge rounded-pill bg-success-subtle text-success-emphasis px-3 py-2">Success</span>
                                            <?php elseif($item->status == "Pending"): ?>
                                                <span class="badge rounded-pill bg-warning-subtle text-warning-emphasis px-3 py-2">Pending</span>
                                            <?php else: ?>
                                                <span class="badge rounded-pill bg-danger-subtle text-danger-emphasis px-3 py-2">Failed</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="6" class="text-muted py-5 text-center">
                                            <h6 class="mb-0">No withdrawal records found.</h6>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>

                        </table>
                    </div>
                </div>
            </div> </div> </div> </div> <?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/zonexpro/hgzy.zone-x.pro/resources/views/user/withdraw.blade.php ENDPATH**/ ?>