<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<br><br><br>
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6">
            <div class="card gift-card">
                <div class="card-header gift-header">
                    <div class="header-content">
                        <i class="fas fa-gift header-icon"></i>
                        <h4 class="mb-0 header-title">Redeem Gift Code</h4>
                    </div>
                </div>
                <div class="card-body gift-body">
                    <div class="text-center mb-4 intro-section">
                        <i class="fas fa-coins intro-icon"></i>
                        <p class="intro-text">Enter your exclusive gift code to unlock amazing rewards and boost your balance!</p>
                    </div>
                    <form id="redeemForm">
                        <?php echo csrf_field(); ?>
                        <div class="form-group code-input-group">
                            <label for="code" class="form-label code-label">
                                <i class="fas fa-key"></i> Gift Code
                            </label>
                            <div class="input-wrapper">
                                <input type="text" class="form-control code-input" id="code" name="code"
                                       placeholder="Enter your gift code here..." required>
                                <div class="input-icon">
                                    <i class="fas fa-lock"></i>
                                </div>
                            </div>
                            <div class="invalid-feedback" id="codeError"></div>
                        </div>
                      
                        <button type="submit" class="btn redeem-btn mt-4" id="redeemBtn">
                            <i class="fas fa-magic"></i> Redeem & Claim Reward
                            <div class="btn-loader" id="btnLoader" style="display: none;">
                                <div class="spinner-border spinner-border-sm" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                            </div>
                        </button>
                    </form>
                    <div class="mt-4 text-center history-link">
                        <a href="<?php echo e(route('gift.code.history')); ?>" class="history-btn">
                            <i class="fas fa-history"></i> View Your Redemption History
                        </a>
                    </div>
                    <!-- Telegram Link Section -->
                    <div class="mt-5 telegram-promo">
                        <div class="promo-card">
                            <div class="promo-icon">
                                <i class="fab fa-telegram-plane"></i>
                            </div>
                            <div class="promo-content">
                                <h5 class="promo-title">Unlock Daily Gift Codes! 💸</h5>
                                <p class="promo-text">Join our vibrant Telegram channel for fresh daily codes, exclusive tips, and community perks!</p>
                                <a href="https://t.me/SbDevTg?livestream" target="_blank" class="btn promo-btn">
                                    <i class="fab fa-telegram-plane"></i> Join Channel Now
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Success Sound Audio -->
<audio id="successSound" preload="auto">
    <source src="https://hgzy.zone-x.pro/public/sounds/6.mp3" type="audio/mpeg">
    <!-- Fallback sound; replace with actual path if needed -->
</audio>
<style>
/* Telegram Blue Theme Integration */
body {
    background: linear-gradient(135deg, #f0f2f5 0%, #e8f0fe 100%);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: #000;
    overflow-x: hidden;
}
.container-fluid {
    padding: 20px 15px;
    min-height: 100vh;
    display: flex;
    align-items: center;
}
.gift-card {
    border: none;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0, 136, 204, 0.2);
    overflow: hidden;
    background: #ffffff;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}
.gift-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 50px rgba(0, 136, 204, 0.3);
}
.gift-header {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    border: none;
    border-radius: 20px 20px 0 0;
    padding: 20px;
    color: white;
    text-align: center;
}
.header-content {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 12px;
}
.header-icon {
    font-size: 2rem;
    animation: bounce 2s infinite;
}
@keyframes bounce {
    0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
    40% { transform: translateY(-10px); }
    60% { transform: translateY(-5px); }
}
.header-title {
    margin: 0;
    font-weight: 700;
    font-size: 1.5rem;
    opacity: 0.95;
}
.gift-body {
    padding: 30px;
    text-align: center;
}
.intro-section {
    animation: fadeInUp 0.8s ease-out;
}
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}
.intro-icon {
    font-size: 3rem;
    color: #0088cc;
    margin-bottom: 15px;
    animation: pulse 2s infinite;
}
@keyframes pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.05); }
    100% { transform: scale(1); }
}
.intro-text {
    font-size: 1.1rem;
    color: #666;
    margin: 0;
    font-weight: 400;
}
.code-input-group {
    position: relative;
    margin-bottom: 20px;
    animation: fadeInUp 0.8s ease-out 0.2s both;
}
.code-label {
    display: flex;
    align-items: center;
    gap: 8px;
    font-weight: 600;
    color: #0088cc;
    margin-bottom: 8px;
    font-size: 1rem;
}
.input-wrapper {
    position: relative;
}
.code-input {
    padding: 15px 20px 15px 50px;
    border: 2px solid #e0e0e0;
    border-radius: 12px;
    font-size: 1.1rem;
    transition: all 0.3s ease;
    background: #f8f9fa;
}
.code-input:focus {
    border-color: #0088cc;
    box-shadow: 0 0 0 0.2rem rgba(0, 136, 204, 0.25);
    background: white;
    transform: scale(1.02);
}
.input-icon {
    position: absolute;
    left: 18px;
    top: 50%;
    transform: translateY(-50%);
    color: #0088cc;
    font-size: 1.2rem;
}
.redeem-btn {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    border: none;
    padding: 15px 30px;
    border-radius: 12px;
    font-weight: 600;
    font-size: 1.1rem;
    width: 100%;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(0, 136, 204, 0.3);
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
}
.redeem-btn:hover:not(:disabled) {
    background: linear-gradient(135deg, #006ba6 0%, #0088cc 100%);
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(0, 136, 204, 0.4);
    color: white;
}
.redeem-btn:disabled {
    opacity: 0.7;
    cursor: not-allowed;
    transform: none;
}
.btn-loader {
    margin-left: 10px;
}
.history-btn {
    color: #0088cc;
    text-decoration: none;
    font-weight: 500;
    transition: color 0.3s ease;
    display: inline-flex;
    align-items: center;
    gap: 8px;
}
.history-btn:hover {
    color: #006ba6;
    text-decoration: underline;
}
.telegram-promo {
    animation: fadeInUp 0.8s ease-out 0.4s both;
}
.promo-card {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    border-radius: 15px;
    padding: 25px;
    color: white;
    display: flex;
    align-items: center;
    gap: 20px;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
    transition: transform 0.3s ease;
}
.promo-card:hover {
    transform: translateY(-3px);
}
.promo-icon {
    font-size: 3rem;
    opacity: 0.9;
    animation: float 3s ease-in-out infinite;
}
@keyframes float {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-10px); }
}
.promo-content {
    flex: 1;
    text-align: left;
}
.promo-title {
    margin: 0 0 10px 0;
    font-weight: 700;
    font-size: 1.3rem;
}
.promo-text {
    margin: 0 0 15px 0;
    opacity: 0.9;
    font-size: 1rem;
}
.promo-btn {
    background: white;
    color: #0088cc;
    border: none;
    padding: 12px 25px;
    border-radius: 25px;
    font-weight: bold;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(255, 255, 255, 0.3);
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 8px;
}
.promo-btn:hover {
    background: #f8f9fa;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(255, 255, 255, 0.4);
    color: #0088cc;
    text-decoration: none;
}
/* Responsive */
@media (max-width: 768px) {
    .container-fluid { padding: 15px 10px; }
    .gift-body { padding: 20px; }
    .promo-card { flex-direction: column; text-align: center; gap: 15px; }
    .promo-content { text-align: center; }
    .header-content { gap: 8px; }
    .header-icon { font-size: 1.8rem; }
    .header-title { font-size: 1.3rem; }
}
</style>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.6.0/dist/confetti.browser.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const redeemForm = document.getElementById('redeemForm');
    const redeemBtn = document.getElementById('redeemBtn');
    const codeInput = document.getElementById('code');
    const btnLoader = document.getElementById('btnLoader');
    const successSound = document.getElementById('successSound');
    function playSuccessSound() {
        successSound.currentTime = 0;
        successSound.play().catch(e => console.log('Audio play failed:', e));
    }
    function launchConfetti() {
        const duration = 3 * 1000;
        const animationEnd = Date.now() + duration;
        const defaults = { startVelocity: 30, spread: 360, ticks: 60, zIndex: 9999 };
        function randomInRange(min, max) {
            return Math.random() * (max - min) + min;
        }
        const interval = setInterval(function() {
            const timeLeft = animationEnd - Date.now();
            if (timeLeft <= 0) {
                clearInterval(interval);
                return;
            }
            confetti({
                particleCount: 50,
                origin: { x: randomInRange(0.1, 0.9), y: Math.random() - 0.2 },
                colors: ['#0088cc', '#00a0e9', '#00ff88'],
                ...defaults
            });
        }, 200);
    }
    redeemForm.addEventListener('submit', function(e) {
        e.preventDefault();
      
        const originalText = redeemBtn.innerHTML.replace(btnLoader.outerHTML, '');
        const originalIcon = redeemBtn.querySelector('i') ? redeemBtn.querySelector('i').outerHTML : '';
      
        // Show loading state
        redeemBtn.innerHTML = originalIcon + ' Processing... ' + btnLoader.outerHTML;
        btnLoader.style.display = 'inline-block';
        redeemBtn.disabled = true;
        // Clear previous errors
        codeInput.classList.remove('is-invalid');
        document.getElementById('codeError').textContent = '';
        // Create form data
        const formData = new FormData();
        formData.append('_token', '<?php echo e(csrf_token()); ?>');
        formData.append('code', codeInput.value);
        fetch('<?php echo e(route("gift.code.redeem")); ?>', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                // Play success sound and confetti
                playSuccessSound();
                launchConfetti();
                Swal.fire({
                    icon: 'success',
                    title: '🎉 Claim Successful!',
                    html: `<div style="text-align: left;">${data.message}</div><br><strong>New Balance: ৳${data.new_balance}</strong>`,
                    confirmButtonText: 'Wonderful!',
                    confirmButtonColor: '#0088cc',
                    timer: 4000,
                    customClass: {
                        popup: 'swal-custom',
                        title: 'swal-title',
                        htmlContainer: 'swal-html'
                    }
                });
                codeInput.value = '';
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops!',
                    text: data.message,
                    confirmButtonText: 'Try Again',
                    confirmButtonColor: '#0088cc'
                });
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire({
                icon: 'error',
                title: 'Connection Issue',
                text: 'Something went wrong! Please check your connection and try again.',
                confirmButtonText: 'OK',
                confirmButtonColor: '#0088cc'
            });
        })
        .finally(() => {
            // Reset button state
            redeemBtn.innerHTML = originalText;
            btnLoader.style.display = 'none';
            redeemBtn.disabled = false;
        });
    });
    // Enter key support
    codeInput.addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
            redeemForm.dispatchEvent(new Event('submit'));
        }
    });
});
</script>
<style>
/* SweetAlert Custom Styles for Theme */
.swal-custom {
    border-radius: 15px;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}
.swal-title {
    color: #0088cc !important;
    font-weight: 700 !important;
}
.swal-html {
    color: #333 !important;
    font-size: 1.1rem !important;
}
</style>
<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/teleearn/checkk.tele-earn.com/resources/views/user/gift_code.blade.php ENDPATH**/ ?>