<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
.telegram-connect-container {
    max-width: 500px;
    margin: 30px auto;
    padding: 30px;
    background: linear-gradient(135deg, #0088cc, #00a2e8);
    border-radius: 20px;
    box-shadow: 0 15px 35px rgba(0, 136, 204, 0.3);
    color: white;
    text-align: center;
}
.telegram-header {
    margin-bottom: 30px;
}
.telegram-icon {
    font-size: 60px;
    margin-bottom: 15px;
}
.telegram-header h2 {
    font-size: 28px;
    margin-bottom: 10px;
    font-weight: 700;
}
.telegram-header p {
    opacity: 0.9;
    font-size: 16px;
}
.telegram-steps {
    background: rgba(255, 255, 255, 0.1);
    padding: 20px;
    border-radius: 15px;
    margin: 25px 0;
    text-align: left;
}
.step {
    display: flex;
    align-items: center;
    margin-bottom: 15px;
    padding: 12px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 10px;
}
.step-number {
    width: 30px;
    height: 30px;
    background: white;
    color: #0088cc;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    margin-right: 15px;
    flex-shrink: 0;
}
.step-content {
    flex: 1;
}
.step-content strong {
    display: block;
    margin-bottom: 5px;
}
.telegram-form {
    margin: 25px 0;
}
.form-group {
    margin-bottom: 20px;
    text-align: left;
}
.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
}
.form-control {
    width: 100%;
    padding: 12px 15px;
    border: none;
    border-radius: 10px;
    background: rgba(255, 255, 255, 0.9);
    font-size: 16px;
    box-sizing: border-box;
}
.form-control:focus {
    outline: none;
    background: white;
    box-shadow: 0 0 0 3px rgba(255, 255, 255, 0.3);
}
.btn-telegram {
    background: white;
    color: #0088cc;
    border: none;
    padding: 15px 30px;
    border-radius: 50px;
    font-size: 16px;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    width: 100%;
    margin: 10px 0;
}
.btn-telegram:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(255, 255, 255, 0.3);
}
.btn-verify {
    background: #28a745;
    color: white;
}
.btn-start-bot {
    background: #ffc107;
    color: #333;
}
.verification-status {
    margin: 20px 0;
    padding: 15px;
    border-radius: 10px;
    display: none;
}
.status-success {
    background: rgba(40, 167, 69, 0.2);
    border: 1px solid #28a745;
}
.status-error {
    background: rgba(220, 53, 69, 0.2);
    border: 1px solid #dc3545;
}
.telegram-note {
    background: rgba(255, 255, 255, 0.1);
    padding: 15px;
    border-radius: 10px;
    margin-top: 20px;
    font-size: 14px;
}
.loading-spinner {
    display: none;
    width: 20px;
    height: 20px;
    border: 2px solid #ffffff;
    border-top: 2px solid transparent;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin: 0 auto;
}
@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}
</style>
<!-- Success Sound Audio -->
<audio id="successSound" preload="auto">
    <source src="https://hgzy.zone-x.pro/public/sounds/1.mp3" type="audio/mpeg">
</audio>
<br><br>
<div class="telegram-connect-container">
    <div class="telegram-header">
        <div class="telegram-icon">
            <i class="fab fa-telegram-plane"></i>
        </div>
        <h2>Connect Telegram Account</h2>
        <p>Connect your Telegram account to unlock exclusive features</p>
    </div>
    <?php if(session('success')): ?>
        <div class="verification-status status-success" style="display: block;">
            ✅ <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="verification-status status-error" style="display: block;">
            ❌ <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>
    <div class="telegram-steps">
        <div class="step">
            <div class="step-number">1</div>
            <div class="step-content">
                <strong>Start Our Bot</strong>
                <span>Click the button below to start our Telegram bot</span>
            </div>
        </div>
        <div class="step">
            <div class="step-number">2</div>
            <div class="step-content">
                <strong>Get Your User ID</strong>
                <span>Send <code>/start</code> command to get your User ID</span>
            </div>
        </div>
        <div class="step">
            <div class="step-number">3</div>
            <div class="step-content">
                <strong>Enter & Verify</strong>
                <span>Enter your User ID below and verify</span>
            </div>
        </div>
    </div>
    <a href="https://t.me/ChatID_SB_Robot" target="_blank" class="btn-telegram btn-start-bot">
        <i class="fab fa-telegram-plane"></i> Start Telegram Bot
    </a>
    <form method="POST" action="<?php echo e(route('telegram.verify')); ?>" class="telegram-form">
        <?php echo csrf_field(); ?>
        <div class="form-group">
            <label for="telegram_user_id">Your Telegram User ID:</label>
            <input type="text"
                   id="telegram_user_id"
                   name="telegram_user_id"
                   class="form-control"
                   placeholder="Enter your Telegram User ID"
                   value="<?php echo e(Auth::user()->telegram_user_id ?? ''); ?>"
                   required>
            <?php if(Auth::user()->tg_id_status == 1): ?>
                <small style="color: #90ee90; margin-top: 5px; display: block;">
                    ✅ Your Telegram ID is verified
                </small>
            <?php endif; ?>
        </div>
       
        <button type="submit" class="btn-telegram">
            <i class="fas fa-paper-plane"></i> Submit Telegram ID
        </button>
    </form>
    <?php if(Auth::user()->telegram_user_id && Auth::user()->tg_id_status == 0): ?>
    <button type="button" onclick="verifyTelegram()" class="btn-telegram btn-verify" id="verify-btn">
        <i class="fas fa-check-circle"></i> Verify Now
        <div class="loading-spinner" id="verify-spinner"></div>
    </button>
    <?php endif; ?>
    <div class="verification-status" id="verification-result"></div>
    <div class="telegram-note">
        <strong>Note:</strong> Make sure you have started the bot and sent the <code>/start</code> command before verification.
    </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const successSound = document.getElementById('successSound');
    function playSuccessSound() {
        successSound.currentTime = 0;
        successSound.volume = 1.0;
        successSound.play().catch(e => console.log('Audio play failed:', e));
    }
    // Play sound if session success is present
    if (<?php echo e(session('success') ? 'true' : 'false'); ?>) {
        playSuccessSound();
    }
});
function verifyTelegram() {
    const verifyBtn = document.getElementById('verify-btn');
    const spinner = document.getElementById('verify-spinner');
    const resultDiv = document.getElementById('verification-result');
    const successSound = document.getElementById('successSound');
    function playSuccessSound() {
        successSound.currentTime = 0;
        successSound.volume = 1.0;
        successSound.play().catch(e => console.log('Audio play failed:', e));
    }
   
    verifyBtn.disabled = true;
    spinner.style.display = 'inline-block';
    resultDiv.style.display = 'none';
   
    fetch('<?php echo e(route("telegram.check")); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            playSuccessSound();
            resultDiv.className = 'verification-status status-success';
            resultDiv.innerHTML = '✅ ' + data.message;
            resultDiv.style.display = 'block';
           
            // Reload page after 2 seconds to show updated status
            setTimeout(() => {
                window.location.reload();
            }, 2000);
        } else {
            resultDiv.className = 'verification-status status-error';
            resultDiv.innerHTML = '❌ ' + data.message;
            resultDiv.style.display = 'block';
        }
    })
    .catch(error => {
        resultDiv.className = 'verification-status status-error';
        resultDiv.innerHTML = '❌ Verification failed. Please try again.';
        resultDiv.style.display = 'block';
    })
    .finally(() => {
        verifyBtn.disabled = false;
        spinner.style.display = 'none';
    });
}
</script>
<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/zonexpro/hgzy.zone-x.pro/resources/views/user/telegram_connect.blade.php ENDPATH**/ ?>