<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
/* Telegram-Inspired Clean Design - Simple & Elegant */
:root {
    --tg-blue: #0088cc;
    --tg-light-blue: #00a0e9;
    --tg-bg: #f0f2f5;
    --tg-card-bg: #ffffff;
    --tg-text-primary: #000000;
    --tg-text-secondary: #666666;
    --tg-success: #34c759;
    --border-radius: 12px;
    --shadow-light: 0 2px 10px rgba(0, 0, 0, 0.1);
}

body {
    background: var(--tg-bg);
    font-family: 'SF Pro Display', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    color: var(--tg-text-primary);
    line-height: 1.4;
    overflow-x: hidden;
}

.deposit-container {
    max-width: 500px;
    margin: 0 auto;
    padding: 20px;
    position: relative;
}

.deposit-header {
    text-align: center;
    margin-bottom: 30px;
    background: var(--tg-blue);
    color: white;
    padding: 30px 20px;
    border-radius: var(--border-radius);
    box-shadow: var(--shadow-light);
    position: relative;
    overflow: hidden;
}
.deposit-header::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    height: 1px;
    background: rgba(255, 255, 255, 0.2);
}
.deposit-header h1 {
    font-size: 1.8rem;
    font-weight: 600;
    margin: 0 0 5px 0;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}
.deposit-header h1 i {
    font-size: 1.5rem;
}
.deposit-header p {
    font-size: 0.95rem;
    margin: 0;
    opacity: 0.9;
    font-weight: 400;
}

.deposit-card {
    background: var(--tg-card-bg);
    border-radius: var(--border-radius);
    box-shadow: var(--shadow-light);
    padding: 30px 25px;
    margin-bottom: 20px;
    border: 1px solid rgba(0, 0, 0, 0.05);
}
.deposit-card h3 {
    text-align: center;
    color: var(--tg-blue);
    margin-bottom: 25px;
    font-size: 1.3rem;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}
.deposit-card h3 i {
    font-size: 1.3rem;
    color: var(--tg-blue);
}

.form-group {
    margin-bottom: 20px;
}
.form-group label {
    display: flex;
    align-items: center;
    gap: 6px;
    margin-bottom: 8px;
    font-weight: 500;
    color: var(--tg-text-secondary);
    font-size: 0.95rem;
}
.form-group i {
    color: var(--tg-blue);
    font-size: 1rem;
    width: 16px;
}
.form-control {
    width: 100%;
    padding: 12px 16px 12px 40px;
    border: 1px solid rgba(0, 0, 0, 0.15);
    border-radius: var(--border-radius);
    font-size: 1rem;
    transition: border-color 0.2s ease, box-shadow 0.2s ease;
    background: #fafafa;
    color: var(--tg-text-primary);
    font-weight: 400;
    position: relative;
}
.form-control:focus {
    border-color: var(--tg-blue);
    outline: none;
    box-shadow: 0 0 0 2px rgba(0, 136, 204, 0.1);
    background: #ffffff;
}
.input-icon {
    position: absolute;
    left: 14px;
    top: 50%;
    transform: translateY(-50%);
    color: var(--tg-blue);
    font-size: 1rem;
    z-index: 1;
    pointer-events: none;
}
.form-control.is-invalid {
    border-color: #ff3b30;
    box-shadow: 0 0 0 2px rgba(255, 59, 48, 0.1);
}
.invalid-feedback {
    color: #ff3b30;
    font-size: 0.85rem;
    margin-top: 5px;
    display: block;
}
small {
    color: var(--tg-text-secondary);
    font-size: 0.85rem;
    display: block;
    margin-top: 4px;
    font-weight: 400;
}

.btn-deposit {
    background: var(--tg-success);
    color: white;
    border: none;
    padding: 14px 20px;
    border-radius: var(--border-radius);
    font-size: 1rem;
    font-weight: 600;
    cursor: pointer;
    width: 100%;
    transition: background 0.2s ease, transform 0.1s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    text-transform: none;
    letter-spacing: 0;
    box-shadow: var(--shadow-light);
}
.btn-deposit:hover:not(:disabled) {
    background: #30d158;
    transform: translateY(-1px);
    box-shadow: 0 4px 15px rgba(52, 199, 89, 0.3);
}
.btn-deposit:active {
    transform: translateY(0);
}
.btn-deposit i {
    font-size: 1rem;
}
.btn-deposit:disabled {
    background: rgba(189, 195, 199, 0.5);
    cursor: not-allowed;
    transform: none;
    box-shadow: none;
}

.footer-credit {
    text-align: center;
    margin-top: 20px;
    padding: 15px;
    background: #f8f9fa;
    border-radius: var(--border-radius);
    font-size: 0.85rem;
    color: var(--tg-text-secondary);
    border: 1px solid rgba(0, 0, 0, 0.05);
}
.footer-credit a {
    color: var(--tg-blue);
    font-weight: 600;
    text-decoration: none;
    transition: color 0.2s ease;
}
.footer-credit a:hover {
    color: var(--tg-light-blue);
    text-decoration: underline;
}

/* Responsive */
@media (max-width: 768px) {
    .deposit-container { padding: 15px; }
    .deposit-header { padding: 25px 15px; }
    .deposit-header h1 { font-size: 1.6rem; }
    .deposit-card { padding: 25px 20px; }
    .form-control { padding: 11px 14px 11px 38px; font-size: 0.95rem; }
    .btn-deposit { padding: 12px 18px; font-size: 0.95rem; }
}
@media (max-width: 480px) {
    .deposit-header h1 { font-size: 1.4rem; }
    .deposit-card { padding: 20px 15px; }
    .deposit-card h3 { font-size: 1.2rem; }
}
</style>
<br><br><br><br>
<div class="deposit-container">
    <div class="deposit-header">
        <h1><i class="fab fa-telegram-plane"></i> Add Funds</h1>
        <p>Securely deposit to your balance</p>
    </div>
    
    <div class="deposit-card">
        <h3><i class="fas fa-credit-card"></i> Enter Amount</h3>
        <form action="<?php echo e(route('deposit')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label for="amount">
                    <i class="fas fa-coins"></i> Amount (৳)
                </label>
                <i class="fas fa-bangla input-icon"></i>
                <input type="number" name="amount" id="amount" class="form-control <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                       placeholder="Enter amount (Min: ৳10)" min="10" step="1" required value="<?php echo e(old('amount')); ?>">
                <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <small>Minimum deposit: ৳10.00 – Instant reflection</small>
            </div>
            <div class="d-grid">
                <button type="submit" class="btn-deposit">
                    <i class="fas fa-arrow-right"></i> Proceed to Payment
                </button>
            </div>
        </form>
        <div class="footer-credit">
            Powered by <a href="https://t.me/sb_lab"><strong>SB LAB</strong></a> | Secure & Instant
        </div>
    </div>
</div>
<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/teleearn/public_html/resources/views/user/deposit.blade.php ENDPATH**/ ?>