<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<style>
    :root {
        --tg-blue: #229ED9;
        --tg-bg: #ffffff;
        --tg-gray: #f5f7fa;
        --tg-text: #1c1c1c;
        --tg-muted: #707579;
        --tg-success: #4caf50;
        --tg-border: #e2e8f0;
    }

    body { 
        background: #f0f2f5; 
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    }

    .payment-wrapper {
        min-height: 100vh;
        display: flex;
        align-items: center;
        padding: 20px 0;
    }

    .payment-card {
        background: var(--tg-bg);
        border-radius: 24px;
        overflow: hidden;
        box-shadow: 0 15px 45px rgba(0,0,0,0.12);
        max-width: 480px;
        margin: 0 auto;
        width: 100%;
        animation: slideUp 0.6s ease-out;
    }

    @keyframes slideUp {
        from { opacity: 0; transform: translateY(30px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .payment-header {
        background: linear-gradient(135deg, #40c4ff, #1e88e5);
        color: white;
        padding: 32px 24px;
        text-align: center;
        position: relative;
        overflow: hidden;
    }

    .payment-header::before {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: rgba(255,255,255,0.1);
        transform: rotate(30deg);
        animation: shine 6s infinite;
    }

    @keyframes shine {
        0% { transform: translateX(-100%) translateY(-100%) rotate(30deg); }
        100% { transform: translateX(100%) translateY(100%) rotate(30deg); }
    }

    .payment-header h3 {
        margin: 0;
        font-size: 26px;
        font-weight: 700;
        position: relative;
        z-index: 2;
    }

    .payment-header p {
        margin: 10px 0 0;
        opacity: 0.95;
        font-size: 15px;
        position: relative;
        z-index: 2;
    }

    .payment-body {
        padding: 32px;
    }

    .summary-card {
        background: linear-gradient(135deg, #f8fff8, #e8f5e8);
        border: 2px solid #c8e6c9;
        border-radius: 18px;
        padding: 24px;
        margin-bottom: 28px;
        text-align: center;
        box-shadow: 0 6px 20px rgba(76, 175, 80, 0.1);
    }

    .summary-title {
        color: #2e7d32;
        font-size: 19px;
        font-weight: 600;
        margin-bottom: 18px;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
    }

    .summary-item {
        display: flex;
        justify-content: space-between;
        padding: 12px 0;
        font-size: 16px;
        border-bottom: 1px dashed #c8e6c9;
    }

    .summary-item:last-child { border: none; }

    .summary-item strong {
        color: var(--tg-text);
        font-weight: 600;
    }

    .total-amount-big {
        margin: 24px 0 0;
        padding: 20px;
        background: #4caf50;
        color: white;
        border-radius: 16px;
        font-size: 30px;
        font-weight: 800;
        text-shadow: 0 2px 10px rgba(0,0,0,0.2);
    }

    .btn-pay {
        width: 100%;
        background: linear-gradient(135deg, #43a047, #66bb6a);
        color: white;
        border: none;
        padding: 18px;
        border-radius: 16px;
        font-size: 19px;
        font-weight: 700;
        margin: 20px 0;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 12px;
        box-shadow: 0 8px 25px rgba(76, 175, 80, 0.35);
        transition: all 0.3s;
        position: relative;
        overflow: hidden;
    }

    .btn-pay:hover {
        transform: translateY(-4px);
        box-shadow: 0 15px 35px rgba(76, 175, 80, 0.45);
    }

    .btn-pay:active {
        transform: translateY(-1px);
    }

    .btn-cancel {
        width: 100%;
        background: #e0e0e0;
        color: #616161;
        padding: 14px;
        border-radius: 14px;
        text-align: center;
        font-weight: 600;
        transition: all 0.2s;
    }

    .btn-cancel:hover {
        background: #d5d5d5;
        color: #424242;
    }

    .secure-note {
        text-align: center;
        margin-top: 24px;
        font-size: 14px;
        color: var(--tg-muted);
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
    }

    .secure-note i {
        color: #4caf50;
        font-size: 18px;
    }
</style>

<div class="payment-wrapper">
    <div class="payment-card">

        <!-- Premium Header -->
        <div class="payment-header">
            <h3>Complete Your Payment</h3>
            <p>Your ad will be live in seconds after payment</p>
        </div>

        <div class="payment-body">

            <?php if(isset($pendingAd) && $pendingAd): ?>
                <!-- Summary Card -->
                <div class="summary-card">
                    <div class="summary-title">
                        Ad Details
                    </div>

                    <div class="summary-item">
                        <span>Duration</span>
                        <strong><?php echo e($pendingAd['duration_hours']); ?> hours</strong>
                    </div>

                    <div class="summary-item">
                        <span>Link</span>
                        <strong>
                            <a href="<?php echo e($pendingAd['link']); ?>" target="_blank" style="color:#1e88e5; text-decoration:underline;">
                                <?php echo e(Str::limit($pendingAd['link'], 35)); ?>

                            </a>
                        </strong>
                    </div>

                    <div class="total-amount-big">
                        ৳<?php echo e(number_format($pendingAd['amount'])); ?>

                    </div>
                </div>

                <!-- Payment Form -->
                <form action="<?php echo e(route('ads.process.payment')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="amount" value="<?php echo e($pendingAd['amount']); ?>">

                    <button type="submit" class="btn-pay">
                        Pay ৳<?php echo e(number_format($pendingAd['amount'])); ?> Now
                    </button>
                </form>

                <a href="<?php echo e(route('ads.create')); ?>" class="btn-cancel">
                    Cancel & Go Back
                </a>

                <div class="secure-note">
                    <i class="fas fa-shield-alt"></i>
                    100% Secure • SSL Encrypted Payment
                </div>

            <?php else: ?>
                <!-- Safety fallback if $pendingAd missing -->
                <div class="text-center py-5">
                    <i class="fas fa-exclamation-triangle fa-3x text-warning mb-3"></i>
                    <h4>Payment Session Expired</h4>
                    <p>Please create a new ad to continue.</p>
                    <a href="<?php echo e(route('ads.create')); ?>" class="btn btn-primary mt-3" style="border-radius:14px; padding:12px 30px;">
                        Create New Ad
                    </a>
                </div>
            <?php endif; ?>

        </div>
    </div>
</div>

<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/teleearn/checkk.tele-earn.com/resources/views/user/ads_payment.blade.php ENDPATH**/ ?>