<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<style>
    /* --- Telegram Light Theme Variables --- */
    :root {
        --tg-bg: #f1f2f6;
        --tg-card-bg: #ffffff;
        --tg-blue: #3390ec;
        --tg-text: #222222;
        --tg-gray: #707579;
        --tg-border: #dfe1e5;
    }

    body {
        background-color: var(--tg-bg);
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
    }

    /* --- Premium Ad Card Styles (Same as before) --- */
    .premium-ad-card {
        background: var(--tg-card-bg);
        border-radius: 14px;
        padding: 12px;
        margin: 25px auto;
        position: relative;
        overflow: hidden;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
        border: 1px solid transparent;
        display: flex;
        align-items: center;
        gap: 15px;
        text-decoration: none !important;
        transition: all 0.2s ease;
    }
    .premium-ad-card:active { transform: scale(0.98); }
    .premium-ad-card:hover { border-color: rgba(51, 144, 236, 0.3); box-shadow: 0 4px 12px rgba(51, 144, 236, 0.1); }
    
    .premium-ad-card::before {
        content: ''; position: absolute; top: 0; left: -100%; width: 50%; height: 100%;
        background: linear-gradient(to right, transparent, rgba(255, 255, 255, 0.8), transparent);
        transform: skewX(-25deg); animation: shine 3s infinite; pointer-events: none;
    }
    @keyframes shine { 100% { left: 200%; } }

    .ad-badge {
        position: absolute; top: 0; right: 0;
        background: linear-gradient(135deg, #3390ec 0%, #0077b5 100%);
        color: white; font-size: 10px; font-weight: 700; padding: 3px 10px;
        border-bottom-left-radius: 10px; z-index: 2;
    }

    .ad-image-wrapper {
        width: 70px; height: 70px; border-radius: 12px; overflow: hidden; flex-shrink: 0;
        background: #f0f0f0; border: 1px solid #eee;
    }
    .ad-image { width: 100%; height: 100%; object-fit: cover; }
    .ad-content { flex: 1; display: flex; flex-direction: column; justify-content: center; }
    .ad-title { font-size: 15px; font-weight: 600; color: var(--tg-text); margin-bottom: 3px; }
    .ad-cta { font-size: 13px; color: var(--tg-blue); font-weight: 500; display: flex; align-items: center; gap: 5px; }
    .ad-arrow-icon { width: 20px; height: 20px; background: #eef6fc; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 10px; color: var(--tg-blue); }

    /* --- Payment History Section Styling --- */
    .payment-section {
        background: var(--tg-card-bg);
        border-radius: 14px;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
        overflow: hidden;
        margin-bottom: 30px;
    }

    .payment-header {
        padding: 18px 20px;
        border-bottom: 1px solid var(--tg-border);
        display: flex;
        align-items: center;
        gap: 10px;
        background: #ffffff;
    }
    
    .payment-title {
        font-size: 17px;
        font-weight: 600;
        color: var(--tg-text);
        margin: 0;
    }

    /* Table Styling */
    .table-tg { width: 100%; margin-bottom: 0; }
    
    .table-tg thead th {
        background: #f7f9fa;
        color: var(--tg-gray);
        font-size: 12px;
        font-weight: 600;
        text-transform: uppercase;
        border: none;
        border-bottom: 1px solid var(--tg-border);
        padding: 12px 15px;
        white-space: nowrap;
    }

    .table-tg tbody td {
        padding: 15px;
        vertical-align: middle;
        border-bottom: 1px solid #f0f0f0;
        font-size: 14px;
        color: var(--tg-text);
    }
    .table-tg tbody tr:last-child td { border-bottom: none; }
    .table-tg tbody tr:hover { background-color: #f4f6f8; }

    /* Custom Column Styles */
    .date-text { color: var(--tg-gray); font-size: 12px; }
    .method-text { font-weight: 600; color: var(--tg-text); }
    .trx-text { 
        font-family: monospace; 
        background: #f1f2f6; 
        padding: 2px 6px; 
        border-radius: 4px; 
        color: var(--tg-text); 
        font-size: 12px;
    }
    .amount-text { font-weight: 700; color: var(--tg-blue); }

    /* Status Badges (Telegram Soft Style) */
    .status-badge {
        padding: 5px 12px;
        border-radius: 30px;
        font-size: 11px;
        font-weight: 600;
        text-transform: capitalize;
        display: inline-block;
    }
    .status-success { background: #e6fcf5; color: #0ca678; }
    .status-pending { background: #fff9db; color: #f59f00; }
    .status-failed  { background: #fff5f5; color: #fa5252; }

</style>

<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-lg-8 col-md-10 col-12">
            
            <br><br><br>

            <?php
                $activeAd = \App\Models\Ad::active()->first();
                if($activeAd){ $activeAd->increment('views'); }
            ?>

            <?php if($activeAd): ?>
                <a href="<?php echo e(route('ad.track.click', $activeAd->id)); ?>" target="_blank" class="premium-ad-card">
                    <span class="ad-badge">Sponsored</span>
                    <div class="ad-image-wrapper">
                        <img src="<?php echo e(asset('ads_images/' . $activeAd->image)); ?>" alt="Ad" class="ad-image">
                    </div>
                    <div class="ad-content">
                        <div class="ad-title">Exclusive Offer For You</div>
                        <div class="ad-cta">
                            Click to View <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
                        </div>
                    </div>
                </a>
            <?php else: ?>
                <a href="/ads/create" target="_blank" class="premium-ad-card">
                    <span class="ad-badge">Promote</span>
                    <div class="ad-image-wrapper">
                        <img src="<?php echo e(asset('ads_images/ads.jpg')); ?>" alt="Ad" class="ad-image">
                    </div>
                    <div class="ad-content">
                        <div class="ad-title">Grow Your Team</div>
                        <div class="ad-cta">
                            Run Ad <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
                        </div>
                    </div>
                </a>
            <?php endif; ?>


            <div class="payment-section">
                <div class="payment-header">
                    <i class="fas fa-history" style="color: var(--tg-blue); font-size: 18px;"></i>
                    <h4 class="payment-title">Payment History</h4>
                </div>

                <div class="table-responsive">
                    <table class="table table-tg">
                        <thead>
                            <tr>
                                <th>Date & Method</th>
                                <th>Transaction ID</th>
                                <th>Amount</th>
                                <th class="text-right">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div class="method-text"><?php echo e($item->method); ?></div>
                                    <div class="date-text"><?php echo e(\Carbon\Carbon::parse($item->created_at)->format('d M, Y')); ?></div>
                                    <div style="font-size: 11px; color: #999;"><?php echo e($item->number); ?></div>
                                </td>
                                
                                <td>
                                    <span class="trx-text"><?php echo e($item->trxid); ?></span>
                                </td>

                                <td>
                                    <span class="amount-text">৳<?php echo e($item->amount); ?></span>
                                </td>

                                <td class="text-right">
                                    <?php if($item->status == "Success"): ?>
                                        <span class="status-badge status-success">Success</span>
                                    <?php elseif($item->status == "Pending"): ?>
                                        <span class="status-badge status-pending">Pending</span>
                                    <?php else: ?>
                                        <span class="status-badge status-failed">Failed</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="4" class="text-center p-5">
                                    <i class="fas fa-wallet fa-3x" style="color: #dfe1e5;"></i>
                                    <p style="color: var(--tg-gray); margin-top: 10px;">No transaction history found.</p>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            </div>
    </div>
</div>

<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/teleearn/public_html/resources/views/user/payment.blade.php ENDPATH**/ ?>