<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<br><br><br>
<div class="col-lg-8">
    <div class="mb-3">

        <div class="gem-withdraw-container">
            <div class="gem-withdraw-header">
                <div class="gem-withdraw-header-content">
                    <h5 class="gem-withdraw-balance-text">Current Balance: ৳<?php echo e(auth()->user()->balance); ?></h5>
                    <a href="<?php echo e(route('withdraw')); ?>" class="gem-withdraw-back-btn">Previous</a>
                </div>
            </div>

            <div class="gem-withdraw-card">
                <div class="gem-withdraw-card-body">
                    <form action="<?php echo e(route('withdrawCreate_submit')); ?>" method="post" enctype="multipart/form-data" class="gem-withdraw-form">
                        <?php echo csrf_field(); ?>

                        <label class="gem-withdraw-label">Choose a withdrawal method *</label>

                        <div class="gem-method-select-wrapper">
                            <button type="button" id="gemMethodToggleBtn" class="gem-method-toggle-btn">
                                <span id="gemSelectedMethodText">Select Withdraw Method</span>
                                <i class="fas fa-chevron-down gem-method-chevron"></i>
                            </button>
                            <div id="gemMethodOptions" class="gem-method-options d-none">
                                <label class="gem-method-option">
                                    <input type="radio" name="withdraw_method" value="bkash" class="gem-method-radio d-none">
                                    <span class="gem-method-label">Bkash </span>
                                </label>
                                <label class="gem-method-option">
                                    <input type="radio" name="withdraw_method" value="nagad" class="gem-method-radio d-none">
                                    <span class="gem-method-label">Nagad </span>
                                </label>
                            </div>
                        </div>

                        <label for="gem_withdraw_to_number" class="gem-withdraw-label mt-4">
                            Wallet Number *
                        </label>
                        <input type="text" id="gem_withdraw_to_number" name="withdraw_to_number" class="gem-withdraw-input" placeholder="Ex: 01xxxxxxxxx" required>

                        <label for="gem_req_amount" class="gem-withdraw-label mt-4">
                            Amount *
                        </label>
                        <input type="number" id="gem_req_amount" name="req_amount" class="gem-withdraw-input" min="1" placeholder="Ex: 55" required>
</div><br>
                        <div class="gem-withdraw-info-box gem-withdraw-info-notice">
                            <p><strong>1. Fees: </strong>5% charge will be deducted for every withdrawal</p>
                        </div>
  <div class="gem-withdraw-info-box gem-withdraw-info-notice">
                            <p><strong>2. Limit: </strong>Minimum Withdraw Limit ৳55</p>
                        </div>
                        <div class="gem-btn-submit-wrapper">
                            <button type="submit" class="gem-btn-submit">
                                Process Withdrawal
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>

<style>
/* Base styles */
body {
    font-family: 'Inter', sans-serif; /* Modern, clean font */
    background-color: #f0f2f5; /* Lighter background for a fresh feel */
    color: #34495e; /* Darker text for readability */
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
}

/* --- Gem Withdraw Container --- */
.gem-withdraw-container {
    max-width: 680px; /* Slightly narrower */
    margin: 0 auto;
    padding: 12px; /* Reduced padding */
}

/* Header */
.gem-withdraw-header {
    padding: 0.8rem 1.2rem; /* Smaller padding */
    margin-bottom: 0.8rem; /* Reduced margin */
    background: linear-gradient(90deg, #3498db, #2980b9); /* Blue gradient */
    border-radius: 10px; /* Slightly smaller radius */
    color: #fff;
    box-shadow: 0 3px 10px rgba(52, 152, 219, 0.2); /* Softer shadow */
}

.gem-withdraw-header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.gem-withdraw-balance-text {
    font-weight: 500; /* Slightly lighter font weight */
    font-size: 1rem; /* Smaller font size */
    color: white;
}

.gem-withdraw-back-btn {
    background-color: rgba(255, 255, 255, 0.2); /* Semi-transparent white */
    color: #fff;
    font-weight: 500; /* Slightly lighter */
    padding: 5px 15px; /* Smaller padding */
    border-radius: 20px; /* More rounded */
    border: 1px solid rgba(255, 255, 255, 0.4); /* Subtle border */
    text-decoration: none;
    font-size: 0.85rem; /* Smaller font size */
    transition: all 0.2s ease;
}

.gem-withdraw-back-btn:hover {
    background-color: rgba(255, 255, 255, 0.3);
    border-color: rgba(255, 255, 255, 0.6);
    transform: translateY(-1px);
    box-shadow: 0 1px 6px rgba(255, 255, 255, 0.2);
}

/* Card */
.gem-withdraw-card {
    background: #ffffff;
    padding: 1.5rem 2rem; /* Reduced padding */
    border-radius: 10px; /* Slightly smaller radius */
    border: 1px solid #e0e0e0; /* Lighter border */
    box-shadow: 0 5px 18px rgba(0, 0, 0, 0.06); /* Lighter, softer shadow */
}

/* Form Elements */
.gem-withdraw-label {
    font-weight: 500; /* Lighter font weight */
    color: #34495e; /* Consistent dark text */
    margin-bottom: 0.5rem; /* Reduced margin */
    font-size: 0.9rem; /* Smaller font size */
    display: block;
}

.gem-withdraw-input {
    width: 100%;
    padding: 10px 15px; /* Smaller padding */
    font-size: 0.9rem; /* Smaller font size */
    border-radius: 6px; /* Smaller radius */
    border: 1px solid #ccc; /* Neutral border */
    outline: none;
    box-shadow: inset 0 1px 2px rgba(0,0,0,0.04);
    transition: border-color 0.2s ease, box-shadow 0.2s ease;
}

.gem-withdraw-input:focus {
    border-color: #3498db; /* Blue on focus */
    box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2); /* Lighter focus ring */
}

/* Method Selector */
.gem-method-select-wrapper {
    max-width: 350px; /* Slightly narrower */
    margin: 0 auto 0.8rem auto; /* Reduced margin */
    position: relative;
    z-index: 10;
}

.gem-method-toggle-btn {
    width: 100%;
    background-color: #ecf0f1; /* Light gray */
    border: 1px solid #bdc3c7; /* Medium gray */
    color: #2c3e50; /* Dark text */
    font-weight: 600;
    font-size: 0.9rem; /* Smaller font size */
    padding: 10px 18px; /* Smaller padding */
    border-radius: 8px; /* Smaller radius */
    cursor: pointer;
    display: flex;
    justify-content: center;
    align-items: center;
    transition: all 0.2s ease;
    box-shadow: 0 1px 4px rgba(0,0,0,0.08);
}

.gem-method-toggle-btn:hover {
    background-color: #dbe2e6; /* Darker light gray */
}

.gem-method-toggle-btn.active {
    border-color: #3498db;
    box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
}

.gem-method-chevron {
    margin-left: 10px; /* Smaller margin */
    transition: transform 0.2s ease;
    font-size: 0.8em; /* Smaller icon */
}

.gem-method-toggle-btn.active .gem-method-chevron {
    transform: rotate(180deg);
}

.gem-method-options {
    position: absolute;
    top: calc(100% + 6px); /* Closer to the button */
    left: 0;
    right: 0;
    display: flex;
    flex-direction: column;
    gap: 6px; /* Smaller gap */
    padding: 10px 12px; /* Reduced padding */
    background: #ffffff;
    border-radius: 8px;
    border: 1px solid #dcdcdc; /* Lighter border */
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    z-index: 100;
}

.d-none {
    display: none !important;
}

.gem-method-option {
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 8px; /* Smaller gap */
    color: #555; /* Medium dark text */
    font-weight: 500;
    font-size: 0.85rem; /* Smaller font size */
    padding: 8px 12px; /* Smaller padding */
    border-radius: 6px; /* Smaller radius */
    border: 1px solid transparent;
    transition: all 0.2s ease;
}

.gem-method-option:hover {
    background-color: #f5f5f5; /* Very light gray */
    border-color: #eee; /* Subtle border on hover */
}

.gem-method-option input[type="radio"]:checked + .gem-method-label {
    color: #27ae60; /* Green for selected */
    font-weight: 600;
}

/* Info Boxes */
.gem-withdraw-info-box {
    padding: 0.8rem 1rem; /* Smaller padding */
    border-radius: 8px; /* Smaller radius */
    margin-bottom: 0.8rem; /* Reduced margin */
    border: 1px solid;
    font-size: 0.85rem; /* Smaller font size */
}

.gem-withdraw-info-warning {
    background-color: #fff9e6; /* Light yellow */
    color: #c07a00; /* Darker yellow/orange */
    border-color: #f8e1a1;
}

.gem-withdraw-info-notice {
    background-color: #e6f9f0; /* Light green for notice (positive tone) */
    color: #27ae60; /* Darker green */
    border-color: #b3ead9;
}

/* Submit Button */
.gem-btn-submit-wrapper {
    text-align: center;
    margin-top: 1.5rem; /* Reduced margin */
}

.gem-btn-submit {
    background: linear-gradient(90deg, #2ecc71, #27ae60); /* Green gradient */
    border: none;
    color: #fff;
    font-weight: 600;
    font-size: 1rem; /* Slightly smaller font size */
    padding: 12px 25px; /* Smaller padding */
    border-radius: 25px; /* More rounded */
    cursor: pointer;
    width: 100%;
    max-width: 350px; /* Smaller max width */
    box-shadow: 0 4px 10px rgba(46, 204, 113, 0.3); /* Softer shadow */
    transition: all 0.2s ease;
}

.gem-btn-submit:hover {
    background: linear-gradient(90deg, #27ae60, #229a5a);
    transform: translateY(-1px);
    box-shadow: 0 6px 12px rgba(46, 204, 113, 0.4);
}

/* Responsive */
@media(max-width: 576px) {
    .gem-withdraw-card {
        padding: 1.2rem 1.5rem; /* Further reduced padding */
    }
    .gem-method-options {
        padding: 8px;
    }
    .gem-method-option {
        padding: 6px 10px;
        font-size: 0.8rem;
    }
    .gem-withdraw-input {
        padding: 8px 12px;
        font-size: 0.85rem;
    }
    .gem-withdraw-info-box {
        padding: 0.7rem 0.9rem;
        font-size: 0.8rem;
    }
    .gem-btn-submit {
        padding: 10px 20px;
        font-size: 0.9rem;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const toggleBtn = document.getElementById('gemMethodToggleBtn');
    const optionsDiv = document.getElementById('gemMethodOptions');
    const selectedSpan = document.getElementById('gemSelectedMethodText');
    const radios = optionsDiv.querySelectorAll('input[type="radio"]');

    toggleBtn.addEventListener('click', function () {
        optionsDiv.classList.toggle('d-none');
        toggleBtn.classList.toggle('active');
    });

    radios.forEach(radio => {
        radio.addEventListener('change', function () {
            const label = this.parentElement;
            selectedSpan.textContent = label.querySelector('.gem-method-label').textContent;
            optionsDiv.classList.add('d-none');
            toggleBtn.classList.remove('active');
        });
    });

    document.addEventListener('click', function(e) {
        if (!toggleBtn.contains(e.target) && !optionsDiv.contains(e.target)) {
            optionsDiv.classList.add('d-none');
            toggleBtn.classList.remove('active');
        }
    });
});
</script>

<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/studentjobbd/kkkkkk.hatiya-panel.site/resources/views/user/withdraw_create.blade.php ENDPATH**/ ?>