<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Password Reset Code</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: #0088cc; color: white; padding: 20px; text-align: center; }
        .content { background: #f9f9f9; padding: 20px; border-radius: 5px; }
        .code { font-size: 32px; font-weight: bold; text-align: center; color: #0088cc; margin: 20px 0; }
        .footer { text-align: center; margin-top: 20px; font-size: 12px; color: #666; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Password Reset Code</h2>
        </div>
        <div class="content">
            <p>Hello,</p>
            <p>You requested to reset your password. Use the verification code below:</p>
            
            <div class="code"><?php echo e($code); ?></div>
            
            <p>This code will expire in 10 minutes.</p>
            <p>If you didn't request this, please ignore this email.</p>
        </div>
        <div class="footer">
            <p>&copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All rights reserved.</p>
        </div>
    </div>
</body>
</html><?php /**PATH /home/teleearn/public_html/resources/views/emails/password-reset.blade.php ENDPATH**/ ?>