<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
    /* Custom Styles for Link Selling System - ST-InvestPro Theme Integration */
    :root {
        --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        --success-gradient: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        --info-gradient: linear-gradient(135deg, #36d1dc 0%, #5b86e5 100%);
        --danger-gradient: linear-gradient(135deg, #ff6b6b 0%, #ee5a24 100%);
        --card-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        --border-radius: 15px;
        --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    body {
        background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
    }

    .link-selling-container {
        padding: 40px 20px;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .link-selling-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        border-radius: var(--border-radius);
        box-shadow: var(--card-shadow);
        padding: 40px;
        width: 100%;
        max-width: 800px;
        position: relative;
        overflow: hidden;
        animation: slideUp 0.8s ease-out;
    }

    .link-selling-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: var(--primary-gradient);
    }

    @keyframes slideUp {
        from { opacity: 0; transform: translateY(30px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .card-header {
        text-align: center;
        margin-bottom: 40px;
    }

    .card-title {
        font-size: 2.5rem;
        font-weight: 700;
        background: var(--primary-gradient);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        margin-bottom: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 12px;
    }

    .card-title i {
        font-size: 2.8rem;
        background: var(--primary-gradient);
        padding: 10px;
        border-radius: 50%;
        box-shadow: var(--card-shadow);
    }

    /* Stats Row */
    .stats-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 20px;
        margin-bottom: 40px;
    }

    .stat-card {
        background: rgba(255, 255, 255, 0.8);
        border-radius: var(--border-radius);
        padding: 25px;
        text-align: center;
        transition: var(--transition);
        border: 1px solid rgba(102, 126, 234, 0.1);
        position: relative;
        overflow: hidden;
    }

    .stat-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 3px;
        background: var(--primary-gradient);
        transform: scaleX(0);
        transition: var(--transition);
    }

    .stat-card:hover::before {
        transform: scaleX(1);
    }

    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
    }

    .stat-icon {
        font-size: 2.5rem;
        margin-bottom: 15px;
        display: block;
    }

    .stat-number {
        font-size: 2rem;
        font-weight: 700;
        color: #2c3e50;
        margin-bottom: 5px;
    }

    .stat-label {
        font-size: 0.95rem;
        color: #7f8c8d;
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    /* Primary Stat */
    .stat-primary .stat-icon { color: #667eea; }
    .stat-info .stat-icon { color: #5b86e5; }
    .stat-success .stat-icon { color: #38ef7d; }

    /* Generate Button */
    .generate-section {
        text-align: center;
        margin-bottom: 40px;
    }

    #generateBtn {
        background: var(--success-gradient);
        border: none;
        padding: 18px 40px;
        border-radius: 50px;
        font-size: 1.1rem;
        font-weight: 600;
        color: white;
        cursor: pointer;
        transition: var(--transition);
        box-shadow: 0 10px 30px rgba(17, 153, 142, 0.3);
        display: inline-flex;
        align-items: center;
        gap: 10px;
        position: relative;
        overflow: hidden;
    }

    #generateBtn:hover:not(:disabled) {
        transform: translateY(-3px);
        box-shadow: 0 15px 40px rgba(17, 153, 142, 0.4);
    }

    #generateBtn:disabled {
        background: #bdc3c7;
        cursor: not-allowed;
        transform: none;
        box-shadow: none;
    }

    .limit-warning {
        margin-top: 15px;
        padding: 12px 20px;
        background: var(--danger-gradient);
        color: white;
        border-radius: 10px;
        font-weight: 600;
        animation: pulse 2s infinite;
    }

    @keyframes pulse {
        0%, 100% { opacity: 1; }
        50% { opacity: 0.8; }
    }

    /* Loading Section */
    #resultSection {
        text-align: center;
        padding: 30px;
        background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);
        border-radius: var(--border-radius);
        margin-bottom: 20px;
        display: none;
        animation: fadeIn 0.5s ease-in;
    }

    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }

    .spinner-custom {
        width: 50px;
        height: 50px;
        border: 4px solid #e3f2fd;
        border-top: 4px solid #2196f3;
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin: 0 auto 20px;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    /* Generated Link Section */
    #linkSection {
        text-align: center;
        padding: 30px;
        background: linear-gradient(135deg, #d4edda 0%, #c8e6c9 100%);
        border-radius: var(--border-radius);
        margin-bottom: 20px;
        display: none;
        animation: fadeIn 0.5s ease-in;
    }

    #generatedLink {
        word-break: break-all;
        background: white;
        padding: 15px;
        border-radius: 10px;
        border: 2px solid #4caf50;
        margin: 20px 0;
        font-family: monospace;
        font-size: 1rem;
    }

    #completeBtn {
        background: var(--primary-gradient);
        border: none;
        padding: 15px 30px;
        border-radius: 50px;
        font-size: 1rem;
        font-weight: 600;
        color: white;
        cursor: pointer;
        transition: var(--transition);
        box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    #completeBtn:hover:not(:disabled) {
        transform: translateY(-2px);
        box-shadow: 0 12px 35px rgba(102, 126, 234, 0.4);
    }

    #completeBtn:disabled {
        background: #bdc3c7;
        cursor: not-allowed;
        transform: none;
    }

    /* Alert for Restriction */
    .restriction-alert {
        background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);
        border: 1px solid #ffeaa7;
        color: #856404;
        padding: 25px;
        border-radius: var(--border-radius);
        text-align: center;
        box-shadow: var(--card-shadow);
        animation: slideUp 0.8s ease-out;
        margin-bottom: 20px;
    }

    .restriction-alert i {
        font-size: 3rem;
        margin-bottom: 15px;
        display: block;
    }

    /* Quick Links */
    .quick-links {
        text-align: center;
        margin-top: 30px;
    }

    .quick-links a {
        background: var(--info-gradient);
        color: white;
        padding: 12px 30px;
        border-radius: 50px;
        text-decoration: none;
        font-weight: 600;
        transition: var(--transition);
        box-shadow: 0 5px 20px rgba(91, 134, 229, 0.3);
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .quick-links a:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 30px rgba(91, 134, 229, 0.4);
        color: white;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .link-selling-container { padding: 20px 15px; }
        .link-selling-card { padding: 25px; }
        .card-title { font-size: 2rem; }
        .stats-row { grid-template-columns: 1fr; }
        #generateBtn, #completeBtn { width: 100%; padding: 15px; }
    }
</style>

<br><br><br>
<style>
    /* Premium Ad Card Styles */
    .premium-ad-card {
        background: white;
        border-radius: 16px;
        padding: 10px;
        margin: 15px auto;
        position: relative;
        overflow: hidden;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        border: 1px solid rgba(0, 0, 0, 0.04);
        display: flex;
        align-items: center;
        gap: 12px;
        max-width: 100%;
        transition: transform 0.2s ease, box-shadow 0.2s ease;
        text-decoration: none; /* Remove underline from link */
    }

    /* Hover Effect */
    .premium-ad-card:active {
        transform: scale(0.98);
    }

    /* Shining Animation Effect (Eye Catcher) */
    .premium-ad-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 50%;
        height: 100%;
        background: linear-gradient(to right, transparent, rgba(255, 255, 255, 0.8), transparent);
        transform: skewX(-25deg);
        animation: shine 3s infinite;
        pointer-events: none;
    }

    @keyframes shine {
        100% { left: 200%; }
    }

    /* Label Badge */
    .ad-badge {
        position: absolute;
        top: 0;
        left: 0;
        background: linear-gradient(135deg, #FF9800 0%, #F57C00 100%);
        color: white;
        font-size: 9px;
        font-weight: 700;
        padding: 2px 8px;
        border-bottom-right-radius: 8px;
        border-top-left-radius: 16px; /* Matches card corner */
        z-index: 2;
        letter-spacing: 0.5px;
    }

    /* Image Styling */
    .ad-image-wrapper {
        width: 80px; /* Fixed width for consistency */
        height: 60px; /* Compact height */
        border-radius: 10px;
        overflow: hidden;
        flex-shrink: 0;
        background: #f0f0f0;
    }

    .ad-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    /* Content Styling */
    .ad-content {
        flex: 1;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .ad-title {
        font-size: 14px;
        font-weight: 600;
        color: #1f2937;
        margin-bottom: 2px;
        line-height: 1.2;
    }

    .ad-cta {
        font-size: 11px;
        color: #229ED9; /* Telegram Blue */
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 4px;
    }
    
    .ad-arrow-icon {
        width: 18px;
        height: 18px;
        background: #e0f2fe;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 10px;
    }
</style>

<?php
    $activeAd = \App\Models\Ad::active()->first();
    
    // যখনি অ্যাডটি লোড হবে, ভিউ বা ইম্প্রেশন ১ বাড়বে
    if($activeAd){
        $activeAd->increment('views');
    }
?>

<?php if($activeAd): ?>
    
    <a href="<?php echo e(route('ad.track.click', $activeAd->id)); ?>" target="_blank" class="premium-ad-card">
        <span class="ad-badge">SPONSORED</span>
        
        <div class="ad-image-wrapper">
            <img src="<?php echo e(asset('ads_images/' . $activeAd->image)); ?>" alt="<?php echo e($activeAd->ad_name ?: 'Exclusive Offer For You'); ?>" class="ad-image">
        </div>
        
        <div class="ad-content">
            
            <div class="ad-title"><?php echo e($activeAd->ad_name ?: 'Exclusive Offer For You'); ?></div>
            
            <div class="ad-cta">
                Click to View 
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
<?php else: ?>
    
    <a href="/ads/create" target="_blank" class="premium-ad-card">
        <span class="ad-badge">Ads Offer</span>
        
        <div class="ad-image-wrapper">
            <img src="<?php echo e(asset('ads_images/ads.jpg')); ?>" alt="Offer" class="ad-image">
        </div>
        
        <div class="ad-content">
            <div class="ad-title">Run Your Ads And Grow Your Team</div>
            <div class="ad-cta">
                Click to Run
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
<?php endif; ?>
<div class="link-selling-container">
    <div class="link-selling-card">
        <div class="card-header">
            <h1 class="card-title">
                <i class="fas fa-link"></i>
                Link Selling System
            </h1>
            <p style="color: #7f8c8d; font-size: 1.1rem;">Generate & Sell Telegram Links – Earn Instantly!</p>
        </div>

        <?php if(!$can_use): ?>
            <div class="restriction-alert">
                <i class="fas fa-exclamation-triangle"></i>
                <h4>Access Restricted</h4>
                <p><?php echo e($message); ?></p>
            </div>
        <?php else: ?>
            <!-- Daily Stats -->
            <div class="stats-row">
                <div class="stat-card stat-primary">
                    <i class="fas fa-calendar-day stat-icon"></i>
                    <div class="stat-number"><?php echo e($daily_limit); ?></div>
                    <div class="stat-label">Daily Limit</div>
                </div>
                <div class="stat-card stat-info">
                    <i class="fas fa-chart-line stat-icon"></i>
                    <div class="stat-number"><?php echo e($used_today); ?></div>
                    <div class="stat-label">Used Today</div>
                </div>
                <div class="stat-card stat-success">
                    <i class="fas fa-check-circle stat-icon"></i>
                    <div class="stat-number"><?php echo e($remaining); ?></div>
                    <div class="stat-label">Remaining</div>
                </div>
            </div>

            <!-- Generate Button -->
            <div class="generate-section">
                <button id="generateBtn" class="btn"
                        <?php echo e($remaining <= 0 ? 'disabled' : ''); ?>>
                    <i class="fas fa-bolt"></i> Generate Telegram Link
                </button>
                
                <?php if($remaining <= 0): ?>
                    <div class="limit-warning">
                        <i class="fas fa-clock"></i> ⚠️ Daily limit reached! Please try again tomorrow.
                    </div>
                <?php endif; ?>
            </div>

            <!-- Result Section -->
            <div id="resultSection">
                <h5>🔗 Generating Secure Link...</h5>
                <div class="spinner-custom"></div>
                <p style="color: #2196f3;">Hold tight – This takes just a moment!</p>
            </div>

            <!-- Generated Link Section -->
            <div id="linkSection">
                <h5>✅ Link Generated Successfully!</h5>
                <div id="generatedLink"></div>
                <button id="completeBtn" class="btn">
                    <i class="fas fa-check"></i> Complete Task & Earn
                </button>
            </div>

            <!-- Quick Links -->
            <div class="quick-links">
                <a href="<?php echo e(route('api.selling.history')); ?>">
                    <i class="fas fa-history"></i> View Work History
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Audio Element for Sound (Link Generation & Completion) -->
<audio id="successSound" preload="auto">
    <source src="<?php echo e(asset('public/sounds/1.mp3')); ?>" type="audio/mpeg">
</audio>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    let currentHistoryId = null;
    const successSound = document.getElementById('successSound');
    
    // Generate Telegram Link
    $('#generateBtn').click(function() {
        $('#resultSection').show();
        $('#generateBtn').prop('disabled', true);
       
        $.ajax({
            url: "<?php echo e(route('api.selling.generate')); ?>",
            type: 'POST',
            data: {
                _token: "<?php echo e(csrf_token()); ?>"
            },
            success: function(response) {
                if (response.success) {
                    currentHistoryId = response.history_id;
                  
                    // Show animation for 2 seconds
                    setTimeout(function() {
                        $('#resultSection').hide();
                        $('#generatedLink').html('<strong>' + response.telegram_link + '</strong>');
                        $('#linkSection').show();
                      
                        // Play success sound immediately after link generation
                        if (successSound) {
                            successSound.currentTime = 0;
                            successSound.volume = 0.8; // Set volume to 80%
                            successSound.play().then(() => {
                                console.log('Link generation sound played successfully!');
                            }).catch(e => {
                                console.log('Audio play failed (user interaction required):', e);
                            });
                        }
                    }, 2000);
                } else {
                    $('#resultSection').hide();
                    alert(response.message || 'Generation failed');
                    $('#generateBtn').prop('disabled', false);
                }
            },
            error: function(xhr, status, error) {
                $('#resultSection').hide();
                alert('Network error. Please try again.');
                $('#generateBtn').prop('disabled', false);
                console.error('AJAX Error:', error);
            }
        });
    });
    
    // Complete Task
    $('#completeBtn').click(function() {
        if (!currentHistoryId) {
            alert('No task to complete');
            return;
        }
        $('#completeBtn').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Processing...');
       
        $.ajax({
            url: "<?php echo e(route('api.selling.complete')); ?>",
            type: 'POST',
            data: {
                _token: "<?php echo e(csrf_token()); ?>",
                history_id: currentHistoryId
            },
            success: function(response) {
                if (response.success) {
                    // Play success sound for task completion
                    if (successSound) {
                        successSound.currentTime = 0;
                        successSound.volume = 0.8;
                        successSound.play().then(() => {
                            console.log('Task completion sound played successfully!');
                        }).catch(e => {
                            console.log('Audio play failed:', e);
                        });
                    }
                  
                    // Show success message
                    alert(response.message);
                  
                    // Update balance display if element exists
                    if ($('.user-balance').length) {
                        $('.user-balance').text(response.new_balance);
                    }
                  
                    // Hide sections and reload stats
                    $('#linkSection').hide();
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                } else {
                    alert(response.message || 'Completion failed');
                    $('#completeBtn').prop('disabled', false).html('<i class="fas fa-check"></i> Complete Task & Earn');
                }
            },
            error: function(xhr, status, error) {
                alert('Network error. Please try again.');
                $('#completeBtn').prop('disabled', false).html('<i class="fas fa-check"></i> Complete Task & Earn');
                console.error('AJAX Error:', error);
            }
        });
    });
});
</script>

<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/teleearn/public_html/resources/views/user/api_selling.blade.php ENDPATH**/ ?>