<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<br><br><br>
<div class="col-lg-8">
    <div class="mb-3">
        <div class="gem-withdraw-container">
            <div class="gem-withdraw-header">
                <div class="gem-withdraw-header-content">
                    <h5 class="gem-withdraw-balance-text">Current Balance: ৳<?php echo e(auth()->user()->balance); ?></h5>
                    <a href="<?php echo e(route('withdraw')); ?>" class="gem-withdraw-back-btn">Previous</a>
                </div>
            </div>
            <?php
                $userBalance = auth()->user()->balance;
                $minWithdraw = app('min_withdraw');
                $canWithdraw = $userBalance >= $minWithdraw;
            ?>
            <?php if(!$canWithdraw): ?>
                <!-- No Withdraw Available State -->
                <div class="empty-withdraw-state">
                    <div class="empty-withdraw-icon">
                        <i class="fas fa-wallet"></i>
                    </div>
                   
                    <h3 class="empty-withdraw-title">Insufficient Balance</h3>
                   
                    <p class="empty-withdraw-message">
                        You need at least ৳<?php echo e($minWithdraw); ?> to make a withdrawal.
                        Your current balance is ৳<?php echo e(number_format($userBalance, 2)); ?>.
                    </p>
                    <div class="balance-progress-container">
                        <div class="balance-progress-label">
                            <span>Progress to withdrawal limit:</span>
                            <span><?php echo e(number_format(($userBalance / $minWithdraw) * 100, 1)); ?>%</span>
                        </div>
                        <div class="balance-progress-bar">
                            <div class="balance-progress-fill" style="width: <?php echo e(min(($userBalance / $minWithdraw) * 100, 100)); ?>%"></div>
                        </div>
                    </div>
                    <div class="withdraw-features-grid">
                        <div class="withdraw-feature-card">
                            <i class="fas fa-bolt feature-icon"></i>
                            <div class="feature-title">Complete Tasks</div>
                            <div class="feature-description">Earn money by completing simple tasks</div>
                        </div>
                       
                        <div class="withdraw-feature-card">
                            <i class="fas fa-users feature-icon"></i>
                            <div class="feature-title">Refer Friends</div>
                            <div class="feature-description">Get bonus for referring friends</div>
                        </div>
                       
                        <div class="withdraw-feature-card">
                            <i class="fas fa-gem feature-icon"></i>
                            <div class="feature-title">Daily Rewards</div>
                            <div class="feature-description">Claim daily login bonuses</div>
                        </div>
                    </div>
                    <div class="withdraw-action-buttons">
                        <a href="<?php echo e(route('tasks')); ?>" class="btn-earn-now">
                            <i class="fas fa-tasks"></i> Earn Now
                        </a>
                        <a href="<?php echo e(route('dashboard')); ?>" class="btn-dashboard">
                            <i class="fas fa-home"></i> Dashboard
                        </a>
                    </div>
                    <div class="withdraw-countdown">
                        <div class="countdown-label">Keep earning and check back when you reach ৳<?php echo e($minWithdraw); ?></div>
                    </div>
                </div>
            <?php else: ?>
                <!-- Withdraw Form Available -->
                <div class="gem-withdraw-card">
                    <div class="gem-withdraw-card-body">
                        <form action="<?php echo e(route('withdrawCreate_submit')); ?>" method="post" enctype="multipart/form-data" class="gem-withdraw-form" id="withdrawForm">
                            <?php echo csrf_field(); ?>
                            <div class="withdraw-success-indicator">
                                <i class="fas fa-check-circle"></i>
                                <span>You are eligible for withdrawal!</span>
                            </div>
                            <label class="gem-withdraw-label">Choose a withdrawal method *</label>
                            <div class="gem-method-select-wrapper">
                                <button type="button" id="gemMethodToggleBtn" class="gem-method-toggle-btn">
                                    <span id="gemSelectedMethodText">Select Withdraw Method</span>
                                    <i class="fas fa-chevron-down gem-method-chevron"></i>
                                </button>
                                <div id="gemMethodOptions" class="gem-method-options d-none">
                                    <label class="gem-method-option">
                                        <input type="radio" name="withdraw_method" value="bkash" class="gem-method-radio d-none">
                                        <span class="gem-method-label">Bkash </span>
                                    </label>
                                    <label class="gem-method-option">
                                        <input type="radio" name="withdraw_method" value="nagad" class="gem-method-radio d-none">
                                        <span class="gem-method-label">Nagad </span>
                                    </label>
                                </div>
                            </div>
                            <label for="gem_withdraw_to_number" class="gem-withdraw-label mt-4">
                                Wallet Number *
                            </label>
                            <input type="text" id="gem_withdraw_to_number" name="withdraw_to_number" class="gem-withdraw-input" placeholder="Ex: 01xxxxxxxxx" required>
                            <label for="gem_req_amount" class="gem-withdraw-label mt-4">
                                Amount *
                            </label>
                            <div class="amount-input-container">
                                <input type="number" id="gem_req_amount" name="req_amount" class="gem-withdraw-input"
                                       min="<?php echo e($minWithdraw); ?>"
                                       max="<?php echo e($userBalance); ?>"
                                       placeholder="Ex: <?php echo e($minWithdraw); ?>"
                                       required
                                       oninput="calculateNetAmount()">
                                <div class="amount-hint">Available: ৳<?php echo e(number_format($userBalance, 2)); ?></div>
                            </div>
                            <!-- Amount Calculation Summary -->
                            <div class="amount-calculation-card">
                                <div class="calculation-row">
                                    <span>Withdrawal Amount:</span>
                                    <span id="withdrawalAmount">৳0.00</span>
                                </div>
                                <div class="calculation-row">
                                    <span>Processing Fee (5%):</span>
                                    <span id="processingFee">৳0.00</span>
                                </div>
                                <div class="calculation-divider"></div>
                                <div class="calculation-row total-row">
                                    <span>You'll Receive:</span>
                                    <span id="netAmount">৳0.00</span>
                                </div>
                            </div>
                            <div class="gem-withdraw-info-box gem-withdraw-info-notice">
                                <p><strong>1. Fees: </strong>5% charge will be deducted for every withdrawal</p>
                            </div>
                            <div class="gem-withdraw-info-box gem-withdraw-info-notice">
                                <p><strong>2. Limit: </strong>Minimum Withdraw Limit ৳<?php echo e($minWithdraw); ?></p>
                            </div>
                            <div class="gem-withdraw-info-box gem-withdraw-info-notice">
                                <p><strong>3. Processing: </strong>Withdrawals are processed within 24 hours</p>
                            </div>
                            <div class="gem-btn-submit-wrapper">
                                <button type="submit" class="gem-btn-submit" id="submitBtn">
                                    <span class="btn-text">Process Withdrawal</span>
                                    <div class="btn-loader d-none">
                                        <div class="spinner"></div>
                                        Processing...
                                    </div>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<style>
/* Telegram Blue Theme Integration - Professional Enhancement */
body {
    background: linear-gradient(135deg, #f0f2f5 0%, #e8f0fe 100%);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: #333;
    overflow-x: hidden;
}
.gem-withdraw-container {
    max-width: 680px;
    margin: 0 auto;
    padding: 20px;
}
.gem-withdraw-header {
    padding: 20px;
    margin-bottom: 20px;
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    border-radius: 15px;
    color: white;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
    animation: fadeInDown 0.8s ease-out;
}
@keyframes fadeInDown {
    from { opacity: 0; transform: translateY(-20px); }
    to { opacity: 1; transform: translateY(0); }
}
.gem-withdraw-header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
}
.gem-withdraw-balance-text {
    font-weight: 600;
    font-size: 1.2rem;
    color: white;
    text-shadow: 0 1px 5px rgba(0, 0, 0, 0.2);
}
.gem-withdraw-back-btn {
    background: rgba(255, 255, 255, 0.2);
    color: white;
    font-weight: 500;
    padding: 10px 20px;
    border-radius: 25px;
    border: 1px solid rgba(255, 255, 255, 0.3);
    text-decoration: none;
    font-size: 0.95rem;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(0, 136, 204, 0.2);
}
.gem-withdraw-back-btn:hover {
    background: rgba(255, 255, 255, 0.3);
    border-color: rgba(255, 255, 255, 0.5);
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 136, 204, 0.3);
    color: white;
    text-decoration: none;
}
/* Empty Withdraw State - Top-Notch Design */
.empty-withdraw-state {
    text-align: center;
    padding: 50px 30px;
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    border-radius: 20px;
    color: white;
    box-shadow: 0 15px 40px rgba(0, 136, 204, 0.3);
    margin: 20px 0;
    position: relative;
    overflow: hidden;
    backdrop-filter: blur(10px);
}
.empty-withdraw-state::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.05"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.05"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
    opacity: 0.1;
}
.empty-withdraw-icon {
    font-size: 5rem;
    margin-bottom: 20px;
    display: inline-block;
    animation: bounce 2s ease-in-out infinite;
    text-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
}
@keyframes bounce {
    0%, 100% { transform: translateY(0); }
    50% { transform: translateY(-10px); }
}
.empty-withdraw-title {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 15px;
    text-shadow: 0 1px 5px rgba(0, 0, 0, 0.2);
}
.empty-withdraw-message {
    font-size: 1.1rem;
    opacity: 0.95;
    margin-bottom: 25px;
    max-width: 500px;
    margin-left: auto;
    margin-right: auto;
    line-height: 1.6;
}
/* Balance Progress - Elegant */
.balance-progress-container {
    background: rgba(255, 255, 255, 0.15);
    padding: 25px;
    border-radius: 15px;
    margin: 25px auto;
    max-width: 400px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    box-shadow: 0 4px 15px rgba(0, 136, 204, 0.1);
}
.balance-progress-label {
    display: flex;
    justify-content: space-between;
    margin-bottom: 12px;
    font-size: 0.95rem;
    font-weight: 500;
}
.balance-progress-bar {
    width: 100%;
    height: 10px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 10px;
    overflow: hidden;
    box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.1);
}
.balance-progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #00ff88, #10b981);
    border-radius: 10px;
    transition: width 0.6s ease;
    box-shadow: 0 0 10px rgba(0, 255, 136, 0.5);
}
/* Features Grid - Premium Look */
.withdraw-features-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
    gap: 20px;
    margin: 30px 0;
}
.withdraw-feature-card {
    background: rgba(255, 255, 255, 0.15);
    padding: 25px;
    border-radius: 15px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.3);
    transition: all 0.3s ease;
    text-align: center;
    position: relative;
    overflow: hidden;
}
.withdraw-feature-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 3px;
    background: linear-gradient(90deg, #0088cc, #00a0e9);
}
.withdraw-feature-card:hover {
    transform: translateY(-5px);
    background: rgba(255, 255, 255, 0.2);
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.2);
}
.feature-icon {
    font-size: 2.5rem;
    margin-bottom: 15px;
    display: block;
    color: #00ff88;
    text-shadow: 0 2px 10px rgba(0, 255, 136, 0.3);
    animation: float 3s ease-in-out infinite;
}
@keyframes float {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-5px); }
}
.feature-title {
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1.1rem;
    color: white;
}
.feature-description {
    font-size: 0.9rem;
    opacity: 0.9;
    line-height: 1.5;
    color: white;
}
/* Action Buttons - Sleek */
.withdraw-action-buttons {
    display: flex;
    gap: 15px;
    justify-content: center;
    flex-wrap: wrap;
    margin-top: 30px;
}
.btn-earn-now, .btn-dashboard {
    padding: 15px 30px;
    border-radius: 25px;
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 10px;
    transition: all 0.3s ease;
    font-size: 1rem;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
}
.btn-earn-now {
    background: linear-gradient(135deg, #00ff88 0%, #10b981 100%);
    color: white;
}
.btn-earn-now:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(0, 255, 136, 0.3);
    color: white;
    text-decoration: none;
}
.btn-dashboard {
    background: rgba(255, 255, 255, 0.2);
    color: white;
    border: 2px solid rgba(255, 255, 255, 0.4);
}
.btn-dashboard:hover {
    background: rgba(255, 255, 255, 0.3);
    transform: translateY(-3px);
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.2);
    color: white;
    text-decoration: none;
}
.withdraw-countdown {
    margin-top: 25px;
}
.countdown-label {
    font-size: 0.95rem;
    opacity: 0.8;
    font-style: italic;
    text-align: center;
}
/* Withdraw Form - Professional */
.withdraw-success-indicator {
    background: linear-gradient(135deg, #00ff88 0%, #10b981 100%);
    color: white;
    padding: 15px 20px;
    border-radius: 12px;
    margin-bottom: 25px;
    display: flex;
    align-items: center;
    gap: 10px;
    font-weight: 600;
    box-shadow: 0 4px 15px rgba(0, 255, 136, 0.3);
    animation: slideInRight 0.6s ease-out;
}
@keyframes slideInRight {
    from { opacity: 0; transform: translateX(-20px); }
    to { opacity: 1; transform: translateX(0); }
}
.gem-withdraw-label {
    font-weight: 600;
    color: #0088cc;
    margin-bottom: 8px;
    font-size: 1rem;
    display: block;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}
.gem-withdraw-input {
    width: 100%;
    padding: 15px 18px;
    font-size: 1rem;
    border-radius: 12px;
    border: 2px solid #e0e0e0;
    outline: none;
    box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.05);
    transition: all 0.3s ease;
    background: #f8f9fa;
    font-weight: 500;
}
.gem-withdraw-input:focus {
    border-color: #0088cc;
    box-shadow: 0 0 0 0.2rem rgba(0, 136, 204, 0.15);
    background: white;
    transform: translateY(-1px);
}
.gem-method-select-wrapper {
    max-width: 350px;
    margin: 0 auto 20px auto;
    position: relative;
    z-index: 10;
}
.gem-method-toggle-btn {
    width: 100%;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border: 2px solid #e0e0e0;
    color: #333;
    font-weight: 600;
    font-size: 1rem;
    padding: 15px 20px;
    border-radius: 12px;
    cursor: pointer;
    display: flex;
    justify-content: space-between;
    align-items: center;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
}
.gem-method-toggle-btn:hover {
    border-color: #0088cc;
    box-shadow: 0 4px 12px rgba(0, 136, 204, 0.15);
}
.gem-method-toggle-btn.active {
    border-color: #0088cc;
    box-shadow: 0 0 0 0.2rem rgba(0, 136, 204, 0.15);
}
.gem-method-chevron {
    transition: transform 0.3s ease;
    font-size: 1rem;
}
.gem-method-toggle-btn.active .gem-method-chevron {
    transform: rotate(180deg);
}
.gem-method-options {
    position: absolute;
    top: calc(100% + 10px);
    left: 0;
    right: 0;
    display: flex;
    flex-direction: column;
    gap: 8px;
    padding: 15px;
    background: white;
    border-radius: 12px;
    border: 2px solid #e0e0e0;
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
    z-index: 100;
    animation: slideDown 0.3s ease-out;
}
@keyframes slideDown {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}
.d-none {
    display: none !important;
}
.gem-method-option {
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 12px;
    color: #555;
    font-weight: 500;
    font-size: 1rem;
    padding: 12px 15px;
    border-radius: 8px;
    border: 1px solid transparent;
    transition: all 0.3s ease;
}
.gem-method-option:hover {
    background: #f8f9fa;
    border-color: #e0e0e0;
}
.gem-method-option input[type="radio"]:checked + .gem-method-label {
    color: #0088cc;
    font-weight: 700;
}
.gem-method-radio:checked + .gem-method-label::before {
    content: '✓';
    color: #0088cc;
    font-weight: bold;
    margin-right: 8px;
}
.amount-input-container {
    position: relative;
}
.amount-hint {
    position: absolute;
    right: 12px;
    top: 50%;
    transform: translateY(-50%);
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    padding: 6px 10px;
    border-radius: 8px;
    font-size: 0.85rem;
    font-weight: 500;
    box-shadow: 0 2px 8px rgba(0, 136, 204, 0.2);
}
.amount-calculation-card {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border: 1px solid #e0e0e0;
    border-radius: 12px;
    padding: 20px;
    margin: 20px 0;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}
.calculation-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 10px 0;
    font-size: 1rem;
    border-bottom: 1px solid #e0e0e0;
}
.calculation-row:last-child {
    border-bottom: none;
    font-weight: 600;
    color: #0088cc;
    font-size: 1.1rem;
}
.calculation-divider {
    height: 2px;
    background: linear-gradient(90deg, #0088cc, #00a0e9);
    margin: 10px 0;
    border-radius: 1px;
}
.total-row {
    font-weight: 700;
    color: #27ae60;
}
.gem-withdraw-info-box {
    padding: 15px 20px;
    border-radius: 12px;
    margin-bottom: 15px;
    border-left: 4px solid #0088cc;
    background: linear-gradient(135deg, #e3f2fd 0%, #f0f8ff 100%);
    color: #0088cc;
    font-size: 0.95rem;
    box-shadow: 0 2px 8px rgba(0, 136, 204, 0.1);
}
.gem-withdraw-info-box strong {
    color: #006ba6;
}
.gem-btn-submit-wrapper {
    text-align: center;
    margin-top: 25px;
}
.gem-btn-submit {
    background: linear-gradient(135deg, #27ae60 0%, #2ecc71 100%);
    border: none;
    color: #fff;
    font-weight: 600;
    font-size: 1.1rem;
    padding: 15px 40px;
    border-radius: 25px;
    cursor: pointer;
    width: 100%;
    max-width: 350px;
    box-shadow: 0 6px 20px rgba(39, 174, 96, 0.3);
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}
.gem-btn-submit:hover:not(:disabled) {
    background: linear-gradient(135deg, #219a52 0%, #27ae60 100%);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(39, 174, 96, 0.4);
}
.gem-btn-submit:disabled {
    background: #bdc3c7;
    cursor: not-allowed;
    transform: none;
    box-shadow: none;
}
.btn-loader {
    display: flex;
    align-items: center;
    gap: 10px;
    justify-content: center;
}
.spinner {
    width: 20px;
    height: 20px;
    border: 2px solid transparent;
    border-top: 2px solid currentColor;
    border-radius: 50%;
    animation: spin 0.8s linear infinite;
}
@keyframes spin {
    to { transform: rotate(360deg); }
}
@media(max-width: 576px) {
    .empty-withdraw-state {
        padding: 40px 20px;
    }
    .empty-withdraw-title {
        font-size: 1.6rem;
    }
    .withdraw-features-grid {
        grid-template-columns: 1fr;
        gap: 15px;
    }
    .withdraw-action-buttons {
        flex-direction: column;
        align-items: center;
        gap: 12px;
    }
    .btn-earn-now, .btn-dashboard {
        width: 100%;
        max-width: 250px;
        justify-content: center;
    }
    .gem-withdraw-card {
        padding: 25px 20px;
    }
    .amount-hint {
        position: static;
        transform: none;
        margin-top: 8px;
        display: inline-block;
        text-align: right;
        width: 100%;
    }
    .gem-method-options {
        position: static;
        margin-top: 10px;
        box-shadow: none;
        border: 1px solid #e0e0e0;
    }
    .gem-method-toggle-btn {
        justify-content: space-between;
    }
}
</style>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const toggleBtn = document.getElementById('gemMethodToggleBtn');
    const optionsDiv = document.getElementById('gemMethodOptions');
    const selectedSpan = document.getElementById('gemSelectedMethodText');
    const radios = optionsDiv.querySelectorAll('input[type="radio"]');
    const withdrawForm = document.getElementById('withdrawForm');
    const submitBtn = document.getElementById('submitBtn');
    // Method selection functionality
    if (toggleBtn) {
        toggleBtn.addEventListener('click', function () {
            optionsDiv.classList.toggle('d-none');
            toggleBtn.classList.toggle('active');
        });
        radios.forEach(radio => {
            radio.addEventListener('change', function () {
                const label = this.parentElement;
                selectedSpan.textContent = label.querySelector('.gem-method-label').textContent;
                optionsDiv.classList.add('d-none');
                toggleBtn.classList.remove('active');
            });
        });
        document.addEventListener('click', function(e) {
            if (!toggleBtn.contains(e.target) && !optionsDiv.contains(e.target)) {
                optionsDiv.classList.add('d-none');
                toggleBtn.classList.remove('active');
            }
        });
    }
    // Form submission handling
    if (withdrawForm) {
        withdrawForm.addEventListener('submit', function(e) {
            const amountInput = document.getElementById('gem_req_amount');
            const methodSelected = document.querySelector('input[name="withdraw_method"]:checked');
           
            if (!methodSelected) {
                e.preventDefault();
                alert('Please select a withdrawal method');
                return;
            }
           
            if (parseFloat(amountInput.value) < parseFloat(amountInput.min)) {
                e.preventDefault();
                alert(`Minimum withdrawal amount is ৳${amountInput.min}`);
                return;
            }
           
            // Show loading state
            const btnText = submitBtn.querySelector('.btn-text');
            const btnLoader = submitBtn.querySelector('.btn-loader');
           
            btnText.classList.add('d-none');
            btnLoader.classList.remove('d-none');
            submitBtn.disabled = true;
        });
    }
    // Initial calculation
    calculateNetAmount();
});
function calculateNetAmount() {
    const amountInput = document.getElementById('gem_req_amount');
    const withdrawalAmountElem = document.getElementById('withdrawalAmount');
    const processingFeeElem = document.getElementById('processingFee');
    const netAmountElem = document.getElementById('netAmount');
   
    const amount = parseFloat(amountInput.value) || 0;
    const fee = amount * 0.05; // 5% fee
    const netAmount = amount - fee;
   
    withdrawalAmountElem.textContent = `৳${amount.toFixed(2)}`;
    processingFeeElem.textContent = `৳${fee.toFixed(2)}`;
    netAmountElem.textContent = `৳${netAmount.toFixed(2)}`;
}
</script>
<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/zonexpro/hgzy.zone-x.pro/resources/views/user/withdraw_create.blade.php ENDPATH**/ ?>