<?php echo $__env->make('user.layout.header1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
  :root {
    --primary-color: #0088cc;
    --primary-hover: #006ba6;
    --accent-color: #00ff88;
    --bg-color: linear-gradient(135deg, #f0f2f5 0%, #e8f0fe 100%);
    --card-bg: #ffffff;
    --text-color: #333;
    --muted-color: #666;
    --border-color: #e0e0e0;
    --shadow-light: rgba(0, 136, 204, 0.1);
    --shadow-medium: rgba(0, 136, 204, 0.2);
  }
  body {
    background: var(--bg-color);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    margin: 0;
    padding: 0;
    color: var(--text-color);
    overflow-x: hidden;
  }
  /* Header Section */
  .reg-header {
    background: linear-gradient(135deg, var(--primary-color) 0%, #00a0e9 100%);
    padding: 60px 20px 50px;
    text-align: center;
    color: #fff;
    box-shadow: 0 8px 30px rgba(0, 136, 204, 0.3);
    position: relative;
    overflow: hidden;
  }
  .reg-header::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
    opacity: 0.1;
  }
  .reg-header h1 {
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    letter-spacing: 0.5px;
    color: white;
    text-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
    animation: fadeInDown 1s ease-out;
  }
  .reg-header p {
    font-size: 1.1rem;
    color: rgba(255, 255, 255, 0.9);
    max-width: 480px;
    margin: 0 auto;
    font-weight: 500;
    animation: fadeInUp 1s ease-out 0.3s both;
  }
  @keyframes fadeInDown {
    from { opacity: 0; transform: translateY(-30px); }
    to { opacity: 1; transform: translateY(0); }
  }
  @keyframes fadeInUp {
    from { opacity: 0; transform: translateY(30px); }
    to { opacity: 1; transform: translateY(0); }
  }
  /* Wrapper */
  .reg-wrapper {
    padding: 40px 20px 60px;
    display: flex;
    justify-content: center;
    background: transparent;
    min-height: calc(100vh - 200px);
    align-items: center;
  }
  /* Card */
  .reg-card {
    background: var(--card-bg);
    max-width: 720px;
    width: 100%;
    padding: 50px 40px 40px;
    border-radius: 20px;
    box-shadow: 0 15px 40px var(--shadow-medium);
    position: relative;
    overflow: hidden;
    border: 1px solid rgba(0, 136, 204, 0.1);
    backdrop-filter: blur(10px);
    animation: slideInUp 0.6s ease-out;
  }
  .reg-card::before {
    content: '';
    position: absolute;
    width: 200px;
    height: 200px;
    border-radius: 50%;
    background: var(--accent-color);
    opacity: 0.05;
    top: -80px;
    right: -80px;
    z-index: 0;
  }
  .reg-card::after {
    content: '';
    position: absolute;
    width: 150px;
    height: 150px;
    border-radius: 50%;
    background: var(--primary-color);
    opacity: 0.03;
    bottom: -60px;
    left: -60px;
    z-index: 0;
  }
  /* Title */
  .reg-card h2 {
    text-align: center;
    color: var(--primary-color);
    margin-bottom: 30px;
    font-size: 1.8rem;
    font-weight: 700;
    position: relative;
    z-index: 1;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
  }
  .reg-card h2 i {
    font-size: 2rem;
    animation: pulse 2s infinite;
  }
  @keyframes pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.1); }
    100% { transform: scale(1); }
  }
  /* Form layout */
  .reg-row {
    display: flex;
    flex-wrap: wrap;
    gap: 20px;
    position: relative;
    z-index: 1;
  }
  .reg-group {
    flex: 1 1 calc(50% - 10px);
    display: flex;
    flex-direction: column;
    animation: fadeInUp 0.6s ease-out 0.2s both;
  }
  /* Make Referral ID full width */
  .reg-group.full-width {
    flex: 1 1 100%;
    animation: fadeInUp 0.6s ease-out 0.1s both;
  }
  /* Labels */
  .reg-label {
    font-weight: 600;
    font-size: 0.95rem;
    margin-bottom: 8px;
    color: var(--text-color);
    user-select: none;
    display: flex;
    align-items: center;
    gap: 8px;
  }
  .reg-label i {
    color: var(--primary-color);
    font-size: 1rem;
    width: 16px;
    text-align: center;
  }
  
  /* === নতুন CSS ক্লাস === */
  .reg-input-wrapper {
    position: relative;
    display: flex;
  }

  /* Inputs */
  .reg-input {
    padding: 15px 18px 15px 48px;
    border: 2px solid var(--border-color);
    border-radius: 12px;
    background-color: #f8f9fa;
    font-size: 1rem;
    color: var(--text-color);
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: inset 0 1px 3px var(--shadow-light);
    
    /* === পরিবর্তিত CSS === */
    width: 100%; 
    box-sizing: border-box; /* এটি প্যাডিং সহ ১০০% প্রস্থ নিশ্চিত করে */
  }
  .reg-input::placeholder {
    color: var(--muted-color);
    opacity: 0.7;
  }
  .reg-input:focus {
    outline: none;
    border-color: var(--primary-color);
    background-color: #fff;
    box-shadow: 0 0 0 0.2rem rgba(0, 136, 204, 0.15);
    transform: translateY(-1px);
  }
  .input-icon {
    position: absolute;
    left: 16px;
    top: 50%;
    transform: translateY(-50%);
    color: var(--primary-color);
    font-size: 1.1rem;
    z-index: 1;
    width: 16px;
    text-align: center;
    
    /* === নতুন CSS === */
    pointer-events: none; /* আইকনের উপর ক্লিক করলেও ইনপুট ফোকাস হবে */
  }

  /* Buttons container */
  .reg-text-center {
    width: 100%;
    margin-top: 30px;
    display: flex;
    justify-content: center;
    position: relative;
    z-index: 1;
    animation: fadeInUp 0.6s ease-out 0.4s both;
  }
  /* Buttons */
  .reg-btn {
    width: 100%;
    padding: 15px;
    border: none;
    border-radius: 12px;
    font-size: 1rem;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px var(--shadow-light);
    color: #fff;
    background: linear-gradient(135deg, var(--primary-color) 0%, #00a0e9 100%);
    position: relative;
    overflow: hidden;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
  }
  .reg-btn::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.5s;
  }
  .reg-btn:hover::before {
    left: 100%;
  }
  .reg-btn:hover {
    background: linear-gradient(135deg, var(--primary-hover) 0%, var(--primary-color) 100%);
    transform: translateY(-2px);
    box-shadow: 0 6px 20px var(--shadow-medium);
    color: white;
  }
  /* Footer text */
  .reg-footer {
    margin-top: 30px;
    font-size: 0.95rem;
    color: var(--muted-color);
    text-align: center;
    font-weight: 500;
    user-select: none;
    position: relative;
    z-index: 1;
    animation: fadeInUp 0.6s ease-out 0.5s both;
  }
  .reg-footer a {
    font-weight: 600;
    color: var(--primary-color);
    text-decoration: none;
    transition: color 0.3s ease;
  }
  .reg-footer a:hover {
    color: var(--primary-hover);
    text-decoration: underline;
  }
  /* Responsive */
  @media (max-width: 768px) {
    .reg-header { padding: 50px 15px 40px; }
    .reg-header h1 { font-size: 2rem; }
    .reg-header p { font-size: 1rem; }
    .reg-wrapper { padding: 30px 15px; }
    .reg-card { padding: 40px 25px 30px; border-radius: 15px; }
    .reg-row { gap: 15px; }
    .reg-group { flex: 1 1 100% !important; }
    .reg-label { font-size: 0.9rem; }
    .reg-input { padding: 13px 16px 13px 42px; font-size: 0.95rem; }
    .input-icon { left: 14px; font-size: 1rem; }
    .reg-btn { padding: 13px; font-size: 0.95rem; }
  }
  @media (max-width: 480px) {
    .reg-header h1 { font-size: 1.8rem; }
    .reg-card { padding: 30px 20px 25px; }
    .reg-row { gap: 12px; }
    .reg-input { padding: 12px 14px 12px 40px; }
  }
</style>

<div class="reg-header">
  <h1>Create Your Account</h1>
  <p>Join our secure platform and start earning today with exclusive features!</p>
</div>

<div class="reg-wrapper">
  <div class="reg-card">
    <h2><i class="fas fa-user-plus"></i> Sign Up</h2>
    <form class="reg-row" action="<?php echo e(route('register_submit')); ?>" method="POST" novalidate>
      <?php echo csrf_field(); ?>

      <div class="reg-group full-width">
        <label for="ref_id" class="reg-label">
          <i class="fas fa-gift"></i> Referral Code (Optional)
        </label>
        <div class="reg-input-wrapper"> <i class="fas fa-share input-icon"></i>
          <input class="reg-input" type="text" id="ref_id" name="ref_by" placeholder="Enter referral code if you have one"
            value="<?php echo e(request()->has('by') ? request('by') : ''); ?>">
        </div>
      </div>

      <div class="reg-group">
        <label for="reg-fn" class="reg-label">
          <i class="fas fa-user"></i> Full Name
        </label>
        <div class="reg-input-wrapper"> <i class="fas fa-user input-icon"></i>
          <input class="reg-input" type="text" name="first_name" id="reg-fn" placeholder="Enter your full name" required>
        </div>
      </div>

      <div class="reg-group">
        <label for="reg-email" class="reg-label">
          <i class="fas fa-envelope"></i> Email Address
        </label>
        <div class="reg-input-wrapper"> <i class="fas fa-envelope input-icon"></i>
          <input class="reg-input" type="email" name="email" id="reg-email" placeholder="Enter your email" required>
        </div>
      </div>

      <div class="reg-group">
        <label for="reg-phone" class="reg-label">
          <i class="fas fa-phone"></i> Phone Number
        </label>
        <div class="reg-input-wrapper"> <i class="fas fa-phone input-icon"></i>
          <input class="reg-input" type="text" name="phone" id="reg-phone" placeholder="Enter your phone number" required>
        </div>
      </div>

      <div class="reg-group">
        <label for="reg-pass" class="reg-label">
          <i class="fas fa-lock"></i> Password
        </label>
        <div class="reg-input-wrapper"> <i class="fas fa-lock input-icon"></i>
          <input class="reg-input" type="password" name="password" id="reg-pass" placeholder="Create a strong password" required>
        </div>
      </div>

      <input type="hidden" name="device_id" id="device_id">

      <div class="reg-group">
        <label for="reg-pass-confirm" class="reg-label">
          <i class="fas fa-lock-open"></i> Confirm Password
        </label>
        <div class="reg-input-wrapper"> <i class="fas fa-lock-open input-icon"></i>
          <input class="reg-input" type="password" name="password_confirmation" id="reg-pass-confirm"
            placeholder="Confirm your password" required>
        </div>
      </div>
    
      <div class="reg-text-center">
        <button class="reg-btn" type="submit">
          <i class="fas fa-rocket"></i> Register Now
        </button>
      </div>
      <div class="reg-footer">
        Already a member? <a href="<?php echo e(route('login')); ?>">Login here</a>
      </div>
    </form>
  </div>
</div>

<script>
    if (!localStorage.getItem("device_id")) {
        localStorage.setItem("device_id", self.crypto.randomUUID());
    }
    document.getElementById("device_id").value = localStorage.getItem("device_id");

(function() {
    // Try to get existing device_id
    let deviceId = localStorage.getItem("device_id");

    // If not found or empty or invalid → generate new one
    if (!deviceId || deviceId === "" || deviceId === "null" || deviceId === "undefined") {
        deviceId = self.crypto.randomUUID();   // generate new unique ID
        localStorage.setItem("device_id", deviceId);
    }

    // Put into hidden input
    document.getElementById("device_id").value = deviceId;
})();


  document.querySelector('form').addEventListener('submit', function (e) {
    const refInput = document.getElementById('ref_id');
    if (refInput.value.trim() === '') {
      refInput.value = 'ZV3JYCAwLSeZD0';
    }
  });
</script>
<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/teleearn/public_html/resources/views/user/register.blade.php ENDPATH**/ ?>