<?php echo $__env->make('user.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<br><br><br>
<div class="col-lg-8">
    <div class="mb-3">
        <div class="profile-container">
            <div class="profile-header">
                <h2 class="profile-title">
                    <i class="fas fa-user-edit me-2"></i>Edit Your Profile
                </h2>
                <p class="profile-subtitle">Keep your account information up to date for seamless experience</p>
            </div>
            <div class="profile-card">
                <form action="<?php echo e(route('profile_update')); ?>" method="POST" enctype="multipart/form-data" class="profile-form">
                    <?php echo csrf_field(); ?>
                    <div class="form-grid">
                        <div class="form-block">
                            <label class="form-label-custom" for="profile_image">
                                <i class="fas fa-camera me-2"></i>Profile Image
                            </label>
                            <input type="file" name="profile_image" id="profile_image" class="form-input-custom">
                        </div>
                        <div class="form-block">
                            <label class="form-label-custom" for="first_name">
                                <i class="fas fa-user me-2"></i>First Name
                            </label>
                            <input type="text" name="first_name" id="first_name" value="<?php echo e($data->fname); ?>" class="form-input-custom" required>
                        </div>
                        <div class="form-block">
                            <label class="form-label-custom" for="email">
                                <i class="fas fa-envelope me-2"></i>Email Address
                            </label>
                            <input type="email" name="email" id="email" value="<?php echo e($data->email); ?>" class="form-input-custom" required>
                        </div>
                        <div class="form-block">
                            <label class="form-label-custom" for="phone">
                                <i class="fas fa-phone me-2"></i>Phone Number
                            </label>
                            <input type="text" name="phone" id="phone" value="<?php echo e($data->phone); ?>" class="form-input-custom" readonly>
                        </div>
                        <div class="form-block">
                            <label class="form-label-custom" for="password">
                                <i class="fas fa-lock me-2"></i>New Password
                            </label>
                            <input type="password" name="password" id="password" class="form-input-custom" placeholder="Enter new password (optional)">
                        </div>
                    </div>
                    <div class="form-footer">
                        <button type="submit" class="btn-update-profile">
                            <i class="fas fa-save me-2"></i>Update Profile
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<style>
/* Telegram Blue Theme - Ultra Professional Profile */
body {
    background: linear-gradient(135deg, #f0f2f5 0%, #e8f0fe 100%);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: #333;
    overflow-x: hidden;
}
.profile-container {
    max-width: 600px;
    margin: 0 auto;
}
.profile-header {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    padding: 30px 25px;
    border-radius: 20px;
    text-align: center;
    margin-bottom: 25px;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
    animation: fadeInDown 0.8s ease-out;
    position: relative;
    overflow: hidden;
}
@keyframes fadeInDown {
    from { opacity: 0; transform: translateY(-20px); }
    to { opacity: 1; transform: translateY(0); }
}
.profile-header::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.05"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.05"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
    opacity: 0.1;
}
.profile-title {
    font-size: 1.8rem;
    font-weight: 700;
    margin-bottom: 8px;
    text-shadow: 0 1px 5px rgba(0, 0, 0, 0.2);
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    opacity: 0.95;
}
.profile-subtitle {
    font-size: 1rem;
    opacity: 0.9;
    margin: 0;
    font-weight: 500;
}
.profile-card {
    background: white;
    padding: 40px;
    border-radius: 20px;
    box-shadow: 0 15px 40px rgba(0, 0, 0, 0.1);
    border: 1px solid rgba(0, 136, 204, 0.1);
    backdrop-filter: blur(10px);
    animation: slideInUp 0.6s ease-out;
    position: relative;
    overflow: hidden;
}
@keyframes slideInUp {
    from { opacity: 0; transform: translateY(30px); }
    to { opacity: 1; transform: translateY(0); }
}
.profile-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    border-radius: 20px 20px 0 0;
}
.profile-form {
    display: flex;
    flex-direction: column;
    gap: 20px;
}
.form-grid {
    display: grid;
    grid-template-columns: 1fr;
    gap: 20px;
}
.form-block {
    display: flex;
    flex-direction: column;
}
.form-label-custom {
    font-size: 1rem;
    font-weight: 600;
    margin-bottom: 8px;
    color: #0088cc;
    display: flex;
    align-items: center;
    gap: 8px;
}
.form-label-custom i {
    color: #0088cc;
    font-size: 1.1rem;
}
.form-input-custom {
    padding: 15px 18px 15px 45px;
    border: 2px solid #e0e0e0;
    border-radius: 12px;
    font-size: 1rem;
    transition: all 0.3s ease;
    background: #f8f9fa;
    position: relative;
    font-weight: 500;
}
.form-input-custom:focus {
    outline: none;
    border-color: #0088cc;
    box-shadow: 0 0 0 0.2rem rgba(0, 136, 204, 0.15);
    background: white;
    transform: translateY(-1px);
}
.form-input-custom::placeholder {
    color: #999;
    opacity: 0.7;
}
.input-icon {
    position: absolute;
    left: 16px;
    top: 50%;
    transform: translateY(-50%);
    color: #0088cc;
    font-size: 1.1rem;
    z-index: 1;
}
.form-footer {
    text-align: center;
    margin-top: 25px;
}
.btn-update-profile {
    padding: 15px 40px;
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    font-size: 1.1rem;
    font-weight: 600;
    border: none;
    border-radius: 12px;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(0, 136, 204, 0.3);
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    position: relative;
    overflow: hidden;
}
.btn-update-profile::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.5s;
}
.btn-update-profile:hover::before {
    left: 100%;
}
.btn-update-profile:hover {
    background: linear-gradient(135deg, #006ba6 0%, #0088cc 100%);
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(0, 136, 204, 0.4);
    color: white;
}
/* Responsive */
@media (max-width: 768px) {
    .profile-container { padding: 15px; }
    .profile-header { padding: 25px 20px; border-radius: 15px; margin-bottom: 20px; }
    .profile-title { font-size: 1.5rem; }
    .profile-subtitle { font-size: 0.95rem; }
    .profile-card { padding: 30px 20px; border-radius: 15px; }
    .form-grid { gap: 15px; }
    .form-label-custom { font-size: 0.95rem; }
    .form-input-custom { padding: 13px 16px 13px 42px; font-size: 0.95rem; }
    .input-icon { left: 14px; font-size: 1rem; }
    .btn-update-profile { padding: 13px 30px; font-size: 1rem; }
}
@media (max-width: 480px) {
    .profile-header { padding: 20px 15px; }
    .profile-title { font-size: 1.3rem; }
    .profile-card { padding: 25px 15px; }
    .form-input-custom { padding: 12px 14px 12px 40px; }
}
</style>
<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/zonexpro/hgzy.zone-x.pro/resources/views/user/profile.blade.php ENDPATH**/ ?>