<!--
  Theme Name: ST-InvestPro
  Developer: Swapno Technology
  DeveloperTeam: https://t.me/swapnotechnology
-->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?php echo $__env->yieldContent('title', 'Tele Earn'); ?></title> <!-- Dynamic title for pages -->
    <!-- SEO Meta Tags-->
    <meta name="keywords" content="shoping site,earning site,affliate,product affilaite">
    <meta name="description" content="Tele Earn - This is an international website. You can earn a much money from here.">
    <meta name="author" content="Promote100pro">
    <meta name="distribution" content="web">
    <!-- Mobile Specific Meta Tag-->
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <!-- Favicon Icons (Logo as Favicon too, if needed) -->
    <link rel="icon" type="image/png" href="<?php echo e(asset('user/assets/images/logo.png')); ?>"> <!-- Use same logo as favicon -->
    <link rel="apple-touch-icon" href="<?php echo e(asset('user/assets/images/logo.png')); ?>">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(asset('user/assets/images/logo.png')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('user/assets/images/logo.png')); ?>">
    <link rel="apple-touch-icon" sizes="167x167" href="<?php echo e(asset('user/assets/images/logo.png')); ?>">
    <!-- Vendor Styles including: Bootstrap, Font Icons, Plugins, etc.-->
    <link rel="stylesheet" media="screen" href="<?php echo e(asset('user/assets/front/css/plugins.min.css')); ?>">
    <link id="mainStyles" rel="stylesheet" media="screen" href="<?php echo e(asset('user/assets/front/css/styles.min.css')); ?>">
    <link id="mainStyles" rel="stylesheet" media="screen" href="<?php echo e(asset('user/assets/front/css/responsive.css')); ?>">
    <link id="mainStyles" rel="stylesheet" media="screen" href="<?php echo e(asset('user/assets/front/css/developer.css')); ?>">
    <!-- Color css -->
    <link href="<?php echo e(asset('user/assets/front/css/color.css')); ?>" rel="stylesheet">
    <!-- Modernizr-->
    <script src="<?php echo e(asset('user/assets/front/js/modernizr.min.js')); ?>"></script>
    <style>
        /* Logo Styling for Title Bar */
        .site-header .site-branding .site-logo > img {
            display: block;
            width: 45%; /* Keep your existing style */
            height: auto; /* Maintain aspect ratio */
            max-height: 50px; /* Limit height for title bar fit */
            border-radius: 8px; /* Optional: Rounded corners */
            transition: transform 0.3s ease; /* Hover effect */
        }
        .site-header .site-branding .site-logo > img:hover {
            transform: scale(1.05); /* Slight zoom on hover */
        }
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .site-header .site-branding .site-logo > img {
                width: 60%; /* Larger on mobile for visibility */
                max-height: 40px;
            }
        }
        /* Fallback if logo not found */
        .site-logo img[alt="App Logo"] {
            background: #f0f0f0; /* Gray placeholder */
            display: flex;
            align-items: center;
            justify-content: center;
            color: #999;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <!-- Sample Header/Title Bar with Logo (Add this in your layout body or header include) -->

    <!-- Main content (yield from pages) -->
    <main class="container-fluid">
        <?php echo $__env->yieldContent('content'); ?> <!-- Your page content here -->
    </main>

    <!-- Your existing footer/scripts -->
    <?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> <!-- If you have footer -->

    <!-- Scripts (add at bottom) -->
    <script src="<?php echo e(asset('user/assets/front/js/plugins.min.js')); ?>"></script>
    <script src="<?php echo e(asset('user/assets/front/js/scripts.min.js')); ?>"></script>
</body>

    <script>
    // ২. রাইট ক্লিক (Context Menu) বন্ধ রাখা হয়েছে যাতে 'Inspect' অপশন না আসে
    document.addEventListener('contextmenu', function(e) {
        e.preventDefault();
        // চাইলে এখানে একটি অ্যালার্ট দিতে পারেন, না চাইলে নিচের লাইনটি কেটে দিন
        // alert("Right Click is disabled to protect content, please use Ctrl+C to copy.");
    });

    document.onkeydown = function(e) {
        // ৩. F12 (Developer Tools) বন্ধ
        if (event.keyCode == 123) {
            return false;
        }

        // ৪. সোর্স কোড দেখার শর্টকাটগুলো (Ctrl+Shift+I, Ctrl+Shift+J, Ctrl+Shift+C, Ctrl+U) বন্ধ
        if (e.ctrlKey && e.shiftKey && (e.keyCode == 'I'.charCodeAt(0) || e.keyCode == 'J'.charCodeAt(0) || e.keyCode == 'C'.charCodeAt(0))) {
            return false;
        }
        if (e.ctrlKey && e.keyCode == 'U'.charCodeAt(0)) {
            return false;
        }
        
        // ৫. বিদ্র: আমরা Ctrl+C (Copy) বা Ctrl+V (Paste) বন্ধ করিনি, তাই ইউজাররা কিবোর্ড দিয়ে কপি করতে পারবে।
    }
</script>

</html><?php /**PATH /home/teleearn/public_html/resources/views/user/layout/header1.blade.php ENDPATH**/ ?>