<!-- Add the necessary meta tags, styles, and script includes as before -->
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<meta charset="utf-8">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
<link id="mainStyles" rel="stylesheet" media="screen" href="<?php echo e(asset('user/assets/front/css/styles.min.css')); ?>">
<link id="mainStyles" rel="stylesheet" media="screen" href="<?php echo e(asset('user/assets/front/css/responsive.css')); ?>">
<link id="mainStyles" rel="stylesheet" media="screen" href="<?php echo e(asset('user/assets/front/css/developer.css')); ?>">
<!-- Color css -->
<link href="<?php echo e(asset('user/assets/front/css/color.css')); ?>" rel="stylesheet">

<!-- Modernizr-->
<script src="<?php echo e(asset('user/assets/front/js/modernizr.min.js')); ?>"></script>

<?php
    use Carbon\Carbon;

    $user = Auth::user();
    $pendingAmount = $user->pending_earning;
    $lastTime = $user->last_earning_time ? Carbon::parse($user->last_earning_time) : now();
    $nextEarningTime = $lastTime->copy()->addHour();
?>

<style>
    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background-color: #f9fafb;
        color: #1f2937;
        margin: 0;
        padding: 0;
    }

    .mining-box {
        width: 95%;
        max-width: 480px;
        margin: 25px auto;
        background: #ffffff;
        padding: 24px 20px;
        border-radius: 16px;
        box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
        text-align: center;
    }

    .mining-box strong {
        color: #2563eb;
        font-weight: 600;
    }

    .progress-bar-container {
        width: 100%;
        height: 12px;
        background: #e5e7eb;
        border-radius: 10px;
        margin-top: 16px;
        overflow: hidden;
    }

    .progress-bar-fill {
        height: 100%;
        width: 0;
        background: linear-gradient(90deg, #10b981, #3b82f6);
        border-radius: 12px;
        transition: width 1s linear;
    }

    .modal-overlay {
        position: fixed;
        inset: 0;
        background: rgba(0, 0, 0, 0.6);
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 1000;
        opacity: 0;
        pointer-events: none;
        transition: opacity 0.3s ease;
    }

    .modal-overlay.active {
        opacity: 1;
        pointer-events: auto;
    }

    .modal-content {
        width: 95%;
        max-width: 400px;
        background: white;
        border-radius: 20px;
        padding: 28px 20px;
        box-shadow: 0 10px 35px rgba(0, 0, 0, 0.2);
        text-align: center;
    }

    .modal-content h2 {
        font-size: 22px;
        color: #2563eb;
        font-weight: 700;
        margin-bottom: 15px;
    }

    .collected-amount {
        font-size: 26px;
        color: #10b981;
        font-weight: bold;
        margin-bottom: 24px;
        opacity: 0;
        transform: translateY(15px);
        transition: opacity 0.4s ease, transform 0.4s ease;
    }

    .collected-amount.visible {
        opacity: 1;
        transform: translateY(0);
    }

    .gift-box {
        width: 120px;
        height: 120px;
        margin: 0 auto 25px;
        background: url('https://pngimg.com/d/gift_PNG100280.png') no-repeat center/contain;
        position: relative;
        cursor: pointer;
    }

    .gift-box::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 120px;
        height: 120px;
        background: url('https://pngimg.com/d/gift_PNG5946.png') no-repeat center/contain;
        transform-origin: bottom center;
        transition: transform 1s ease;
        z-index: 10;
    }

    .gift-box.open::before {
        transform: rotateX(-100deg);
    }

    .gift-box.open {
        animation: bounceOpen 0.5s ease forwards;
    }

    @keyframes bounceOpen {
        0% { transform: scale(1); }
        50% { transform: scale(1.1) translateY(-5px); }
        100% { transform: scale(1); }
    }

    .modal-collect-btn {
        background-color: #10b981;
        border: none;
        padding: 12px 24px;
        border-radius: 30px;
        font-size: 16px;
        font-weight: bold;
        color: white;
        width: 100%;
        max-width: 280px;
        margin: 0 auto;
        box-shadow: 0 6px 15px rgba(16, 185, 129, 0.4);
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .modal-collect-btn:hover:not(:disabled) {
        background-color: #059669;
    }

    .modal-collect-btn:disabled {
        background-color: #94a3b8;
        cursor: not-allowed;
        box-shadow: none;
    }

    .container {
        width: 95%;
        max-width: 960px;
        margin: 30px auto;
        padding: 0 10px;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        background: white;
        font-size: 14px;
    }

    th, td {
        padding: 10px 12px;
        border: 1px solid #d1d5db;
    }

    th {
        background-color: #f3f4f6;
        font-weight: bold;
        text-align: left;
    }

    @media (max-width: 500px) {
        .modal-content h2 {
            font-size: 20px;
        }

        .collected-amount {
            font-size: 22px;
        }

        .gift-box {
            width: 100px;
            height: 100px;
        }

        .gift-box::before {
            width: 100px;
            height: 100px;
        }

        .modal-collect-btn {
            font-size: 15px;
        }
    }
</style>

<div class="mining-box">
    <p><strong>Collectable Balance:</strong> ৳<?php echo e(number_format($pendingAmount, 2)); ?></p>
    <p><strong>Mining :</strong></p>
    <div class="progress-bar-container">
        <div class="progress-bar-fill" id="progress-bar"></div>
    </div>
</div>

<?php if($pendingAmount > 0): ?>
<div class="modal-overlay active" id="gift-modal" role="dialog" aria-modal="true">
    <div class="modal-content">
        <h2>You have a gift!</h2>

        <div class="collected-amount" id="collected-amount">৳<?php echo e(number_format($pendingAmount, 2)); ?></div>

        <div class="gift-box" id="gift-box" tabindex="0" aria-label="Gift box, click to open"></div>

        <form method="POST" action="<?php echo e(route('mining.collect')); ?>">
            <?php echo csrf_field(); ?>
            <button
                type="submit"
                class="modal-collect-btn"
                id="collect-btn"
                disabled
            >
                Collect
            </button>
        </form>
    </div>
</div>
<?php endif; ?>

<div class="container">
    <h2 style="margin-bottom: 16px;">Earnings History</h2>
    <table>
        <thead>
            <tr>
                <th>Amount</th>
                <th>Type</th>
                <th>Time</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $allHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td>৳<?php echo e(number_format($history->earned_amount, 2)); ?></td>
                    <td><?php echo e(ucfirst($history->type)); ?></td>  
                    <td><?php echo e(date('d M Y, h:i A', strtotime($history->collected_at))); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="3" class="text-center">No earnings history found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<script>
    const nextEarningTime = new Date("<?php echo e($nextEarningTime->format('Y-m-d H:i:s')); ?>").getTime();
    const progressBar = document.getElementById('progress-bar');
    const totalDuration = 3600; // seconds
    let interval;

    function updateProgress() {
        const now = new Date().getTime();
        let distance = (nextEarningTime - now) / 1000;

        if (distance <= 0) {
            progressBar.style.width = '100%';
            clearInterval(interval);
            return;
        }

        let progressPercent = ((totalDuration - distance) / totalDuration) * 100;
        progressBar.style.width = progressPercent + '%';
    }

    updateProgress();
    interval = setInterval(updateProgress, 1000);

    <?php if($pendingAmount > 0): ?>
    const giftBox = document.getElementById('gift-box');
    const collectBtn = document.getElementById('collect-btn');
    const collectedAmountEl = document.getElementById('collected-amount');

    collectedAmountEl.classList.remove('visible');
    collectBtn.disabled = true;

    function openGiftBox() {
        giftBox.classList.add('open');
        setTimeout(() => {
            collectedAmountEl.classList.add('visible');
            collectBtn.disabled = false;
        }, 1000);
    }

    giftBox.addEventListener('click', () => {
        if (collectBtn.disabled) openGiftBox();
    });

    giftBox.addEventListener('keydown', (e) => {
        if ((e.key === "Enter" || e.key === " ") && collectBtn.disabled) {
            e.preventDefault();
            openGiftBox();
        }
    });
    <?php endif; ?>
</script>

<?php echo $__env->make('user.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/botpaysh/aruu.bot-pay.shop/resources/views/user/mining.blade.php ENDPATH**/ ?>