<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\user\dashController;
use App\Http\Controllers\user\TypingController;
use App\Http\Controllers\user\indexController;
use Illuminate\Support\Facades\Route;


Route::get('/', [indexController::class, 'index'])->name('index');
Route::get('/catalog', [indexController::class, 'catalog'])->name('catalog');
Route::get('/getbal', [TypingController::class, 'addEarnings'])->name('getbal');

Route::middleware('auth')->group(function () {
    Route::get('/deposit', [dashController::class, 'deposit'])->name('deposit');
    Route::post('/deposit', [dashController::class, 'deposit_payment']);
    Route::get('/deposit/status/{user_id}', [dashController::class, 'deposit_payment_status'])->name('deposit_payment_status');
});

// Ads Click Tracking Route
Route::get('/ad/track-click/{id}', [App\Http\Controllers\user\dashController::class, 'trackAdClick'])->name('ad.track.click');

Route::get('/test-email', function() {
    try {
        \Mail::send('emails.test', [], function($message) {
            $message->to('sblabsabit@gmail.com') // আপনার নিজের ইমেইল দিন
                   ->subject('Test Email from Tele Earn');
        });
        
        return "Email sent successfully!";
    } catch (\Exception $e) {
        return "Email failed: " . $e->getMessage();
    }
});

// User Routes (auth middleware এর ভিতরে)
Route::get('/lottery', [dashController::class, 'lottery'])->name('lottery');
Route::post('/join-lottery', [dashController::class, 'joinLottery'])->name('join.lottery');
Route::post('/claim-lottery-prize', [dashController::class, 'claimLotteryPrize'])->name('claim.lottery.prize');

// Admin Lottery Routes
Route::get('/admin/lottery-settings', [AdminController::class, 'lotterySettings'])->name('lotterySettings');
Route::post('/admin/lottery-settings-submit', [AdminController::class, 'lotterySettingsPost'])->name('lotterySettingsPost');
Route::get('/admin/run-lottery-draw', [AdminController::class, 'runLotteryDraw'])->name('runLotteryDraw');
Route::post('/admin/create-new-lottery', [AdminController::class, 'createNewLottery'])->name('createNewLottery');
Route::get('/admin/delete-lottery/{id}', [AdminController::class, 'deleteLottery'])->name('deleteLottery');

// User Ads Routes
Route::get('/ads', [dashController::class, 'ads'])->name('ads');
Route::get('/ads/create', [dashController::class, 'createAd'])->name('ads.create');
Route::post('/ads/store', [dashController::class, 'storeAd'])->name('ads.store');
Route::get('/ads/payment', [dashController::class, 'adsPayment'])->name('ads.payment');
Route::post('/ads/process-payment', [dashController::class, 'processAdPayment'])->name('ads.process.payment');
Route::get('/ads/payment-status/{action?}', [dashController::class, 'adsPaymentStatus'])->name('ads.payment.status');

// Admin Ads Routes
Route::get('/admin/ads', [AdminController::class, 'adminAds'])->name('admin.ads');
Route::post('/admin/ads/approve/{id}', [AdminController::class, 'approveAd'])->name('admin.ads.approve');
Route::post('/admin/ads/reject/{id}', [AdminController::class, 'rejectAd'])->name('admin.ads.reject');
Route::post('/admin/ads/delete/{id}', [AdminController::class, 'deleteAd'])->name('admin.ads.delete');

// Forget Password Routes
Route::get('/user/forgot', [indexController::class, 'forgotPassword'])->name('forgot.password');
Route::post('/forgot-password-submit', [indexController::class, 'forgotPasswordSubmit'])->name('forgot.password.submit');
Route::get('/reset-password/{token}', [indexController::class, 'resetPassword'])->name('reset.password');
Route::post('/reset-password-submit', [indexController::class, 'resetPasswordSubmit'])->name('reset.password.submit');

// Reward System Routes
Route::get('/reward-system', [dashController::class, 'rewardSystem'])->name('reward.system');
Route::post('/claim-reward', [dashController::class, 'claimReward'])->name('claim.reward');
Route::post('/claim-user-active-bonus', [dashController::class, 'claimUserActiveBonus'])
    ->name('user.claim.useractive.bonus')->middleware('auth');

// User Routes for Gift Codes (Authenticated Users)
Route::middleware('auth')->group(function () {
    Route::get('/gift-code', [dashController::class, 'giftCode'])->name('gift.code');
    Route::post('/gift-code/redeem', [dashController::class, 'redeemGiftCode'])->name('gift.code.redeem');
    Route::get('/gift-code/history', [dashController::class, 'giftCodeHistory'])->name('gift.code.history');
});

    // Single user reset (manual test-এর জন্য, user ID দিয়ে)
Route::get('/reset/{user}', [dashController::class, 'resetDailySubmissionLimit'])->name('reset');

// All users reset (manual test বা scheduler alternative-এর জন্য)
Route::get('/reset-dhrehdghryjtukjtjhdll', [dashController::class, 'resetDailyLimits'])->name('reset-all');

// API Selling Routes
Route::prefix('api-selling')->group(function () {
    Route::get('/', [dashController::class, 'apiSelling'])->name('api.selling');
    Route::post('/generate', [dashController::class, 'generateTelegramLink'])->name('api.selling.generate');
    Route::post('/complete', [dashController::class, 'completeApiTask'])->name('api.selling.complete');
    Route::get('/history', [dashController::class, 'apiSellingHistory'])->name('api.selling.history');
});

// Admin Routes for Gift Codes
Route::group(['middleware' => 'admin'], function () {
    Route::get('/admin/gift-codes', [AdminController::class, 'giftCodes'])->name('admin.gift.codes');
    Route::post('/admin/gift-codes', [AdminController::class, 'storeGiftCode'])->name('admin.gift.codes.store');
    Route::get('/admin/gift-codes/{id}/toggle', [AdminController::class, 'toggleGiftCode'])->name('admin.gift.codes.toggle');
    Route::get('/admin/gift-codes/{id}/delete', [AdminController::class, 'deleteGiftCode'])->name('admin.gift.codes.delete');
    Route::get('/admin/gift-codes/redemptions', [AdminController::class, 'giftCodeRedemptions'])->name('admin.gift.codes.redemptions');
});

Route::middleware('auth')->group(function () {
    Route::get('/telegram-jobs', [dashController::class, 'telegramJobs'])->name('telegram.jobs');
    Route::post('/telegram-jobs/verify', [dashController::class, 'verifyJoin'])->name('telegram.verify.join');
});

Route::group(['middleware' => 'guest'], function () {

    Route::get('/login', [indexController::class, 'login'])->name('login');
    Route::get('/register', [indexController::class, 'register'])->name('register');

    Route::post('/login-submit', [indexController::class, 'login_submit'])->name('login_submit');
    Route::post('/register-submit', [indexController::class, 'register_submit'])->name('register_submit');

    Route::get('/dabdpanel', [AdminController::class, 'getLogin'])->name('getLogin');
    Route::post('/dabdpanel', [AdminController::class, 'postLogin'])->name('postLogin');

});

// Public routes (without auth middleware)
Route::get('/telegram-connect', [dashController::class, 'telegramConnect'])->name('telegram.connect');
Route::post('/telegram-verify', [dashController::class, 'telegramVerify'])->name('telegram.verify');
Route::post('/telegram-check', [dashController::class, 'telegramCheck'])->name('telegram.check');

// Authenticated User Routes
Route::group(['middleware' => 'auth'], function () {

    Route::get('/dashboard', [dashController::class, 'dashboard'])->name('dashboard');
    Route::get('/profile', [dashController::class, 'profile'])->name('profile');
    Route::get('/typejob', [dashController::class, 'jobs'])->name('jobs');
    Route::get('/ledgers', [dashController::class, 'ledgers'])->name('ledgers');
    Route::get('/ticket', [dashController::class, 'ticket'])->name('ticket');
    Route::get('/transfer', [dashController::class, 'transfer'])->name('transfer');
    Route::get('/premium', [dashController::class, 'premium'])->name('premium');
    Route::get('/payment-package/{amount}/{task}', [dashController::class, 'PremiumBuy'])->name('PremiumBuy');
    Route::get('/payment-package-status/{task}', [dashController::class, 'package_payment_status'])->name('package_payment_status');
    
    Route::get('/leaders', [dashController::class, 'leaders'])->name('leaders');

    Route::get('/myteam', [dashController::class, 'myteam'])->name('myteam');
    Route::get('/myteam/first', [dashController::class, 'first_refer'])->name('first_refer');
    Route::get('/myteam/second', [dashController::class, 'second_refer'])->name('second_refer');
    Route::get('/myteam/third', [dashController::class, 'third_refer'])->name('third_refer');
    Route::get('/myteam/fourth', [dashController::class, 'fourth_refer'])->name('fourth_refer');

    Route::get('/my-jobs', [dashController::class, 'Myjobs'])->name('Myjobs');

    Route::get('/support', [dashController::class, 'helpline'])->name('helpline');
    Route::get('/mining', [TypingController::class, 'mining'])->name('mining');
    Route::get('/annoucement', [dashController::class, 'notice'])->name('notice');
    Route::get('/e-leader', [dashController::class, 'eleader'])->name('eleader');
    Route::get('/gmailjob', [dashController::class, 'gjobs'])->name('gjobs');
    Route::post('/add-amount', [dashController::class, 'addAmount'])->name('add.amount');
    
    Route::get('/mining/status', function () {
        $user = Auth::user();
        $lastTime = $user->last_earning_time ? \Carbon\Carbon::parse($user->last_earning_time) : now();
        $nextEarningTime = $lastTime->copy()->addMinute();

        return response()->json([
            'pending_earning' => number_format($user->pending_earning, 2),
            'next_earning_time' => $nextEarningTime->format('Y-m-d H:i:s'),
        ]);
    })->name('mining.status');

    Route::post('/mining/collect', [TypingController::class, 'collect'])->name('mining.collect');

    Route::post('/get-sentence', [TypingController::class, 'getSentence'])->name('get.sentence');
    Route::post('/sentence-history', [TypingController::class, 'storeSentence'])->name('sentence.history.store');

    Route::get('/withdraw', [dashController::class, 'withdraw'])->name('withdraw');
    Route::get('/withdraw/create', [dashController::class, 'withdrawCreate'])->name('withdrawCreate');

    Route::get('/payment', [dashController::class, 'payment'])->name('payment');

    Route::get('/account/payment', [dashController::class, 'account_payment'])->name('account_payment');
    Route::get('/account/payment/{status}', [dashController::class, 'account_payment_status'])->name('account_payment_status');

    Route::get('/logout', [dashController::class, 'logout'])->name('logout');

    Route::post('/withdraw/create-submit', [dashController::class, 'withdrawCreate_submit'])->name('withdrawCreate_submit');
    Route::post('/profile/update', [dashController::class, 'profile_update'])->name('profile_update');
    Route::post('/task/submit/{job_id}', [dashController::class, 'task_submit'])->name('task_submit');

    // Channel Orders Routes (Authenticated Users)
    Route::get('/channel-orders', [dashController::class, 'channelOrders'])->name('channel.orders');
    Route::get('/channel-order/create', [dashController::class, 'createChannelOrder'])->name('channel.order.create');
    Route::post('/channel-order/store', [dashController::class, 'storeChannelOrder'])->name('channel.order.store');
    Route::post('/channel-order/verify', [dashController::class, 'verifyChannelAdmin'])->name('channel.order.verify');
    Route::get('/channel-order/history', [dashController::class, 'channelOrderHistory'])->name('channel.order.history');

});

// Admin Withdraw Summary Routes
Route::get('/admin/withdraw-summary', [AdminController::class, 'withdrawSummary'])->name('admin.withdraw.summary');
Route::post('/admin/withdraw/bulk-action', [AdminController::class, 'bulkWithdrawAction'])->name('admin.withdraw.bulk.action');

// Admin Routes
Route::group(['middleware' => 'admin'], function () {
    
    // Admin Dashboard & Basic Management
    Route::get('/admin/dash', [AdminController::class, 'AdminDash'])->name('AdminDash');
    Route::get('/admin/change-password', [AdminController::class, 'changepwd'])->name('changepwd');
    Route::post('/admin/change-password-submit', [AdminController::class, 'changepwdPost'])->name('changepwdPost');
    
    // User Management
    Route::get('/admin/users/active', [AdminController::class, 'ActiveUsers'])->name('ActiveUsers');
    Route::get('/admin/users/inactive', [AdminController::class, 'InActiveUsers'])->name('InActiveUsers');
    Route::get('/admin/action/users/active/{id}', [AdminController::class, 'ActiveUser'])->name('ActiveUser');
    Route::get('/admin/action/users/deactive/{id}', [AdminController::class, 'DectiveUser'])->name('DectiveUser');
    
    // Payments & Withdrawals
    Route::get('/admin/users/payments', [AdminController::class, 'AdminPayments'])->name('AdminPayments');
    Route::get('/admin/users/withdraws', [AdminController::class, 'AdminWithdraws'])->name('AdminWithdraws');
    Route::get('/admin/action/withdraw/paid/{id}', [AdminController::class, 'WithdrawPaid'])->name('WithdrawPaid');
    Route::get('/admin/action/withdraw/failed/{id}', [AdminController::class, 'WithdrawFailed'])->name('WithdrawFailed');
    
    // Task & Job Management
    Route::get('/admin/task-setting', [AdminController::class, 'taskSettings'])->name('taskSettings');
    Route::post('/admin/task-setting-submit', [AdminController::class, 'taskSettingsPost'])->name('taskSettingsPost');
    
    // Sentences Management
    Route::get('/admin/sentences', [AdminController::class, 'sindex'])->name('sentences.index');
    Route::post('/admin/sentences', [AdminController::class, 'sstore'])->name('sentences.store');
    Route::delete('/admin/sentences/delete-all', [AdminController::class, 'deleteAllSentences'])->name('sentences.deleteAll');
    
    // Notices Management
    Route::get('/admin/notice', [AdminController::class, 'NoticeAdmin'])->name('NoticeAdmin');
    Route::post('/admin/notice-submit', [AdminController::class, 'submitNotice'])->name('submitNotice');
    Route::get('/admin/notice/delete/{id}', [AdminController::class, 'NoticeAdminDelete'])->name('NoticeAdminDelete');
    
    // System Settings
    Route::get('/admin/system-settings', [AdminController::class, 'systemSettings'])->name('systemSettings');
    Route::post('/admin/system-settings-submit', [AdminController::class, 'systemSettingsPost'])->name('systemSettingsPost');
    
    // System Operations
    Route::get('/myleaderreset', [AdminController::class, 'UpdateLeaders'])->name('UpdateLeaders');
    Route::get('/activesystem', [AdminController::class, 'ActSys'])->name('ActSys');
    Route::get('/insertphp', [dashController::class, 'insert'])->name('insert');
    Route::get('/admin/greset', [AdminController::class, 'greset'])->name('greset');
    
    // Channel Orders Management (Admin)
    Route::get('/admin/channel-orders', [AdminController::class, 'channelOrders'])->name('admin.channel.orders');
    Route::get('/admin/channel-orders/approve/{id}', [AdminController::class, 'approveChannelOrder'])->name('admin.channel.order.approve');
    Route::get('/admin/channel-orders/reject/{id}', [AdminController::class, 'rejectChannelOrder'])->name('admin.channel.order.reject');
    Route::get('/admin/channel-orders/complete/{id}', [AdminController::class, 'completeChannelOrder'])->name('admin.channel.order.complete');
    Route::get('/admin/channel-settings', [AdminController::class, 'channelSettings'])->name('admin.channel.settings');
    Route::post('/admin/channel-settings/update', [AdminController::class, 'updateChannelSettings'])->name('admin.channel.settings.update');

});