@include('user.layout.header')

<style>
    /* Premium Ad Card Styles */
    .premium-ad-card {
        background: white;
        border-radius: 16px;
        padding: 10px;
        margin: 15px auto;
        position: relative;
        overflow: hidden;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        border: 1px solid rgba(0, 0, 0, 0.04);
        display: flex;
        align-items: center;
        gap: 12px;
        max-width: 100%;
        transition: transform 0.2s ease, box-shadow 0.2s ease;
        text-decoration: none; /* Remove underline from link */
    }

    /* Hover Effect */
    .premium-ad-card:active {
        transform: scale(0.98);
    }

    /* Shining Animation Effect (Eye Catcher) */
    .premium-ad-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 50%;
        height: 100%;
        background: linear-gradient(to right, transparent, rgba(255, 255, 255, 0.8), transparent);
        transform: skewX(-25deg);
        animation: shine 3s infinite;
        pointer-events: none;
    }

    @keyframes shine {
        100% { left: 200%; }
    }

    /* Label Badge */
    .ad-badge {
        position: absolute;
        top: 0;
        left: 0;
        background: linear-gradient(135deg, #FF9800 0%, #F57C00 100%);
        color: white;
        font-size: 9px;
        font-weight: 700;
        padding: 2px 8px;
        border-bottom-right-radius: 8px;
        border-top-left-radius: 16px; /* Matches card corner */
        z-index: 2;
        letter-spacing: 0.5px;
    }

    /* Image Styling */
    .ad-image-wrapper {
        width: 80px; /* Fixed width for consistency */
        height: 60px; /* Compact height */
        border-radius: 10px;
        overflow: hidden;
        flex-shrink: 0;
        background: #f0f0f0;
    }

    .ad-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    /* Content Styling */
    .ad-content {
        flex: 1;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .ad-title {
        font-size: 14px;
        font-weight: 600;
        color: #1f2937;
        margin-bottom: 2px;
        line-height: 1.2;
    }

    .ad-cta {
        font-size: 11px;
        color: #229ED9; /* Telegram Blue */
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 4px;
    }
    
    .ad-arrow-icon {
        width: 18px;
        height: 18px;
        background: #e0f2fe;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 10px;
    }
</style>

@php
    $activeAd = \App\Models\Ad::active()->first();
    
    // যখনি অ্যাডটি লোড হবে, ভিউ বা ইম্প্রেশন ১ বাড়বে
    if($activeAd){
        $activeAd->increment('views');
    }
@endphp

@if($activeAd)
    {{-- Active Ad Section --}}
    <a href="{{ route('ad.track.click', $activeAd->id) }}" target="_blank" class="premium-ad-card">
        <span class="ad-badge">SPONSORED</span>
        
        <div class="ad-image-wrapper">
            <img src="{{ asset('ads_images/' . $activeAd->image) }}" alt="{{ $activeAd->ad_name ?: 'Exclusive Offer For You' }}" class="ad-image">
        </div>
        
        <div class="ad-content">
            {{-- এই লাইনটি আপডেট করা হয়েছে --}}
            <div class="ad-title">{{ $activeAd->ad_name ?: 'Exclusive Offer For You' }}</div>
            
            <div class="ad-cta">
                Click to View 
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
@else
    {{-- Default/Fallback Section --}}
    <a href="/ads/create" target="_blank" class="premium-ad-card">
        <span class="ad-badge">Ads Offer</span>
        
        <div class="ad-image-wrapper">
            <img src="{{ asset('ads_images/ads.jpg') }}" alt="Offer" class="ad-image">
        </div>
        
        <div class="ad-content">
            <div class="ad-title">Run Your Ads And Grow Your Team</div>
            <div class="ad-cta">
                Click to Run
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
@endif
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8">

            <div class="card shadow-sm border-0 rounded-3 mb-4">
                <div class="card-body p-4 d-flex justify-content-between align-items-center">
                    <h4 class="text-primary mb-0 fw-bold"> All Withdrawals</h4>
                    </div>
            </div>

            <div class="card shadow-sm border-0 rounded-3">
                <div class="card-body p-0"> <div class="table-responsive rounded-3">
                        <table class="table table-hover text-center align-middle mb-0 withdraw-table">
                            
                            <thead class="table-light">
                                <tr>
                                    <th scope="col" class="py-3 px-2 text-uppercase fw-semibold text-muted">Date</th>
                                    <th scope="col" class="py-3 px-2 text-uppercase fw-semibold text-muted">Amount</th>
                                    <th scope="col" class="py-3 px-2 text-uppercase fw-semibold text-muted">Charge</th>
                                    <th scope="col" class="py-3 px-2 text-uppercase fw-semibold text-muted">Total</th>
                                    <th scope="col" class="py-3 px-2 text-uppercase fw-semibold text-muted">Operator</th>
                                    <th scope="col" class="py-3 px-2 text-uppercase fw-semibold text-muted">Status</th>
                                </tr>
                            </thead>

                            <tbody>
                                @forelse($data as $item)
                                    <tr>
                                        <td class="py-3">{{ \Carbon\Carbon::parse($item->created_at)->format('d M, Y') }}</td>
                                        
                                        <td>{{ number_format($item->amount, 2) }}</td>
                                        
                                        <td>{{ number_format($item->charges, 2) }}</td>
                                                                                
                                        <td>{{ number_format($item->amount + $item->charges, 2) }}</td>
                                        
                                        <td>{{ $item->method }}</td>
                                        
                                        <td>
    @if($item->status == "Success")
        {{-- সফল (Success) - সবুজ রঙ --}}
        <span class="badge rounded-pill bg-success text-white px-3 py-2" style="min-width: 80px;">
            Success
        </span>
    @elseif($item->status == "Pending")
        {{-- অপেক্ষমান (Pending) - নীল বা আকাশি রঙ (Info/Primary) --}}
        <span class="badge rounded-pill bg-info text-dark px-3 py-2" style="min-width: 80px;">
            Pending
        </span>
    @elseif($item->status == "Hold")
        {{-- স্থগিত (Hold) - হলুদ রঙ (Warning) --}}
        <span class="badge rounded-pill bg-warning text-dark px-3 py-2" style="min-width: 80px;">
            Hold
        </span>
                <p class="mt-2 text-warning small">
          আপনি সফটওয়্যার আপডেট কালীন সময়ে উইথড্র দিয়েছেন যার কারণে আপনার ওই Withdraw টি হোল্ড করা হয়েছে। এই উইদ্রটা তিন থেকে সাত কার্য দিবসের ভিতরে পাবেন।
        </p>
    @else
        {{-- ব্যর্থ (Failed) - লাল রঙ --}}
        <span class="badge rounded-pill bg-danger text-white px-3 py-2" style="min-width: 80px;">
            Failed
        </span>
        <p class="mt-2 text-danger small">
            আজকের সব Withdraw Failed হয়েছে তাই আপনারটাও Failed করা হয়েছে। ২টা রেফার করে আবার চেষ্টা করুন।
        </p>
    @endif
</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-muted py-5 text-center">
                                            <h6 class="mb-0">No withdrawal records found.</h6>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>

                        </table>
                    </div>
                </div>
            </div> </div> </div> </div> @include('user.layout.footer')