@extends('user.layout.header')
<br><br>
@section('title', 'Telegram Jobs')
<!-- CSRF Token -->
<meta name="csrf-token" content="{{ csrf_token() }}">
<style>
    .telegram-job-card {
        background: linear-gradient(135deg, #0088cc, #00a2e8);
        border-radius: 18px;
        padding: 25px;
        color: white;
        margin-bottom: 20px;
        box-shadow: 0 10px 30px rgba(0, 136, 204, 0.3);
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }
    .telegram-job-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 35px rgba(0, 136, 204, 0.4);
    }
    .telegram-job-card::before {
        content: '';
        position: absolute;
        top: 0; left: 0;
        width: 100%; height: 5px;
        background: linear-gradient(90deg, #ffd700, #ff6b6b);
    }
    .channel-title {
        font-size: 1.4rem;
        font-weight: 700;
        margin-bottom: 8px;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    .earning-badge {
        background: rgba(255, 255, 255, 0.2);
        padding: 5px 12px;
        border-radius: 20px;
        font-size: 0.9rem;
        font-weight: bold;
        backdrop-filter: blur(5px);
    }
    .action-buttons {
        display: flex;
        gap: 12px;
        margin-top: 15px;
        flex-wrap: wrap;
    }
    .btn-join, .btn-verify {
        padding: 10px 20px;
        border-radius: 25px;
        font-weight: bold;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        transition: all 0.3s ease;
        font-size: 0.95rem;
    }
    .btn-join {
        background: white;
        color: #0088cc;
    }
    .btn-join:hover {
        background: #f0f0f0;
        transform: translateY(-2px);
    }
    .btn-verify {
        background: rgba(255, 255, 255, 0.2);
        color: white;
        border: 2px solid white;
    }
    .btn-verify:hover:not(:disabled) {
        background: white;
        color: #0088cc;
    }
    .btn-verify:disabled {
        opacity: 0.6;
        cursor: not-allowed;
        background: rgba(255, 255, 255, 0.1);
        border-color: rgba(255, 255, 255, 0.5);
    }
    .loader {
        width: 16px;
        height: 16px;
        border: 2px solid white;
        border-top: 2px solid transparent;
        border-radius: 50%;
        animation: spin 0.8s linear infinite;
        display: none;
        margin-left: 8px;
    }
    @keyframes spin {
        to { transform: rotate(360deg); }
    }
    .connect-telegram-box {
        text-align: center;
        padding: 40px 20px;
        background: linear-gradient(135deg, #ff6b6b, #ee5a24);
        border-radius: 20px;
        color: white;
        box-shadow: 0 10px 30px rgba(238, 90, 36, 0.3);
    }
    .connect-telegram-box h2 {
        font-size: 1.8rem;
        margin-bottom: 15px;
    }
    .btn-connect {
        background: white;
        color: #ee5a24;
        padding: 14px 30px;
        border-radius: 30px;
        font-weight: bold;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 10px;
        margin-top: 15px;
        font-size: 1.1rem;
    }
    .btn-connect:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(255,255,255,0.3);
    }
    .custom-toast {
        position: fixed;
        bottom: 20px;
        right: 20px;
        background: #28a745;
        color: white;
        padding: 14px 24px;
        border-radius: 12px;
        z-index: 9999;
        font-weight: 600;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        font-size: 15px;
        max-width: 300px;
        word-wrap: break-word;
        opacity: 1;
        transform: translateX(0);
        transition: all 0.4s ease;
    }
    .custom-toast.error {
        background: #dc3545;
    }
    .custom-toast i {
        margin-right: 8px;
    }
    /* Enhanced Empty State Design */
    .empty-state-container {
        text-align: center;
        padding: 60px 30px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 25px;
        color: white;
        box-shadow: 0 15px 35px rgba(102, 126, 234, 0.3);
        margin: 30px 0;
        position: relative;
        overflow: hidden;
    }
    .empty-state-container::before {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(255,255,255,0.1) 1px, transparent 1px);
        background-size: 20px 20px;
        animation: floatBackground 20s linear infinite;
        z-index: 1;
    }
    @keyframes floatBackground {
        0% { transform: translate(0, 0) rotate(0deg); }
        100% { transform: translate(-20px, -20px) rotate(360deg); }
    }
    .empty-state-icon {
        font-size: 80px;
        margin-bottom: 25px;
        display: inline-block;
        animation: bounce 2s ease-in-out infinite;
        position: relative;
        z-index: 2;
    }
    @keyframes bounce {
        0%, 100% { transform: translateY(0); }
        50% { transform: translateY(-15px); }
    }
    .empty-state-title {
        font-size: 2.2rem;
        font-weight: 700;
        margin-bottom: 15px;
        position: relative;
        z-index: 2;
        text-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
    }
    .empty-state-subtitle {
        font-size: 1.1rem;
        opacity: 0.9;
        margin-bottom: 30px;
        max-width: 500px;
        margin-left: auto;
        margin-right: auto;
        line-height: 1.6;
        position: relative;
        z-index: 2;
    }
    .empty-state-features {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 20px;
        margin: 35px 0;
        position: relative;
        z-index: 2;
    }
    .feature-card {
        background: rgba(255, 255, 255, 0.15);
        padding: 20px;
        border-radius: 15px;
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
        transition: all 0.3s ease;
    }
    .feature-card:hover {
        transform: translateY(-5px);
        background: rgba(255, 255, 255, 0.2);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
    }
    .feature-icon {
        font-size: 2rem;
        margin-bottom: 12px;
        display: block;
    }
    .feature-title {
        font-weight: 600;
        margin-bottom: 8px;
        font-size: 1.1rem;
    }
    .feature-description {
        font-size: 0.9rem;
        opacity: 0.8;
        line-height: 1.4;
    }
    .empty-state-actions {
        display: flex;
        gap: 15px;
        justify-content: center;
        flex-wrap: wrap;
        margin-top: 25px;
        position: relative;
        z-index: 2;
    }
    .btn-primary, .btn-secondary {
        padding: 14px 28px;
        border-radius: 30px;
        font-weight: 600;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 10px;
        transition: all 0.3s ease;
        font-size: 1rem;
        border: none;
        cursor: pointer;
    }
    .btn-primary {
        background: white;
        color: #667eea;
        box-shadow: 0 6px 20px rgba(255, 255, 255, 0.3);
    }
    .btn-primary:hover {
        transform: translateY(-3px);
        box-shadow: 0 10px 25px rgba(255, 255, 255, 0.4);
    }
    .btn-secondary {
        background: rgba(255, 255, 255, 0.2);
        color: white;
        border: 2px solid rgba(255, 255, 255, 0.5);
        backdrop-filter: blur(10px);
    }
    .btn-secondary:hover {
        background: rgba(255, 255, 255, 0.3);
        transform: translateY(-3px);
    }
    .countdown-timer {
        background: rgba(255, 255, 255, 0.15);
        padding: 15px 25px;
        border-radius: 15px;
        margin: 25px auto;
        max-width: 300px;
        backdrop-filter: blur(10px);
        position: relative;
        z-index: 2;
    }
    .timer-label {
        font-size: 0.9rem;
        opacity: 0.8;
        margin-bottom: 8px;
    }
    .timer-display {
        font-size: 1.4rem;
        font-weight: 700;
        font-family: 'Courier New', monospace;
    }
    /* Responsive Design */
    @media (max-width: 768px) {
        .empty-state-container {
            padding: 40px 20px;
            margin: 20px 0;
        }
       
        .empty-state-title {
            font-size: 1.8rem;
        }
       
        .empty-state-features {
            grid-template-columns: 1fr;
        }
       
        .empty-state-actions {
            flex-direction: column;
            align-items: center;
        }
       
        .btn-primary, .btn-secondary {
            width: 100%;
            max-width: 250px;
            justify-content: center;
        }
    }
</style>
<style>
    /* Premium Ad Card Styles */
    .premium-ad-card {
        background: white;
        border-radius: 16px;
        padding: 10px;
        margin: 15px auto;
        position: relative;
        overflow: hidden;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        border: 1px solid rgba(0, 0, 0, 0.04);
        display: flex;
        align-items: center;
        gap: 12px;
        max-width: 100%;
        transition: transform 0.2s ease, box-shadow 0.2s ease;
        text-decoration: none; /* Remove underline from link */
    }

    /* Hover Effect */
    .premium-ad-card:active {
        transform: scale(0.98);
    }

    /* Shining Animation Effect (Eye Catcher) */
    .premium-ad-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 50%;
        height: 100%;
        background: linear-gradient(to right, transparent, rgba(255, 255, 255, 0.8), transparent);
        transform: skewX(-25deg);
        animation: shine 3s infinite;
        pointer-events: none;
    }

    @keyframes shine {
        100% { left: 200%; }
    }

    /* Label Badge */
    .ad-badge {
        position: absolute;
        top: 0;
        left: 0;
        background: linear-gradient(135deg, #FF9800 0%, #F57C00 100%);
        color: white;
        font-size: 9px;
        font-weight: 700;
        padding: 2px 8px;
        border-bottom-right-radius: 8px;
        border-top-left-radius: 16px; /* Matches card corner */
        z-index: 2;
        letter-spacing: 0.5px;
    }

    /* Image Styling */
    .ad-image-wrapper {
        width: 80px; /* Fixed width for consistency */
        height: 60px; /* Compact height */
        border-radius: 10px;
        overflow: hidden;
        flex-shrink: 0;
        background: #f0f0f0;
    }

    .ad-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    /* Content Styling */
    .ad-content {
        flex: 1;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .ad-title {
        font-size: 14px;
        font-weight: 600;
        color: #1f2937;
        margin-bottom: 2px;
        line-height: 1.2;
    }

    .ad-cta {
        font-size: 11px;
        color: #229ED9; /* Telegram Blue */
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 4px;
    }
    
    .ad-arrow-icon {
        width: 18px;
        height: 18px;
        background: #e0f2fe;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 10px;
    }
</style>

@php
    $activeAd = \App\Models\Ad::active()->first();
    
    // যখনি অ্যাডটি লোড হবে, ভিউ বা ইম্প্রেশন ১ বাড়বে
    if($activeAd){
        $activeAd->increment('views');
    }
@endphp

@if($activeAd)
    {{-- Active Ad Section --}}
    <a href="{{ route('ad.track.click', $activeAd->id) }}" target="_blank" class="premium-ad-card">
        <span class="ad-badge">SPONSORED</span>
        
        <div class="ad-image-wrapper">
            <img src="{{ asset('ads_images/' . $activeAd->image) }}" alt="{{ $activeAd->ad_name ?: 'Exclusive Offer For You' }}" class="ad-image">
        </div>
        
        <div class="ad-content">
            {{-- এই লাইনটি আপডেট করা হয়েছে --}}
            <div class="ad-title">{{ $activeAd->ad_name ?: 'Exclusive Offer For You' }}</div>
            
            <div class="ad-cta">
                Click to View 
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
@else
    {{-- Default/Fallback Section --}}
    <a href="/ads/create" target="_blank" class="premium-ad-card">
        <span class="ad-badge">Ads Offer</span>
        
        <div class="ad-image-wrapper">
            <img src="{{ asset('ads_images/ads.jpg') }}" alt="Offer" class="ad-image">
        </div>
        
        <div class="ad-content">
            <div class="ad-title">Run Your Ads And Grow Your Team</div>
            <div class="ad-cta">
                Click to Run
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
@endif

<div class="col-lg-8">
    <h2 class="mb-4" style="color: #2c3e50; font-weight: 700;">
        Telegram Join & Earn
    </h2>
   
    @if($needsTelegram)
        <div class="connect-telegram-box">
            <i class="fab fa-telegram-plane" style="font-size: 60px; margin-bottom: 20px;"></i>
            <h2>Connect Your Telegram First!</h2>
            <p>To earn from Telegram tasks, you must connect your Telegram ID.</p>
            <a href="{{ route('telegram.connect') }}" class="btn-connect">
                <i class="fab fa-telegram-plane"></i> Connect Telegram ID
            </a>
        </div>
    @else
        @forelse($channels as $channel)
            @php
                $alreadyJoined = \App\Models\UserChannelJoin::where('user_id', auth()->id())
                    ->where('channel_order_id', $channel->id)->exists();
                $joined_count = \App\Models\UserChannelJoin::where('channel_order_id', $channel->id)
                    ->where('earned', true)->count();
                $earning = $channel->total_cost / max($channel->member_count, 1);
            @endphp
            @if(!$alreadyJoined && $joined_count < $channel->member_count)
            <div class="telegram-job-card">
                <div class="channel-title">
                    <i class="fab fa-telegram-plane"></i>
                    {{ '@' . ltrim($channel->channel_username, '@') }}
                </div>
                <div class="earning-badge">
                    Earn: ৳{{ number_format($earning, 2) }} per join
                </div>
                <p style="margin: 10px 0 0; opacity: 0.9; font-size: 0.95rem;">
                    Join the channel and verify to earn instantly!
                </p>
                <div class="action-buttons">
                    <a href="https://t.me/{{ ltrim($channel->channel_username, '@') }}" target="_blank" class="btn-join">
                        <i class="fas fa-external-link-alt"></i> Join Channel
                    </a>
                    <button
                        class="btn-verify {{ $alreadyJoined ? 'disabled' : '' }}"
                        onclick="verifyJoin({{ $channel->id }}, this)"
                        {{ $alreadyJoined ? 'disabled' : '' }}>
                        <span class="verify-text">
                            {{ $alreadyJoined ? 'Completed' : 'Verify Join' }}
                        </span>
                        <span class="loader"></span>
                    </button>
                </div>
            </div>
            @endif
        @empty
            <!-- Enhanced Empty State -->
            <div class="empty-state-container">
                <div class="empty-state-icon">
                    <i class="fab fa-telegram-plane"></i>
                </div>
               
                <h2 class="empty-state-title">No Active Tasks Available</h2>
               
                <p class="empty-state-subtitle">
                    Currently, there are no Telegram channels available for joining.
                    New earning opportunities are added regularly, so check back soon!
                </p>
                <!-- Countdown Timer for Next Update -->
                <div class="countdown-timer">
                    <div class="timer-label">Next update in:</div>
                    <div class="timer-display" id="countdown-timer">03:00:00</div>
                </div>
                <!-- Features Grid -->
                <div class="empty-state-features">
                    <div class="feature-card">
                        <i class="fas fa-sync-alt feature-icon"></i>
                        <div class="feature-title">Regular Updates</div>
                        <div class="feature-description">New channels added daily with fresh earning opportunities</div>
                    </div>
                   
                    <div class="feature-card">
                        <i class="fas fa-bolt feature-icon"></i>
                        <div class="feature-title">Instant Payout</div>
                        <div class="feature-description">Get paid immediately after successful verification</div>
                    </div>
                   
                    <div class="feature-card">
                        <i class="fas fa-users feature-icon"></i>
                        <div class="feature-title">Growing Community</div>
                        <div class="feature-description">Join thousands of users earning daily</div>
                    </div>
                </div>
                <!-- Action Buttons -->
                <div class="empty-state-actions">
                    <a href="{{ route('dashboard') }}" class="btn-primary">
                        <i class="fas fa-home"></i> Back to Dashboard
                    </a>
                    <button onclick="location.reload()" class="btn-secondary">
                        <i class="fas fa-redo"></i> Refresh Page
                    </button>
                </div>
            </div>
        @endforelse
    @endif
</div>
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Countdown Timer Functionality
    function startCountdown() {
        const timerElement = document.getElementById('countdown-timer');
        if (!timerElement) return;
        let timeLeft = 3 * 60 * 60; // 3 hours in seconds
       
        function updateTimer() {
            if (timeLeft <= 0) {
                timerElement.textContent = '00:00:00';
                location.reload(); // Auto-refresh when timer ends
                return;
            }
           
            const hours = Math.floor(timeLeft / 3600);
            const minutes = Math.floor((timeLeft % 3600) / 60);
            const seconds = timeLeft % 60;
           
            timerElement.textContent =
                `${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
           
            timeLeft--;
        }
       
        updateTimer(); // Initial call
        setInterval(updateTimer, 1000); // Update every second
    }
    // Start the countdown
    startCountdown();
    // Existing verification functionality
    window.verifyJoin = function(channelId, button) {
        const loader = button.querySelector('.loader');
        const text = button.querySelector('.verify-text');
        if (button.disabled) return;
        button.disabled = true;
        loader.style.display = 'inline-block';
        text.textContent = 'Checking...';
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        fetch("{{ route('telegram.verify.join') }}", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': csrfToken,
                'Accept': 'application/json'
            },
            body: JSON.stringify({ channel_id: channelId })
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('Server error: ' + response.status);
            }
            return response.json();
        })
        .then(data => {
            loader.style.display = 'none';
            if (data.success) {
                // Play success sound once on task completion
                const audio = new Audio("https://hgzy.zone-x.pro/public/sounds/5.mp3");
                audio.preload = 'auto';
                audio.volume = 1.0;
                audio.play().catch(e => console.log('Sound play failed:', e)); // Ignore autoplay errors
                button.innerHTML = '<i class="fas fa-check"></i> Completed';
                button.style.background = '#28a745';
                button.style.borderColor = '#28a745';
                button.disabled = true;
                showToast(`${data.message} | Balance: ৳${data.new_balance}`, 'success');
                setTimeout(() => location.reload(), 1500);
            } else {
                resetButton();
                showToast(data.message, 'error');
            }
        })
        .catch(err => {
            console.error('Fetch Error:', err);
            resetButton();
            showToast('Network error. Please refresh.', 'error');
        });
        function resetButton() {
            loader.style.display = 'none';
            text.textContent = 'Verify Join';
            button.disabled = false;
        }
    };
   
    window.showToast = function(message, type = 'success') {
        const old = document.querySelector('.custom-toast');
        if (old) old.remove();
        const toast = document.createElement('div');
        toast.className = `custom-toast ${type === 'error' ? 'error' : ''}`;
        toast.innerHTML = `<i class="fas ${type === 'success' ? 'fa-check-circle' : 'fa-exclamation-triangle'}"></i> ${message}`;
        document.body.appendChild(toast);
        setTimeout(() => {
            toast.style.opacity = '0';
            toast.style.transform = 'translateX(100%)';
            setTimeout(() => toast.remove(), 400);
        }, 3000);
    };
});
</script>
@include('user.layout.footer')