@include('user.layout.header')

<!-- ব্যাকগ্রাউন্ড কালার বা ইমেজ (গ্লাসমর্ফিজম বোঝার জন্য এটি জরুরি) -->
<style>
    body {
        /* টেলিগ্রাম বা আধুনিক অ্যাপের মতো একটি সফট ব্যাকগ্রাউন্ড */
        background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
        /* অথবা ডার্ক মোড চাইলে নিচের লাইনটি ব্যবহার করুন */
        /* background: linear-gradient(135deg, #0f2027 0%, #203a43 50%, #2c5364 100%); */
        min-height: 100vh;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* --- GLASSMORPHISM CARD BASE --- */
    .glass-panel {
        background: rgba(255, 255, 255, 0.7); /* সাদা স্বচ্ছ */
        backdrop-filter: blur(12px); /* ব্লার ইফেক্ট */
        -webkit-backdrop-filter: blur(12px);
        border: 1px solid rgba(255, 255, 255, 0.5);
        box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.1);
        border-radius: 20px;
    }

    /* --- Premium Ad Card Styles (Updated) --- */
    .premium-ad-card {
        padding: 12px;
        margin: 20px auto;
        position: relative;
        overflow: hidden;
        display: flex;
        align-items: center;
        gap: 15px;
        max-width: 100%;
        transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
        text-decoration: none;
        /* Glass Style Inherited via class or added here */
        background: rgba(255, 255, 255, 0.65);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.4);
        border-radius: 18px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.03);
    }

    .premium-ad-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 10px 25px rgba(34, 158, 217, 0.15); /* Telegram Blue glow */
        background: rgba(255, 255, 255, 0.85);
    }

    .premium-ad-card:active {
        transform: scale(0.98);
    }

    /* Shining Animation */
    .premium-ad-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 50%;
        height: 100%;
        background: linear-gradient(to right, transparent, rgba(255, 255, 255, 0.9), transparent);
        transform: skewX(-25deg);
        animation: shine 4s infinite;
        pointer-events: none;
    }

    @keyframes shine {
        0% { left: -100%; }
        20% { left: 200%; }
        100% { left: 200%; }
    }

    /* Label Badge */
    .ad-badge {
        position: absolute;
        top: 0;
        left: 0;
        background: linear-gradient(135deg, #2AABEE 0%, #229ED9 100%); /* Telegram Colors */
        color: white;
        font-size: 10px;
        font-weight: 700;
        padding: 4px 12px;
        border-bottom-right-radius: 12px;
        border-top-left-radius: 18px;
        z-index: 2;
        letter-spacing: 0.5px;
        box-shadow: 2px 2px 10px rgba(34, 158, 217, 0.3);
    }

    /* Image Styling */
    .ad-image-wrapper {
        width: 85px;
        height: 85px;
        border-radius: 14px;
        overflow: hidden;
        flex-shrink: 0;
        background: rgba(255, 255, 255, 0.5);
        box-shadow: inset 0 0 10px rgba(0,0,0,0.05);
    }

    .ad-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.3s ease;
    }
    .premium-ad-card:hover .ad-image {
        transform: scale(1.1);
    }

    /* Content Styling */
    .ad-content {
        flex: 1;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .ad-title {
        font-size: 16px;
        font-weight: 700;
        color: #333;
        margin-bottom: 5px;
        line-height: 1.3;
    }

    .ad-cta {
        font-size: 12px;
        color: #229ED9;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 6px;
    }

    .ad-arrow-icon {
        width: 22px;
        height: 22px;
        background: rgba(34, 158, 217, 0.1);
        color: #229ED9;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 10px;
        transition: all 0.3s ease;
    }
    .premium-ad-card:hover .ad-arrow-icon {
        background: #229ED9;
        color: white;
        transform: translateX(5px);
    }

    /* --- HEADER SECTION --- */
    .gen-member-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 10px 5px;
    }

    .gen-title {
        font-size: 22px;
        font-weight: 700;
        background: linear-gradient(135deg, #333 0%, #555 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        margin: 0;
    }

    .gen-back-btn {
        background: rgba(255, 255, 255, 0.5);
        backdrop-filter: blur(5px);
        padding: 8px 16px;
        border-radius: 20px;
        text-decoration: none;
        color: #333;
        font-weight: 600;
        font-size: 14px;
        border: 1px solid rgba(255, 255, 255, 0.6);
        transition: all 0.3s ease;
    }
    .gen-back-btn:hover {
        background: white;
        box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        color: #229ED9;
    }

    /* --- TABLE STYLES (Glassmorphism) --- */
    .gen-member-card {
        /* Glass class applied in HTML */
        padding: 20px;
        margin-bottom: 30px;
    }

    .gen-table-wrapper {
        overflow-x: auto;
    }

    .gen-member-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0 10px; /* Rows spacing */
    }

    .gen-member-table thead th {
        color: #666;
        font-size: 13px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 1px;
        padding: 0 15px 10px 15px;
        border: none;
        text-align: left;
    }

    .gen-member-table tbody tr {
        background: rgba(255, 255, 255, 0.4);
        transition: all 0.2s ease;
    }

    .gen-member-table tbody tr td {
        padding: 15px;
        font-size: 14px;
        color: #444;
        font-weight: 500;
        border-top: 1px solid rgba(255, 255, 255, 0.4);
        border-bottom: 1px solid rgba(255, 255, 255, 0.4);
    }

    /* Rounded corners for rows */
    .gen-member-table tbody tr td:first-child {
        border-top-left-radius: 12px;
        border-bottom-left-radius: 12px;
        border-left: 1px solid rgba(255, 255, 255, 0.4);
    }
    .gen-member-table tbody tr td:last-child {
        border-top-right-radius: 12px;
        border-bottom-right-radius: 12px;
        border-right: 1px solid rgba(255, 255, 255, 0.4);
    }

    .gen-member-table tbody tr:hover {
        background: rgba(255, 255, 255, 0.8);
        transform: scale(1.01);
        box-shadow: 0 5px 15px rgba(0,0,0,0.05);
    }

    /* Status Badges */
    .status-badge {
        padding: 5px 12px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 700;
        text-transform: uppercase;
    }

    .status-badge.active {
        background: rgba(0, 200, 81, 0.15);
        color: #007E33;
        border: 1px solid rgba(0, 200, 81, 0.2);
    }

    .status-badge.inactive {
        background: rgba(255, 68, 68, 0.15);
        color: #CC0000;
        border: 1px solid rgba(255, 68, 68, 0.2);
    }
</style>

<div class="container" style="padding-top: 30px;">
    <div class="row justify-content-center">
        <div class="col-lg-8">

            @php
    $activeAd = \App\Models\Ad::active()->first();
    
    // যখনি অ্যাডটি লোড হবে, ভিউ বা ইম্প্রেশন ১ বাড়বে
    if($activeAd){
        $activeAd->increment('views');
    }
@endphp

@if($activeAd)
    {{-- এখানে href পরিবর্তন করে আমাদের ট্র্যাকিং রাউট দেওয়া হয়েছে --}}
    <a href="{{ route('ad.track.click', $activeAd->id) }}" target="_blank" class="premium-ad-card">
        <span class="ad-badge">SPONSORED</span>
        
        <div class="ad-image-wrapper">
            <img src="{{ asset('ads_images/' . $activeAd->image) }}" alt="Offer" class="ad-image">
        </div>
        
        <div class="ad-content">
            <div class="ad-title">Exclusive Offer For You</div>
            <div class="ad-cta">
                Click to View 
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
@else
    <a href="/ads/create" target="_blank" class="premium-ad-card">
        <span class="ad-badge">Ads Offer</span>
        
        <div class="ad-image-wrapper">
            <img src="{{ asset('ads_images/ads.jpg') }}" alt="Offer" class="ad-image">
        </div>
        
        <div class="ad-content">
            <div class="ad-title">Run Your Ads And Grow Your Team</div>
            <div class="ad-cta">
                Click to Run
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
@endif

            {{-- MEMBER LIST HEADER --}}
            <div class="gen-member-header mb-3">
                <div class="gen-header-content">
                    <h2 class="gen-title">👥 My Team</h2>
                </div>
                <a href="{{ route('myteam') }}" class="gen-back-btn">
                    <i class="fas fa-arrow-left"></i> Back
                </a>
            </div>

            {{-- MEMBER TABLE CARD (GLASS) --}}
            <div class="glass-panel gen-member-card">
                <div class="gen-table-wrapper">
                    <table class="gen-member-table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Phone</th>
                                <th>Status</th>
                                <th>Joined</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($data as $item)
                                <tr>
                                    <td><b>#{{ $item->id }}</b></td>
                                    <td>{{ $item->fname }} {{ $item->lname }}</td>
                                    <td style="font-family: monospace; letter-spacing: 1px;">
                                        {{ substr($item->phone, 0, 4) . '••••' . substr($item->phone, -2) }}
                                    </td>
                                    <td>
                                        @if($item->user_active == 0)
                                            <span class="status-badge inactive">Inactive</span>
                                        @else
                                            <span class="status-badge active">Active</span>
                                        @endif
                                    </td>
                                    <td style="font-size: 12px; color: #666;">
                                        {{ $item->created_at->format('d M, Y') }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>
</div>

@include('user.layout.footer')