@include('user.layout.header')

<style>
    /* --- Telegram Light Theme Colors --- */
    :root {
        --tg-bg: #f1f2f6;       /* পেজ ব্যাকগ্রাউন্ড */
        --tg-card-bg: #ffffff;  /* কার্ড ব্যাকগ্রাউন্ড */
        --tg-blue: #3390ec;     /* টেলিগ্রাম ব্লু */
        --tg-text: #222222;     /* মেইন টেক্সট */
        --tg-gray: #707579;     /* হালকা টেক্সট */
        --tg-border: #dfe1e5;   /* বর্ডার কালার */
        --tg-hover: #f5f5f5;    /* হোভার এফেক্ট */
    }

    body {
        background-color: var(--tg-bg);
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
    }

    /* --- Premium Ad Card Styling --- */
    .premium-ad-card {
        background: var(--tg-card-bg);
        border-radius: 14px;
        padding: 12px;
        margin: 20px auto;
        position: relative;
        overflow: hidden;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
        border: 1px solid transparent;
        display: flex;
        align-items: center;
        gap: 15px;
        text-decoration: none !important;
        transition: all 0.2s ease;
    }

    .premium-ad-card:active { transform: scale(0.98); }
    .premium-ad-card:hover {
        border-color: rgba(51, 144, 236, 0.3);
        box-shadow: 0 4px 12px rgba(51, 144, 236, 0.1);
    }

    /* Shining Effect */
    .premium-ad-card::before {
        content: '';
        position: absolute;
        top: 0; left: -100%; width: 50%; height: 100%;
        background: linear-gradient(to right, transparent, rgba(255, 255, 255, 0.8), transparent);
        transform: skewX(-25deg);
        animation: shine 3s infinite;
        pointer-events: none;
    }
    @keyframes shine { 100% { left: 200%; } }

    /* Badge */
    .ad-badge {
        position: absolute;
        top: 0; right: 0;
        background: linear-gradient(135deg, #3390ec 0%, #0077b5 100%); /* Blue Gradient */
        color: white;
        font-size: 10px;
        font-weight: 700;
        padding: 3px 10px;
        border-bottom-left-radius: 10px;
        z-index: 2;
        letter-spacing: 0.5px;
    }

    /* Ad Image */
    .ad-image-wrapper {
        width: 70px; height: 70px;
        border-radius: 12px;
        overflow: hidden;
        flex-shrink: 0;
        background: #f0f0f0;
        border: 1px solid #eee;
    }
    .ad-image { width: 100%; height: 100%; object-fit: cover; }

    /* Ad Content */
    .ad-content { flex: 1; display: flex; flex-direction: column; justify-content: center; }
    .ad-title {
        font-size: 15px; font-weight: 600; color: var(--tg-text); margin-bottom: 3px;
    }
    .ad-cta {
        font-size: 13px; color: var(--tg-blue); font-weight: 500; display: flex; align-items: center; gap: 5px;
    }
    .ad-arrow-icon {
        width: 20px; height: 20px;
        background: #eef6fc;
        border-radius: 50%;
        display: flex; align-items: center; justify-content: center;
        font-size: 10px; color: var(--tg-blue);
    }


    /* --- Notice Board Styling (Telegram List Style) --- */
    .notice-section {
        background: var(--tg-card-bg);
        border-radius: 14px;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
        overflow: hidden;
        margin-top: 25px;
        padding-bottom: 10px;
    }

    .notice-header {
        padding: 15px 20px;
        border-bottom: 1px solid var(--tg-border);
        display: flex;
        align-items: center;
        gap: 10px;
    }
    .notice-header i { color: var(--tg-blue); font-size: 18px; }
    .notice-title { font-size: 16px; font-weight: 600; color: var(--tg-text); margin: 0; }

    /* Modern Table Design */
    .notice-table { width: 100%; margin-bottom: 0; }
    .notice-table thead th {
        background: #f9f9f9;
        color: var(--tg-gray);
        font-size: 12px;
        text-transform: uppercase;
        font-weight: 600;
        padding: 10px 20px;
        border: none;
        border-bottom: 1px solid var(--tg-border);
    }
    .notice-table tbody td {
        padding: 15px 20px;
        vertical-align: middle;
        border-bottom: 1px solid #f0f0f0;
    }
    .notice-table tbody tr:last-child td { border-bottom: none; }
    .notice-table tbody tr:hover { background-color: var(--tg-hover); }

    /* Specific Columns */
    .date-column {
        white-space: nowrap;
        color: var(--tg-gray);
        font-size: 12px;
        font-weight: 500;
    }
    .type-column {
        color: var(--tg-blue);
        font-weight: 600;
        font-size: 14px;
        margin-bottom: 2px;
        display: block;
    }
    .desc-column {
        color: var(--tg-text);
        font-size: 13px;
        line-height: 1.4;
    }
    
</style>

<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-lg-8 col-md-10 col-12">
            <br><br><br>

            @php
    $activeAd = \App\Models\Ad::active()->first();
    
    // যখনি অ্যাডটি লোড হবে, ভিউ বা ইম্প্রেশন ১ বাড়বে
    if($activeAd){
        $activeAd->increment('views');
    }
@endphp

@if($activeAd)
    {{-- Active Ad Section --}}
    <a href="{{ route('ad.track.click', $activeAd->id) }}" target="_blank" class="premium-ad-card">
        <span class="ad-badge">SPONSORED</span>
        
        <div class="ad-image-wrapper">
            <img src="{{ asset('ads_images/' . $activeAd->image) }}" alt="{{ $activeAd->ad_name ?: 'Exclusive Offer For You' }}" class="ad-image">
        </div>
        
        <div class="ad-content">
            {{-- এই লাইনটি আপডেট করা হয়েছে --}}
            <div class="ad-title">{{ $activeAd->ad_name ?: 'Exclusive Offer For You' }}</div>
            
            <div class="ad-cta">
                Click to View 
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
@else
    {{-- Default/Fallback Section --}}
    <a href="/ads/create" target="_blank" class="premium-ad-card">
        <span class="ad-badge">Ads Offer</span>
        
        <div class="ad-image-wrapper">
            <img src="{{ asset('ads_images/ads.jpg') }}" alt="Offer" class="ad-image">
        </div>
        
        <div class="ad-content">
            <div class="ad-title">Run Your Ads And Grow Your Team</div>
            <div class="ad-cta">
                Click to Run
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
@endif
            <div class="notice-section">
                <div class="notice-header">
                    <i class="fas fa-bullhorn"></i> <h4 class="notice-title">Latest Announcements</h4>
                </div>

                <div class="table-responsive">
                    <table class="table notice-table">
                        <thead>
                            <tr>
                                <th style="width: 20%">Date</th>
                                <th style="width: 80%">Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($data as $item)
                            <tr>
                                <td class="date-column">
                                    <i class="far fa-clock" style="margin-right: 4px;"></i>
                                    {{ $item->created_at->format('M d') }}
                                </td>
                                
                                <td>
                                    <span class="type-column">{{ $item->notice_title }}</span>
                                    <div class="desc-column">{{ $item->notice_body }}</div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="2" class="text-center p-4">
                                    <div style="color: var(--tg-gray);">
                                        <i class="fas fa-inbox fa-2x mb-2"></i><br>
                                        No notices available right now.
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            </div>
    </div>
</div>

@include('user.layout.footer')