@auth
<?php
    header("Location: /dashboard");
    exit();
?>
@endauth
@include('user.layout.header1')
<style>
    :root {
        --primary-color: #0088cc;
        --primary-hover: #006ba6;
        --accent-color: #00ff88;
        --bg-color: linear-gradient(135deg, #f0f2f5 0%, #e8f0fe 100%);
        --card-bg: #ffffff;
        --text-color: #333;
        --muted-color: #666;
        --border-color: #e0e0e0;
        --shadow-light: rgba(0, 136, 204, 0.1);
        --shadow-medium: rgba(0, 136, 204, 0.2);
    }
    body {
        background: var(--bg-color);
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        margin: 0;
        color: var(--text-color);
        overflow-x: hidden;
    }
    .header-gradient {
        background: linear-gradient(135deg, var(--primary-color) 0%, #00a0e9 100%);
        padding: 60px 20px 50px;
        text-align: center;
        color: #fff;
        box-shadow: 0 8px 30px rgba(0, 136, 204, 0.3);
        position: relative;
        overflow: hidden;
    }
    .header-gradient::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
        opacity: 0.1;
    }
    .header-gradient h1 {
        font-size: 2.5rem;
        margin-bottom: 10px;
        color: white;
        font-weight: 700;
        text-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
        animation: fadeInDown 1s ease-out;
    }
    .header-gradient p {
        font-size: 1.1rem;
        color: rgba(255, 255, 255, 0.9);
        margin: 0;
        animation: fadeInUp 1s ease-out 0.3s both;
    }
    @keyframes fadeInDown {
        from { opacity: 0; transform: translateY(-30px); }
        to { opacity: 1; transform: translateY(0); }
    }
    @keyframes fadeInUp {
        from { opacity: 0; transform: translateY(30px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .login-container {
        display: flex;
        justify-content: center;
        align-items: center;
        padding: 40px 20px;
        min-height: calc(100vh - 200px);
    }
    .login-box {
        background: var(--card-bg);
        padding: 40px;
        max-width: 420px;
        width: 100%;
        border-radius: 20px;
        box-shadow: 0 15px 40px var(--shadow-medium);
        position: relative;
        animation: slideInUp 0.6s ease-out;
        border: 1px solid rgba(0, 136, 204, 0.1);
        backdrop-filter: blur(10px);
    }
    .login-box::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(135deg, var(--primary-color) 0%, #00a0e9 100%);
        border-radius: 20px 20px 0 0;
    }
    .login-box h2 {
        text-align: center;
        margin-bottom: 30px;
        color: var(--primary-color);
        font-size: 1.8rem;
        font-weight: 700;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
    }
    .login-box h2 i {
        font-size: 2rem;
        animation: lockPulse 2s infinite;
    }
    @keyframes lockPulse {
        0%, 100% { transform: scale(1); }
        50% { transform: scale(1.1); }
    }
    .form-item {
        margin-bottom: 20px;
        position: relative;
        animation: fadeInUp 0.6s ease-out 0.2s both;
    }
    .input-field {
        width: 100%;
        padding: 15px 20px 15px 50px;
        border: 2px solid var(--border-color);
        border-radius: 12px;
        background-color: #f8f9fa;
        font-size: 1rem;
        transition: all 0.3s ease;
        position: relative;
    }
    .input-field:focus {
        outline: none;
        border-color: var(--primary-color);
        background-color: #fff;
        box-shadow: 0 0 0 0.2rem rgba(0, 136, 204, 0.15);
        transform: translateY(-2px);
    }
    .input-field::placeholder {
        color: var(--muted-color);
        opacity: 0.7;
    }
    .input-field.is-invalid {
        border-color: #dc3545;
        background-color: #fff5f5;
    }
    .input-icon {
        position: absolute;
        left: 18px;
        top: 50%;
        transform: translateY(-50%);
        color: var(--primary-color);
        font-size: 1.2rem;
        z-index: 1;
    }
    .form-remember {
        display: flex;
        justify-content: space-between;
        align-items: center;
        font-size: 0.9rem;
        margin-bottom: 20px;
        color: var(--muted-color);
    }
    .form-remember label {
        display: flex;
        align-items: center;
        gap: 8px;
        cursor: pointer;
    }
    .form-remember input[type="checkbox"] {
        accent-color: var(--primary-color);
    }
    .forgot-link {
        color: var(--primary-color);
        font-weight: 500;
        text-decoration: none;
        transition: color 0.3s ease;
    }
    .forgot-link:hover {
        color: var(--primary-hover);
        text-decoration: underline;
    }
    .btn-submit {
        width: 100%;
        padding: 15px;
        background: linear-gradient(135deg, var(--primary-color) 0%, #00a0e9 100%);
        color: white;
        border: none;
        border-radius: 12px;
        font-weight: 600;
        font-size: 1rem;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px var(--shadow-light);
        position: relative;
        overflow: hidden;
    }
    .btn-submit::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
        transition: left 0.5s;
    }
    .btn-submit:hover::before {
        left: 100%;
    }
    .btn-submit:hover {
        background: linear-gradient(135deg, var(--primary-hover) 0%, var(--primary-color) 100%);
        transform: translateY(-2px);
        box-shadow: 0 6px 20px var(--shadow-medium);
        color: white;
    }
    .btn-submit.hidden {
        display: none;
    }
    .footer-text {
        text-align: center;
        font-size: 0.9rem;
        color: var(--muted-color);
        margin-top: 20px;
    }
    .footer-text a {
        color: var(--primary-color);
        text-decoration: none;
        font-weight: 600;
        transition: color 0.3s ease;
    }
    .footer-text a:hover {
        color: var(--primary-hover);
        text-decoration: underline;
    }
    .toggle-password {
        position: absolute;
        right: 15px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        font-size: 1.1rem;
        color: var(--muted-color);
        transition: color 0.3s ease;
        z-index: 1;
    }
    .toggle-password:hover {
        color: var(--primary-color);
    }
    .hidden {
        display: none !important;
    }
    .error-message {
        background: rgba(220, 53, 69, 0.1);
        border: 1px solid #dc3545;
        color: #dc3545;
        padding: 12px;
        border-radius: 8px;
        margin-bottom: 20px;
        font-size: 0.9rem;
        text-align: center;
        animation: shake 0.5s ease-in-out;
    }
    .validation-error {
        color: #dc3545;
        font-size: 0.85rem;
        margin-top: 5px;
        display: block;
    }
    @keyframes shake {
        0%, 100% { transform: translateX(0); }
        25% { transform: translateX(-5px); }
        75% { transform: translateX(5px); }
    }
    @media (max-width: 480px) {
        .header-gradient { padding: 40px 15px 30px; }
        .header-gradient h1 { font-size: 2rem; }
        .header-gradient p { font-size: 1rem; }
        .login-container { padding: 20px 15px; }
        .login-box { padding: 30px 20px; border-radius: 15px; }
        .login-box h2 { font-size: 1.5rem; }
        .input-field { padding: 12px 16px 12px 45px; font-size: 0.95rem; }
        .input-icon { left: 15px; font-size: 1.1rem; }
        .toggle-password { right: 12px; font-size: 1rem; }
        .btn-submit { padding: 12px; font-size: 0.95rem; }
    }
</style>
<!-- 🔶 Header Gradient Banner -->
<div class="header-gradient">
    <h1>Welcome to Tele Earn</h1>
    <p>Your secure platform for earning and growth</p>
</div>
<!-- 🔒 Login Form Box -->
<div class="login-container">
    <div class="login-box">
        <h2><i class="fas fa-lock"></i> Login</h2>
        @if(session('error'))
            <div class="error-message">
                {{ session('error') }}
            </div>
        @endif
        @if ($errors->any())
            <div class="error-message">
                @foreach ($errors->all() as $error)
                    {{ $error }}<br>
                @endforeach
            </div>
        @endif
        <form method="post" action="{{ route('login_submit') }}" id="loginForm">
            @csrf
            <!-- Step 1: Phone or Email -->
            <div class="form-item" id="phoneStep">
                <i class="fas fa-user input-icon"></i>
                <input type="text" name="login_identity" class="input-field @error('login_identity') is-invalid @enderror" placeholder="Phone or Email" value="{{ old('login_identity') }}" required>
                @error('login_identity')
                    <span class="validation-error">{{ $message }}</span>
                @enderror
            </div>
            <!-- Step 2: Password -->
            <div id="passwordStep" class="hidden @if(old('login_password') || $errors->has('login_password')) @else hidden @endif">
                <div class="form-item">
                    <i class="fas fa-lock input-icon"></i>
                    <input type="password" name="login_password" class="input-field @error('login_password') is-invalid @enderror" placeholder="Password" id="passwordField" value="{{ old('login_password') }}" required>
                    <span class="toggle-password" onclick="togglePassword()">👁</span>
                    @error('login_password')
                        <span class="validation-error">{{ $message }}</span>
                    @enderror
                </div>
                <div class="form-remember">
                    <label><input type="checkbox" name="login_remember" {{ old('login_remember') ? 'checked' : '' }}> Remember me</label>
                    <a href="{{ url('user/forgot') }}" class="forgot-link">Forgot password?</a>
                </div>
            </div>
            <!-- Buttons -->
            <div class="form-item">
                <button type="button" class="btn-submit @if(old('login_password') || $errors->has('login_password')) hidden @endif" id="nextBtn">
                    <i class="fas fa-arrow-right"></i> Next
                </button>
                <button type="submit" class="btn-submit @if(!old('login_password') && !$errors->has('login_password')) hidden @endif" id="loginBtn">
                    <i class="fas fa-sign-in-alt"></i> Login
                </button>
            </div>
            <div class="footer-text">
                Don't have an account? <a href="{{ route('register') }}">Register here</a>
            </div>
        </form>
    </div>
</div>
<script>
    // Check if we should auto-advance to password step on load (e.g., validation error)
    document.addEventListener('DOMContentLoaded', function() {
        const passwordStep = document.getElementById("passwordStep");
        const nextBtn = document.getElementById("nextBtn");
        const loginBtn = document.getElementById("loginBtn");
        const identityInput = document.querySelector('input[name="login_identity"]');

        if (passwordStep.classList.contains('hidden') === false) {
            // Already shown via Blade, but ensure JS state
            nextBtn.classList.add("hidden");
            loginBtn.classList.remove("hidden");
            identityInput.readOnly = true;
            passwordStep.scrollIntoView({ behavior: 'smooth' });
        }
    });

    const nextBtn = document.getElementById("nextBtn");
    const loginBtn = document.getElementById("loginBtn");
    const passwordStep = document.getElementById("passwordStep");
    const identityInput = document.querySelector('input[name="login_identity"]');
    nextBtn.addEventListener("click", function () {
        if (identityInput.value.trim() === "") {
            identityInput.classList.add('is-invalid');
            identityInput.placeholder = 'Please enter your phone number or email first.';
            setTimeout(() => {
                identityInput.classList.remove('is-invalid');
                identityInput.placeholder = 'Phone or Email';
            }, 3000);
            return;
        }
        identityInput.readOnly = true;
        nextBtn.classList.add("hidden");
        passwordStep.classList.remove("hidden");
        loginBtn.classList.remove("hidden");
        passwordStep.scrollIntoView({ behavior: 'smooth' });
    });
    function togglePassword() {
        const password = document.getElementById("passwordField");
        const icon = document.querySelector('.toggle-password');
        password.type = password.type === "password" ? "text" : "password";
        icon.textContent = password.type === "password" ? '👁' : '🙈';
    }
    // Add smooth transitions
    document.querySelectorAll('.form-item').forEach((item, index) => {
        item.style.animationDelay = `${index * 0.1}s`;
    });
</script>
@include('user.layout.footer')