<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Tele Earn - International Joining to Earning website</title>
    <meta name="keywords" content="shopping site,earning site,affiliate,product affiliate">
    <meta name="description" content="Tele Earn Income - A professional joining to earn website. Buy products and earn money by referring friends.">
    <meta name="author" content="Tele Income">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <link rel="icon" type="image/png" href="{{asset('user/assets/images/logo.png')}}">
    <link rel="apple-touch-icon" href="{{asset('user/assets/images/logo.png')}}">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
    <link rel="stylesheet" media="screen" href="{{asset('user/assets/front/css/plugins.min.css')}}">
    <link id="mainStyles" rel="stylesheet" media="screen" href="{{asset('user/assets/front/css/styles.min.css')}}">
    <link href="{{asset('user/assets/front/css/color.css')}}" rel="stylesheet">

    <style>
        /* --- GLOBAL VARIABLES --- */
        :root {
            --telegram-primary: #229ED9;
            --telegram-dark: #1e8bbf;
            --telegram-gradient: linear-gradient(135deg, #2AABEE 0%, #229ED9 100%);
            --glass-bg: rgba(255, 255, 255, 0.85);
            --glass-border: rgba(255, 255, 255, 0.5);
            --sidebar-width: 280px;
            --text-dark: #1f2937;
            --text-light: #6b7280;
            --success: #10b981;
            --danger: #ef4444;
            --shadow-sm: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
            --shadow-lg: 0 10px 25px -5px rgba(34, 158, 217, 0.25);
        }

        /* --- BASE STYLES --- */
        body { 
            font-family: 'Inter', sans-serif; 
            background: #f0f2f5; 
            color: var(--text-dark); 
            margin: 0; 
            padding-top: 70px; /* Space for fixed header */
            overflow-x: hidden;
            -webkit-font-smoothing: antialiased;
        }

        /* --- TOP BAR (Glassmorphism) --- */
        .telegram-top-bar { 
            background: var(--telegram-gradient);
            padding: 10px 20px; 
            display: flex; 
            align-items: center; 
            justify-content: space-between; 
            position: fixed; 
            top: 0; left: 0; right: 0; 
            z-index: 1001; 
            box-shadow: 0 4px 20px rgba(34, 158, 217, 0.3);
            backdrop-filter: blur(10px);
            border-bottom-left-radius: 20px;
            border-bottom-right-radius: 20px;
        }

        .telegram-menu-toggle { 
            background: rgba(255,255,255,0.2); 
            border: none; 
            color: white; 
            font-size: 18px; 
            cursor: pointer; 
            width: 40px; height: 40px;
            border-radius: 12px; 
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            display: flex; justify-content: center; align-items: center;
        }

        .telegram-menu-toggle:hover { 
            background: rgba(255,255,255,0.3); 
            transform: scale(1.05);
        }

        .status-badge {
            display: flex; align-items: center; gap: 8px;
            background: rgba(255,255,255,0.15);
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: 500;
            color: white;
            border: 1px solid rgba(255,255,255,0.2);
        }

        .status-dot {
            width: 8px; height: 8px; border-radius: 50%;
            position: relative;
        }
        .status-dot::after {
            content: ''; position: absolute; top: -2px; left: -2px; right: -2px; bottom: -2px;
            border-radius: 50%; animation: pulse 1.5s infinite; opacity: 0.6;
        }
        .dot-active { background: #4ade80; } .dot-active::after { background: #4ade80; }
        .dot-inactive { background: #f87171; } .dot-inactive::after { background: #f87171; }

        .profile-wrapper {
            position: relative;
            cursor: pointer;
        }
        .profile-avatar { 
            width: 40px; height: 40px; 
            border-radius: 50%; 
            border: 2px solid rgba(255,255,255,0.8); 
            overflow: hidden; 
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
            transition: transform 0.3s ease;
        }
        .profile-avatar:hover { transform: scale(1.1); border-color: white; }

        /* --- SIDEBAR (Modern) --- */
        .telegram-sidebar { 
            position: fixed; 
            top: 0; left: -320px; 
            width: var(--sidebar-width); 
            height: 100vh; 
            background: rgba(255, 255, 255, 0.95); 
            box-shadow: 10px 0 30px rgba(0, 0, 0, 0.1); 
            transition: cubic-bezier(0.4, 0, 0.2, 1) 0.4s; 
            z-index: 1002; 
            backdrop-filter: blur(15px);
            border-right: 1px solid rgba(0,0,0,0.05);
        }
        
        .telegram-sidebar.open { left: 0; }

        .sidebar-header { 
            height: 140px;
            background: var(--telegram-gradient); 
            color: white; 
            padding: 25px; 
            display: flex; 
            flex-direction: column;
            justify-content: flex-end;
            position: relative;
            border-bottom-right-radius: 30px;
        }

        .close-sidebar-btn {
            position: absolute; top: 20px; right: 20px;
            background: rgba(255,255,255,0.2); border: none;
            color: white; width: 32px; height: 32px; border-radius: 50%;
            cursor: pointer; transition: 0.3s;
        }
        .close-sidebar-btn:hover { background: rgba(255,255,255,0.4); transform: rotate(90deg); }

        .user-info h4 { margin: 0; font-size: 18px; font-weight: 600; letter-spacing: 0.5px; }
        .user-info p { margin: 5px 0 0; font-size: 13px; opacity: 0.9; }

        .sidebar-menu { 
            list-style: none; padding: 20px 15px; margin: 0; 
            overflow-y: auto; height: calc(100vh - 140px);
        }
        
        .sidebar-menu li { margin-bottom: 8px; }

        .sidebar-menu a { 
            display: flex; align-items: center; 
            padding: 12px 18px; 
            text-decoration: none; 
            color: var(--text-dark); 
            font-size: 14px; font-weight: 500;
            border-radius: 12px;
            transition: all 0.2s ease;
        }

        .sidebar-menu a i { 
            width: 25px; margin-right: 15px; 
            color: var(--text-light); 
            font-size: 16px; transition: 0.2s;
        }

        .sidebar-menu a:hover, .sidebar-menu a.active { 
            background: #eff6ff; 
            color: var(--telegram-primary); 
            transform: translateX(5px);
        }
        
        .sidebar-menu a:hover i { color: var(--telegram-primary); }

        /* Special Reward Item */
        .reward-link {
            background: linear-gradient(135deg, #FFF8E1 0%, #FFF3E0 100%);
            border: 1px solid #FFE0B2;
        }
        .reward-text {
            background: linear-gradient(to right, #FF8F00, #FF6F00);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            font-weight: 700;
        }

        /* --- LOADER --- */
        .beautiful-loader { 
            position: fixed; top: 0; left: 0; width: 100%; height: 100%; 
            background: white; 
            display: flex; flex-direction: column; 
            align-items: center; justify-content: center; 
            z-index: 9999; transition: opacity 0.6s ease, visibility 0.6s; 
        }
        .beautiful-loader.hidden { opacity: 0; visibility: hidden; }
        
        .loader-icon-box {
            width: 80px; height: 80px;
            background: var(--telegram-gradient);
            border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            font-size: 40px; color: white;
            box-shadow: 0 10px 30px rgba(34, 158, 217, 0.4);
            animation: float 3s ease-in-out infinite;
            margin-bottom: 20px;
        }
        
        .loader-bar {
            width: 150px; height: 4px; background: #eee; border-radius: 4px; overflow: hidden;
        }
        .loader-progress {
            width: 100%; height: 100%; background: var(--telegram-primary);
            animation: loading 2s infinite ease-in-out;
            transform-origin: left;
        }

        /* --- ANIMATIONS --- */
        @keyframes pulse { 0% { box-shadow: 0 0 0 0 rgba(74, 222, 128, 0.7); } 70% { box-shadow: 0 0 0 6px rgba(74, 222, 128, 0); } 100% { box-shadow: 0 0 0 0 rgba(74, 222, 128, 0); } }
        @keyframes float { 0%, 100% { transform: translateY(0); } 50% { transform: translateY(-10px); } }
        @keyframes loading { 0% { transform: scaleX(0); } 50% { transform: scaleX(0.5); } 100% { transform: scaleX(1); transform-origin: right; } }
        
        /* Overlay */
        .sidebar-overlay {
            position: fixed; top: 0; left: 0; right: 0; bottom: 0;
            background: rgba(0,0,0,0.3);
            z-index: 1001; opacity: 0; visibility: hidden;
            transition: 0.3s; backdrop-filter: blur(2px);
        }
        .sidebar-overlay.active { opacity: 1; visibility: visible; }

    </style>
</head>
<body>

    <div class="sidebar-overlay" onclick="toggleTelegramSidebar()"></div>

    <div class="telegram-top-bar">
        <div style="display: flex; align-items: center; gap: 15px;">
            <button onclick="toggleTelegramSidebar()" class="telegram-menu-toggle">
                <i class="fas fa-bars"></i>
            </button>
            <div class="status-badge">
                @if(auth()->user()->user_active == 1)
                    <div class="status-dot dot-active"></div>
                    <span>Active</span>
                @else
                    <div class="status-dot dot-inactive"></div>
                    <span>Inactive</span>
                @endif
            </div>
        </div>
        
        <a href="{{ route('profile') }}" class="profile-wrapper">
            @if(Auth::check() && Auth::user()->profile_image !== null)
                <img class="profile-avatar" src="{{ asset('uploads/profile_images/' . Auth::user()->profile_image) }}" alt="Profile">
            @else
                <img class="profile-avatar" src="https://ui-avatars.com/api/?name={{ Auth::user()->fname }}&background=0D8ABC&color=fff" alt="Profile">
            @endif
        </a>
    </div>

    <div id="telegramSidebar" class="telegram-sidebar">
        <div class="sidebar-header">
            <button onclick="toggleTelegramSidebar()" class="close-sidebar-btn"><i class="fas fa-times"></i></button>
            <div class="user-info">
                <div style="display: flex; align-items: center; gap: 10px; margin-bottom: 5px;">
                    <div class="profile-avatar" style="width: 45px; height: 45px; border: 2px solid white;">
                        @if(Auth::check() && Auth::user()->profile_image !== null)
                            <img src="{{ asset('uploads/profile_images/' . Auth::user()->profile_image) }}" style="width: 100%; height: 100%; object-fit: cover;">
                        @else
                            <img src="https://ui-avatars.com/api/?name={{ Auth::user()->fname }}&background=fff&color=0088cc" style="width: 100%; height: 100%; object-fit: cover;">
                        @endif
                    </div>
                </div>
                <h4>{{ Auth::user()->fname }}</h4>
                <p>{{ Auth::user()->email }}</p>
            </div>
        </div>

        <ul class="sidebar-menu">
            <li><a href="{{ route('dashboard') }}"><i class="fas fa-home"></i>Dashboard</a></li>
            <li><a href="{{ route('myteam') }}"><i class="fas fa-users"></i>My Team</a></li>
            <li><a href="/api-selling"><i class="fas fa-exchange-alt"></i>Api Sell</a></li>
            <li><a href="/gift-code"><i class="fas fa-gift"></i>Gift Code</a></li>
            <li><a href="/lottery"><i class="fas fa-ticket-alt"></i>Lottery</a></li>
            
            <li>
                <a href="/reward-system" class="reward-link">
                    <i class="fas fa-crown" style="color: #FF8F00;"></i>
                    <span class="reward-text">Refer Reward</span>
                    <span class="ms-auto animate__animated animate__pulse animate__infinite" style="font-size: 1.2em;">🎁</span>
                </a>
            </li>

            <li><a href="/leaders"><i class="fas fa-trophy"></i>Leaderboard</a></li>
            <li><a href="/telegram-connect"><i class="fab fa-telegram"></i>Connect Telegram</a></li>
            <li><a href="{{ route('ads') }}"><i class="fas fa-ad"></i>Ads</a></li>
            <li><a href="{{ route('notice') }}"><i class="fas fa-bullhorn"></i>Announcement</a></li>
            <li><a href="{{ route('helpline') }}"><i class="fas fa-headset"></i>Support</a></li>
            
            <li style="margin-top: 10px; border-top: 1px solid #eee; padding-top: 10px;">
                <small style="padding-left: 18px; color: #9ca3af; font-weight: 600;">FINANCE</small>
            </li>
            
            <li><a href="{{ route('withdrawCreate') }}"><i class="fas fa-money-bill-wave" style="color: var(--success);"></i>Withdraw Now</a></li>
            <li><a href="{{ route('withdraw') }}"><i class="fas fa-history"></i>Withdraw History</a></li>
            <li><a href="{{ route('payment') }}"><i class="fas fa-file-invoice-dollar"></i>My Payments</a></li>
            
            <li style="margin-top: 20px;">
                <a href="{{ route('logout') }}" style="color: var(--danger); background: rgba(239, 68, 68, 0.05);">
                    <i class="fas fa-sign-out-alt" style="color: var(--danger);"></i>Sign Out
                </a>
            </li>
        </ul>
    </div>

    <div id="beautiful-loader" class="beautiful-loader">
        <div class="loader-icon-box">
            <i class="fab fa-telegram-plane"></i>
        </div>
        <h3 style="margin: 0 0 15px 0; font-weight: 600; color: var(--telegram-primary);">Tele Earn</h3>
        <div class="loader-bar">
            <div class="loader-progress"></div>
        </div>
    </div>

    <script src="{{asset('user/assets/front/js/modernizr.min.js')}}"></script>
    <script>
        function toggleTelegramSidebar() {
            const sidebar = document.getElementById('telegramSidebar');
            const overlay = document.querySelector('.sidebar-overlay');
            
            sidebar.classList.toggle('open');
            overlay.classList.toggle('active');

            if (sidebar.classList.contains('open')) {
                document.body.style.overflow = 'hidden';
            } else {
                document.body.style.overflow = 'auto';
            }
        }

        // Loader Animation Logic
        window.addEventListener('load', () => {
            const loader = document.getElementById('beautiful-loader');
            setTimeout(() => {
                loader.classList.add('hidden');
            }, 1500); // 1.5 seconds minimum show time
        });
    </script>
<script>
    // ২. রাইট ক্লিক (Context Menu) বন্ধ রাখা হয়েছে যাতে 'Inspect' অপশন না আসে
    document.addEventListener('contextmenu', function(e) {
        e.preventDefault();
        // চাইলে এখানে একটি অ্যালার্ট দিতে পারেন, না চাইলে নিচের লাইনটি কেটে দিন
        // alert("Right Click is disabled to protect content, please use Ctrl+C to copy.");
    });

    document.onkeydown = function(e) {
        // ৩. F12 (Developer Tools) বন্ধ
        if (event.keyCode == 123) {
            return false;
        }

        // ৪. সোর্স কোড দেখার শর্টকাটগুলো (Ctrl+Shift+I, Ctrl+Shift+J, Ctrl+Shift+C, Ctrl+U) বন্ধ
        if (e.ctrlKey && e.shiftKey && (e.keyCode == 'I'.charCodeAt(0) || e.keyCode == 'J'.charCodeAt(0) || e.keyCode == 'C'.charCodeAt(0))) {
            return false;
        }
        if (e.ctrlKey && e.keyCode == 'U'.charCodeAt(0)) {
            return false;
        }
        
        // ৫. বিদ্র: আমরা Ctrl+C (Copy) বা Ctrl+V (Paste) বন্ধ করিনি, তাই ইউজাররা কিবোর্ড দিয়ে কপি করতে পারবে।
    }
</script>
    
</body>
</html>