@include('user.layout.header')



<style>

  #successPopup {
    display: none;
    position: fixed;
    top: 50%; left: 50%;
    transform: translate(-50%, -50%);
    background: #e6f9e6; /* soft pale green background */
    border: 2px solid #28a745; /* bootstrap success green */
    box-shadow: 0 0 20px #28a745;
    border-radius: 12px;
    padding: 25px 40px;
    text-align: center;
    z-index: 9999;
    font-family: 'Georgia', serif;
    color: #19692c; /* dark green text */
    width: 320px;
  }
  #successPopup h2 {
    margin-bottom: 15px;
    text-shadow: 0 0 6px #28a745;
  }
  #successPopup img {
    width: 120px;
    margin-bottom: 10px;
  }
  #successPopup p {
    font-weight: 700;
  }
  .notice-highlight {
  font-weight: bold;
  font-size: 18px;
  color: #ff8c00;
   width: 100%;
  background: #fff8e7;
  padding: 10px 16px;
  border-left: 5px solid #ffa500;
  border-radius: 6px;
  box-shadow: 0 0 8px rgba(255, 165, 0, 0.2);
}

</style>

<div class="col-lg-8">
  <div class="padding-top-2x mt-2 hidden-lg-up"></div>
  <br><br>

  <!-- Banner with User Level -->
  <section class="banner-level-section">
    <div class="container banner-content">
      <h1 class="banner-title">
        @if(auth()->user()->user_active == 1)
          Your Running Software
        @else
          Software Not Running
        @endif
      </h1>
      <div class="user-level-badge">
        Level: <span id="userLevel">
          @if(auth()->user()->user_active == 1)
            Basic
          @else 
            None
          @endif
        </span>
      </div> 
    </div>
  </section>
<div style="text-align:center;">Your page space today : {{ Auth::user()->job_limit }} lines</div>
<br>
  <!-- Typing box and button -->
  <div class="typebox-container">
    <textarea id="textBox" class="sentence-display" readonly placeholder="Auto typing will appear here..."></textarea>
    @if(auth()->user()->user_active == 1)  @if(auth()->user()->job_limit > 0) <button id="actionBtn" class="auto-btn">Auto Type</button> @else <button class="auto-btn">Today Software Limit Used </button> @endif @else <a href="/account/payment"><button class="auto-btn">Run the Software First</button></a> @endif 
    
    <div id="successMsg" class="success-alert">Sell successful! ✅</div>
  </div>
</div>
<div class="col-lg-8">
  <div class="padding-top-2x mt-2 hidden-lg-up"></div>
<p class="notice-highlight">💬 1 Line = {{ app('per_sentence_amount') }} BDT</p>

<div id="customSuccessToast" style="display:none; position: fixed; bottom: 30px; right: 30px; z-index: 9999; background: #28a745; color: white; padding: 20px 30px; border-radius: 10px; box-shadow: 0 5px 15px rgba(0,0,0,0.2); font-size: 16px; font-weight: 600; animation: fadeInOut 4s;">
  Success! You earned ৳<span id="earnedAmount"></span>
</div>

<style>
  @keyframes fadeInOut {
    0%   { opacity: 0; transform: translateY(20px); }
    10%  { opacity: 1; transform: translateY(0); }
    90%  { opacity: 1; transform: translateY(0); }
    100% { opacity: 0; transform: translateY(20px); }
  }
</style>

<!-- Success Popup -->
<div id="successPopup">
  <h2>Sell Successful! ✅</h2>
  <img src="https://assets-v2.lottiefiles.com/a/66a6fd34-1151-11ee-84f6-2fb2b681b87c/4m2zfxYwLR.gif" alt="Success GIF"/>
  <p>Verifying...</p>
</div>

<script>
  const textBox = document.getElementById('textBox');
  const actionBtn = document.getElementById('actionBtn');
  const successMsg = document.getElementById('successMsg');
  const successPopup = document.getElementById('successPopup');
 const jobLimit = {{ $jobLimit }}; 
 
  let currentSentences = [];
  let currentSentenceIds = [];
  let currentLineIndex = 0;
  let charIndex = 0;
  let typingTimer;
  let isTyping = false;
  

  function resetTyping() {
    charIndex = 0;
    currentLineIndex = 0;
    currentSentences = [];
    currentSentenceIds = [];
    isTyping = false;
  }


  function typeCharacter() {
    const fullLine = `${currentLineIndex + 1}. ${currentSentences[currentLineIndex]}`;

    if (charIndex < fullLine.length) {
      textBox.value += fullLine.charAt(charIndex);
      charIndex++;
    } else {
      clearInterval(typingTimer);
      charIndex = 0;
      currentLineIndex++;

      if (currentLineIndex < jobLimit) {
        textBox.value += "\n";
    
        setTimeout(() => {
          typingTimer = setInterval(typeCharacter, 50);
        }, 400);
      } else {
     
        actionBtn.textContent = "Sell the page";
        isTyping = false;
      }
    }
  }


  async function getMultipleSentences() {
    const sentences = [];
    const ids = [];

    for (let i = 0; i < jobLimit; i++) {
      const res = await fetch("{{ route('get.sentence') }}", {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({})
      });

      const json = await res.json();
      if (json.status === 'done') break;

      sentences.push(json.sentence);
      ids.push(json.sentence_id);
    }

    return { sentences, ids };
  }


  async function storeSentences(sentences, ids) {
    const res = await fetch("{{ route('sentence.history.store') }}", {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'X-CSRF-TOKEN': '{{ csrf_token() }}'
      },
      body: JSON.stringify({
        sentences: sentences,
        sentence_ids: ids
      })
    });
    return res.json();
  }

  actionBtn.addEventListener('click', async () => {
    successMsg.style.display = "none";

    if (actionBtn.textContent === "Auto Type" && !isTyping) {
      textBox.value = "";
      resetTyping();
      isTyping = true;
      actionBtn.disabled = true;

      const response = await getMultipleSentences();

      if (response.sentences.length === 0) {
        textBox.value = "Not available";
        actionBtn.disabled = false;
        isTyping = false;
        return;
      }

      currentSentences = response.sentences;
      currentSentenceIds = response.ids;

      typingTimer = setInterval(typeCharacter, 50);

      let checkFinishInterval = setInterval(() => {
        if (!isTyping) {
          actionBtn.disabled = false;
          clearInterval(checkFinishInterval);
        }
      }, 100);
    }

    else if (actionBtn.textContent === "Sell the page") {
      const storeResponse = await storeSentences(currentSentences, currentSentenceIds);

      if (storeResponse.status === "success") {
        successPopup.style.display = 'block';
        actionBtn.disabled = true;
        textBox.value = "";
        resetTyping();

        setTimeout(() => {
          successPopup.style.display = 'none';
          window.location.href = "/typejob"; 
        }, 3000);

      } else {
        alert("Failed to save sentence.");
      }
      if (storeResponse.status === "success") {
  const earned = storeResponse.earned;

  // Show custom toast message
  const toast = document.getElementById('customSuccessToast');
  const earnedAmount = document.getElementById('earnedAmount');

  earnedAmount.textContent = earned.toFixed(2);
  toast.style.display = 'block';

  setTimeout(() => {
    toast.style.display = 'none';
  }, 4000);
}
    }
  });
</script>


@include('user.layout.footer')
