@auth
<?php
    header("Location: /dashboard");
    exit();
?>
@endauth

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ env('APP_NAME') }} - Start Earning Today</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    
    <style>
        /* --- Telegram Light Theme Variables --- */
        :root {
            --tg-bg: #f1f2f6;
            --tg-white: #ffffff;
            --tg-blue: #3390ec; /* Telegram Blue */
            --tg-blue-hover: #2880ca;
            --tg-text: #222222;
            --tg-gray: #707579;
        }

        body {
            background-color: var(--tg-bg);
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
            margin: 0;
            padding: 0;
            color: var(--tg-text);
        }

        /* --- Navbar --- */
        .navbar-custom {
            background: var(--tg-white);
            box-shadow: 0 1px 2px rgba(0,0,0,0.05);
            padding: 15px 20px;
        }
        .navbar-brand {
            font-weight: 700;
            color: var(--tg-blue) !important;
            font-size: 24px;
        }
        .btn-login-nav {
            color: var(--tg-blue);
            font-weight: 600;
            text-decoration: none;
            padding: 8px 20px;
            border-radius: 20px;
            background: #eef6fc;
            transition: all 0.3s;
        }
        .btn-login-nav:hover {
            background: #dcebf7;
            text-decoration: none;
            color: var(--tg-blue-hover);
        }

        /* --- Hero Section --- */
        .hero-section {
            background: var(--tg-white);
            padding: 60px 20px 80px 20px;
            border-bottom-left-radius: 40px;
            border-bottom-right-radius: 40px;
            text-align: center;
            box-shadow: 0 4px 15px rgba(0,0,0,0.03);
            position: relative;
            overflow: hidden;
        }

        .hero-title {
            font-size: 32px;
            font-weight: 800;
            margin-bottom: 15px;
            background: linear-gradient(135deg, #3390ec 0%, #0088cc 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .hero-subtitle {
            font-size: 16px;
            color: var(--tg-gray);
            margin-bottom: 30px;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
            line-height: 1.6;
        }

        /* Buttons */
        .btn-action {
            padding: 12px 35px;
            border-radius: 12px;
            font-weight: 600;
            font-size: 16px;
            border: none;
            transition: transform 0.2s, box-shadow 0.2s;
            display: inline-block;
            text-decoration: none;
            margin: 5px;
        }

        .btn-primary-tg {
            background: var(--tg-blue);
            color: white;
            box-shadow: 0 4px 15px rgba(51, 144, 236, 0.4);
            animation: pulse-blue 2s infinite;
        }
        .btn-primary-tg:hover {
            background: var(--tg-blue-hover);
            color: white;
            transform: translateY(-2px);
            text-decoration: none;
        }

        .btn-outline-tg {
            background: transparent;
            border: 2px solid var(--tg-blue);
            color: var(--tg-blue);
        }
        .btn-outline-tg:hover {
            background: #eef6fc;
            color: var(--tg-blue-hover);
            transform: translateY(-2px);
            text-decoration: none;
        }

        @keyframes pulse-blue {
            0% { box-shadow: 0 0 0 0 rgba(51, 144, 236, 0.7); }
            70% { box-shadow: 0 0 0 10px rgba(51, 144, 236, 0); }
            100% { box-shadow: 0 0 0 0 rgba(51, 144, 236, 0); }
        }

        /* --- Stats Section --- */
        .stats-container {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin-top: -40px;
            padding: 0 15px;
        }
        .stat-card {
            background: white;
            padding: 15px 25px;
            border-radius: 16px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.06);
            text-align: center;
            min-width: 140px;
            z-index: 10;
        }
        .stat-number {
            font-size: 20px;
            font-weight: 700;
            color: var(--tg-blue);
        }
        .stat-label {
            font-size: 12px;
            color: var(--tg-gray);
            font-weight: 500;
        }

        /* --- Features Section --- */
        .features-section {
            padding: 50px 20px;
        }
        .section-title {
            text-align: center;
            font-size: 22px;
            font-weight: 700;
            color: var(--tg-text);
            margin-bottom: 30px;
        }

        .feature-box {
            background: var(--tg-white);
            border-radius: 16px;
            padding: 25px 20px;
            margin-bottom: 20px;
            text-align: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.03);
            transition: all 0.3s;
            border: 1px solid transparent;
        }
        .feature-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.08);
            border-color: #eef6fc;
        }
        .feature-icon {
            width: 60px;
            height: 60px;
            background: #eef6fc;
            color: var(--tg-blue);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            margin: 0 auto 15px auto;
        }
        .feature-title {
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 8px;
        }
        .feature-desc {
            font-size: 13px;
            color: var(--tg-gray);
            line-height: 1.5;
        }

        /* --- Footer --- */
        .footer {
            background: var(--tg-white);
            padding: 30px 20px;
            text-align: center;
            border-top: 1px solid #eee;
        }
        .footer-text {
            color: var(--tg-gray);
            font-size: 13px;
        }
        .footer a { color: var(--tg-blue); text-decoration: none; }

        /* Floating Icon Animation */
        .floating-icon {
            font-size: 80px;
            color: rgba(51, 144, 236, 0.1);
            position: absolute;
            top: 20px;
            right: 20px;
            animation: float 4s ease-in-out infinite;
        }
        @keyframes float {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-20px); }
            100% { transform: translateY(0px); }
        }

    </style>
</head>
<body>

    <nav class="navbar navbar-custom d-flex justify-content-between align-items-center">
        <a class="navbar-brand" href="#"><i class="fab fa-telegram-plane mr-2"></i>Tele-Earn</a>
        <a href="/login" class="btn-login-nav">Login</a>
    </nav>

    <section class="hero-section">
        <i class="fas fa-rocket floating-icon"></i> <h1 class="hero-title">Start Your Earnings <br> with API Selling</h1>
        <p class="hero-subtitle">
            Join the smartest earning platform. Invest small, earn daily rewards, and withdraw your money instantly via Bkash/Nagad.
        </p>
        
        <div class="mt-4">
            <a href="/register" class="btn-action btn-primary-tg">
                <i class="fas fa-user-plus mr-2"></i> Join Now
            </a>
            <a href="/login" class="btn-action btn-outline-tg">
                <i class="fas fa-sign-in-alt mr-2"></i> Login
            </a>
        </div>
    </section>

    <div class="stats-container">
        <div class="stat-card">
            <div class="stat-number">5.2K+</div>
            <div class="stat-label">Active Users</div>
        </div>
        <div class="stat-card">
            <div class="stat-number">৳250K+</div>
            <div class="stat-label">Total Paid</div>
        </div>
    </div>

    <section class="features-section">
        <h2 class="section-title">Why Choose Us?</h2>
        <div class="container">
            <div class="row">
                <div class="col-md-4 col-12">
                    <div class="feature-box">
                        <div class="feature-icon">
                            <i class="fas fa-chart-line"></i>
                        </div>
                        <h4 class="feature-title">High Daily Returns</h4>
                        <p class="feature-desc">Earn reliable daily income through our API selling program with minimal effort.</p>
                    </div>
                </div>

                <div class="col-md-4 col-12">
                    <div class="feature-box">
                        <div class="feature-icon">
                            <i class="fas fa-shield-alt"></i>
                        </div>
                        <h4 class="feature-title">Secure & Safe</h4>
                        <p class="feature-desc">Your data and investments are protected with our advanced security system.</p>
                    </div>
                </div>

                <div class="col-md-4 col-12">
                    <div class="feature-box">
                        <div class="feature-icon">
                            <i class="fas fa-hand-holding-usd"></i>
                        </div>
                        <h4 class="feature-title">Fast Withdrawal</h4>
                        <p class="feature-desc">Withdraw your earnings anytime directly to your preferred payment method.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="container mb-5">
        <div class="card border-0 shadow-sm rounded-lg overflow-hidden" style="background: white;">
            <div class="card-body p-4 text-center">
                <h4 class="mb-4" style="color: var(--tg-text); font-weight: 700;">How to Start?</h4>
                <div class="d-flex justify-content-around align-items-center flex-wrap">
                    <div class="mb-3">
                        <i class="fas fa-user-circle fa-2x text-primary mb-2"></i>
                        <h6 class="font-weight-bold">1. Register</h6>
                    </div>
                    <div class="d-none d-md-block text-muted"><i class="fas fa-chevron-right"></i></div>
                    <div class="mb-3">
                        <i class="fas fa-shopping-cart fa-2x text-primary mb-2"></i>
                        <h6 class="font-weight-bold">2. Buy Plan</h6>
                    </div>
                    <div class="d-none d-md-block text-muted"><i class="fas fa-chevron-right"></i></div>
                    <div class="mb-3">
                        <i class="fas fa-coins fa-2x text-primary mb-2"></i>
                        <h6 class="font-weight-bold">3. Earn Daily</h6>
                    </div>
                </div>
                <div class="mt-4">
                    <a href="/register" class="btn btn-sm btn-login-nav px-4">Get Started Now</a>
                </div>
            </div>
        </div>
    </section>

    <footer class="footer">
        <p class="footer-text">
            &copy; {{ date('Y') }} <strong>Tele-Earn</strong>. All Rights Reserved.<br>
            <a href="#">Privacy Policy</a> | <a href="#">Terms of Service</a>
        </p>
    </footer>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>