@include('user.layout.header')

<style>
    /* --- Telegram Theme Variables --- */
    :root {
        --tg-bg: #f1f2f6;
        --tg-white: #ffffff;
        --tg-blue: #3390ec;
        --tg-text-main: #222222;
        --tg-text-sub: #707579;
        --tg-border: #dfe1e5;
    }

    body {
        background-color: var(--tg-bg);
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
    }

    /* --- Premium Ad Card Styles --- */
    .premium-ad-card {
        background: var(--tg-white);
        border-radius: 14px;
        padding: 12px;
        margin: 20px auto;
        position: relative;
        overflow: hidden;
        box-shadow: 0 1px 3px rgba(0,0,0,0.08); /* খুব হালকা শ্যাডো */
        border: 1px solid transparent;
        display: flex;
        align-items: center;
        gap: 15px;
        transition: all 0.2s ease;
        text-decoration: none !important;
    }

    .premium-ad-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(51, 144, 236, 0.15); /* হোভার করলে হালকা নীল আভা */
        border-color: rgba(51, 144, 236, 0.3);
    }

    /* Shining Animation */
    .premium-ad-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 50%;
        height: 100%;
        background: linear-gradient(to right, transparent, rgba(255, 255, 255, 0.6), transparent);
        transform: skewX(-25deg);
        animation: shine 4s infinite;
        pointer-events: none;
    }
    @keyframes shine { 100% { left: 200%; } }

    /* Badge Style */
    .ad-badge {
        position: absolute;
        top: 0;
        right: 0; /* ডান পাশে রাখলাম টেলিগ্রাম স্টাইলে */
        background: #eef6fc;
        color: var(--tg-blue);
        font-size: 10px;
        font-weight: 700;
        padding: 4px 10px;
        border-bottom-left-radius: 10px;
        border-top-right-radius: 14px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    /* Image Wrapper */
    .ad-image-wrapper {
        width: 70px;
        height: 70px;
        border-radius: 10px;
        overflow: hidden;
        flex-shrink: 0;
        background: #f0f0f0;
        border: 1px solid #eee;
    }
    .ad-image { width: 100%; height: 100%; object-fit: cover; }

    /* Content */
    .ad-content { flex: 1; display: flex; flex-direction: column; justify-content: center; }
    .ad-title {
        font-size: 15px;
        font-weight: 600;
        color: var(--tg-text-main);
        margin-bottom: 4px;
    }
    .ad-cta {
        font-size: 13px;
        color: var(--tg-blue);
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 5px;
    }
    .ad-arrow-icon { font-size: 12px; transition: transform 0.2s; }
    .premium-ad-card:hover .ad-arrow-icon { transform: translateX(3px); }


    /* --- Helpline Section Styles --- */
    .helpline-box {
        margin-top: 30px;
        padding-bottom: 30px;
    }
    .helpline-heading {
        font-size: 18px;
        font-weight: 600;
        color: var(--tg-text-main);
        margin-bottom: 15px;
        padding-left: 5px;
        border-left: 4px solid var(--tg-blue);
        line-height: 1.2;
    }

    /* Helpline Cards */
    .helpline-card {
        background: var(--tg-white);
        border-radius: 12px;
        padding: 15px;
        display: flex;
        align-items: center;
        gap: 15px;
        box-shadow: 0 1px 2px rgba(0,0,0,0.05);
        border: 1px solid #f0f0f0;
        transition: all 0.2s ease;
        height: 100%;
    }

    .helpline-card:hover {
        background-color: #fafdff; /* হোভার করলে খুব হালকা নীল */
        border-color: #d1e4f5;
    }

    .helpline-icon {
        width: 45px;
        height: 45px;
        background: #eef6fc; /* টেলিগ্রাম ব্লু এর হালকা ভার্সন */
        color: var(--tg-blue);
        border-radius: 50%; /* গোল আইকন */
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 18px;
        flex-shrink: 0;
    }

    .helpline-info h6 {
        font-size: 14px;
        font-weight: 600;
        margin: 0;
        color: var(--tg-text-main);
    }
    .helpline-info p {
        font-size: 13px;
        color: var(--tg-text-sub);
        margin: 2px 0 0 0;
        word-break: break-all;
    }
    .helpline-info a {
        color: var(--tg-blue);
        text-decoration: none;
        font-weight: 500;
    }
    .helpline-info a:hover { text-decoration: underline; }

</style>

<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-lg-8 col-md-10 col-12">
            <br><br><br>

            @php
    $activeAd = \App\Models\Ad::active()->first();
    
    // যখনি অ্যাডটি লোড হবে, ভিউ বা ইম্প্রেশন ১ বাড়বে
    if($activeAd){
        $activeAd->increment('views');
    }
@endphp

@if($activeAd)
    {{-- Active Ad Section --}}
    <a href="{{ route('ad.track.click', $activeAd->id) }}" target="_blank" class="premium-ad-card">
        <span class="ad-badge">SPONSORED</span>
        
        <div class="ad-image-wrapper">
            <img src="{{ asset('ads_images/' . $activeAd->image) }}" alt="{{ $activeAd->ad_name ?: 'Exclusive Offer For You' }}" class="ad-image">
        </div>
        
        <div class="ad-content">
            {{-- এই লাইনটি আপডেট করা হয়েছে --}}
            <div class="ad-title">{{ $activeAd->ad_name ?: 'Exclusive Offer For You' }}</div>
            
            <div class="ad-cta">
                Click to View 
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
@else
    {{-- Default/Fallback Section --}}
    <a href="/ads/create" target="_blank" class="premium-ad-card">
        <span class="ad-badge">Ads Offer</span>
        
        <div class="ad-image-wrapper">
            <img src="{{ asset('ads_images/ads.jpg') }}" alt="Offer" class="ad-image">
        </div>
        
        <div class="ad-content">
            <div class="ad-title">Run Your Ads And Grow Your Team</div>
            <div class="ad-cta">
                Click to Run
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
@endif
            <div class="helpline-box">
                <h4 class="helpline-heading">Support & Help</h4>

                <div class="row gy-3">
                    
                    <div class="col-md-6">
                        <div class="helpline-card">
                            <div class="helpline-icon">
                                <i class="fas fa-phone-alt"></i>
                            </div>
                            <div class="helpline-info">
                                <h6>Phone Support</h6>
                                <p>{{ app('help_phone') }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="helpline-card">
                            <div class="helpline-icon">
                                <i class="fab fa-telegram-plane"></i>
                            </div>
                            <div class="helpline-info">
                                <h6>Official Channel</h6>
                                <p><a href="{{ app('telegram_url') }}" target="_blank">Join Telegram Group</a></p>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="helpline-card">
                            <div class="helpline-icon">
                                <i class="fas fa-envelope"></i>
                            </div>
                            <div class="helpline-info">
                                <h6>Email Us</h6>
                                <p>{{ app('help_email') }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="helpline-card">
                            <div class="helpline-icon">
                                <i class="fas fa-map-pin"></i>
                            </div>
                            <div class="helpline-info">
                                <h6>Our Office</h6>
                                <p>{{ app('help_address') }}</p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            </div>
    </div>
</div>

@include('user.layout.footer')