@include('user.layout.header')

<style>
/* ---------------------------------------------------- */
/* --- 1. Base Styling: Clean and Minimal --- */
body {
    background-color: #f0f2f5; /* Very light, soft background */
    font-family: 'Inter', 'Helvetica Neue', sans-serif; /* Standard, clean font */
    color: #1c1e21;
}

/* ---------------------------------------------------- */
/* --- 2. Main Card: Clean, Elevated Paper Look --- */
.clean-card {
    max-width: 480px; /* Slightly smaller for a tighter focus */
    margin: 80px auto;
    background: #ffffff;
    border-radius: 8px; 
    text-align: center;
    padding: 30px 25px 40px 25px; /* Asymmetrical padding */
    
    /* Single, soft, large shadow for a modern, floating effect */
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1); 
    
    transition: box-shadow 0.2s ease;
    border: 1px solid #dee2e6; /* Subtle, light border */
}

.clean-card:hover {
    box-shadow: 0 6px 16px rgba(0, 0, 0, 0.15); /* Hover increases elevation */
}

/* --- Card Header/Logo --- */
.task-icon {
    width: 80px; 
    margin-bottom: 20px;
    border-radius: 12px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}

h2 {
    font-size: 24px;
    color: #0d6efd; /* Strong primary blue */
    font-weight: 600;
    margin-bottom: 8px;
}

.card-desc {
    font-size: 15px;
    line-height: 1.5;
    color: #6c757d;
    margin: 0 auto 25px auto;
    max-width: 90%;
}

/* --- Reward Tag: Flat, Professional Badge --- */
.reward-badge {
    background: #28a745; /* Clean Green */
    border: none;
    padding: 8px 15px;
    color: #ffffff;
    font-weight: 500;
    border-radius: 4px; /* Squared off */
    margin: 10px 0;
    font-size: 14px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}

/* --- Main Action Button: Pressed/Physical Feel --- */
.main-action-btn {
    background: #007bff; 
    border: none;
    padding: 12px 25px; 
    color: white;
    border-radius: 6px; 
    cursor: pointer;
    margin-top: 25px;
    font-size: 16px;
    font-weight: 600;
    /* Realistic 3D shadow */
    box-shadow: 0 4px 0 #0056b3; 
    transition: all 0.1s linear;
}

.main-action-btn:hover {
    box-shadow: 0 4px 0 #0056b3; 
    transform: translateY(-1px);
}

.main-action-btn:active {
    /* Press effect */
    transform: translateY(4px); 
    box-shadow: 0 0 0 #0056b3; 
}

/* ---------------------------------------------------- */
/* --- 3. Popup: Simple, Centered Modal --- */
.simple-modal {
    display: none;
    position: fixed;
    inset: 0;
    background: rgba(0,0,0,0.5); 
    justify-content: center;
    align-items: center;
    z-index: 9999;
    padding: 20px;
}

.modal-content-simple {
    background: #ffffff;
    color: #343a40;
    padding: 25px;
    border-radius: 8px; 
    width: 100%;
    max-width: 350px;
    text-align: center;
    box-shadow: 0 5px 15px rgba(0,0,0,0.3);
}

.modal-content-simple h2 {
    font-size: 20px;
    margin-bottom: 15px;
}

.generate-btn {
    background: #17a2b8; 
    color: #fff;
    font-weight: 500;
    padding: 10px 18px;
    border-radius: 4px; 
    margin-top: 10px;
}
.generate-btn:active {
    transform: translateY(1px);
}

#emailBox {
    width: 100%;
    margin-top: 15px;
    padding: 10px;
    border-radius: 4px;
    border: 1px solid #ced4da;
    background-color: #f8f9fa;
    font-size: 14px;
    font-weight: 400;
}

.submit-btn, .close-btn {
    padding: 8px 20px;
    margin: 15px 5px 0;
    border-radius: 4px;
    font-weight: 500;
    box-shadow: 0 2px 0 #333; /* Flat physical shadow */
    transition: all 0.1s linear;
}
.submit-btn { 
    background: #28a745; 
    color: white; 
    box-shadow: 0 4px 0 #1e7e34;
} 
.submit-btn:active { 
    transform: translateY(4px); 
    box-shadow: 0 0 0 #1e7e34;
}

.close-btn { 
    background: #6c757d; 
    color: white; 
    box-shadow: 0 4px 0 #5a6268;
} 
.close-btn:active { 
    transform: translateY(4px); 
    box-shadow: 0 0 0 #5a6268;
}

/* ---------------------------------------------------- */
/* --- Success Popup: Simple Notification --- */
.success-notification {
    display: none;
    position: fixed;
    inset: 0;
    background: rgba(255, 255, 255, 0.9);
    justify-content: center;
    align-items: center;
    z-index: 10000;
    color: #343a40;
}

.notification-content {
    animation: fadeInScale 0.3s ease-out;
    padding: 30px;
    background: #ffffff;
    border-radius: 8px;
    border-left: 5px solid #28a745; /* Green success bar */
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
}

.notification-content h2 {
    color: #28a745;
    font-size: 24px;
}

.notification-content p {
    font-size: 15px;
    margin: 5px 0;
}

@keyframes fadeInScale {
    from { opacity: 0; transform: scale(0.95); }
    to { opacity: 1; transform: scale(1); }
}
</style>
<br><br>
<div class="clean-card">
    <img src="https://chromeunboxed.com/wp-content/uploads/2022/03/gmail-icon-color-featured.jpg" class="task-icon" alt="Gmail Logo">
    <h2>**প্রিমিয়াম ভেরিফিকেশন টাস্ক**</h2>
    <p class="card-desc">আপনার ইনভেস্টমেন্ট অ্যাকাউন্টকে শক্তিশালী করতে ভেরিফাইড Gmail তৈরি করুন। এটি সহজ এবং দ্রুত উপার্জনের সুযোগ।</p>
    <button class="reward-badge"> নিশ্চিত **২ টাকা** ক্রেডিট</button>
    @if($user->submission_count < env('SUBMISSION_LIMIT', 5))
        <button class="main-action-btn" onclick="openPopup()">টাস্ক শুরু করুন</button>
    @endif
</div>

<div class="simple-modal" id="popup">
    <div class="modal-content-simple">
        <img src="https://cdn-icons-png.flaticon.com/512/281/281769.png" class="task-icon" alt="AI Icon">
        <h2>নতুন Gmail তৈরি করুন</h2>
        <button class="generate-btn" onclick="generateEmail()">Generate Email</button>
        <input type="text" id="emailBox" placeholder="— তৈরি হওয়া ইমেল অ্যাড্রেস —" readonly>
        <div style="margin-top:20px;">
            <button class="close-btn" onclick="closePopup()">বন্ধ করুন</button>
            <button class="submit-btn" id="submitBtn" onclick="submitForm()" disabled>সাবমিট</button>
        </div>
    </div>
</div>

<div class="success-notification" id="successPopup">
    <div class="notification-content">
        <img src="https://cdn.dribbble.com/users/116728/screenshots/3373498/slack_animation.gif" class="task-icon" alt="Success Icon">
        <h2>সফলভাবে সম্পূর্ণ!</h2>
        <p>**২ টাকা** আপনার ব্যালেন্সে যোগ করা হয়েছে।</p>
        <p>ফিরে যাচ্ছি <span id="countdown">৫</span> সেকেন্ডের মধ্যে...</p>
        <audio id="successSound" src="/mixkit-fantasy-game-success-notification-270.wav"></audio>
    </div>
</div>

<script>
// JavaScript কার্যকারিতা অপরিবর্তিত রাখা হলো।
const rewardAmount = @json(config('reward.gmail_account_reward'));
let submissionCount = 0;
const submissionLimit = 5;

function openPopup() {
  document.getElementById("popup").style.display = "flex";
}
function closePopup() {
  document.getElementById("popup").style.display = "none";
  document.getElementById("emailBox").value = "";
  document.getElementById("submitBtn").disabled = true;
  document.getElementById("submitBtn").innerText = "সাবমিট";
  document.querySelector(".generate-btn").innerText = "Generate Email";
  document.querySelector(".generate-btn").disabled = false;
}

function generateEmail() {
  const button = document.querySelector(".generate-btn");
  button.innerText = "তৈরি হচ্ছে...";
  button.disabled = true;

  setTimeout(() => {
    // Random email generation
    const prefixes = ['pro', 'acc', 'gac', 'tst', 'mail'].filter(Boolean);
    const prefix = prefixes[Math.floor(Math.random() * prefixes.length)];
    const randomNum = Math.floor(Math.random() * 9000) + 1000;
    const randomString = Math.random().toString(36).substring(2, 6);
    const randomName = prefix + randomNum.toString().slice(-3) + randomString;
   
    document.getElementById("emailBox").value = randomName + "@gmail.com";
    button.innerText = "আবার তৈরি করুন";
    button.disabled = false;
    document.getElementById("submitBtn").disabled = false;
  }, 1500);
}

function submitForm() {
  const email = document.getElementById("emailBox").value;
  if (email.trim() === "" || !email.includes('@gmail.com')) {
    return alert(" দয়া করে আগে ইমেল তৈরি করুন।");
  }

  const btn = document.getElementById("submitBtn");
  btn.innerText = "প্রসেসিং...";
  btn.disabled = true;

  setTimeout(() => {
    addAmountToUserAccount();
  }, 1200);
}

function addAmountToUserAccount() {
  fetch("{{ route('add.amount') }}", {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
      'X-CSRF-TOKEN': '{{ csrf_token() }}',
    },
    body: JSON.stringify({ amount: rewardAmount })
  })
  .then(res => {
    if (!res.ok) {
      throw new Error(`HTTP error! status: ${res.status}`);
    }
    return res.json();
  })
  .then(data => {
    if (data.success) {
      showSuccessPopup();
      closePopup();
    } else {
      alert(data.message || "সার্ভার ভেরিফিকেশনে সমস্যা হয়েছে।");
      document.getElementById("submitBtn").innerText = "সাবমিট";
      document.getElementById("submitBtn").disabled = false;
    }
  })
  .catch(e => {
    console.error("Submission failed:", e);
    alert(" নেটওয়ার্ক ত্রুটি অথবা সার্ভার সংযোগ বিচ্ছিন্ন।");
    document.getElementById("submitBtn").innerText = "সাবমিট";
    document.getElementById("submitBtn").disabled = false;
  });
}

function showSuccessPopup() {
  const popup = document.getElementById("successPopup");
  popup.style.display = "flex";
  const audio = document.getElementById("successSound");
  audio.play().catch(e => console.log("Audio play failed:", e));

  let countdown = 5;
  const counter = document.getElementById("countdown");
  counter.innerText = countdown;
 
  const interval = setInterval(() => {
    countdown--;
    counter.innerText = countdown;
    if (countdown <= 0) {
      clearInterval(interval);
      setTimeout(() => {
        window.location.href = "{{ route('gjobs') }}";
      }, 500);
    }
  }, 1000);
}
</script>

@include('user.layout.footer')