@include('user.layout.header')
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Claim Referral Bonus - Exclusive Rewards</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --success-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            --warning-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            --premium-gradient: linear-gradient(135deg, #ff9a9e 0%, #fecfef 100%);
        }
        
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .glass-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
        }
        
        .bonus-card {
            background: var(--primary-gradient);
            border-radius: 25px;
            color: white;
            padding: 40px 30px;
            margin-bottom: 30px;
            box-shadow: 0 15px 35px rgba(102, 126, 234, 0.3);
            position: relative;
            overflow: hidden;
        }
        
        .bonus-card::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 1%, transparent 1%);
            background-size: 20px 20px;
            animation: float 3s infinite linear;
        }
        
        @keyframes float {
            0% { transform: translate(0, 0) rotate(0deg); }
            100% { transform: translate(-20px, -20px) rotate(360deg); }
        }
        
        .stats-card {
            background: white;
            border-radius: 20px;
            padding: 25px;
            margin-bottom: 25px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.08);
            border: none;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .stats-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: var(--primary-gradient);
        }
        
        .stats-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 35px rgba(0,0,0,0.15);
        }
        
        .claim-btn {
            background: var(--warning-gradient);
            border: none;
            border-radius: 50px;
            padding: 15px 40px;
            font-weight: 700;
            font-size: 18px;
            color: white;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            box-shadow: 0 10px 25px rgba(245, 87, 108, 0.3);
        }
        
        .claim-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            transition: left 0.5s;
        }
        
        .claim-btn:hover::before {
            left: 100%;
        }
        
        .claim-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 30px rgba(245, 87, 108, 0.4);
        }
        
        .claim-btn:disabled {
            background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
            transform: none;
            box-shadow: none;
        }
        
        .bonus-icon {
            font-size: 4rem;
            margin-bottom: 20px;
            background: linear-gradient(135deg, #fff 0%, #f8f9fa 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            filter: drop-shadow(0 5px 15px rgba(0,0,0,0.2));
        }
        
        .tier-card {
            border-left: 5px solid #007bff;
            border-radius: 15px;
            transition: all 0.3s ease;
            background: white;
            position: relative;
            overflow: hidden;
        }
        
        .tier-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, rgba(0,123,255,0.05) 0%, transparent 100%);
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .tier-card:hover::before {
            opacity: 1;
        }
        
        .tier-card.active {
            border-left: 5px solid #28a745;
            background: linear-gradient(135deg, #f8fff9 0%, #e8f5e8 100%);
            transform: scale(1.02);
        }
        
        .tier-card.active::before {
            background: linear-gradient(135deg, rgba(40,167,69,0.1) 0%, transparent 100%);
            opacity: 1;
        }
        
        .progress-ring {
            position: relative;
            width: 80px;
            height: 80px;
        }
        
        .progress-ring circle {
            transform: rotate(-90deg);
            transform-origin: 50% 50%;
        }
        
        .floating {
            animation: floating 3s ease-in-out infinite;
        }
        
        @keyframes floating {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
            100% { transform: translateY(0px); }
        }
        
        .pulse {
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(102, 126, 234, 0.4); }
            70% { box-shadow: 0 0 0 15px rgba(102, 126, 234, 0); }
            100% { box-shadow: 0 0 0 0 rgba(102, 126, 234, 0); }
        }
        
        .badge-premium {
            background: var(--premium-gradient);
            color: white;
            font-weight: 600;
            padding: 8px 15px;
            border-radius: 20px;
            font-size: 0.8rem;
        }
        
        .referral-count {
            font-size: 2.5rem;
            font-weight: 800;
            background: var(--primary-gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .bonus-amount {
            font-size: 2.5rem;
            font-weight: 800;
            background: var(--warning-gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .confetti {
            position: absolute;
            width: 10px;
            height: 10px;
            background: #ffd700;
            border-radius: 50%;
            opacity: 0;
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-10 col-lg-8">
                
                @if(session('giftcode_success'))
    <div class="alert alert-success alert-dismissible fade show glass-card" role="alert">
        {!! session('giftcode_success') !!}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif
                <!-- Main Bonus Card -->
                <div class="bonus-card text-center pulse">
                    <div class="floating">
                        <i class="fas fa-gift bonus-icon"></i>
                    </div>
                    <h1 class="mb-3 fw-bold">🎁 Exclusive Referral Bonus</h1>
                    <p class="lead mb-4 opacity-90">Invite your friends and unlock amazing rewards! The more you refer, the more you earn.</p>
                    
                    <div class="row justify-content-center">
                        <div class="col-md-5 mb-4">
                            <div class="stats-card text-center">
                                <div class="floating">
                                    <i class="fas fa-users text-primary mb-3 fa-2x"></i>
                                </div>
                                <h3 class="referral-count">{{ $referralCount }}</h3>
                                <p class="text-muted mb-0 fw-semibold">Active Referrals</p>
                                <small class="text-success">
                                    <i class="fas fa-arrow-up me-1"></i>
                                    {{ $referralCount }}/3 required for bonus
                                </small>
                            </div>
                        </div>
                        <div class="col-md-5 mb-4">
                            <div class="stats-card text-center">
                                <div class="floating">
                                    <i class="fas fa-coins text-warning mb-3 fa-2x"></i>
                                </div>
                                <h3 class="bonus-amount">{{ $availableBonus }} ৳</h3>
                                <p class="text-muted mb-0 fw-semibold">Available Bonus</p>
                                <small class="text-info">
                                    <i class="fas fa-wallet me-1"></i>
                                    Deposit balance
                                </small>
                            </div>
                        </div>
                    </div>

                    @if($canClaim)
                        <form action="{{ route('claim.bonus') }}" method="POST" class="mt-4">
                            @csrf
                            <button type="submit" class="btn claim-btn btn-lg">
                                <i class="fas fa-gift me-2"></i>🎯 Claim My Bonus Now
                            </button>
                            <p class="mt-2 opacity-75">
                                <small><i class="fas fa-bolt me-1"></i>Instant credit to your deposit balance</small>
                            </p>
                        </form>
                    @else
                        <div class="mt-4">
                            <button class="btn claim-btn btn-lg" disabled>
                                <i class="fas fa-lock me-2"></i>
                                @if(!$user->canClaimReferralBonus())
                                    🏆 Bonus Already Claimed
                                @else
                                    📊 Need More Active Referrals
                                @endif
                            </button>
                            @if($user->canClaimReferralBonus())
                                <p class="mt-2 opacity-75">
                                    <small><i class="fas fa-info-circle me-1"></i>You need at least 3 active referrals to claim your bonus</small>
                                </p>
                            @endif
                        </div>
                    @endif
                </div>

                <!-- Bonus Tiers -->
                <div class="glass-card p-4 mb-4">
                    <div class="d-flex align-items-center mb-4">
                        <i class="fas fa-trophy text-warning me-3 fa-2x"></i>
                        <div>
                            <h4 class="fw-bold mb-1">Bonus Achievement Tiers</h4>
                            <p class="text-muted mb-0">Reach new milestones and unlock higher rewards</p>
                        </div>
                    </div>
                    
                    <div class="row g-3">
                        @php
                            $tiers = [
                                ['count' => 3, 'bonus' => env('REFERRAL_BONUS_3', 20), 'icon' => '🥉', 'color' => 'primary'],
                                ['count' => 5, 'bonus' => env('REFERRAL_BONUS_5', 50), 'icon' => '🥈', 'color' => 'info'],
                                ['count' => 10, 'bonus' => env('REFERRAL_BONUS_10', 100), 'icon' => '🥇', 'color' => 'warning'],
                                ['count' => 20, 'bonus' => env('REFERRAL_BONUS_20', 200), 'icon' => '🏆', 'color' => 'danger']
                            ];
                        @endphp
                        
                        @foreach($tiers as $tier)
                            <div class="col-md-6">
                                <div class="tier-card p-4 {{ $referralCount >= $tier['count'] ? 'active' : '' }}">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="flex-grow-1">
                                            <div class="d-flex align-items-center mb-2">
                                                <span class="me-2" style="font-size: 1.5rem;">{{ $tier['icon'] }}</span>
                                                <h5 class="fw-bold mb-0 text-{{ $tier['color'] }}">
                                                    {{ $tier['count'] }}+ Referrals
                                                </h5>
                                            </div>
                                            <p class="text-muted mb-2">Achieve {{ $tier['count'] }} active referrals</p>
                                            <div class="d-flex align-items-center">
                                                <span class="badge bg-{{ $tier['color'] }} px-3 py-2">
                                                    <i class="fas fa-coins me-1"></i>{{ $tier['bonus'] }} ৳ Bonus
                                                </span>
                                            </div>
                                        </div>
                                        <div class="ms-3">
                                            <i class="fas {{ $referralCount >= $tier['count'] ? 'fa-check-circle text-success' : 'fa-clock text-secondary' }} fa-2x"></i>
                                        </div>
                                    </div>
                                    @if($referralCount >= $tier['count'])
                                        <div class="mt-2">
                                            <div class="progress" style="height: 6px;">
                                                <div class="progress-bar bg-success" style="width: 100%"></div>
                                            </div>
                                            <small class="text-success"><i class="fas fa-check me-1"></i>Milestone Achieved</small>
                                        </div>
                                    @else
                                        <div class="mt-2">
                                            <div class="progress" style="height: 6px;">
                                                <div class="progress-bar bg-{{ $tier['color'] }}" 
                                                     style="width: {{ min(($referralCount / $tier['count']) * 100, 100) }}%">
                                                </div>
                                            </div>
                                            <small class="text-muted">{{ $referralCount }}/{{ $tier['count'] }} referrals</small>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Requirements & Features -->
                <div class="row g-4">
                    <div class="col-md-6">
                        <div class="glass-card p-4 h-100">
                            <h5 class="fw-bold mb-3">
                                <i class="fas fa-list-check text-success me-2"></i>
                                Bonus Requirements
                            </h5>
                            <div class="list-group list-group-flush">
                                <div class="list-group-item px-0 border-0">
                                    <i class="fas fa-user-check text-success me-2"></i>
                                    <span class="fw-semibold">Active Account</span>
                                    <small class="text-muted d-block">Your account must be verified and active</small>
                                </div>
                                <div class="list-group-item px-0 border-0">
                                    <i class="fas fa-users text-info me-2"></i>
                                    <span class="fw-semibold">Active Referrals</span>
                                    <small class="text-muted d-block">Referrals must complete account activation</small>
                                </div>
                                <div class="list-group-item px-0 border-0">
                                    <i class="fas fa-calendar-check text-warning me-2"></i>
                                    <span class="fw-semibold">One-Time Claim</span>
                                    <small class="text-muted d-block">Bonus can be claimed only once per account</small>
                                </div>
                                <div class="list-group-item px-0 border-0">
                                    <i class="fas fa-wallet text-primary me-2"></i>
                                    <span class="fw-semibold">Deposit Balance</span>
                                    <small class="text-muted d-block">Bonus credited to deposit balance instantly</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="glass-card p-4 h-100" style="background: var(--success-gradient); color: white;">
                            <h5 class="fw-bold mb-3">
                                <i class="fas fa-rocket me-2"></i>
                                Quick Tips
                            </h5>
                            <div class="list-group list-group-flush bg-transparent">
                                <div class="list-group-item px-0 border-0 bg-transparent text-white">
                                    <i class="fas fa-share-alt me-2"></i>
                                    <span class="fw-semibold">Share Your Link</span>
                                    <small class="opacity-90 d-block">Share your referral code with friends</small>
                                </div>
                                <div class="list-group-item px-0 border-0 bg-transparent text-white">
                                    <i class="fas fa-bullhorn me-2"></i>
                                    <span class="fw-semibold">Promote Actively</span>
                                    <small class="opacity-90 d-block">Use social media to reach more people</small>
                                </div>
                                <div class="list-group-item px-0 border-0 bg-transparent text-white">
                                    <i class="fas fa-chart-line me-2"></i>
                                    <span class="fw-semibold">Track Progress</span>
                                    <small class="opacity-90 d-block">Monitor your referrals in real-time</small>
                                </div>
                                <div class="list-group-item px-0 border-0 bg-transparent text-white">
                                    <i class="fas fa-gem me-2"></i>
                                    <span class="fw-semibold">Maximize Earnings</span>
                                    <small class="opacity-90 d-block">Aim for higher tiers for better rewards</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Alert Messages -->
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show mt-4 glass-card" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-party-horn fa-2x me-3"></i>
                            <div>
                                <h5 class="alert-heading mb-1">Congratulations! 🎉</h5>
                                {{ session('success') }}
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show mt-4 glass-card" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-exclamation-triangle fa-2x me-3"></i>
                            <div>
                                <h5 class="alert-heading mb-1">Attention Required</h5>
                                {{ session('error') }}
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Add some interactive animations
        document.addEventListener('DOMContentLoaded', function() {
            // Add floating animation to stats cards
            const statsCards = document.querySelectorAll('.stats-card');
            statsCards.forEach((card, index) => {
                card.style.animationDelay = `${index * 0.1}s`;
            });
            
            // Add confetti effect when bonus is claimed successfully
            @if(session('success'))
                createConfetti();
            @endif
        });
        
        function createConfetti() {
            const colors = ['#ff0000', '#00ff00', '#0000ff', '#ffff00', '#ff00ff', '#00ffff'];
            const container = document.querySelector('.bonus-card');
            
            for (let i = 0; i < 50; i++) {
                const confetti = document.createElement('div');
                confetti.className = 'confetti';
                confetti.style.left = Math.random() * 100 + '%';
                confetti.style.top = Math.random() * 100 + '%';
                confetti.style.backgroundColor = colors[Math.floor(Math.random() * colors.length)];
                confetti.style.animation = `confettiFall ${Math.random() * 3 + 2}s linear forwards`;
                container.appendChild(confetti);
                
                // Remove confetti after animation
                setTimeout(() => {
                    confetti.remove();
                }, 5000);
            }
        }
        
        // Add CSS for confetti animation
        const style = document.createElement('style');
        style.textContent = `
            @keyframes confettiFall {
                0% {
                    transform: translateY(-100px) rotate(0deg);
                    opacity: 1;
                }
                100% {
                    transform: translateY(500px) rotate(360deg);
                    opacity: 0;
                }
            }
        `;
        document.head.appendChild(style);
    </script>
</body>
</html>
@include('user.layout.footer')