@include('user.layout.header')
<style>
.channel-orders-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 20px;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}
.orders-header {
    text-align: center;
    margin-bottom: 40px;
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    padding: 40px 20px;
    border-radius: 15px;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
    animation: fadeInUp 0.8s ease-out;
}
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}
.orders-header h1 {
    font-size: 2.5rem;
    margin-bottom: 10px;
    font-weight: 700;
    text-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
}
.orders-header p {
    font-size: 1.1rem;
    opacity: 0.9;
    margin: 0;
}
.features-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 25px;
    margin-bottom: 40px;
}
.feature-card {
    background: white;
    color: #333;
    padding: 30px;
    border-radius: 15px;
    text-align: center;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
    border-top: 4px solid #0088cc;
    position: relative;
    overflow: hidden;
}
.feature-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: linear-gradient(90deg, #0088cc, #00a0e9);
}
.feature-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 136, 204, 0.2);
}
.feature-icon {
    font-size: 3rem;
    color: #0088cc;
    margin-bottom: 15px;
    animation: pulse 2s infinite;
}
@keyframes pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.1); }
    100% { transform: scale(1); }
}
.feature-card h3 {
    font-size: 1.5rem;
    margin-bottom: 10px;
    color: #333;
    font-weight: 600;
}
.feature-card p {
    color: #666;
    line-height: 1.6;
}
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-bottom: 40px;
}
.stat-card {
    background: white;
    padding: 25px;
    border-radius: 12px;
    text-align: center;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
    border-left: 4px solid #0088cc;
    transition: all 0.3s ease;
    animation: fadeInUp 0.8s ease-out 0.2s both;
}
.stat-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.15);
}
.stat-card h3 {
    color: #0088cc;
    font-size: 2rem;
    margin-bottom: 5px;
    font-weight: 700;
}
.stat-card p {
    color: #666;
    margin: 0;
    font-weight: 500;
}
.cta-section {
    text-align: center;
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    padding: 40px;
    border-radius: 15px;
    margin-bottom: 40px;
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
    animation: fadeInUp 0.8s ease-out 0.3s both;
}
.cta-section h2 {
    font-size: 2rem;
    margin-bottom: 15px;
    font-weight: 700;
}
.cta-section p {
    font-size: 1.1rem;
    opacity: 0.9;
    margin-bottom: 20px;
}
.btn-create-order {
    background: white;
    color: #0088cc;
    padding: 15px 40px;
    border-radius: 50px;
    text-decoration: none;
    font-weight: bold;
    font-size: 1.1rem;
    display: inline-flex;
    align-items: center;
    gap: 10px;
    margin-top: 10px;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(0, 136, 204, 0.2);
}
.btn-create-order:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.3);
    text-decoration: none;
    color: #0088cc;
}
.btn-create-order:disabled {
    opacity: 0.6;
    cursor: not-allowed;
    transform: none;
    box-shadow: none;
}
.how-it-works {
    background: #f8f9fa;
    padding: 40px;
    border-radius: 15px;
    margin-bottom: 40px;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
    animation: fadeInUp 0.8s ease-out 0.4s both;
}
.how-it-works h2 {
    text-align: center;
    color: #0088cc;
    margin-bottom: 30px;
    font-size: 2rem;
    font-weight: 700;
}
.steps {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 25px;
}
.step {
    text-align: center;
    padding: 25px;
    background: white;
    border-radius: 12px;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}
.step::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: linear-gradient(90deg, #0088cc, #00a0e9);
}
.step:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0, 136, 204, 0.15);
}
.step-number {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    font-weight: bold;
    margin: 0 auto 15px;
    box-shadow: 0 4px 15px rgba(0, 136, 204, 0.3);
    animation: spin 3s linear infinite;
}
@keyframes spin {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}
.step h4 {
    color: #333;
    margin-bottom: 10px;
    font-weight: 600;
    font-size: 1.3rem;
}
.step p {
    color: #666;
    line-height: 1.6;
}
.requirements {
    background: linear-gradient(135deg, #e3f2fd 0%, #f0f8ff 100%);
    border: 1px solid #bbdefb;
    border-radius: 12px;
    padding: 25px;
    margin-bottom: 30px;
    animation: fadeInUp 0.8s ease-out 0.5s both;
}
.requirements h3 {
    color: #0088cc;
    margin-bottom: 15px;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 8px;
}
.requirements ul {
    color: #333;
    margin: 0;
    padding-left: 20px;
    font-size: 1rem;
}
.requirements li {
    margin-bottom: 8px;
    line-height: 1.5;
}
.telegram-prerequisite {
    background: linear-gradient(135deg, #e8f5e8 0%, #f1f8e9 100%);
    border: 1px solid #c8e6c9;
    border-radius: 12px;
    padding: 25px;
    margin-bottom: 30px;
    text-align: center;
    box-shadow: 0 4px 15px rgba(76, 175, 80, 0.1);
    animation: fadeInUp 0.8s ease-out 0.6s both;
}
.telegram-prerequisite h3 {
    color: #2e7d32;
    margin-bottom: 15px;
    font-weight: 700;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}
.telegram-prerequisite p {
    color: #388e3c;
    margin-bottom: 20px;
    font-size: 1rem;
}
.telegram-prerequisite a {
    color: #1b5e20;
    font-weight: bold;
    text-decoration: none;
    padding: 10px 20px;
    background: white;
    border-radius: 25px;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(76, 175, 80, 0.2);
}
.telegram-prerequisite a:hover {
    background: #e8f5e8;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(76, 175, 80, 0.3);
    text-decoration: none;
    color: #1b5e20;
}
.history-link {
    text-align: center;
    margin-top: 30px;
    animation: fadeInUp 0.8s ease-out 0.7s both;
}
.history-link a {
    background: linear-gradient(135deg, #0088cc 0%, #00a0e9 100%);
    color: white;
    padding: 15px 30px;
    border-radius: 50px;
    text-decoration: none;
    font-weight: bold;
    font-size: 1.1rem;
    display: inline-flex;
    align-items: center;
    gap: 10px;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(0, 136, 204, 0.3);
}
.history-link a:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(0, 136, 204, 0.4);
    text-decoration: none;
    color: white;
}
/* Responsive */
@media (max-width: 768px) {
    .channel-orders-container { padding: 15px; }
    .orders-header { padding: 30px 15px; }
    .orders-header h1 { font-size: 2rem; }
    .features-grid, .steps { grid-template-columns: 1fr; gap: 20px; }
    .stat-card { padding: 20px; }
    .cta-section, .how-it-works { padding: 30px 20px; }
    .requirements, .telegram-prerequisite { padding: 20px; }
}
</style>
<div class="channel-orders-container">
            <br><br><br>
    <div class="orders-header">
        <br><br>
        <h1><i class="fas fa-broadcast-tower"></i> Telegram Channel Orders</h1>
        <p>Boost your Telegram channel with real, active members and watch your audience grow exponentially</p>
    </div>
    @if(!Auth::user()->telegram_user_id || Auth::user()->tg_id_status != 1)
    <div class="telegram-prerequisite">
        <h3><i class="fas fa-exclamation-triangle"></i> Telegram Verification Required</h3>
        <p>Connect and verify your Telegram ID to unlock channel ordering features and ensure seamless delivery.</p>
        <a href="{{ route('telegram.connect') }}">
            <i class="fab fa-telegram-plane"></i> Verify Telegram ID Now
        </a>
    </div>
    @endif
    <div class="requirements">
        <h3><i class="fas fa-check-circle"></i> Essential Requirements</h3>
        <ul>
            <li><i class="fas fa-globe"></i> Your Telegram channel must be public and accessible</li>
            <li><i class="fas fa-user-shield"></i> You must be an admin of the channel</li>
            <li><i class="fas fa-robot"></i> Add @ChatID_SB_Robot as admin to your channel for verification</li>
            <li><i class="fas fa-wallet"></i> Ensure sufficient balance in your account for the order</li>
        </ul>
    </div>
    <div class="stats-grid">
        <div class="stat-card">
            <h3>৳{{ $costPerMember }}</h3>
            <p>Cost Per Member</p>
        </div>
        <div class="stat-card">
            <h3>{{ $minMembers }}+</h3>
            <p>Minimum Order</p>
        </div>
        <div class="stat-card">
            <h3>{{ $maxMembers }}</h3>
            <p>Maximum Order</p>
        </div>
        <div class="stat-card">
            <h3>৳{{ $minOrderAmount }}</h3>
            <p>Starting Investment</p>
        </div>
    </div>
    <div class="features-grid">
        <div class="feature-card">
            <div class="feature-icon"><i class="fas fa-rocket"></i></div>
            <h3>Lightning Fast Delivery</h3>
            <p>Experience rapid member addition with our optimized system for instant channel growth</p>
        </div>
        <div class="feature-card">
            <div class="feature-icon"><i class="fas fa-users"></i></div>
            <h3>100% Real & Active Users</h3>
            <p>We deliver genuine Telegram users who engage with your content, ensuring authentic growth</p>
        </div>
        <div class="feature-card">
            <div class="feature-icon"><i class="fas fa-shield-alt"></i></div>
            <h3>Secure & Guaranteed</h3>
            <p>Your channel's safety is our priority – fully compliant, risk-free, and satisfaction assured</p>
        </div>
    </div>
    <div class="cta-section">
        <h2>Ready to Skyrocket Your Channel?</h2>
        <p>Start with just ৳{{ $minOrderAmount }} and transform your audience today</p>
        @if(Auth::user()->telegram_user_id && Auth::user()->tg_id_status == 1)
        <a href="{{ route('channel.order.create') }}" class="btn-create-order">
            <i class="fas fa-plus-circle"></i> Create New Order Now
        </a>
        @else
        <button class="btn-create-order" disabled style="opacity: 0.6; cursor: not-allowed;">
            <i class="fas fa-lock"></i> Verify Telegram First
        </button>
        @endif
    </div>
    <div class="how-it-works">
        <h2><i class="fas fa-lightbulb"></i> How It Works: Simple 4-Step Process</h2>
        <div class="steps">
            <div class="step">
                <div class="step-number">1</div>
                <h4>Verify & Add Bot</h4>
                <p>Connect your Telegram and add @ChatID_SB_Robot as admin for seamless integration</p>
            </div>
            <div class="step">
                <div class="step-number">2</div>
                <h4>Submit Order Details</h4>
                <p>Enter your channel link and desired member count – we'll handle the rest</p>
            </div>
            <div class="step">
                <div class="step-number">3</div>
                <h4>Admin Review & Approval</h4>
                <p>Our team verifies and approves your order for quality and compliance</p>
            </div>
            <div class="step">
                <div class="step-number">4</div>
                <h4>Watch Members Join</h4>
                <p>Real users start joining your channel – track progress in real-time</p>
            </div>
        </div>
    </div>
    <div class="history-link">
        <a href="{{ route('channel.order.history') }}">
            <i class="fas fa-history"></i> View Your Order History
        </a>
    </div>
</div>
@include('user.layout.footer')